// Compiled by ClojureScript 1.8.40 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18382 = [];
var len__7276__auto___18388 = arguments.length;
var i__7277__auto___18389 = (0);
while(true){
if((i__7277__auto___18389 < len__7276__auto___18388)){
args18382.push((arguments[i__7277__auto___18389]));

var G__18390 = (i__7277__auto___18389 + (1));
i__7277__auto___18389 = G__18390;
continue;
} else {
}
break;
}

var G__18384 = args18382.length;
switch (G__18384) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18382.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18385 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18385 = (function (f,blockable,meta18386){
this.f = f;
this.blockable = blockable;
this.meta18386 = meta18386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18387,meta18386__$1){
var self__ = this;
var _18387__$1 = this;
return (new cljs.core.async.t_cljs$core$async18385(self__.f,self__.blockable,meta18386__$1));
});

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18387){
var self__ = this;
var _18387__$1 = this;
return self__.meta18386;
});

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18385.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18386","meta18386",-654556936,null)], null);
});

cljs.core.async.t_cljs$core$async18385.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18385";

cljs.core.async.t_cljs$core$async18385.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18385");
});

cljs.core.async.__GT_t_cljs$core$async18385 = (function cljs$core$async$__GT_t_cljs$core$async18385(f__$1,blockable__$1,meta18386){
return (new cljs.core.async.t_cljs$core$async18385(f__$1,blockable__$1,meta18386));
});

}

return (new cljs.core.async.t_cljs$core$async18385(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18394 = [];
var len__7276__auto___18397 = arguments.length;
var i__7277__auto___18398 = (0);
while(true){
if((i__7277__auto___18398 < len__7276__auto___18397)){
args18394.push((arguments[i__7277__auto___18398]));

var G__18399 = (i__7277__auto___18398 + (1));
i__7277__auto___18398 = G__18399;
continue;
} else {
}
break;
}

var G__18396 = args18394.length;
switch (G__18396) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18394.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18401 = [];
var len__7276__auto___18404 = arguments.length;
var i__7277__auto___18405 = (0);
while(true){
if((i__7277__auto___18405 < len__7276__auto___18404)){
args18401.push((arguments[i__7277__auto___18405]));

var G__18406 = (i__7277__auto___18405 + (1));
i__7277__auto___18405 = G__18406;
continue;
} else {
}
break;
}

var G__18403 = args18401.length;
switch (G__18403) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18401.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18408 = [];
var len__7276__auto___18411 = arguments.length;
var i__7277__auto___18412 = (0);
while(true){
if((i__7277__auto___18412 < len__7276__auto___18411)){
args18408.push((arguments[i__7277__auto___18412]));

var G__18413 = (i__7277__auto___18412 + (1));
i__7277__auto___18412 = G__18413;
continue;
} else {
}
break;
}

var G__18410 = args18408.length;
switch (G__18410) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18408.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18415 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18415);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18415,ret){
return (function (){
return fn1.call(null,val_18415);
});})(val_18415,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18416 = [];
var len__7276__auto___18419 = arguments.length;
var i__7277__auto___18420 = (0);
while(true){
if((i__7277__auto___18420 < len__7276__auto___18419)){
args18416.push((arguments[i__7277__auto___18420]));

var G__18421 = (i__7277__auto___18420 + (1));
i__7277__auto___18420 = G__18421;
continue;
} else {
}
break;
}

var G__18418 = args18416.length;
switch (G__18418) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18416.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7121__auto___18423 = n;
var x_18424 = (0);
while(true){
if((x_18424 < n__7121__auto___18423)){
(a[x_18424] = (0));

var G__18425 = (x_18424 + (1));
x_18424 = G__18425;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18426 = (i + (1));
i = G__18426;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18430 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18430 = (function (alt_flag,flag,meta18431){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta18431 = meta18431;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18432,meta18431__$1){
var self__ = this;
var _18432__$1 = this;
return (new cljs.core.async.t_cljs$core$async18430(self__.alt_flag,self__.flag,meta18431__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18432){
var self__ = this;
var _18432__$1 = this;
return self__.meta18431;
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18431","meta18431",-2084989266,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18430.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18430.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18430";

cljs.core.async.t_cljs$core$async18430.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18430");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18430 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18430(alt_flag__$1,flag__$1,meta18431){
return (new cljs.core.async.t_cljs$core$async18430(alt_flag__$1,flag__$1,meta18431));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18430(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18436 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18436 = (function (alt_handler,flag,cb,meta18437){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta18437 = meta18437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18438,meta18437__$1){
var self__ = this;
var _18438__$1 = this;
return (new cljs.core.async.t_cljs$core$async18436(self__.alt_handler,self__.flag,self__.cb,meta18437__$1));
});

cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18438){
var self__ = this;
var _18438__$1 = this;
return self__.meta18437;
});

cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18436.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18437","meta18437",-39295581,null)], null);
});

cljs.core.async.t_cljs$core$async18436.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18436.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18436";

cljs.core.async.t_cljs$core$async18436.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18436");
});

cljs.core.async.__GT_t_cljs$core$async18436 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18436(alt_handler__$1,flag__$1,cb__$1,meta18437){
return (new cljs.core.async.t_cljs$core$async18436(alt_handler__$1,flag__$1,cb__$1,meta18437));
});

}

return (new cljs.core.async.t_cljs$core$async18436(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18439_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18439_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18440_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18440_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6207__auto__ = wport;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18441 = (i + (1));
i = G__18441;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6207__auto__ = ret;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6195__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6195__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___18447 = arguments.length;
var i__7277__auto___18448 = (0);
while(true){
if((i__7277__auto___18448 < len__7276__auto___18447)){
args__7283__auto__.push((arguments[i__7277__auto___18448]));

var G__18449 = (i__7277__auto___18448 + (1));
i__7277__auto___18448 = G__18449;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18444){
var map__18445 = p__18444;
var map__18445__$1 = ((((!((map__18445 == null)))?((((map__18445.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18445.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18445):map__18445);
var opts = map__18445__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18442){
var G__18443 = cljs.core.first.call(null,seq18442);
var seq18442__$1 = cljs.core.next.call(null,seq18442);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18443,seq18442__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18450 = [];
var len__7276__auto___18500 = arguments.length;
var i__7277__auto___18501 = (0);
while(true){
if((i__7277__auto___18501 < len__7276__auto___18500)){
args18450.push((arguments[i__7277__auto___18501]));

var G__18502 = (i__7277__auto___18501 + (1));
i__7277__auto___18501 = G__18502;
continue;
} else {
}
break;
}

var G__18452 = args18450.length;
switch (G__18452) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18450.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18337__auto___18504 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___18504){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___18504){
return (function (state_18476){
var state_val_18477 = (state_18476[(1)]);
if((state_val_18477 === (7))){
var inst_18472 = (state_18476[(2)]);
var state_18476__$1 = state_18476;
var statearr_18478_18505 = state_18476__$1;
(statearr_18478_18505[(2)] = inst_18472);

(statearr_18478_18505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (1))){
var state_18476__$1 = state_18476;
var statearr_18479_18506 = state_18476__$1;
(statearr_18479_18506[(2)] = null);

(statearr_18479_18506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (4))){
var inst_18455 = (state_18476[(7)]);
var inst_18455__$1 = (state_18476[(2)]);
var inst_18456 = (inst_18455__$1 == null);
var state_18476__$1 = (function (){var statearr_18480 = state_18476;
(statearr_18480[(7)] = inst_18455__$1);

return statearr_18480;
})();
if(cljs.core.truth_(inst_18456)){
var statearr_18481_18507 = state_18476__$1;
(statearr_18481_18507[(1)] = (5));

} else {
var statearr_18482_18508 = state_18476__$1;
(statearr_18482_18508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (13))){
var state_18476__$1 = state_18476;
var statearr_18483_18509 = state_18476__$1;
(statearr_18483_18509[(2)] = null);

(statearr_18483_18509[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (6))){
var inst_18455 = (state_18476[(7)]);
var state_18476__$1 = state_18476;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18476__$1,(11),to,inst_18455);
} else {
if((state_val_18477 === (3))){
var inst_18474 = (state_18476[(2)]);
var state_18476__$1 = state_18476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18476__$1,inst_18474);
} else {
if((state_val_18477 === (12))){
var state_18476__$1 = state_18476;
var statearr_18484_18510 = state_18476__$1;
(statearr_18484_18510[(2)] = null);

(statearr_18484_18510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (2))){
var state_18476__$1 = state_18476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18476__$1,(4),from);
} else {
if((state_val_18477 === (11))){
var inst_18465 = (state_18476[(2)]);
var state_18476__$1 = state_18476;
if(cljs.core.truth_(inst_18465)){
var statearr_18485_18511 = state_18476__$1;
(statearr_18485_18511[(1)] = (12));

} else {
var statearr_18486_18512 = state_18476__$1;
(statearr_18486_18512[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (9))){
var state_18476__$1 = state_18476;
var statearr_18487_18513 = state_18476__$1;
(statearr_18487_18513[(2)] = null);

(statearr_18487_18513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (5))){
var state_18476__$1 = state_18476;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18488_18514 = state_18476__$1;
(statearr_18488_18514[(1)] = (8));

} else {
var statearr_18489_18515 = state_18476__$1;
(statearr_18489_18515[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (14))){
var inst_18470 = (state_18476[(2)]);
var state_18476__$1 = state_18476;
var statearr_18490_18516 = state_18476__$1;
(statearr_18490_18516[(2)] = inst_18470);

(statearr_18490_18516[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (10))){
var inst_18462 = (state_18476[(2)]);
var state_18476__$1 = state_18476;
var statearr_18491_18517 = state_18476__$1;
(statearr_18491_18517[(2)] = inst_18462);

(statearr_18491_18517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18477 === (8))){
var inst_18459 = cljs.core.async.close_BANG_.call(null,to);
var state_18476__$1 = state_18476;
var statearr_18492_18518 = state_18476__$1;
(statearr_18492_18518[(2)] = inst_18459);

(statearr_18492_18518[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___18504))
;
return ((function (switch__18225__auto__,c__18337__auto___18504){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_18496 = [null,null,null,null,null,null,null,null];
(statearr_18496[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_18496[(1)] = (1));

return statearr_18496;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_18476){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18497){if((e18497 instanceof Object)){
var ex__18229__auto__ = e18497;
var statearr_18498_18519 = state_18476;
(statearr_18498_18519[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18476);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18497;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18520 = state_18476;
state_18476 = G__18520;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_18476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_18476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___18504))
})();
var state__18339__auto__ = (function (){var statearr_18499 = f__18338__auto__.call(null);
(statearr_18499[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___18504);

return statearr_18499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___18504))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__18704){
var vec__18705 = p__18704;
var v = cljs.core.nth.call(null,vec__18705,(0),null);
var p = cljs.core.nth.call(null,vec__18705,(1),null);
var job = vec__18705;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__18337__auto___18887 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results){
return (function (state_18710){
var state_val_18711 = (state_18710[(1)]);
if((state_val_18711 === (1))){
var state_18710__$1 = state_18710;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18710__$1,(2),res,v);
} else {
if((state_val_18711 === (2))){
var inst_18707 = (state_18710[(2)]);
var inst_18708 = cljs.core.async.close_BANG_.call(null,res);
var state_18710__$1 = (function (){var statearr_18712 = state_18710;
(statearr_18712[(7)] = inst_18707);

return statearr_18712;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18710__$1,inst_18708);
} else {
return null;
}
}
});})(c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results))
;
return ((function (switch__18225__auto__,c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_18716 = [null,null,null,null,null,null,null,null];
(statearr_18716[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__);

(statearr_18716[(1)] = (1));

return statearr_18716;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1 = (function (state_18710){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18710);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18717){if((e18717 instanceof Object)){
var ex__18229__auto__ = e18717;
var statearr_18718_18888 = state_18710;
(statearr_18718_18888[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18710);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18717;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18889 = state_18710;
state_18710 = G__18889;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = function(state_18710){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1.call(this,state_18710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results))
})();
var state__18339__auto__ = (function (){var statearr_18719 = f__18338__auto__.call(null);
(statearr_18719[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___18887);

return statearr_18719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___18887,res,vec__18705,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18720){
var vec__18721 = p__18720;
var v = cljs.core.nth.call(null,vec__18721,(0),null);
var p = cljs.core.nth.call(null,vec__18721,(1),null);
var job = vec__18721;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7121__auto___18890 = n;
var __18891 = (0);
while(true){
if((__18891 < n__7121__auto___18890)){
var G__18722_18892 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__18722_18892) {
case "compute":
var c__18337__auto___18894 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18891,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (__18891,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function (state_18735){
var state_val_18736 = (state_18735[(1)]);
if((state_val_18736 === (1))){
var state_18735__$1 = state_18735;
var statearr_18737_18895 = state_18735__$1;
(statearr_18737_18895[(2)] = null);

(statearr_18737_18895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (2))){
var state_18735__$1 = state_18735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18735__$1,(4),jobs);
} else {
if((state_val_18736 === (3))){
var inst_18733 = (state_18735[(2)]);
var state_18735__$1 = state_18735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18735__$1,inst_18733);
} else {
if((state_val_18736 === (4))){
var inst_18725 = (state_18735[(2)]);
var inst_18726 = process.call(null,inst_18725);
var state_18735__$1 = state_18735;
if(cljs.core.truth_(inst_18726)){
var statearr_18738_18896 = state_18735__$1;
(statearr_18738_18896[(1)] = (5));

} else {
var statearr_18739_18897 = state_18735__$1;
(statearr_18739_18897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (5))){
var state_18735__$1 = state_18735;
var statearr_18740_18898 = state_18735__$1;
(statearr_18740_18898[(2)] = null);

(statearr_18740_18898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (6))){
var state_18735__$1 = state_18735;
var statearr_18741_18899 = state_18735__$1;
(statearr_18741_18899[(2)] = null);

(statearr_18741_18899[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18736 === (7))){
var inst_18731 = (state_18735[(2)]);
var state_18735__$1 = state_18735;
var statearr_18742_18900 = state_18735__$1;
(statearr_18742_18900[(2)] = inst_18731);

(statearr_18742_18900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18891,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
;
return ((function (__18891,switch__18225__auto__,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_18746 = [null,null,null,null,null,null,null];
(statearr_18746[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__);

(statearr_18746[(1)] = (1));

return statearr_18746;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1 = (function (state_18735){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18747){if((e18747 instanceof Object)){
var ex__18229__auto__ = e18747;
var statearr_18748_18901 = state_18735;
(statearr_18748_18901[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18747;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18902 = state_18735;
state_18735 = G__18902;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = function(state_18735){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1.call(this,state_18735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__;
})()
;})(__18891,switch__18225__auto__,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
})();
var state__18339__auto__ = (function (){var statearr_18749 = f__18338__auto__.call(null);
(statearr_18749[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___18894);

return statearr_18749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(__18891,c__18337__auto___18894,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
);


break;
case "async":
var c__18337__auto___18903 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18891,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (__18891,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function (state_18762){
var state_val_18763 = (state_18762[(1)]);
if((state_val_18763 === (1))){
var state_18762__$1 = state_18762;
var statearr_18764_18904 = state_18762__$1;
(statearr_18764_18904[(2)] = null);

(statearr_18764_18904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18763 === (2))){
var state_18762__$1 = state_18762;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18762__$1,(4),jobs);
} else {
if((state_val_18763 === (3))){
var inst_18760 = (state_18762[(2)]);
var state_18762__$1 = state_18762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18762__$1,inst_18760);
} else {
if((state_val_18763 === (4))){
var inst_18752 = (state_18762[(2)]);
var inst_18753 = async.call(null,inst_18752);
var state_18762__$1 = state_18762;
if(cljs.core.truth_(inst_18753)){
var statearr_18765_18905 = state_18762__$1;
(statearr_18765_18905[(1)] = (5));

} else {
var statearr_18766_18906 = state_18762__$1;
(statearr_18766_18906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18763 === (5))){
var state_18762__$1 = state_18762;
var statearr_18767_18907 = state_18762__$1;
(statearr_18767_18907[(2)] = null);

(statearr_18767_18907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18763 === (6))){
var state_18762__$1 = state_18762;
var statearr_18768_18908 = state_18762__$1;
(statearr_18768_18908[(2)] = null);

(statearr_18768_18908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18763 === (7))){
var inst_18758 = (state_18762[(2)]);
var state_18762__$1 = state_18762;
var statearr_18769_18909 = state_18762__$1;
(statearr_18769_18909[(2)] = inst_18758);

(statearr_18769_18909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18891,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
;
return ((function (__18891,switch__18225__auto__,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_18773 = [null,null,null,null,null,null,null];
(statearr_18773[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__);

(statearr_18773[(1)] = (1));

return statearr_18773;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1 = (function (state_18762){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18774){if((e18774 instanceof Object)){
var ex__18229__auto__ = e18774;
var statearr_18775_18910 = state_18762;
(statearr_18775_18910[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18762);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18911 = state_18762;
state_18762 = G__18911;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = function(state_18762){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1.call(this,state_18762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__;
})()
;})(__18891,switch__18225__auto__,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
})();
var state__18339__auto__ = (function (){var statearr_18776 = f__18338__auto__.call(null);
(statearr_18776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___18903);

return statearr_18776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(__18891,c__18337__auto___18903,G__18722_18892,n__7121__auto___18890,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18912 = (__18891 + (1));
__18891 = G__18912;
continue;
} else {
}
break;
}

var c__18337__auto___18913 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___18913,jobs,results,process,async){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___18913,jobs,results,process,async){
return (function (state_18798){
var state_val_18799 = (state_18798[(1)]);
if((state_val_18799 === (1))){
var state_18798__$1 = state_18798;
var statearr_18800_18914 = state_18798__$1;
(statearr_18800_18914[(2)] = null);

(statearr_18800_18914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18799 === (2))){
var state_18798__$1 = state_18798;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18798__$1,(4),from);
} else {
if((state_val_18799 === (3))){
var inst_18796 = (state_18798[(2)]);
var state_18798__$1 = state_18798;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18798__$1,inst_18796);
} else {
if((state_val_18799 === (4))){
var inst_18779 = (state_18798[(7)]);
var inst_18779__$1 = (state_18798[(2)]);
var inst_18780 = (inst_18779__$1 == null);
var state_18798__$1 = (function (){var statearr_18801 = state_18798;
(statearr_18801[(7)] = inst_18779__$1);

return statearr_18801;
})();
if(cljs.core.truth_(inst_18780)){
var statearr_18802_18915 = state_18798__$1;
(statearr_18802_18915[(1)] = (5));

} else {
var statearr_18803_18916 = state_18798__$1;
(statearr_18803_18916[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18799 === (5))){
var inst_18782 = cljs.core.async.close_BANG_.call(null,jobs);
var state_18798__$1 = state_18798;
var statearr_18804_18917 = state_18798__$1;
(statearr_18804_18917[(2)] = inst_18782);

(statearr_18804_18917[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18799 === (6))){
var inst_18779 = (state_18798[(7)]);
var inst_18784 = (state_18798[(8)]);
var inst_18784__$1 = cljs.core.async.chan.call(null,(1));
var inst_18785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18786 = [inst_18779,inst_18784__$1];
var inst_18787 = (new cljs.core.PersistentVector(null,2,(5),inst_18785,inst_18786,null));
var state_18798__$1 = (function (){var statearr_18805 = state_18798;
(statearr_18805[(8)] = inst_18784__$1);

return statearr_18805;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18798__$1,(8),jobs,inst_18787);
} else {
if((state_val_18799 === (7))){
var inst_18794 = (state_18798[(2)]);
var state_18798__$1 = state_18798;
var statearr_18806_18918 = state_18798__$1;
(statearr_18806_18918[(2)] = inst_18794);

(statearr_18806_18918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18799 === (8))){
var inst_18784 = (state_18798[(8)]);
var inst_18789 = (state_18798[(2)]);
var state_18798__$1 = (function (){var statearr_18807 = state_18798;
(statearr_18807[(9)] = inst_18789);

return statearr_18807;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18798__$1,(9),results,inst_18784);
} else {
if((state_val_18799 === (9))){
var inst_18791 = (state_18798[(2)]);
var state_18798__$1 = (function (){var statearr_18808 = state_18798;
(statearr_18808[(10)] = inst_18791);

return statearr_18808;
})();
var statearr_18809_18919 = state_18798__$1;
(statearr_18809_18919[(2)] = null);

(statearr_18809_18919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___18913,jobs,results,process,async))
;
return ((function (switch__18225__auto__,c__18337__auto___18913,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_18813 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18813[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__);

(statearr_18813[(1)] = (1));

return statearr_18813;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1 = (function (state_18798){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18798);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18814){if((e18814 instanceof Object)){
var ex__18229__auto__ = e18814;
var statearr_18815_18920 = state_18798;
(statearr_18815_18920[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18798);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18814;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18921 = state_18798;
state_18798 = G__18921;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = function(state_18798){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1.call(this,state_18798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___18913,jobs,results,process,async))
})();
var state__18339__auto__ = (function (){var statearr_18816 = f__18338__auto__.call(null);
(statearr_18816[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___18913);

return statearr_18816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___18913,jobs,results,process,async))
);


var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__,jobs,results,process,async){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__,jobs,results,process,async){
return (function (state_18854){
var state_val_18855 = (state_18854[(1)]);
if((state_val_18855 === (7))){
var inst_18850 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18856_18922 = state_18854__$1;
(statearr_18856_18922[(2)] = inst_18850);

(statearr_18856_18922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (20))){
var state_18854__$1 = state_18854;
var statearr_18857_18923 = state_18854__$1;
(statearr_18857_18923[(2)] = null);

(statearr_18857_18923[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (1))){
var state_18854__$1 = state_18854;
var statearr_18858_18924 = state_18854__$1;
(statearr_18858_18924[(2)] = null);

(statearr_18858_18924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (4))){
var inst_18819 = (state_18854[(7)]);
var inst_18819__$1 = (state_18854[(2)]);
var inst_18820 = (inst_18819__$1 == null);
var state_18854__$1 = (function (){var statearr_18859 = state_18854;
(statearr_18859[(7)] = inst_18819__$1);

return statearr_18859;
})();
if(cljs.core.truth_(inst_18820)){
var statearr_18860_18925 = state_18854__$1;
(statearr_18860_18925[(1)] = (5));

} else {
var statearr_18861_18926 = state_18854__$1;
(statearr_18861_18926[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (15))){
var inst_18832 = (state_18854[(8)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18854__$1,(18),to,inst_18832);
} else {
if((state_val_18855 === (21))){
var inst_18845 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18862_18927 = state_18854__$1;
(statearr_18862_18927[(2)] = inst_18845);

(statearr_18862_18927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (13))){
var inst_18847 = (state_18854[(2)]);
var state_18854__$1 = (function (){var statearr_18863 = state_18854;
(statearr_18863[(9)] = inst_18847);

return statearr_18863;
})();
var statearr_18864_18928 = state_18854__$1;
(statearr_18864_18928[(2)] = null);

(statearr_18864_18928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (6))){
var inst_18819 = (state_18854[(7)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18854__$1,(11),inst_18819);
} else {
if((state_val_18855 === (17))){
var inst_18840 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
if(cljs.core.truth_(inst_18840)){
var statearr_18865_18929 = state_18854__$1;
(statearr_18865_18929[(1)] = (19));

} else {
var statearr_18866_18930 = state_18854__$1;
(statearr_18866_18930[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (3))){
var inst_18852 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18854__$1,inst_18852);
} else {
if((state_val_18855 === (12))){
var inst_18829 = (state_18854[(10)]);
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18854__$1,(14),inst_18829);
} else {
if((state_val_18855 === (2))){
var state_18854__$1 = state_18854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18854__$1,(4),results);
} else {
if((state_val_18855 === (19))){
var state_18854__$1 = state_18854;
var statearr_18867_18931 = state_18854__$1;
(statearr_18867_18931[(2)] = null);

(statearr_18867_18931[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (11))){
var inst_18829 = (state_18854[(2)]);
var state_18854__$1 = (function (){var statearr_18868 = state_18854;
(statearr_18868[(10)] = inst_18829);

return statearr_18868;
})();
var statearr_18869_18932 = state_18854__$1;
(statearr_18869_18932[(2)] = null);

(statearr_18869_18932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (9))){
var state_18854__$1 = state_18854;
var statearr_18870_18933 = state_18854__$1;
(statearr_18870_18933[(2)] = null);

(statearr_18870_18933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (5))){
var state_18854__$1 = state_18854;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18871_18934 = state_18854__$1;
(statearr_18871_18934[(1)] = (8));

} else {
var statearr_18872_18935 = state_18854__$1;
(statearr_18872_18935[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (14))){
var inst_18834 = (state_18854[(11)]);
var inst_18832 = (state_18854[(8)]);
var inst_18832__$1 = (state_18854[(2)]);
var inst_18833 = (inst_18832__$1 == null);
var inst_18834__$1 = cljs.core.not.call(null,inst_18833);
var state_18854__$1 = (function (){var statearr_18873 = state_18854;
(statearr_18873[(11)] = inst_18834__$1);

(statearr_18873[(8)] = inst_18832__$1);

return statearr_18873;
})();
if(inst_18834__$1){
var statearr_18874_18936 = state_18854__$1;
(statearr_18874_18936[(1)] = (15));

} else {
var statearr_18875_18937 = state_18854__$1;
(statearr_18875_18937[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (16))){
var inst_18834 = (state_18854[(11)]);
var state_18854__$1 = state_18854;
var statearr_18876_18938 = state_18854__$1;
(statearr_18876_18938[(2)] = inst_18834);

(statearr_18876_18938[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (10))){
var inst_18826 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18877_18939 = state_18854__$1;
(statearr_18877_18939[(2)] = inst_18826);

(statearr_18877_18939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (18))){
var inst_18837 = (state_18854[(2)]);
var state_18854__$1 = state_18854;
var statearr_18878_18940 = state_18854__$1;
(statearr_18878_18940[(2)] = inst_18837);

(statearr_18878_18940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18855 === (8))){
var inst_18823 = cljs.core.async.close_BANG_.call(null,to);
var state_18854__$1 = state_18854;
var statearr_18879_18941 = state_18854__$1;
(statearr_18879_18941[(2)] = inst_18823);

(statearr_18879_18941[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto__,jobs,results,process,async))
;
return ((function (switch__18225__auto__,c__18337__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_18883 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18883[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__);

(statearr_18883[(1)] = (1));

return statearr_18883;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1 = (function (state_18854){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e18884){if((e18884 instanceof Object)){
var ex__18229__auto__ = e18884;
var statearr_18885_18942 = state_18854;
(statearr_18885_18942[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18854);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18943 = state_18854;
state_18854 = G__18943;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__ = function(state_18854){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1.call(this,state_18854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__,jobs,results,process,async))
})();
var state__18339__auto__ = (function (){var statearr_18886 = f__18338__auto__.call(null);
(statearr_18886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_18886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__,jobs,results,process,async))
);

return c__18337__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18944 = [];
var len__7276__auto___18947 = arguments.length;
var i__7277__auto___18948 = (0);
while(true){
if((i__7277__auto___18948 < len__7276__auto___18947)){
args18944.push((arguments[i__7277__auto___18948]));

var G__18949 = (i__7277__auto___18948 + (1));
i__7277__auto___18948 = G__18949;
continue;
} else {
}
break;
}

var G__18946 = args18944.length;
switch (G__18946) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18944.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18951 = [];
var len__7276__auto___18954 = arguments.length;
var i__7277__auto___18955 = (0);
while(true){
if((i__7277__auto___18955 < len__7276__auto___18954)){
args18951.push((arguments[i__7277__auto___18955]));

var G__18956 = (i__7277__auto___18955 + (1));
i__7277__auto___18955 = G__18956;
continue;
} else {
}
break;
}

var G__18953 = args18951.length;
switch (G__18953) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18951.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18958 = [];
var len__7276__auto___19011 = arguments.length;
var i__7277__auto___19012 = (0);
while(true){
if((i__7277__auto___19012 < len__7276__auto___19011)){
args18958.push((arguments[i__7277__auto___19012]));

var G__19013 = (i__7277__auto___19012 + (1));
i__7277__auto___19012 = G__19013;
continue;
} else {
}
break;
}

var G__18960 = args18958.length;
switch (G__18960) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18958.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__18337__auto___19015 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___19015,tc,fc){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___19015,tc,fc){
return (function (state_18986){
var state_val_18987 = (state_18986[(1)]);
if((state_val_18987 === (7))){
var inst_18982 = (state_18986[(2)]);
var state_18986__$1 = state_18986;
var statearr_18988_19016 = state_18986__$1;
(statearr_18988_19016[(2)] = inst_18982);

(statearr_18988_19016[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (1))){
var state_18986__$1 = state_18986;
var statearr_18989_19017 = state_18986__$1;
(statearr_18989_19017[(2)] = null);

(statearr_18989_19017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (4))){
var inst_18963 = (state_18986[(7)]);
var inst_18963__$1 = (state_18986[(2)]);
var inst_18964 = (inst_18963__$1 == null);
var state_18986__$1 = (function (){var statearr_18990 = state_18986;
(statearr_18990[(7)] = inst_18963__$1);

return statearr_18990;
})();
if(cljs.core.truth_(inst_18964)){
var statearr_18991_19018 = state_18986__$1;
(statearr_18991_19018[(1)] = (5));

} else {
var statearr_18992_19019 = state_18986__$1;
(statearr_18992_19019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (13))){
var state_18986__$1 = state_18986;
var statearr_18993_19020 = state_18986__$1;
(statearr_18993_19020[(2)] = null);

(statearr_18993_19020[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (6))){
var inst_18963 = (state_18986[(7)]);
var inst_18969 = p.call(null,inst_18963);
var state_18986__$1 = state_18986;
if(cljs.core.truth_(inst_18969)){
var statearr_18994_19021 = state_18986__$1;
(statearr_18994_19021[(1)] = (9));

} else {
var statearr_18995_19022 = state_18986__$1;
(statearr_18995_19022[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (3))){
var inst_18984 = (state_18986[(2)]);
var state_18986__$1 = state_18986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18986__$1,inst_18984);
} else {
if((state_val_18987 === (12))){
var state_18986__$1 = state_18986;
var statearr_18996_19023 = state_18986__$1;
(statearr_18996_19023[(2)] = null);

(statearr_18996_19023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (2))){
var state_18986__$1 = state_18986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18986__$1,(4),ch);
} else {
if((state_val_18987 === (11))){
var inst_18963 = (state_18986[(7)]);
var inst_18973 = (state_18986[(2)]);
var state_18986__$1 = state_18986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18986__$1,(8),inst_18973,inst_18963);
} else {
if((state_val_18987 === (9))){
var state_18986__$1 = state_18986;
var statearr_18997_19024 = state_18986__$1;
(statearr_18997_19024[(2)] = tc);

(statearr_18997_19024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (5))){
var inst_18966 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18967 = cljs.core.async.close_BANG_.call(null,fc);
var state_18986__$1 = (function (){var statearr_18998 = state_18986;
(statearr_18998[(8)] = inst_18966);

return statearr_18998;
})();
var statearr_18999_19025 = state_18986__$1;
(statearr_18999_19025[(2)] = inst_18967);

(statearr_18999_19025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (14))){
var inst_18980 = (state_18986[(2)]);
var state_18986__$1 = state_18986;
var statearr_19000_19026 = state_18986__$1;
(statearr_19000_19026[(2)] = inst_18980);

(statearr_19000_19026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (10))){
var state_18986__$1 = state_18986;
var statearr_19001_19027 = state_18986__$1;
(statearr_19001_19027[(2)] = fc);

(statearr_19001_19027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18987 === (8))){
var inst_18975 = (state_18986[(2)]);
var state_18986__$1 = state_18986;
if(cljs.core.truth_(inst_18975)){
var statearr_19002_19028 = state_18986__$1;
(statearr_19002_19028[(1)] = (12));

} else {
var statearr_19003_19029 = state_18986__$1;
(statearr_19003_19029[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___19015,tc,fc))
;
return ((function (switch__18225__auto__,c__18337__auto___19015,tc,fc){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_19007 = [null,null,null,null,null,null,null,null,null];
(statearr_19007[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_19007[(1)] = (1));

return statearr_19007;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_18986){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_18986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e19008){if((e19008 instanceof Object)){
var ex__18229__auto__ = e19008;
var statearr_19009_19030 = state_18986;
(statearr_19009_19030[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19031 = state_18986;
state_18986 = G__19031;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_18986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_18986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___19015,tc,fc))
})();
var state__18339__auto__ = (function (){var statearr_19010 = f__18338__auto__.call(null);
(statearr_19010[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___19015);

return statearr_19010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___19015,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__){
return (function (state_19095){
var state_val_19096 = (state_19095[(1)]);
if((state_val_19096 === (7))){
var inst_19091 = (state_19095[(2)]);
var state_19095__$1 = state_19095;
var statearr_19097_19118 = state_19095__$1;
(statearr_19097_19118[(2)] = inst_19091);

(statearr_19097_19118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (1))){
var inst_19075 = init;
var state_19095__$1 = (function (){var statearr_19098 = state_19095;
(statearr_19098[(7)] = inst_19075);

return statearr_19098;
})();
var statearr_19099_19119 = state_19095__$1;
(statearr_19099_19119[(2)] = null);

(statearr_19099_19119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (4))){
var inst_19078 = (state_19095[(8)]);
var inst_19078__$1 = (state_19095[(2)]);
var inst_19079 = (inst_19078__$1 == null);
var state_19095__$1 = (function (){var statearr_19100 = state_19095;
(statearr_19100[(8)] = inst_19078__$1);

return statearr_19100;
})();
if(cljs.core.truth_(inst_19079)){
var statearr_19101_19120 = state_19095__$1;
(statearr_19101_19120[(1)] = (5));

} else {
var statearr_19102_19121 = state_19095__$1;
(statearr_19102_19121[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (6))){
var inst_19082 = (state_19095[(9)]);
var inst_19075 = (state_19095[(7)]);
var inst_19078 = (state_19095[(8)]);
var inst_19082__$1 = f.call(null,inst_19075,inst_19078);
var inst_19083 = cljs.core.reduced_QMARK_.call(null,inst_19082__$1);
var state_19095__$1 = (function (){var statearr_19103 = state_19095;
(statearr_19103[(9)] = inst_19082__$1);

return statearr_19103;
})();
if(inst_19083){
var statearr_19104_19122 = state_19095__$1;
(statearr_19104_19122[(1)] = (8));

} else {
var statearr_19105_19123 = state_19095__$1;
(statearr_19105_19123[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (3))){
var inst_19093 = (state_19095[(2)]);
var state_19095__$1 = state_19095;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19095__$1,inst_19093);
} else {
if((state_val_19096 === (2))){
var state_19095__$1 = state_19095;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19095__$1,(4),ch);
} else {
if((state_val_19096 === (9))){
var inst_19082 = (state_19095[(9)]);
var inst_19075 = inst_19082;
var state_19095__$1 = (function (){var statearr_19106 = state_19095;
(statearr_19106[(7)] = inst_19075);

return statearr_19106;
})();
var statearr_19107_19124 = state_19095__$1;
(statearr_19107_19124[(2)] = null);

(statearr_19107_19124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (5))){
var inst_19075 = (state_19095[(7)]);
var state_19095__$1 = state_19095;
var statearr_19108_19125 = state_19095__$1;
(statearr_19108_19125[(2)] = inst_19075);

(statearr_19108_19125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (10))){
var inst_19089 = (state_19095[(2)]);
var state_19095__$1 = state_19095;
var statearr_19109_19126 = state_19095__$1;
(statearr_19109_19126[(2)] = inst_19089);

(statearr_19109_19126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19096 === (8))){
var inst_19082 = (state_19095[(9)]);
var inst_19085 = cljs.core.deref.call(null,inst_19082);
var state_19095__$1 = state_19095;
var statearr_19110_19127 = state_19095__$1;
(statearr_19110_19127[(2)] = inst_19085);

(statearr_19110_19127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto__))
;
return ((function (switch__18225__auto__,c__18337__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18226__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18226__auto____0 = (function (){
var statearr_19114 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19114[(0)] = cljs$core$async$reduce_$_state_machine__18226__auto__);

(statearr_19114[(1)] = (1));

return statearr_19114;
});
var cljs$core$async$reduce_$_state_machine__18226__auto____1 = (function (state_19095){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_19095);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e19115){if((e19115 instanceof Object)){
var ex__18229__auto__ = e19115;
var statearr_19116_19128 = state_19095;
(statearr_19116_19128[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19095);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19115;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19129 = state_19095;
state_19095 = G__19129;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18226__auto__ = function(state_19095){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18226__auto____1.call(this,state_19095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18226__auto____0;
cljs$core$async$reduce_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18226__auto____1;
return cljs$core$async$reduce_$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__))
})();
var state__18339__auto__ = (function (){var statearr_19117 = f__18338__auto__.call(null);
(statearr_19117[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_19117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__))
);

return c__18337__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19130 = [];
var len__7276__auto___19182 = arguments.length;
var i__7277__auto___19183 = (0);
while(true){
if((i__7277__auto___19183 < len__7276__auto___19182)){
args19130.push((arguments[i__7277__auto___19183]));

var G__19184 = (i__7277__auto___19183 + (1));
i__7277__auto___19183 = G__19184;
continue;
} else {
}
break;
}

var G__19132 = args19130.length;
switch (G__19132) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19130.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__){
return (function (state_19157){
var state_val_19158 = (state_19157[(1)]);
if((state_val_19158 === (7))){
var inst_19139 = (state_19157[(2)]);
var state_19157__$1 = state_19157;
var statearr_19159_19186 = state_19157__$1;
(statearr_19159_19186[(2)] = inst_19139);

(statearr_19159_19186[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (1))){
var inst_19133 = cljs.core.seq.call(null,coll);
var inst_19134 = inst_19133;
var state_19157__$1 = (function (){var statearr_19160 = state_19157;
(statearr_19160[(7)] = inst_19134);

return statearr_19160;
})();
var statearr_19161_19187 = state_19157__$1;
(statearr_19161_19187[(2)] = null);

(statearr_19161_19187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (4))){
var inst_19134 = (state_19157[(7)]);
var inst_19137 = cljs.core.first.call(null,inst_19134);
var state_19157__$1 = state_19157;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19157__$1,(7),ch,inst_19137);
} else {
if((state_val_19158 === (13))){
var inst_19151 = (state_19157[(2)]);
var state_19157__$1 = state_19157;
var statearr_19162_19188 = state_19157__$1;
(statearr_19162_19188[(2)] = inst_19151);

(statearr_19162_19188[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (6))){
var inst_19142 = (state_19157[(2)]);
var state_19157__$1 = state_19157;
if(cljs.core.truth_(inst_19142)){
var statearr_19163_19189 = state_19157__$1;
(statearr_19163_19189[(1)] = (8));

} else {
var statearr_19164_19190 = state_19157__$1;
(statearr_19164_19190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (3))){
var inst_19155 = (state_19157[(2)]);
var state_19157__$1 = state_19157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19157__$1,inst_19155);
} else {
if((state_val_19158 === (12))){
var state_19157__$1 = state_19157;
var statearr_19165_19191 = state_19157__$1;
(statearr_19165_19191[(2)] = null);

(statearr_19165_19191[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (2))){
var inst_19134 = (state_19157[(7)]);
var state_19157__$1 = state_19157;
if(cljs.core.truth_(inst_19134)){
var statearr_19166_19192 = state_19157__$1;
(statearr_19166_19192[(1)] = (4));

} else {
var statearr_19167_19193 = state_19157__$1;
(statearr_19167_19193[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (11))){
var inst_19148 = cljs.core.async.close_BANG_.call(null,ch);
var state_19157__$1 = state_19157;
var statearr_19168_19194 = state_19157__$1;
(statearr_19168_19194[(2)] = inst_19148);

(statearr_19168_19194[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (9))){
var state_19157__$1 = state_19157;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19169_19195 = state_19157__$1;
(statearr_19169_19195[(1)] = (11));

} else {
var statearr_19170_19196 = state_19157__$1;
(statearr_19170_19196[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (5))){
var inst_19134 = (state_19157[(7)]);
var state_19157__$1 = state_19157;
var statearr_19171_19197 = state_19157__$1;
(statearr_19171_19197[(2)] = inst_19134);

(statearr_19171_19197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (10))){
var inst_19153 = (state_19157[(2)]);
var state_19157__$1 = state_19157;
var statearr_19172_19198 = state_19157__$1;
(statearr_19172_19198[(2)] = inst_19153);

(statearr_19172_19198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19158 === (8))){
var inst_19134 = (state_19157[(7)]);
var inst_19144 = cljs.core.next.call(null,inst_19134);
var inst_19134__$1 = inst_19144;
var state_19157__$1 = (function (){var statearr_19173 = state_19157;
(statearr_19173[(7)] = inst_19134__$1);

return statearr_19173;
})();
var statearr_19174_19199 = state_19157__$1;
(statearr_19174_19199[(2)] = null);

(statearr_19174_19199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto__))
;
return ((function (switch__18225__auto__,c__18337__auto__){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_19178 = [null,null,null,null,null,null,null,null];
(statearr_19178[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_19178[(1)] = (1));

return statearr_19178;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_19157){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_19157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e19179){if((e19179 instanceof Object)){
var ex__18229__auto__ = e19179;
var statearr_19180_19200 = state_19157;
(statearr_19180_19200[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19157);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19201 = state_19157;
state_19157 = G__19201;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_19157){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_19157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__))
})();
var state__18339__auto__ = (function (){var statearr_19181 = f__18338__auto__.call(null);
(statearr_19181[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_19181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__))
);

return c__18337__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6870__auto__ = (((_ == null))?null:_);
var m__6871__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,_);
} else {
var m__6871__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6871__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m);
} else {
var m__6871__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19423 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19423 = (function (mult,ch,cs,meta19424){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta19424 = meta19424;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19425,meta19424__$1){
var self__ = this;
var _19425__$1 = this;
return (new cljs.core.async.t_cljs$core$async19423(self__.mult,self__.ch,self__.cs,meta19424__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19425){
var self__ = this;
var _19425__$1 = this;
return self__.meta19424;
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19424","meta19424",1539285043,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19423.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19423.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19423";

cljs.core.async.t_cljs$core$async19423.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async19423");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19423 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19423(mult__$1,ch__$1,cs__$1,meta19424){
return (new cljs.core.async.t_cljs$core$async19423(mult__$1,ch__$1,cs__$1,meta19424));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19423(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18337__auto___19644 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___19644,cs,m,dchan,dctr,done){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___19644,cs,m,dchan,dctr,done){
return (function (state_19556){
var state_val_19557 = (state_19556[(1)]);
if((state_val_19557 === (7))){
var inst_19552 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19558_19645 = state_19556__$1;
(statearr_19558_19645[(2)] = inst_19552);

(statearr_19558_19645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (20))){
var inst_19457 = (state_19556[(7)]);
var inst_19467 = cljs.core.first.call(null,inst_19457);
var inst_19468 = cljs.core.nth.call(null,inst_19467,(0),null);
var inst_19469 = cljs.core.nth.call(null,inst_19467,(1),null);
var state_19556__$1 = (function (){var statearr_19559 = state_19556;
(statearr_19559[(8)] = inst_19468);

return statearr_19559;
})();
if(cljs.core.truth_(inst_19469)){
var statearr_19560_19646 = state_19556__$1;
(statearr_19560_19646[(1)] = (22));

} else {
var statearr_19561_19647 = state_19556__$1;
(statearr_19561_19647[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (27))){
var inst_19428 = (state_19556[(9)]);
var inst_19504 = (state_19556[(10)]);
var inst_19497 = (state_19556[(11)]);
var inst_19499 = (state_19556[(12)]);
var inst_19504__$1 = cljs.core._nth.call(null,inst_19497,inst_19499);
var inst_19505 = cljs.core.async.put_BANG_.call(null,inst_19504__$1,inst_19428,done);
var state_19556__$1 = (function (){var statearr_19562 = state_19556;
(statearr_19562[(10)] = inst_19504__$1);

return statearr_19562;
})();
if(cljs.core.truth_(inst_19505)){
var statearr_19563_19648 = state_19556__$1;
(statearr_19563_19648[(1)] = (30));

} else {
var statearr_19564_19649 = state_19556__$1;
(statearr_19564_19649[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (1))){
var state_19556__$1 = state_19556;
var statearr_19565_19650 = state_19556__$1;
(statearr_19565_19650[(2)] = null);

(statearr_19565_19650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (24))){
var inst_19457 = (state_19556[(7)]);
var inst_19474 = (state_19556[(2)]);
var inst_19475 = cljs.core.next.call(null,inst_19457);
var inst_19437 = inst_19475;
var inst_19438 = null;
var inst_19439 = (0);
var inst_19440 = (0);
var state_19556__$1 = (function (){var statearr_19566 = state_19556;
(statearr_19566[(13)] = inst_19440);

(statearr_19566[(14)] = inst_19438);

(statearr_19566[(15)] = inst_19439);

(statearr_19566[(16)] = inst_19474);

(statearr_19566[(17)] = inst_19437);

return statearr_19566;
})();
var statearr_19567_19651 = state_19556__$1;
(statearr_19567_19651[(2)] = null);

(statearr_19567_19651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (39))){
var state_19556__$1 = state_19556;
var statearr_19571_19652 = state_19556__$1;
(statearr_19571_19652[(2)] = null);

(statearr_19571_19652[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (4))){
var inst_19428 = (state_19556[(9)]);
var inst_19428__$1 = (state_19556[(2)]);
var inst_19429 = (inst_19428__$1 == null);
var state_19556__$1 = (function (){var statearr_19572 = state_19556;
(statearr_19572[(9)] = inst_19428__$1);

return statearr_19572;
})();
if(cljs.core.truth_(inst_19429)){
var statearr_19573_19653 = state_19556__$1;
(statearr_19573_19653[(1)] = (5));

} else {
var statearr_19574_19654 = state_19556__$1;
(statearr_19574_19654[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (15))){
var inst_19440 = (state_19556[(13)]);
var inst_19438 = (state_19556[(14)]);
var inst_19439 = (state_19556[(15)]);
var inst_19437 = (state_19556[(17)]);
var inst_19453 = (state_19556[(2)]);
var inst_19454 = (inst_19440 + (1));
var tmp19568 = inst_19438;
var tmp19569 = inst_19439;
var tmp19570 = inst_19437;
var inst_19437__$1 = tmp19570;
var inst_19438__$1 = tmp19568;
var inst_19439__$1 = tmp19569;
var inst_19440__$1 = inst_19454;
var state_19556__$1 = (function (){var statearr_19575 = state_19556;
(statearr_19575[(13)] = inst_19440__$1);

(statearr_19575[(14)] = inst_19438__$1);

(statearr_19575[(18)] = inst_19453);

(statearr_19575[(15)] = inst_19439__$1);

(statearr_19575[(17)] = inst_19437__$1);

return statearr_19575;
})();
var statearr_19576_19655 = state_19556__$1;
(statearr_19576_19655[(2)] = null);

(statearr_19576_19655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (21))){
var inst_19478 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19580_19656 = state_19556__$1;
(statearr_19580_19656[(2)] = inst_19478);

(statearr_19580_19656[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (31))){
var inst_19504 = (state_19556[(10)]);
var inst_19508 = done.call(null,null);
var inst_19509 = cljs.core.async.untap_STAR_.call(null,m,inst_19504);
var state_19556__$1 = (function (){var statearr_19581 = state_19556;
(statearr_19581[(19)] = inst_19508);

return statearr_19581;
})();
var statearr_19582_19657 = state_19556__$1;
(statearr_19582_19657[(2)] = inst_19509);

(statearr_19582_19657[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (32))){
var inst_19496 = (state_19556[(20)]);
var inst_19497 = (state_19556[(11)]);
var inst_19499 = (state_19556[(12)]);
var inst_19498 = (state_19556[(21)]);
var inst_19511 = (state_19556[(2)]);
var inst_19512 = (inst_19499 + (1));
var tmp19577 = inst_19496;
var tmp19578 = inst_19497;
var tmp19579 = inst_19498;
var inst_19496__$1 = tmp19577;
var inst_19497__$1 = tmp19578;
var inst_19498__$1 = tmp19579;
var inst_19499__$1 = inst_19512;
var state_19556__$1 = (function (){var statearr_19583 = state_19556;
(statearr_19583[(20)] = inst_19496__$1);

(statearr_19583[(11)] = inst_19497__$1);

(statearr_19583[(12)] = inst_19499__$1);

(statearr_19583[(21)] = inst_19498__$1);

(statearr_19583[(22)] = inst_19511);

return statearr_19583;
})();
var statearr_19584_19658 = state_19556__$1;
(statearr_19584_19658[(2)] = null);

(statearr_19584_19658[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (40))){
var inst_19524 = (state_19556[(23)]);
var inst_19528 = done.call(null,null);
var inst_19529 = cljs.core.async.untap_STAR_.call(null,m,inst_19524);
var state_19556__$1 = (function (){var statearr_19585 = state_19556;
(statearr_19585[(24)] = inst_19528);

return statearr_19585;
})();
var statearr_19586_19659 = state_19556__$1;
(statearr_19586_19659[(2)] = inst_19529);

(statearr_19586_19659[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (33))){
var inst_19515 = (state_19556[(25)]);
var inst_19517 = cljs.core.chunked_seq_QMARK_.call(null,inst_19515);
var state_19556__$1 = state_19556;
if(inst_19517){
var statearr_19587_19660 = state_19556__$1;
(statearr_19587_19660[(1)] = (36));

} else {
var statearr_19588_19661 = state_19556__$1;
(statearr_19588_19661[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (13))){
var inst_19447 = (state_19556[(26)]);
var inst_19450 = cljs.core.async.close_BANG_.call(null,inst_19447);
var state_19556__$1 = state_19556;
var statearr_19589_19662 = state_19556__$1;
(statearr_19589_19662[(2)] = inst_19450);

(statearr_19589_19662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (22))){
var inst_19468 = (state_19556[(8)]);
var inst_19471 = cljs.core.async.close_BANG_.call(null,inst_19468);
var state_19556__$1 = state_19556;
var statearr_19590_19663 = state_19556__$1;
(statearr_19590_19663[(2)] = inst_19471);

(statearr_19590_19663[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (36))){
var inst_19515 = (state_19556[(25)]);
var inst_19519 = cljs.core.chunk_first.call(null,inst_19515);
var inst_19520 = cljs.core.chunk_rest.call(null,inst_19515);
var inst_19521 = cljs.core.count.call(null,inst_19519);
var inst_19496 = inst_19520;
var inst_19497 = inst_19519;
var inst_19498 = inst_19521;
var inst_19499 = (0);
var state_19556__$1 = (function (){var statearr_19591 = state_19556;
(statearr_19591[(20)] = inst_19496);

(statearr_19591[(11)] = inst_19497);

(statearr_19591[(12)] = inst_19499);

(statearr_19591[(21)] = inst_19498);

return statearr_19591;
})();
var statearr_19592_19664 = state_19556__$1;
(statearr_19592_19664[(2)] = null);

(statearr_19592_19664[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (41))){
var inst_19515 = (state_19556[(25)]);
var inst_19531 = (state_19556[(2)]);
var inst_19532 = cljs.core.next.call(null,inst_19515);
var inst_19496 = inst_19532;
var inst_19497 = null;
var inst_19498 = (0);
var inst_19499 = (0);
var state_19556__$1 = (function (){var statearr_19593 = state_19556;
(statearr_19593[(20)] = inst_19496);

(statearr_19593[(27)] = inst_19531);

(statearr_19593[(11)] = inst_19497);

(statearr_19593[(12)] = inst_19499);

(statearr_19593[(21)] = inst_19498);

return statearr_19593;
})();
var statearr_19594_19665 = state_19556__$1;
(statearr_19594_19665[(2)] = null);

(statearr_19594_19665[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (43))){
var state_19556__$1 = state_19556;
var statearr_19595_19666 = state_19556__$1;
(statearr_19595_19666[(2)] = null);

(statearr_19595_19666[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (29))){
var inst_19540 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19596_19667 = state_19556__$1;
(statearr_19596_19667[(2)] = inst_19540);

(statearr_19596_19667[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (44))){
var inst_19549 = (state_19556[(2)]);
var state_19556__$1 = (function (){var statearr_19597 = state_19556;
(statearr_19597[(28)] = inst_19549);

return statearr_19597;
})();
var statearr_19598_19668 = state_19556__$1;
(statearr_19598_19668[(2)] = null);

(statearr_19598_19668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (6))){
var inst_19488 = (state_19556[(29)]);
var inst_19487 = cljs.core.deref.call(null,cs);
var inst_19488__$1 = cljs.core.keys.call(null,inst_19487);
var inst_19489 = cljs.core.count.call(null,inst_19488__$1);
var inst_19490 = cljs.core.reset_BANG_.call(null,dctr,inst_19489);
var inst_19495 = cljs.core.seq.call(null,inst_19488__$1);
var inst_19496 = inst_19495;
var inst_19497 = null;
var inst_19498 = (0);
var inst_19499 = (0);
var state_19556__$1 = (function (){var statearr_19599 = state_19556;
(statearr_19599[(20)] = inst_19496);

(statearr_19599[(11)] = inst_19497);

(statearr_19599[(12)] = inst_19499);

(statearr_19599[(29)] = inst_19488__$1);

(statearr_19599[(30)] = inst_19490);

(statearr_19599[(21)] = inst_19498);

return statearr_19599;
})();
var statearr_19600_19669 = state_19556__$1;
(statearr_19600_19669[(2)] = null);

(statearr_19600_19669[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (28))){
var inst_19496 = (state_19556[(20)]);
var inst_19515 = (state_19556[(25)]);
var inst_19515__$1 = cljs.core.seq.call(null,inst_19496);
var state_19556__$1 = (function (){var statearr_19601 = state_19556;
(statearr_19601[(25)] = inst_19515__$1);

return statearr_19601;
})();
if(inst_19515__$1){
var statearr_19602_19670 = state_19556__$1;
(statearr_19602_19670[(1)] = (33));

} else {
var statearr_19603_19671 = state_19556__$1;
(statearr_19603_19671[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (25))){
var inst_19499 = (state_19556[(12)]);
var inst_19498 = (state_19556[(21)]);
var inst_19501 = (inst_19499 < inst_19498);
var inst_19502 = inst_19501;
var state_19556__$1 = state_19556;
if(cljs.core.truth_(inst_19502)){
var statearr_19604_19672 = state_19556__$1;
(statearr_19604_19672[(1)] = (27));

} else {
var statearr_19605_19673 = state_19556__$1;
(statearr_19605_19673[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (34))){
var state_19556__$1 = state_19556;
var statearr_19606_19674 = state_19556__$1;
(statearr_19606_19674[(2)] = null);

(statearr_19606_19674[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (17))){
var state_19556__$1 = state_19556;
var statearr_19607_19675 = state_19556__$1;
(statearr_19607_19675[(2)] = null);

(statearr_19607_19675[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (3))){
var inst_19554 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19556__$1,inst_19554);
} else {
if((state_val_19557 === (12))){
var inst_19483 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19608_19676 = state_19556__$1;
(statearr_19608_19676[(2)] = inst_19483);

(statearr_19608_19676[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (2))){
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19556__$1,(4),ch);
} else {
if((state_val_19557 === (23))){
var state_19556__$1 = state_19556;
var statearr_19609_19677 = state_19556__$1;
(statearr_19609_19677[(2)] = null);

(statearr_19609_19677[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (35))){
var inst_19538 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19610_19678 = state_19556__$1;
(statearr_19610_19678[(2)] = inst_19538);

(statearr_19610_19678[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (19))){
var inst_19457 = (state_19556[(7)]);
var inst_19461 = cljs.core.chunk_first.call(null,inst_19457);
var inst_19462 = cljs.core.chunk_rest.call(null,inst_19457);
var inst_19463 = cljs.core.count.call(null,inst_19461);
var inst_19437 = inst_19462;
var inst_19438 = inst_19461;
var inst_19439 = inst_19463;
var inst_19440 = (0);
var state_19556__$1 = (function (){var statearr_19611 = state_19556;
(statearr_19611[(13)] = inst_19440);

(statearr_19611[(14)] = inst_19438);

(statearr_19611[(15)] = inst_19439);

(statearr_19611[(17)] = inst_19437);

return statearr_19611;
})();
var statearr_19612_19679 = state_19556__$1;
(statearr_19612_19679[(2)] = null);

(statearr_19612_19679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (11))){
var inst_19437 = (state_19556[(17)]);
var inst_19457 = (state_19556[(7)]);
var inst_19457__$1 = cljs.core.seq.call(null,inst_19437);
var state_19556__$1 = (function (){var statearr_19613 = state_19556;
(statearr_19613[(7)] = inst_19457__$1);

return statearr_19613;
})();
if(inst_19457__$1){
var statearr_19614_19680 = state_19556__$1;
(statearr_19614_19680[(1)] = (16));

} else {
var statearr_19615_19681 = state_19556__$1;
(statearr_19615_19681[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (9))){
var inst_19485 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19616_19682 = state_19556__$1;
(statearr_19616_19682[(2)] = inst_19485);

(statearr_19616_19682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (5))){
var inst_19435 = cljs.core.deref.call(null,cs);
var inst_19436 = cljs.core.seq.call(null,inst_19435);
var inst_19437 = inst_19436;
var inst_19438 = null;
var inst_19439 = (0);
var inst_19440 = (0);
var state_19556__$1 = (function (){var statearr_19617 = state_19556;
(statearr_19617[(13)] = inst_19440);

(statearr_19617[(14)] = inst_19438);

(statearr_19617[(15)] = inst_19439);

(statearr_19617[(17)] = inst_19437);

return statearr_19617;
})();
var statearr_19618_19683 = state_19556__$1;
(statearr_19618_19683[(2)] = null);

(statearr_19618_19683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (14))){
var state_19556__$1 = state_19556;
var statearr_19619_19684 = state_19556__$1;
(statearr_19619_19684[(2)] = null);

(statearr_19619_19684[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (45))){
var inst_19546 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19620_19685 = state_19556__$1;
(statearr_19620_19685[(2)] = inst_19546);

(statearr_19620_19685[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (26))){
var inst_19488 = (state_19556[(29)]);
var inst_19542 = (state_19556[(2)]);
var inst_19543 = cljs.core.seq.call(null,inst_19488);
var state_19556__$1 = (function (){var statearr_19621 = state_19556;
(statearr_19621[(31)] = inst_19542);

return statearr_19621;
})();
if(inst_19543){
var statearr_19622_19686 = state_19556__$1;
(statearr_19622_19686[(1)] = (42));

} else {
var statearr_19623_19687 = state_19556__$1;
(statearr_19623_19687[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (16))){
var inst_19457 = (state_19556[(7)]);
var inst_19459 = cljs.core.chunked_seq_QMARK_.call(null,inst_19457);
var state_19556__$1 = state_19556;
if(inst_19459){
var statearr_19624_19688 = state_19556__$1;
(statearr_19624_19688[(1)] = (19));

} else {
var statearr_19625_19689 = state_19556__$1;
(statearr_19625_19689[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (38))){
var inst_19535 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19626_19690 = state_19556__$1;
(statearr_19626_19690[(2)] = inst_19535);

(statearr_19626_19690[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (30))){
var state_19556__$1 = state_19556;
var statearr_19627_19691 = state_19556__$1;
(statearr_19627_19691[(2)] = null);

(statearr_19627_19691[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (10))){
var inst_19440 = (state_19556[(13)]);
var inst_19438 = (state_19556[(14)]);
var inst_19446 = cljs.core._nth.call(null,inst_19438,inst_19440);
var inst_19447 = cljs.core.nth.call(null,inst_19446,(0),null);
var inst_19448 = cljs.core.nth.call(null,inst_19446,(1),null);
var state_19556__$1 = (function (){var statearr_19628 = state_19556;
(statearr_19628[(26)] = inst_19447);

return statearr_19628;
})();
if(cljs.core.truth_(inst_19448)){
var statearr_19629_19692 = state_19556__$1;
(statearr_19629_19692[(1)] = (13));

} else {
var statearr_19630_19693 = state_19556__$1;
(statearr_19630_19693[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (18))){
var inst_19481 = (state_19556[(2)]);
var state_19556__$1 = state_19556;
var statearr_19631_19694 = state_19556__$1;
(statearr_19631_19694[(2)] = inst_19481);

(statearr_19631_19694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (42))){
var state_19556__$1 = state_19556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19556__$1,(45),dchan);
} else {
if((state_val_19557 === (37))){
var inst_19428 = (state_19556[(9)]);
var inst_19524 = (state_19556[(23)]);
var inst_19515 = (state_19556[(25)]);
var inst_19524__$1 = cljs.core.first.call(null,inst_19515);
var inst_19525 = cljs.core.async.put_BANG_.call(null,inst_19524__$1,inst_19428,done);
var state_19556__$1 = (function (){var statearr_19632 = state_19556;
(statearr_19632[(23)] = inst_19524__$1);

return statearr_19632;
})();
if(cljs.core.truth_(inst_19525)){
var statearr_19633_19695 = state_19556__$1;
(statearr_19633_19695[(1)] = (39));

} else {
var statearr_19634_19696 = state_19556__$1;
(statearr_19634_19696[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19557 === (8))){
var inst_19440 = (state_19556[(13)]);
var inst_19439 = (state_19556[(15)]);
var inst_19442 = (inst_19440 < inst_19439);
var inst_19443 = inst_19442;
var state_19556__$1 = state_19556;
if(cljs.core.truth_(inst_19443)){
var statearr_19635_19697 = state_19556__$1;
(statearr_19635_19697[(1)] = (10));

} else {
var statearr_19636_19698 = state_19556__$1;
(statearr_19636_19698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___19644,cs,m,dchan,dctr,done))
;
return ((function (switch__18225__auto__,c__18337__auto___19644,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18226__auto__ = null;
var cljs$core$async$mult_$_state_machine__18226__auto____0 = (function (){
var statearr_19640 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19640[(0)] = cljs$core$async$mult_$_state_machine__18226__auto__);

(statearr_19640[(1)] = (1));

return statearr_19640;
});
var cljs$core$async$mult_$_state_machine__18226__auto____1 = (function (state_19556){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_19556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e19641){if((e19641 instanceof Object)){
var ex__18229__auto__ = e19641;
var statearr_19642_19699 = state_19556;
(statearr_19642_19699[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19556);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19641;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19700 = state_19556;
state_19556 = G__19700;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18226__auto__ = function(state_19556){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18226__auto____1.call(this,state_19556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18226__auto____0;
cljs$core$async$mult_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18226__auto____1;
return cljs$core$async$mult_$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___19644,cs,m,dchan,dctr,done))
})();
var state__18339__auto__ = (function (){var statearr_19643 = f__18338__auto__.call(null);
(statearr_19643[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___19644);

return statearr_19643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___19644,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args19701 = [];
var len__7276__auto___19704 = arguments.length;
var i__7277__auto___19705 = (0);
while(true){
if((i__7277__auto___19705 < len__7276__auto___19704)){
args19701.push((arguments[i__7277__auto___19705]));

var G__19706 = (i__7277__auto___19705 + (1));
i__7277__auto___19705 = G__19706;
continue;
} else {
}
break;
}

var G__19703 = args19701.length;
switch (G__19703) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19701.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m);
} else {
var m__6871__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,state_map);
} else {
var m__6871__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,mode);
} else {
var m__6871__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___19718 = arguments.length;
var i__7277__auto___19719 = (0);
while(true){
if((i__7277__auto___19719 < len__7276__auto___19718)){
args__7283__auto__.push((arguments[i__7277__auto___19719]));

var G__19720 = (i__7277__auto___19719 + (1));
i__7277__auto___19719 = G__19720;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((3) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7284__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19712){
var map__19713 = p__19712;
var map__19713__$1 = ((((!((map__19713 == null)))?((((map__19713.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19713.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19713):map__19713);
var opts = map__19713__$1;
var statearr_19715_19721 = state;
(statearr_19715_19721[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__19713,map__19713__$1,opts){
return (function (val){
var statearr_19716_19722 = state;
(statearr_19716_19722[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__19713,map__19713__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_19717_19723 = state;
(statearr_19717_19723[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19708){
var G__19709 = cljs.core.first.call(null,seq19708);
var seq19708__$1 = cljs.core.next.call(null,seq19708);
var G__19710 = cljs.core.first.call(null,seq19708__$1);
var seq19708__$2 = cljs.core.next.call(null,seq19708__$1);
var G__19711 = cljs.core.first.call(null,seq19708__$2);
var seq19708__$3 = cljs.core.next.call(null,seq19708__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19709,G__19710,G__19711,seq19708__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19887 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19887 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19888){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19888 = meta19888;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19889,meta19888__$1){
var self__ = this;
var _19889__$1 = this;
return (new cljs.core.async.t_cljs$core$async19887(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19888__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19889){
var self__ = this;
var _19889__$1 = this;
return self__.meta19888;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19888","meta19888",299443453,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19887.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19887.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19887";

cljs.core.async.t_cljs$core$async19887.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async19887");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19887 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19887(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19888){
return (new cljs.core.async.t_cljs$core$async19887(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19888));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19887(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18337__auto___20050 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19987){
var state_val_19988 = (state_19987[(1)]);
if((state_val_19988 === (7))){
var inst_19905 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
var statearr_19989_20051 = state_19987__$1;
(statearr_19989_20051[(2)] = inst_19905);

(statearr_19989_20051[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (20))){
var inst_19917 = (state_19987[(7)]);
var state_19987__$1 = state_19987;
var statearr_19990_20052 = state_19987__$1;
(statearr_19990_20052[(2)] = inst_19917);

(statearr_19990_20052[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (27))){
var state_19987__$1 = state_19987;
var statearr_19991_20053 = state_19987__$1;
(statearr_19991_20053[(2)] = null);

(statearr_19991_20053[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (1))){
var inst_19893 = (state_19987[(8)]);
var inst_19893__$1 = calc_state.call(null);
var inst_19895 = (inst_19893__$1 == null);
var inst_19896 = cljs.core.not.call(null,inst_19895);
var state_19987__$1 = (function (){var statearr_19992 = state_19987;
(statearr_19992[(8)] = inst_19893__$1);

return statearr_19992;
})();
if(inst_19896){
var statearr_19993_20054 = state_19987__$1;
(statearr_19993_20054[(1)] = (2));

} else {
var statearr_19994_20055 = state_19987__$1;
(statearr_19994_20055[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (24))){
var inst_19947 = (state_19987[(9)]);
var inst_19940 = (state_19987[(10)]);
var inst_19961 = (state_19987[(11)]);
var inst_19961__$1 = inst_19940.call(null,inst_19947);
var state_19987__$1 = (function (){var statearr_19995 = state_19987;
(statearr_19995[(11)] = inst_19961__$1);

return statearr_19995;
})();
if(cljs.core.truth_(inst_19961__$1)){
var statearr_19996_20056 = state_19987__$1;
(statearr_19996_20056[(1)] = (29));

} else {
var statearr_19997_20057 = state_19987__$1;
(statearr_19997_20057[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (4))){
var inst_19908 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19908)){
var statearr_19998_20058 = state_19987__$1;
(statearr_19998_20058[(1)] = (8));

} else {
var statearr_19999_20059 = state_19987__$1;
(statearr_19999_20059[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (15))){
var inst_19934 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19934)){
var statearr_20000_20060 = state_19987__$1;
(statearr_20000_20060[(1)] = (19));

} else {
var statearr_20001_20061 = state_19987__$1;
(statearr_20001_20061[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (21))){
var inst_19939 = (state_19987[(12)]);
var inst_19939__$1 = (state_19987[(2)]);
var inst_19940 = cljs.core.get.call(null,inst_19939__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19941 = cljs.core.get.call(null,inst_19939__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19942 = cljs.core.get.call(null,inst_19939__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19987__$1 = (function (){var statearr_20002 = state_19987;
(statearr_20002[(13)] = inst_19941);

(statearr_20002[(10)] = inst_19940);

(statearr_20002[(12)] = inst_19939__$1);

return statearr_20002;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19987__$1,(22),inst_19942);
} else {
if((state_val_19988 === (31))){
var inst_19969 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19969)){
var statearr_20003_20062 = state_19987__$1;
(statearr_20003_20062[(1)] = (32));

} else {
var statearr_20004_20063 = state_19987__$1;
(statearr_20004_20063[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (32))){
var inst_19946 = (state_19987[(14)]);
var state_19987__$1 = state_19987;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19987__$1,(35),out,inst_19946);
} else {
if((state_val_19988 === (33))){
var inst_19939 = (state_19987[(12)]);
var inst_19917 = inst_19939;
var state_19987__$1 = (function (){var statearr_20005 = state_19987;
(statearr_20005[(7)] = inst_19917);

return statearr_20005;
})();
var statearr_20006_20064 = state_19987__$1;
(statearr_20006_20064[(2)] = null);

(statearr_20006_20064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (13))){
var inst_19917 = (state_19987[(7)]);
var inst_19924 = inst_19917.cljs$lang$protocol_mask$partition0$;
var inst_19925 = (inst_19924 & (64));
var inst_19926 = inst_19917.cljs$core$ISeq$;
var inst_19927 = (inst_19925) || (inst_19926);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19927)){
var statearr_20007_20065 = state_19987__$1;
(statearr_20007_20065[(1)] = (16));

} else {
var statearr_20008_20066 = state_19987__$1;
(statearr_20008_20066[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (22))){
var inst_19947 = (state_19987[(9)]);
var inst_19946 = (state_19987[(14)]);
var inst_19945 = (state_19987[(2)]);
var inst_19946__$1 = cljs.core.nth.call(null,inst_19945,(0),null);
var inst_19947__$1 = cljs.core.nth.call(null,inst_19945,(1),null);
var inst_19948 = (inst_19946__$1 == null);
var inst_19949 = cljs.core._EQ_.call(null,inst_19947__$1,change);
var inst_19950 = (inst_19948) || (inst_19949);
var state_19987__$1 = (function (){var statearr_20009 = state_19987;
(statearr_20009[(9)] = inst_19947__$1);

(statearr_20009[(14)] = inst_19946__$1);

return statearr_20009;
})();
if(cljs.core.truth_(inst_19950)){
var statearr_20010_20067 = state_19987__$1;
(statearr_20010_20067[(1)] = (23));

} else {
var statearr_20011_20068 = state_19987__$1;
(statearr_20011_20068[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (36))){
var inst_19939 = (state_19987[(12)]);
var inst_19917 = inst_19939;
var state_19987__$1 = (function (){var statearr_20012 = state_19987;
(statearr_20012[(7)] = inst_19917);

return statearr_20012;
})();
var statearr_20013_20069 = state_19987__$1;
(statearr_20013_20069[(2)] = null);

(statearr_20013_20069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (29))){
var inst_19961 = (state_19987[(11)]);
var state_19987__$1 = state_19987;
var statearr_20014_20070 = state_19987__$1;
(statearr_20014_20070[(2)] = inst_19961);

(statearr_20014_20070[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (6))){
var state_19987__$1 = state_19987;
var statearr_20015_20071 = state_19987__$1;
(statearr_20015_20071[(2)] = false);

(statearr_20015_20071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (28))){
var inst_19957 = (state_19987[(2)]);
var inst_19958 = calc_state.call(null);
var inst_19917 = inst_19958;
var state_19987__$1 = (function (){var statearr_20016 = state_19987;
(statearr_20016[(15)] = inst_19957);

(statearr_20016[(7)] = inst_19917);

return statearr_20016;
})();
var statearr_20017_20072 = state_19987__$1;
(statearr_20017_20072[(2)] = null);

(statearr_20017_20072[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (25))){
var inst_19983 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
var statearr_20018_20073 = state_19987__$1;
(statearr_20018_20073[(2)] = inst_19983);

(statearr_20018_20073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (34))){
var inst_19981 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
var statearr_20019_20074 = state_19987__$1;
(statearr_20019_20074[(2)] = inst_19981);

(statearr_20019_20074[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (17))){
var state_19987__$1 = state_19987;
var statearr_20020_20075 = state_19987__$1;
(statearr_20020_20075[(2)] = false);

(statearr_20020_20075[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (3))){
var state_19987__$1 = state_19987;
var statearr_20021_20076 = state_19987__$1;
(statearr_20021_20076[(2)] = false);

(statearr_20021_20076[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (12))){
var inst_19985 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19987__$1,inst_19985);
} else {
if((state_val_19988 === (2))){
var inst_19893 = (state_19987[(8)]);
var inst_19898 = inst_19893.cljs$lang$protocol_mask$partition0$;
var inst_19899 = (inst_19898 & (64));
var inst_19900 = inst_19893.cljs$core$ISeq$;
var inst_19901 = (inst_19899) || (inst_19900);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19901)){
var statearr_20022_20077 = state_19987__$1;
(statearr_20022_20077[(1)] = (5));

} else {
var statearr_20023_20078 = state_19987__$1;
(statearr_20023_20078[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (23))){
var inst_19946 = (state_19987[(14)]);
var inst_19952 = (inst_19946 == null);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19952)){
var statearr_20024_20079 = state_19987__$1;
(statearr_20024_20079[(1)] = (26));

} else {
var statearr_20025_20080 = state_19987__$1;
(statearr_20025_20080[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (35))){
var inst_19972 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
if(cljs.core.truth_(inst_19972)){
var statearr_20026_20081 = state_19987__$1;
(statearr_20026_20081[(1)] = (36));

} else {
var statearr_20027_20082 = state_19987__$1;
(statearr_20027_20082[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (19))){
var inst_19917 = (state_19987[(7)]);
var inst_19936 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19917);
var state_19987__$1 = state_19987;
var statearr_20028_20083 = state_19987__$1;
(statearr_20028_20083[(2)] = inst_19936);

(statearr_20028_20083[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (11))){
var inst_19917 = (state_19987[(7)]);
var inst_19921 = (inst_19917 == null);
var inst_19922 = cljs.core.not.call(null,inst_19921);
var state_19987__$1 = state_19987;
if(inst_19922){
var statearr_20029_20084 = state_19987__$1;
(statearr_20029_20084[(1)] = (13));

} else {
var statearr_20030_20085 = state_19987__$1;
(statearr_20030_20085[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (9))){
var inst_19893 = (state_19987[(8)]);
var state_19987__$1 = state_19987;
var statearr_20031_20086 = state_19987__$1;
(statearr_20031_20086[(2)] = inst_19893);

(statearr_20031_20086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (5))){
var state_19987__$1 = state_19987;
var statearr_20032_20087 = state_19987__$1;
(statearr_20032_20087[(2)] = true);

(statearr_20032_20087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (14))){
var state_19987__$1 = state_19987;
var statearr_20033_20088 = state_19987__$1;
(statearr_20033_20088[(2)] = false);

(statearr_20033_20088[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (26))){
var inst_19947 = (state_19987[(9)]);
var inst_19954 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19947);
var state_19987__$1 = state_19987;
var statearr_20034_20089 = state_19987__$1;
(statearr_20034_20089[(2)] = inst_19954);

(statearr_20034_20089[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (16))){
var state_19987__$1 = state_19987;
var statearr_20035_20090 = state_19987__$1;
(statearr_20035_20090[(2)] = true);

(statearr_20035_20090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (38))){
var inst_19977 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
var statearr_20036_20091 = state_19987__$1;
(statearr_20036_20091[(2)] = inst_19977);

(statearr_20036_20091[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (30))){
var inst_19947 = (state_19987[(9)]);
var inst_19941 = (state_19987[(13)]);
var inst_19940 = (state_19987[(10)]);
var inst_19964 = cljs.core.empty_QMARK_.call(null,inst_19940);
var inst_19965 = inst_19941.call(null,inst_19947);
var inst_19966 = cljs.core.not.call(null,inst_19965);
var inst_19967 = (inst_19964) && (inst_19966);
var state_19987__$1 = state_19987;
var statearr_20037_20092 = state_19987__$1;
(statearr_20037_20092[(2)] = inst_19967);

(statearr_20037_20092[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (10))){
var inst_19893 = (state_19987[(8)]);
var inst_19913 = (state_19987[(2)]);
var inst_19914 = cljs.core.get.call(null,inst_19913,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19915 = cljs.core.get.call(null,inst_19913,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19916 = cljs.core.get.call(null,inst_19913,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19917 = inst_19893;
var state_19987__$1 = (function (){var statearr_20038 = state_19987;
(statearr_20038[(16)] = inst_19916);

(statearr_20038[(17)] = inst_19914);

(statearr_20038[(18)] = inst_19915);

(statearr_20038[(7)] = inst_19917);

return statearr_20038;
})();
var statearr_20039_20093 = state_19987__$1;
(statearr_20039_20093[(2)] = null);

(statearr_20039_20093[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (18))){
var inst_19931 = (state_19987[(2)]);
var state_19987__$1 = state_19987;
var statearr_20040_20094 = state_19987__$1;
(statearr_20040_20094[(2)] = inst_19931);

(statearr_20040_20094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (37))){
var state_19987__$1 = state_19987;
var statearr_20041_20095 = state_19987__$1;
(statearr_20041_20095[(2)] = null);

(statearr_20041_20095[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19988 === (8))){
var inst_19893 = (state_19987[(8)]);
var inst_19910 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19893);
var state_19987__$1 = state_19987;
var statearr_20042_20096 = state_19987__$1;
(statearr_20042_20096[(2)] = inst_19910);

(statearr_20042_20096[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18225__auto__,c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18226__auto__ = null;
var cljs$core$async$mix_$_state_machine__18226__auto____0 = (function (){
var statearr_20046 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20046[(0)] = cljs$core$async$mix_$_state_machine__18226__auto__);

(statearr_20046[(1)] = (1));

return statearr_20046;
});
var cljs$core$async$mix_$_state_machine__18226__auto____1 = (function (state_19987){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_19987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20047){if((e20047 instanceof Object)){
var ex__18229__auto__ = e20047;
var statearr_20048_20097 = state_19987;
(statearr_20048_20097[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19987);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20047;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20098 = state_19987;
state_19987 = G__20098;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18226__auto__ = function(state_19987){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18226__auto____1.call(this,state_19987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18226__auto____0;
cljs$core$async$mix_$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18226__auto____1;
return cljs$core$async$mix_$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18339__auto__ = (function (){var statearr_20049 = f__18338__auto__.call(null);
(statearr_20049[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20050);

return statearr_20049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20050,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6871__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20099 = [];
var len__7276__auto___20102 = arguments.length;
var i__7277__auto___20103 = (0);
while(true){
if((i__7277__auto___20103 < len__7276__auto___20102)){
args20099.push((arguments[i__7277__auto___20103]));

var G__20104 = (i__7277__auto___20103 + (1));
i__7277__auto___20103 = G__20104;
continue;
} else {
}
break;
}

var G__20101 = args20099.length;
switch (G__20101) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20099.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20107 = [];
var len__7276__auto___20232 = arguments.length;
var i__7277__auto___20233 = (0);
while(true){
if((i__7277__auto___20233 < len__7276__auto___20232)){
args20107.push((arguments[i__7277__auto___20233]));

var G__20234 = (i__7277__auto___20233 + (1));
i__7277__auto___20233 = G__20234;
continue;
} else {
}
break;
}

var G__20109 = args20107.length;
switch (G__20109) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20107.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6207__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6207__auto__,mults){
return (function (p1__20106_SHARP_){
if(cljs.core.truth_(p1__20106_SHARP_.call(null,topic))){
return p1__20106_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20106_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6207__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20110 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20110 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20111){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20111 = meta20111;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20112,meta20111__$1){
var self__ = this;
var _20112__$1 = this;
return (new cljs.core.async.t_cljs$core$async20110(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20111__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20112){
var self__ = this;
var _20112__$1 = this;
return self__.meta20111;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20111","meta20111",669831591,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20110.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20110.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20110";

cljs.core.async.t_cljs$core$async20110.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20110");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20110 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20110(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20111){
return (new cljs.core.async.t_cljs$core$async20110(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20111));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20110(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18337__auto___20236 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20236,mults,ensure_mult,p){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20236,mults,ensure_mult,p){
return (function (state_20184){
var state_val_20185 = (state_20184[(1)]);
if((state_val_20185 === (7))){
var inst_20180 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20186_20237 = state_20184__$1;
(statearr_20186_20237[(2)] = inst_20180);

(statearr_20186_20237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (20))){
var state_20184__$1 = state_20184;
var statearr_20187_20238 = state_20184__$1;
(statearr_20187_20238[(2)] = null);

(statearr_20187_20238[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (1))){
var state_20184__$1 = state_20184;
var statearr_20188_20239 = state_20184__$1;
(statearr_20188_20239[(2)] = null);

(statearr_20188_20239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (24))){
var inst_20163 = (state_20184[(7)]);
var inst_20172 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20163);
var state_20184__$1 = state_20184;
var statearr_20189_20240 = state_20184__$1;
(statearr_20189_20240[(2)] = inst_20172);

(statearr_20189_20240[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (4))){
var inst_20115 = (state_20184[(8)]);
var inst_20115__$1 = (state_20184[(2)]);
var inst_20116 = (inst_20115__$1 == null);
var state_20184__$1 = (function (){var statearr_20190 = state_20184;
(statearr_20190[(8)] = inst_20115__$1);

return statearr_20190;
})();
if(cljs.core.truth_(inst_20116)){
var statearr_20191_20241 = state_20184__$1;
(statearr_20191_20241[(1)] = (5));

} else {
var statearr_20192_20242 = state_20184__$1;
(statearr_20192_20242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (15))){
var inst_20157 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20193_20243 = state_20184__$1;
(statearr_20193_20243[(2)] = inst_20157);

(statearr_20193_20243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (21))){
var inst_20177 = (state_20184[(2)]);
var state_20184__$1 = (function (){var statearr_20194 = state_20184;
(statearr_20194[(9)] = inst_20177);

return statearr_20194;
})();
var statearr_20195_20244 = state_20184__$1;
(statearr_20195_20244[(2)] = null);

(statearr_20195_20244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (13))){
var inst_20139 = (state_20184[(10)]);
var inst_20141 = cljs.core.chunked_seq_QMARK_.call(null,inst_20139);
var state_20184__$1 = state_20184;
if(inst_20141){
var statearr_20196_20245 = state_20184__$1;
(statearr_20196_20245[(1)] = (16));

} else {
var statearr_20197_20246 = state_20184__$1;
(statearr_20197_20246[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (22))){
var inst_20169 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20169)){
var statearr_20198_20247 = state_20184__$1;
(statearr_20198_20247[(1)] = (23));

} else {
var statearr_20199_20248 = state_20184__$1;
(statearr_20199_20248[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (6))){
var inst_20115 = (state_20184[(8)]);
var inst_20163 = (state_20184[(7)]);
var inst_20165 = (state_20184[(11)]);
var inst_20163__$1 = topic_fn.call(null,inst_20115);
var inst_20164 = cljs.core.deref.call(null,mults);
var inst_20165__$1 = cljs.core.get.call(null,inst_20164,inst_20163__$1);
var state_20184__$1 = (function (){var statearr_20200 = state_20184;
(statearr_20200[(7)] = inst_20163__$1);

(statearr_20200[(11)] = inst_20165__$1);

return statearr_20200;
})();
if(cljs.core.truth_(inst_20165__$1)){
var statearr_20201_20249 = state_20184__$1;
(statearr_20201_20249[(1)] = (19));

} else {
var statearr_20202_20250 = state_20184__$1;
(statearr_20202_20250[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (25))){
var inst_20174 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20203_20251 = state_20184__$1;
(statearr_20203_20251[(2)] = inst_20174);

(statearr_20203_20251[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (17))){
var inst_20139 = (state_20184[(10)]);
var inst_20148 = cljs.core.first.call(null,inst_20139);
var inst_20149 = cljs.core.async.muxch_STAR_.call(null,inst_20148);
var inst_20150 = cljs.core.async.close_BANG_.call(null,inst_20149);
var inst_20151 = cljs.core.next.call(null,inst_20139);
var inst_20125 = inst_20151;
var inst_20126 = null;
var inst_20127 = (0);
var inst_20128 = (0);
var state_20184__$1 = (function (){var statearr_20204 = state_20184;
(statearr_20204[(12)] = inst_20128);

(statearr_20204[(13)] = inst_20126);

(statearr_20204[(14)] = inst_20125);

(statearr_20204[(15)] = inst_20127);

(statearr_20204[(16)] = inst_20150);

return statearr_20204;
})();
var statearr_20205_20252 = state_20184__$1;
(statearr_20205_20252[(2)] = null);

(statearr_20205_20252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (3))){
var inst_20182 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20184__$1,inst_20182);
} else {
if((state_val_20185 === (12))){
var inst_20159 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20206_20253 = state_20184__$1;
(statearr_20206_20253[(2)] = inst_20159);

(statearr_20206_20253[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (2))){
var state_20184__$1 = state_20184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20184__$1,(4),ch);
} else {
if((state_val_20185 === (23))){
var state_20184__$1 = state_20184;
var statearr_20207_20254 = state_20184__$1;
(statearr_20207_20254[(2)] = null);

(statearr_20207_20254[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (19))){
var inst_20115 = (state_20184[(8)]);
var inst_20165 = (state_20184[(11)]);
var inst_20167 = cljs.core.async.muxch_STAR_.call(null,inst_20165);
var state_20184__$1 = state_20184;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20184__$1,(22),inst_20167,inst_20115);
} else {
if((state_val_20185 === (11))){
var inst_20139 = (state_20184[(10)]);
var inst_20125 = (state_20184[(14)]);
var inst_20139__$1 = cljs.core.seq.call(null,inst_20125);
var state_20184__$1 = (function (){var statearr_20208 = state_20184;
(statearr_20208[(10)] = inst_20139__$1);

return statearr_20208;
})();
if(inst_20139__$1){
var statearr_20209_20255 = state_20184__$1;
(statearr_20209_20255[(1)] = (13));

} else {
var statearr_20210_20256 = state_20184__$1;
(statearr_20210_20256[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (9))){
var inst_20161 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20211_20257 = state_20184__$1;
(statearr_20211_20257[(2)] = inst_20161);

(statearr_20211_20257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (5))){
var inst_20122 = cljs.core.deref.call(null,mults);
var inst_20123 = cljs.core.vals.call(null,inst_20122);
var inst_20124 = cljs.core.seq.call(null,inst_20123);
var inst_20125 = inst_20124;
var inst_20126 = null;
var inst_20127 = (0);
var inst_20128 = (0);
var state_20184__$1 = (function (){var statearr_20212 = state_20184;
(statearr_20212[(12)] = inst_20128);

(statearr_20212[(13)] = inst_20126);

(statearr_20212[(14)] = inst_20125);

(statearr_20212[(15)] = inst_20127);

return statearr_20212;
})();
var statearr_20213_20258 = state_20184__$1;
(statearr_20213_20258[(2)] = null);

(statearr_20213_20258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (14))){
var state_20184__$1 = state_20184;
var statearr_20217_20259 = state_20184__$1;
(statearr_20217_20259[(2)] = null);

(statearr_20217_20259[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (16))){
var inst_20139 = (state_20184[(10)]);
var inst_20143 = cljs.core.chunk_first.call(null,inst_20139);
var inst_20144 = cljs.core.chunk_rest.call(null,inst_20139);
var inst_20145 = cljs.core.count.call(null,inst_20143);
var inst_20125 = inst_20144;
var inst_20126 = inst_20143;
var inst_20127 = inst_20145;
var inst_20128 = (0);
var state_20184__$1 = (function (){var statearr_20218 = state_20184;
(statearr_20218[(12)] = inst_20128);

(statearr_20218[(13)] = inst_20126);

(statearr_20218[(14)] = inst_20125);

(statearr_20218[(15)] = inst_20127);

return statearr_20218;
})();
var statearr_20219_20260 = state_20184__$1;
(statearr_20219_20260[(2)] = null);

(statearr_20219_20260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (10))){
var inst_20128 = (state_20184[(12)]);
var inst_20126 = (state_20184[(13)]);
var inst_20125 = (state_20184[(14)]);
var inst_20127 = (state_20184[(15)]);
var inst_20133 = cljs.core._nth.call(null,inst_20126,inst_20128);
var inst_20134 = cljs.core.async.muxch_STAR_.call(null,inst_20133);
var inst_20135 = cljs.core.async.close_BANG_.call(null,inst_20134);
var inst_20136 = (inst_20128 + (1));
var tmp20214 = inst_20126;
var tmp20215 = inst_20125;
var tmp20216 = inst_20127;
var inst_20125__$1 = tmp20215;
var inst_20126__$1 = tmp20214;
var inst_20127__$1 = tmp20216;
var inst_20128__$1 = inst_20136;
var state_20184__$1 = (function (){var statearr_20220 = state_20184;
(statearr_20220[(12)] = inst_20128__$1);

(statearr_20220[(17)] = inst_20135);

(statearr_20220[(13)] = inst_20126__$1);

(statearr_20220[(14)] = inst_20125__$1);

(statearr_20220[(15)] = inst_20127__$1);

return statearr_20220;
})();
var statearr_20221_20261 = state_20184__$1;
(statearr_20221_20261[(2)] = null);

(statearr_20221_20261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (18))){
var inst_20154 = (state_20184[(2)]);
var state_20184__$1 = state_20184;
var statearr_20222_20262 = state_20184__$1;
(statearr_20222_20262[(2)] = inst_20154);

(statearr_20222_20262[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20185 === (8))){
var inst_20128 = (state_20184[(12)]);
var inst_20127 = (state_20184[(15)]);
var inst_20130 = (inst_20128 < inst_20127);
var inst_20131 = inst_20130;
var state_20184__$1 = state_20184;
if(cljs.core.truth_(inst_20131)){
var statearr_20223_20263 = state_20184__$1;
(statearr_20223_20263[(1)] = (10));

} else {
var statearr_20224_20264 = state_20184__$1;
(statearr_20224_20264[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20236,mults,ensure_mult,p))
;
return ((function (switch__18225__auto__,c__18337__auto___20236,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20228[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20228[(1)] = (1));

return statearr_20228;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20184){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20229){if((e20229 instanceof Object)){
var ex__18229__auto__ = e20229;
var statearr_20230_20265 = state_20184;
(statearr_20230_20265[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20184);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20266 = state_20184;
state_20184 = G__20266;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20184){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20236,mults,ensure_mult,p))
})();
var state__18339__auto__ = (function (){var statearr_20231 = f__18338__auto__.call(null);
(statearr_20231[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20236);

return statearr_20231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20236,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20267 = [];
var len__7276__auto___20270 = arguments.length;
var i__7277__auto___20271 = (0);
while(true){
if((i__7277__auto___20271 < len__7276__auto___20270)){
args20267.push((arguments[i__7277__auto___20271]));

var G__20272 = (i__7277__auto___20271 + (1));
i__7277__auto___20271 = G__20272;
continue;
} else {
}
break;
}

var G__20269 = args20267.length;
switch (G__20269) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20267.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20274 = [];
var len__7276__auto___20277 = arguments.length;
var i__7277__auto___20278 = (0);
while(true){
if((i__7277__auto___20278 < len__7276__auto___20277)){
args20274.push((arguments[i__7277__auto___20278]));

var G__20279 = (i__7277__auto___20278 + (1));
i__7277__auto___20278 = G__20279;
continue;
} else {
}
break;
}

var G__20276 = args20274.length;
switch (G__20276) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20274.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20281 = [];
var len__7276__auto___20352 = arguments.length;
var i__7277__auto___20353 = (0);
while(true){
if((i__7277__auto___20353 < len__7276__auto___20352)){
args20281.push((arguments[i__7277__auto___20353]));

var G__20354 = (i__7277__auto___20353 + (1));
i__7277__auto___20353 = G__20354;
continue;
} else {
}
break;
}

var G__20283 = args20281.length;
switch (G__20283) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20281.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__18337__auto___20356 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20322){
var state_val_20323 = (state_20322[(1)]);
if((state_val_20323 === (7))){
var state_20322__$1 = state_20322;
var statearr_20324_20357 = state_20322__$1;
(statearr_20324_20357[(2)] = null);

(statearr_20324_20357[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (1))){
var state_20322__$1 = state_20322;
var statearr_20325_20358 = state_20322__$1;
(statearr_20325_20358[(2)] = null);

(statearr_20325_20358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (4))){
var inst_20286 = (state_20322[(7)]);
var inst_20288 = (inst_20286 < cnt);
var state_20322__$1 = state_20322;
if(cljs.core.truth_(inst_20288)){
var statearr_20326_20359 = state_20322__$1;
(statearr_20326_20359[(1)] = (6));

} else {
var statearr_20327_20360 = state_20322__$1;
(statearr_20327_20360[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (15))){
var inst_20318 = (state_20322[(2)]);
var state_20322__$1 = state_20322;
var statearr_20328_20361 = state_20322__$1;
(statearr_20328_20361[(2)] = inst_20318);

(statearr_20328_20361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (13))){
var inst_20311 = cljs.core.async.close_BANG_.call(null,out);
var state_20322__$1 = state_20322;
var statearr_20329_20362 = state_20322__$1;
(statearr_20329_20362[(2)] = inst_20311);

(statearr_20329_20362[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (6))){
var state_20322__$1 = state_20322;
var statearr_20330_20363 = state_20322__$1;
(statearr_20330_20363[(2)] = null);

(statearr_20330_20363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (3))){
var inst_20320 = (state_20322[(2)]);
var state_20322__$1 = state_20322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20322__$1,inst_20320);
} else {
if((state_val_20323 === (12))){
var inst_20308 = (state_20322[(8)]);
var inst_20308__$1 = (state_20322[(2)]);
var inst_20309 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20308__$1);
var state_20322__$1 = (function (){var statearr_20331 = state_20322;
(statearr_20331[(8)] = inst_20308__$1);

return statearr_20331;
})();
if(cljs.core.truth_(inst_20309)){
var statearr_20332_20364 = state_20322__$1;
(statearr_20332_20364[(1)] = (13));

} else {
var statearr_20333_20365 = state_20322__$1;
(statearr_20333_20365[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (2))){
var inst_20285 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20286 = (0);
var state_20322__$1 = (function (){var statearr_20334 = state_20322;
(statearr_20334[(7)] = inst_20286);

(statearr_20334[(9)] = inst_20285);

return statearr_20334;
})();
var statearr_20335_20366 = state_20322__$1;
(statearr_20335_20366[(2)] = null);

(statearr_20335_20366[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (11))){
var inst_20286 = (state_20322[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20322,(10),Object,null,(9));
var inst_20295 = chs__$1.call(null,inst_20286);
var inst_20296 = done.call(null,inst_20286);
var inst_20297 = cljs.core.async.take_BANG_.call(null,inst_20295,inst_20296);
var state_20322__$1 = state_20322;
var statearr_20336_20367 = state_20322__$1;
(statearr_20336_20367[(2)] = inst_20297);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20322__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (9))){
var inst_20286 = (state_20322[(7)]);
var inst_20299 = (state_20322[(2)]);
var inst_20300 = (inst_20286 + (1));
var inst_20286__$1 = inst_20300;
var state_20322__$1 = (function (){var statearr_20337 = state_20322;
(statearr_20337[(7)] = inst_20286__$1);

(statearr_20337[(10)] = inst_20299);

return statearr_20337;
})();
var statearr_20338_20368 = state_20322__$1;
(statearr_20338_20368[(2)] = null);

(statearr_20338_20368[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (5))){
var inst_20306 = (state_20322[(2)]);
var state_20322__$1 = (function (){var statearr_20339 = state_20322;
(statearr_20339[(11)] = inst_20306);

return statearr_20339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20322__$1,(12),dchan);
} else {
if((state_val_20323 === (14))){
var inst_20308 = (state_20322[(8)]);
var inst_20313 = cljs.core.apply.call(null,f,inst_20308);
var state_20322__$1 = state_20322;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20322__$1,(16),out,inst_20313);
} else {
if((state_val_20323 === (16))){
var inst_20315 = (state_20322[(2)]);
var state_20322__$1 = (function (){var statearr_20340 = state_20322;
(statearr_20340[(12)] = inst_20315);

return statearr_20340;
})();
var statearr_20341_20369 = state_20322__$1;
(statearr_20341_20369[(2)] = null);

(statearr_20341_20369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (10))){
var inst_20290 = (state_20322[(2)]);
var inst_20291 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20322__$1 = (function (){var statearr_20342 = state_20322;
(statearr_20342[(13)] = inst_20290);

return statearr_20342;
})();
var statearr_20343_20370 = state_20322__$1;
(statearr_20343_20370[(2)] = inst_20291);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20322__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20323 === (8))){
var inst_20304 = (state_20322[(2)]);
var state_20322__$1 = state_20322;
var statearr_20344_20371 = state_20322__$1;
(statearr_20344_20371[(2)] = inst_20304);

(statearr_20344_20371[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18225__auto__,c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20348[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20348[(1)] = (1));

return statearr_20348;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20322){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20349){if((e20349 instanceof Object)){
var ex__18229__auto__ = e20349;
var statearr_20350_20372 = state_20322;
(statearr_20350_20372[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20322);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20373 = state_20322;
state_20322 = G__20373;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20322){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18339__auto__ = (function (){var statearr_20351 = f__18338__auto__.call(null);
(statearr_20351[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20356);

return statearr_20351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20356,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20375 = [];
var len__7276__auto___20431 = arguments.length;
var i__7277__auto___20432 = (0);
while(true){
if((i__7277__auto___20432 < len__7276__auto___20431)){
args20375.push((arguments[i__7277__auto___20432]));

var G__20433 = (i__7277__auto___20432 + (1));
i__7277__auto___20432 = G__20433;
continue;
} else {
}
break;
}

var G__20377 = args20375.length;
switch (G__20377) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20375.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___20435 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20435,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20435,out){
return (function (state_20407){
var state_val_20408 = (state_20407[(1)]);
if((state_val_20408 === (7))){
var inst_20387 = (state_20407[(7)]);
var inst_20386 = (state_20407[(8)]);
var inst_20386__$1 = (state_20407[(2)]);
var inst_20387__$1 = cljs.core.nth.call(null,inst_20386__$1,(0),null);
var inst_20388 = cljs.core.nth.call(null,inst_20386__$1,(1),null);
var inst_20389 = (inst_20387__$1 == null);
var state_20407__$1 = (function (){var statearr_20409 = state_20407;
(statearr_20409[(7)] = inst_20387__$1);

(statearr_20409[(8)] = inst_20386__$1);

(statearr_20409[(9)] = inst_20388);

return statearr_20409;
})();
if(cljs.core.truth_(inst_20389)){
var statearr_20410_20436 = state_20407__$1;
(statearr_20410_20436[(1)] = (8));

} else {
var statearr_20411_20437 = state_20407__$1;
(statearr_20411_20437[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (1))){
var inst_20378 = cljs.core.vec.call(null,chs);
var inst_20379 = inst_20378;
var state_20407__$1 = (function (){var statearr_20412 = state_20407;
(statearr_20412[(10)] = inst_20379);

return statearr_20412;
})();
var statearr_20413_20438 = state_20407__$1;
(statearr_20413_20438[(2)] = null);

(statearr_20413_20438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (4))){
var inst_20379 = (state_20407[(10)]);
var state_20407__$1 = state_20407;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20407__$1,(7),inst_20379);
} else {
if((state_val_20408 === (6))){
var inst_20403 = (state_20407[(2)]);
var state_20407__$1 = state_20407;
var statearr_20414_20439 = state_20407__$1;
(statearr_20414_20439[(2)] = inst_20403);

(statearr_20414_20439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (3))){
var inst_20405 = (state_20407[(2)]);
var state_20407__$1 = state_20407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20407__$1,inst_20405);
} else {
if((state_val_20408 === (2))){
var inst_20379 = (state_20407[(10)]);
var inst_20381 = cljs.core.count.call(null,inst_20379);
var inst_20382 = (inst_20381 > (0));
var state_20407__$1 = state_20407;
if(cljs.core.truth_(inst_20382)){
var statearr_20416_20440 = state_20407__$1;
(statearr_20416_20440[(1)] = (4));

} else {
var statearr_20417_20441 = state_20407__$1;
(statearr_20417_20441[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (11))){
var inst_20379 = (state_20407[(10)]);
var inst_20396 = (state_20407[(2)]);
var tmp20415 = inst_20379;
var inst_20379__$1 = tmp20415;
var state_20407__$1 = (function (){var statearr_20418 = state_20407;
(statearr_20418[(11)] = inst_20396);

(statearr_20418[(10)] = inst_20379__$1);

return statearr_20418;
})();
var statearr_20419_20442 = state_20407__$1;
(statearr_20419_20442[(2)] = null);

(statearr_20419_20442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (9))){
var inst_20387 = (state_20407[(7)]);
var state_20407__$1 = state_20407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20407__$1,(11),out,inst_20387);
} else {
if((state_val_20408 === (5))){
var inst_20401 = cljs.core.async.close_BANG_.call(null,out);
var state_20407__$1 = state_20407;
var statearr_20420_20443 = state_20407__$1;
(statearr_20420_20443[(2)] = inst_20401);

(statearr_20420_20443[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (10))){
var inst_20399 = (state_20407[(2)]);
var state_20407__$1 = state_20407;
var statearr_20421_20444 = state_20407__$1;
(statearr_20421_20444[(2)] = inst_20399);

(statearr_20421_20444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20408 === (8))){
var inst_20387 = (state_20407[(7)]);
var inst_20386 = (state_20407[(8)]);
var inst_20379 = (state_20407[(10)]);
var inst_20388 = (state_20407[(9)]);
var inst_20391 = (function (){var cs = inst_20379;
var vec__20384 = inst_20386;
var v = inst_20387;
var c = inst_20388;
return ((function (cs,vec__20384,v,c,inst_20387,inst_20386,inst_20379,inst_20388,state_val_20408,c__18337__auto___20435,out){
return (function (p1__20374_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20374_SHARP_);
});
;})(cs,vec__20384,v,c,inst_20387,inst_20386,inst_20379,inst_20388,state_val_20408,c__18337__auto___20435,out))
})();
var inst_20392 = cljs.core.filterv.call(null,inst_20391,inst_20379);
var inst_20379__$1 = inst_20392;
var state_20407__$1 = (function (){var statearr_20422 = state_20407;
(statearr_20422[(10)] = inst_20379__$1);

return statearr_20422;
})();
var statearr_20423_20445 = state_20407__$1;
(statearr_20423_20445[(2)] = null);

(statearr_20423_20445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20435,out))
;
return ((function (switch__18225__auto__,c__18337__auto___20435,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20427 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20427[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20427[(1)] = (1));

return statearr_20427;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20407){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20428){if((e20428 instanceof Object)){
var ex__18229__auto__ = e20428;
var statearr_20429_20446 = state_20407;
(statearr_20429_20446[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20407);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20428;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20447 = state_20407;
state_20407 = G__20447;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20407){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20435,out))
})();
var state__18339__auto__ = (function (){var statearr_20430 = f__18338__auto__.call(null);
(statearr_20430[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20435);

return statearr_20430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20435,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20448 = [];
var len__7276__auto___20497 = arguments.length;
var i__7277__auto___20498 = (0);
while(true){
if((i__7277__auto___20498 < len__7276__auto___20497)){
args20448.push((arguments[i__7277__auto___20498]));

var G__20499 = (i__7277__auto___20498 + (1));
i__7277__auto___20498 = G__20499;
continue;
} else {
}
break;
}

var G__20450 = args20448.length;
switch (G__20450) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20448.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___20501 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20501,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20501,out){
return (function (state_20474){
var state_val_20475 = (state_20474[(1)]);
if((state_val_20475 === (7))){
var inst_20456 = (state_20474[(7)]);
var inst_20456__$1 = (state_20474[(2)]);
var inst_20457 = (inst_20456__$1 == null);
var inst_20458 = cljs.core.not.call(null,inst_20457);
var state_20474__$1 = (function (){var statearr_20476 = state_20474;
(statearr_20476[(7)] = inst_20456__$1);

return statearr_20476;
})();
if(inst_20458){
var statearr_20477_20502 = state_20474__$1;
(statearr_20477_20502[(1)] = (8));

} else {
var statearr_20478_20503 = state_20474__$1;
(statearr_20478_20503[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (1))){
var inst_20451 = (0);
var state_20474__$1 = (function (){var statearr_20479 = state_20474;
(statearr_20479[(8)] = inst_20451);

return statearr_20479;
})();
var statearr_20480_20504 = state_20474__$1;
(statearr_20480_20504[(2)] = null);

(statearr_20480_20504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (4))){
var state_20474__$1 = state_20474;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20474__$1,(7),ch);
} else {
if((state_val_20475 === (6))){
var inst_20469 = (state_20474[(2)]);
var state_20474__$1 = state_20474;
var statearr_20481_20505 = state_20474__$1;
(statearr_20481_20505[(2)] = inst_20469);

(statearr_20481_20505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (3))){
var inst_20471 = (state_20474[(2)]);
var inst_20472 = cljs.core.async.close_BANG_.call(null,out);
var state_20474__$1 = (function (){var statearr_20482 = state_20474;
(statearr_20482[(9)] = inst_20471);

return statearr_20482;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20474__$1,inst_20472);
} else {
if((state_val_20475 === (2))){
var inst_20451 = (state_20474[(8)]);
var inst_20453 = (inst_20451 < n);
var state_20474__$1 = state_20474;
if(cljs.core.truth_(inst_20453)){
var statearr_20483_20506 = state_20474__$1;
(statearr_20483_20506[(1)] = (4));

} else {
var statearr_20484_20507 = state_20474__$1;
(statearr_20484_20507[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (11))){
var inst_20451 = (state_20474[(8)]);
var inst_20461 = (state_20474[(2)]);
var inst_20462 = (inst_20451 + (1));
var inst_20451__$1 = inst_20462;
var state_20474__$1 = (function (){var statearr_20485 = state_20474;
(statearr_20485[(8)] = inst_20451__$1);

(statearr_20485[(10)] = inst_20461);

return statearr_20485;
})();
var statearr_20486_20508 = state_20474__$1;
(statearr_20486_20508[(2)] = null);

(statearr_20486_20508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (9))){
var state_20474__$1 = state_20474;
var statearr_20487_20509 = state_20474__$1;
(statearr_20487_20509[(2)] = null);

(statearr_20487_20509[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (5))){
var state_20474__$1 = state_20474;
var statearr_20488_20510 = state_20474__$1;
(statearr_20488_20510[(2)] = null);

(statearr_20488_20510[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (10))){
var inst_20466 = (state_20474[(2)]);
var state_20474__$1 = state_20474;
var statearr_20489_20511 = state_20474__$1;
(statearr_20489_20511[(2)] = inst_20466);

(statearr_20489_20511[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20475 === (8))){
var inst_20456 = (state_20474[(7)]);
var state_20474__$1 = state_20474;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20474__$1,(11),out,inst_20456);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20501,out))
;
return ((function (switch__18225__auto__,c__18337__auto___20501,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20493 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20493[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20493[(1)] = (1));

return statearr_20493;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20474){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20494){if((e20494 instanceof Object)){
var ex__18229__auto__ = e20494;
var statearr_20495_20512 = state_20474;
(statearr_20495_20512[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20513 = state_20474;
state_20474 = G__20513;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20501,out))
})();
var state__18339__auto__ = (function (){var statearr_20496 = f__18338__auto__.call(null);
(statearr_20496[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20501);

return statearr_20496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20501,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20521 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20521 = (function (map_LT_,f,ch,meta20522){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta20522 = meta20522;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20523,meta20522__$1){
var self__ = this;
var _20523__$1 = this;
return (new cljs.core.async.t_cljs$core$async20521(self__.map_LT_,self__.f,self__.ch,meta20522__$1));
});

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20523){
var self__ = this;
var _20523__$1 = this;
return self__.meta20522;
});

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async20524 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20524 = (function (map_LT_,f,ch,meta20522,_,fn1,meta20525){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta20522 = meta20522;
this._ = _;
this.fn1 = fn1;
this.meta20525 = meta20525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20526,meta20525__$1){
var self__ = this;
var _20526__$1 = this;
return (new cljs.core.async.t_cljs$core$async20524(self__.map_LT_,self__.f,self__.ch,self__.meta20522,self__._,self__.fn1,meta20525__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20526){
var self__ = this;
var _20526__$1 = this;
return self__.meta20525;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__20514_SHARP_){
return f1.call(null,(((p1__20514_SHARP_ == null))?null:self__.f.call(null,p1__20514_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20522","meta20522",1718142911,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async20521","cljs.core.async/t_cljs$core$async20521",-2135440757,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta20525","meta20525",1141564285,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20524.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20524.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20524";

cljs.core.async.t_cljs$core$async20524.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20524");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async20524 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20524(map_LT___$1,f__$1,ch__$1,meta20522__$1,___$2,fn1__$1,meta20525){
return (new cljs.core.async.t_cljs$core$async20524(map_LT___$1,f__$1,ch__$1,meta20522__$1,___$2,fn1__$1,meta20525));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async20524(self__.map_LT_,self__.f,self__.ch,self__.meta20522,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6195__auto__ = ret;
if(cljs.core.truth_(and__6195__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6195__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20521.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async20521.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20522","meta20522",1718142911,null)], null);
});

cljs.core.async.t_cljs$core$async20521.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20521.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20521";

cljs.core.async.t_cljs$core$async20521.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20521");
});

cljs.core.async.__GT_t_cljs$core$async20521 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20521(map_LT___$1,f__$1,ch__$1,meta20522){
return (new cljs.core.async.t_cljs$core$async20521(map_LT___$1,f__$1,ch__$1,meta20522));
});

}

return (new cljs.core.async.t_cljs$core$async20521(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20530 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20530 = (function (map_GT_,f,ch,meta20531){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta20531 = meta20531;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20532,meta20531__$1){
var self__ = this;
var _20532__$1 = this;
return (new cljs.core.async.t_cljs$core$async20530(self__.map_GT_,self__.f,self__.ch,meta20531__$1));
});

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20532){
var self__ = this;
var _20532__$1 = this;
return self__.meta20531;
});

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20530.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async20530.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20531","meta20531",1161812503,null)], null);
});

cljs.core.async.t_cljs$core$async20530.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20530.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20530";

cljs.core.async.t_cljs$core$async20530.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20530");
});

cljs.core.async.__GT_t_cljs$core$async20530 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20530(map_GT___$1,f__$1,ch__$1,meta20531){
return (new cljs.core.async.t_cljs$core$async20530(map_GT___$1,f__$1,ch__$1,meta20531));
});

}

return (new cljs.core.async.t_cljs$core$async20530(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async20536 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20536 = (function (filter_GT_,p,ch,meta20537){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta20537 = meta20537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20538,meta20537__$1){
var self__ = this;
var _20538__$1 = this;
return (new cljs.core.async.t_cljs$core$async20536(self__.filter_GT_,self__.p,self__.ch,meta20537__$1));
});

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20538){
var self__ = this;
var _20538__$1 = this;
return self__.meta20537;
});

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20536.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async20536.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20537","meta20537",638222919,null)], null);
});

cljs.core.async.t_cljs$core$async20536.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20536";

cljs.core.async.t_cljs$core$async20536.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20536");
});

cljs.core.async.__GT_t_cljs$core$async20536 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20536(filter_GT___$1,p__$1,ch__$1,meta20537){
return (new cljs.core.async.t_cljs$core$async20536(filter_GT___$1,p__$1,ch__$1,meta20537));
});

}

return (new cljs.core.async.t_cljs$core$async20536(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args20539 = [];
var len__7276__auto___20583 = arguments.length;
var i__7277__auto___20584 = (0);
while(true){
if((i__7277__auto___20584 < len__7276__auto___20583)){
args20539.push((arguments[i__7277__auto___20584]));

var G__20585 = (i__7277__auto___20584 + (1));
i__7277__auto___20584 = G__20585;
continue;
} else {
}
break;
}

var G__20541 = args20539.length;
switch (G__20541) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20539.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___20587 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20587,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20587,out){
return (function (state_20562){
var state_val_20563 = (state_20562[(1)]);
if((state_val_20563 === (7))){
var inst_20558 = (state_20562[(2)]);
var state_20562__$1 = state_20562;
var statearr_20564_20588 = state_20562__$1;
(statearr_20564_20588[(2)] = inst_20558);

(statearr_20564_20588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (1))){
var state_20562__$1 = state_20562;
var statearr_20565_20589 = state_20562__$1;
(statearr_20565_20589[(2)] = null);

(statearr_20565_20589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (4))){
var inst_20544 = (state_20562[(7)]);
var inst_20544__$1 = (state_20562[(2)]);
var inst_20545 = (inst_20544__$1 == null);
var state_20562__$1 = (function (){var statearr_20566 = state_20562;
(statearr_20566[(7)] = inst_20544__$1);

return statearr_20566;
})();
if(cljs.core.truth_(inst_20545)){
var statearr_20567_20590 = state_20562__$1;
(statearr_20567_20590[(1)] = (5));

} else {
var statearr_20568_20591 = state_20562__$1;
(statearr_20568_20591[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (6))){
var inst_20544 = (state_20562[(7)]);
var inst_20549 = p.call(null,inst_20544);
var state_20562__$1 = state_20562;
if(cljs.core.truth_(inst_20549)){
var statearr_20569_20592 = state_20562__$1;
(statearr_20569_20592[(1)] = (8));

} else {
var statearr_20570_20593 = state_20562__$1;
(statearr_20570_20593[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (3))){
var inst_20560 = (state_20562[(2)]);
var state_20562__$1 = state_20562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20562__$1,inst_20560);
} else {
if((state_val_20563 === (2))){
var state_20562__$1 = state_20562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20562__$1,(4),ch);
} else {
if((state_val_20563 === (11))){
var inst_20552 = (state_20562[(2)]);
var state_20562__$1 = state_20562;
var statearr_20571_20594 = state_20562__$1;
(statearr_20571_20594[(2)] = inst_20552);

(statearr_20571_20594[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (9))){
var state_20562__$1 = state_20562;
var statearr_20572_20595 = state_20562__$1;
(statearr_20572_20595[(2)] = null);

(statearr_20572_20595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (5))){
var inst_20547 = cljs.core.async.close_BANG_.call(null,out);
var state_20562__$1 = state_20562;
var statearr_20573_20596 = state_20562__$1;
(statearr_20573_20596[(2)] = inst_20547);

(statearr_20573_20596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (10))){
var inst_20555 = (state_20562[(2)]);
var state_20562__$1 = (function (){var statearr_20574 = state_20562;
(statearr_20574[(8)] = inst_20555);

return statearr_20574;
})();
var statearr_20575_20597 = state_20562__$1;
(statearr_20575_20597[(2)] = null);

(statearr_20575_20597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20563 === (8))){
var inst_20544 = (state_20562[(7)]);
var state_20562__$1 = state_20562;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20562__$1,(11),out,inst_20544);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20587,out))
;
return ((function (switch__18225__auto__,c__18337__auto___20587,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20579 = [null,null,null,null,null,null,null,null,null];
(statearr_20579[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20579[(1)] = (1));

return statearr_20579;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20562){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20580){if((e20580 instanceof Object)){
var ex__18229__auto__ = e20580;
var statearr_20581_20598 = state_20562;
(statearr_20581_20598[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20562);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20580;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20599 = state_20562;
state_20562 = G__20599;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20562){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20587,out))
})();
var state__18339__auto__ = (function (){var statearr_20582 = f__18338__auto__.call(null);
(statearr_20582[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20587);

return statearr_20582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20587,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args20600 = [];
var len__7276__auto___20603 = arguments.length;
var i__7277__auto___20604 = (0);
while(true){
if((i__7277__auto___20604 < len__7276__auto___20603)){
args20600.push((arguments[i__7277__auto___20604]));

var G__20605 = (i__7277__auto___20604 + (1));
i__7277__auto___20604 = G__20605;
continue;
} else {
}
break;
}

var G__20602 = args20600.length;
switch (G__20602) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20600.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18337__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto__){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto__){
return (function (state_20772){
var state_val_20773 = (state_20772[(1)]);
if((state_val_20773 === (7))){
var inst_20768 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
var statearr_20774_20815 = state_20772__$1;
(statearr_20774_20815[(2)] = inst_20768);

(statearr_20774_20815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (20))){
var inst_20738 = (state_20772[(7)]);
var inst_20749 = (state_20772[(2)]);
var inst_20750 = cljs.core.next.call(null,inst_20738);
var inst_20724 = inst_20750;
var inst_20725 = null;
var inst_20726 = (0);
var inst_20727 = (0);
var state_20772__$1 = (function (){var statearr_20775 = state_20772;
(statearr_20775[(8)] = inst_20726);

(statearr_20775[(9)] = inst_20727);

(statearr_20775[(10)] = inst_20749);

(statearr_20775[(11)] = inst_20724);

(statearr_20775[(12)] = inst_20725);

return statearr_20775;
})();
var statearr_20776_20816 = state_20772__$1;
(statearr_20776_20816[(2)] = null);

(statearr_20776_20816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (1))){
var state_20772__$1 = state_20772;
var statearr_20777_20817 = state_20772__$1;
(statearr_20777_20817[(2)] = null);

(statearr_20777_20817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (4))){
var inst_20713 = (state_20772[(13)]);
var inst_20713__$1 = (state_20772[(2)]);
var inst_20714 = (inst_20713__$1 == null);
var state_20772__$1 = (function (){var statearr_20778 = state_20772;
(statearr_20778[(13)] = inst_20713__$1);

return statearr_20778;
})();
if(cljs.core.truth_(inst_20714)){
var statearr_20779_20818 = state_20772__$1;
(statearr_20779_20818[(1)] = (5));

} else {
var statearr_20780_20819 = state_20772__$1;
(statearr_20780_20819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (15))){
var state_20772__$1 = state_20772;
var statearr_20784_20820 = state_20772__$1;
(statearr_20784_20820[(2)] = null);

(statearr_20784_20820[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (21))){
var state_20772__$1 = state_20772;
var statearr_20785_20821 = state_20772__$1;
(statearr_20785_20821[(2)] = null);

(statearr_20785_20821[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (13))){
var inst_20726 = (state_20772[(8)]);
var inst_20727 = (state_20772[(9)]);
var inst_20724 = (state_20772[(11)]);
var inst_20725 = (state_20772[(12)]);
var inst_20734 = (state_20772[(2)]);
var inst_20735 = (inst_20727 + (1));
var tmp20781 = inst_20726;
var tmp20782 = inst_20724;
var tmp20783 = inst_20725;
var inst_20724__$1 = tmp20782;
var inst_20725__$1 = tmp20783;
var inst_20726__$1 = tmp20781;
var inst_20727__$1 = inst_20735;
var state_20772__$1 = (function (){var statearr_20786 = state_20772;
(statearr_20786[(8)] = inst_20726__$1);

(statearr_20786[(9)] = inst_20727__$1);

(statearr_20786[(14)] = inst_20734);

(statearr_20786[(11)] = inst_20724__$1);

(statearr_20786[(12)] = inst_20725__$1);

return statearr_20786;
})();
var statearr_20787_20822 = state_20772__$1;
(statearr_20787_20822[(2)] = null);

(statearr_20787_20822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (22))){
var state_20772__$1 = state_20772;
var statearr_20788_20823 = state_20772__$1;
(statearr_20788_20823[(2)] = null);

(statearr_20788_20823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (6))){
var inst_20713 = (state_20772[(13)]);
var inst_20722 = f.call(null,inst_20713);
var inst_20723 = cljs.core.seq.call(null,inst_20722);
var inst_20724 = inst_20723;
var inst_20725 = null;
var inst_20726 = (0);
var inst_20727 = (0);
var state_20772__$1 = (function (){var statearr_20789 = state_20772;
(statearr_20789[(8)] = inst_20726);

(statearr_20789[(9)] = inst_20727);

(statearr_20789[(11)] = inst_20724);

(statearr_20789[(12)] = inst_20725);

return statearr_20789;
})();
var statearr_20790_20824 = state_20772__$1;
(statearr_20790_20824[(2)] = null);

(statearr_20790_20824[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (17))){
var inst_20738 = (state_20772[(7)]);
var inst_20742 = cljs.core.chunk_first.call(null,inst_20738);
var inst_20743 = cljs.core.chunk_rest.call(null,inst_20738);
var inst_20744 = cljs.core.count.call(null,inst_20742);
var inst_20724 = inst_20743;
var inst_20725 = inst_20742;
var inst_20726 = inst_20744;
var inst_20727 = (0);
var state_20772__$1 = (function (){var statearr_20791 = state_20772;
(statearr_20791[(8)] = inst_20726);

(statearr_20791[(9)] = inst_20727);

(statearr_20791[(11)] = inst_20724);

(statearr_20791[(12)] = inst_20725);

return statearr_20791;
})();
var statearr_20792_20825 = state_20772__$1;
(statearr_20792_20825[(2)] = null);

(statearr_20792_20825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (3))){
var inst_20770 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20772__$1,inst_20770);
} else {
if((state_val_20773 === (12))){
var inst_20758 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
var statearr_20793_20826 = state_20772__$1;
(statearr_20793_20826[(2)] = inst_20758);

(statearr_20793_20826[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (2))){
var state_20772__$1 = state_20772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20772__$1,(4),in$);
} else {
if((state_val_20773 === (23))){
var inst_20766 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
var statearr_20794_20827 = state_20772__$1;
(statearr_20794_20827[(2)] = inst_20766);

(statearr_20794_20827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (19))){
var inst_20753 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
var statearr_20795_20828 = state_20772__$1;
(statearr_20795_20828[(2)] = inst_20753);

(statearr_20795_20828[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (11))){
var inst_20738 = (state_20772[(7)]);
var inst_20724 = (state_20772[(11)]);
var inst_20738__$1 = cljs.core.seq.call(null,inst_20724);
var state_20772__$1 = (function (){var statearr_20796 = state_20772;
(statearr_20796[(7)] = inst_20738__$1);

return statearr_20796;
})();
if(inst_20738__$1){
var statearr_20797_20829 = state_20772__$1;
(statearr_20797_20829[(1)] = (14));

} else {
var statearr_20798_20830 = state_20772__$1;
(statearr_20798_20830[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (9))){
var inst_20760 = (state_20772[(2)]);
var inst_20761 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_20772__$1 = (function (){var statearr_20799 = state_20772;
(statearr_20799[(15)] = inst_20760);

return statearr_20799;
})();
if(cljs.core.truth_(inst_20761)){
var statearr_20800_20831 = state_20772__$1;
(statearr_20800_20831[(1)] = (21));

} else {
var statearr_20801_20832 = state_20772__$1;
(statearr_20801_20832[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (5))){
var inst_20716 = cljs.core.async.close_BANG_.call(null,out);
var state_20772__$1 = state_20772;
var statearr_20802_20833 = state_20772__$1;
(statearr_20802_20833[(2)] = inst_20716);

(statearr_20802_20833[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (14))){
var inst_20738 = (state_20772[(7)]);
var inst_20740 = cljs.core.chunked_seq_QMARK_.call(null,inst_20738);
var state_20772__$1 = state_20772;
if(inst_20740){
var statearr_20803_20834 = state_20772__$1;
(statearr_20803_20834[(1)] = (17));

} else {
var statearr_20804_20835 = state_20772__$1;
(statearr_20804_20835[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (16))){
var inst_20756 = (state_20772[(2)]);
var state_20772__$1 = state_20772;
var statearr_20805_20836 = state_20772__$1;
(statearr_20805_20836[(2)] = inst_20756);

(statearr_20805_20836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20773 === (10))){
var inst_20727 = (state_20772[(9)]);
var inst_20725 = (state_20772[(12)]);
var inst_20732 = cljs.core._nth.call(null,inst_20725,inst_20727);
var state_20772__$1 = state_20772;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20772__$1,(13),out,inst_20732);
} else {
if((state_val_20773 === (18))){
var inst_20738 = (state_20772[(7)]);
var inst_20747 = cljs.core.first.call(null,inst_20738);
var state_20772__$1 = state_20772;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20772__$1,(20),out,inst_20747);
} else {
if((state_val_20773 === (8))){
var inst_20726 = (state_20772[(8)]);
var inst_20727 = (state_20772[(9)]);
var inst_20729 = (inst_20727 < inst_20726);
var inst_20730 = inst_20729;
var state_20772__$1 = state_20772;
if(cljs.core.truth_(inst_20730)){
var statearr_20806_20837 = state_20772__$1;
(statearr_20806_20837[(1)] = (10));

} else {
var statearr_20807_20838 = state_20772__$1;
(statearr_20807_20838[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto__))
;
return ((function (switch__18225__auto__,c__18337__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____0 = (function (){
var statearr_20811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20811[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__);

(statearr_20811[(1)] = (1));

return statearr_20811;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____1 = (function (state_20772){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20812){if((e20812 instanceof Object)){
var ex__18229__auto__ = e20812;
var statearr_20813_20839 = state_20772;
(statearr_20813_20839[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20840 = state_20772;
state_20772 = G__20840;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__ = function(state_20772){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____1.call(this,state_20772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18226__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto__))
})();
var state__18339__auto__ = (function (){var statearr_20814 = f__18338__auto__.call(null);
(statearr_20814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto__);

return statearr_20814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto__))
);

return c__18337__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20841 = [];
var len__7276__auto___20844 = arguments.length;
var i__7277__auto___20845 = (0);
while(true){
if((i__7277__auto___20845 < len__7276__auto___20844)){
args20841.push((arguments[i__7277__auto___20845]));

var G__20846 = (i__7277__auto___20845 + (1));
i__7277__auto___20845 = G__20846;
continue;
} else {
}
break;
}

var G__20843 = args20841.length;
switch (G__20843) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20841.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20848 = [];
var len__7276__auto___20851 = arguments.length;
var i__7277__auto___20852 = (0);
while(true){
if((i__7277__auto___20852 < len__7276__auto___20851)){
args20848.push((arguments[i__7277__auto___20852]));

var G__20853 = (i__7277__auto___20852 + (1));
i__7277__auto___20852 = G__20853;
continue;
} else {
}
break;
}

var G__20850 = args20848.length;
switch (G__20850) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20848.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20855 = [];
var len__7276__auto___20906 = arguments.length;
var i__7277__auto___20907 = (0);
while(true){
if((i__7277__auto___20907 < len__7276__auto___20906)){
args20855.push((arguments[i__7277__auto___20907]));

var G__20908 = (i__7277__auto___20907 + (1));
i__7277__auto___20907 = G__20908;
continue;
} else {
}
break;
}

var G__20857 = args20855.length;
switch (G__20857) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20855.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___20910 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20910,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20910,out){
return (function (state_20881){
var state_val_20882 = (state_20881[(1)]);
if((state_val_20882 === (7))){
var inst_20876 = (state_20881[(2)]);
var state_20881__$1 = state_20881;
var statearr_20883_20911 = state_20881__$1;
(statearr_20883_20911[(2)] = inst_20876);

(statearr_20883_20911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (1))){
var inst_20858 = null;
var state_20881__$1 = (function (){var statearr_20884 = state_20881;
(statearr_20884[(7)] = inst_20858);

return statearr_20884;
})();
var statearr_20885_20912 = state_20881__$1;
(statearr_20885_20912[(2)] = null);

(statearr_20885_20912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (4))){
var inst_20861 = (state_20881[(8)]);
var inst_20861__$1 = (state_20881[(2)]);
var inst_20862 = (inst_20861__$1 == null);
var inst_20863 = cljs.core.not.call(null,inst_20862);
var state_20881__$1 = (function (){var statearr_20886 = state_20881;
(statearr_20886[(8)] = inst_20861__$1);

return statearr_20886;
})();
if(inst_20863){
var statearr_20887_20913 = state_20881__$1;
(statearr_20887_20913[(1)] = (5));

} else {
var statearr_20888_20914 = state_20881__$1;
(statearr_20888_20914[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (6))){
var state_20881__$1 = state_20881;
var statearr_20889_20915 = state_20881__$1;
(statearr_20889_20915[(2)] = null);

(statearr_20889_20915[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (3))){
var inst_20878 = (state_20881[(2)]);
var inst_20879 = cljs.core.async.close_BANG_.call(null,out);
var state_20881__$1 = (function (){var statearr_20890 = state_20881;
(statearr_20890[(9)] = inst_20878);

return statearr_20890;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20881__$1,inst_20879);
} else {
if((state_val_20882 === (2))){
var state_20881__$1 = state_20881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20881__$1,(4),ch);
} else {
if((state_val_20882 === (11))){
var inst_20861 = (state_20881[(8)]);
var inst_20870 = (state_20881[(2)]);
var inst_20858 = inst_20861;
var state_20881__$1 = (function (){var statearr_20891 = state_20881;
(statearr_20891[(7)] = inst_20858);

(statearr_20891[(10)] = inst_20870);

return statearr_20891;
})();
var statearr_20892_20916 = state_20881__$1;
(statearr_20892_20916[(2)] = null);

(statearr_20892_20916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (9))){
var inst_20861 = (state_20881[(8)]);
var state_20881__$1 = state_20881;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20881__$1,(11),out,inst_20861);
} else {
if((state_val_20882 === (5))){
var inst_20858 = (state_20881[(7)]);
var inst_20861 = (state_20881[(8)]);
var inst_20865 = cljs.core._EQ_.call(null,inst_20861,inst_20858);
var state_20881__$1 = state_20881;
if(inst_20865){
var statearr_20894_20917 = state_20881__$1;
(statearr_20894_20917[(1)] = (8));

} else {
var statearr_20895_20918 = state_20881__$1;
(statearr_20895_20918[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (10))){
var inst_20873 = (state_20881[(2)]);
var state_20881__$1 = state_20881;
var statearr_20896_20919 = state_20881__$1;
(statearr_20896_20919[(2)] = inst_20873);

(statearr_20896_20919[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20882 === (8))){
var inst_20858 = (state_20881[(7)]);
var tmp20893 = inst_20858;
var inst_20858__$1 = tmp20893;
var state_20881__$1 = (function (){var statearr_20897 = state_20881;
(statearr_20897[(7)] = inst_20858__$1);

return statearr_20897;
})();
var statearr_20898_20920 = state_20881__$1;
(statearr_20898_20920[(2)] = null);

(statearr_20898_20920[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20910,out))
;
return ((function (switch__18225__auto__,c__18337__auto___20910,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20902 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20902[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20902[(1)] = (1));

return statearr_20902;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20881){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20903){if((e20903 instanceof Object)){
var ex__18229__auto__ = e20903;
var statearr_20904_20921 = state_20881;
(statearr_20904_20921[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20903;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20922 = state_20881;
state_20881 = G__20922;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20881){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20910,out))
})();
var state__18339__auto__ = (function (){var statearr_20905 = f__18338__auto__.call(null);
(statearr_20905[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20910);

return statearr_20905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20910,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20923 = [];
var len__7276__auto___20993 = arguments.length;
var i__7277__auto___20994 = (0);
while(true){
if((i__7277__auto___20994 < len__7276__auto___20993)){
args20923.push((arguments[i__7277__auto___20994]));

var G__20995 = (i__7277__auto___20994 + (1));
i__7277__auto___20994 = G__20995;
continue;
} else {
}
break;
}

var G__20925 = args20923.length;
switch (G__20925) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20923.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___20997 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___20997,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___20997,out){
return (function (state_20963){
var state_val_20964 = (state_20963[(1)]);
if((state_val_20964 === (7))){
var inst_20959 = (state_20963[(2)]);
var state_20963__$1 = state_20963;
var statearr_20965_20998 = state_20963__$1;
(statearr_20965_20998[(2)] = inst_20959);

(statearr_20965_20998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (1))){
var inst_20926 = (new Array(n));
var inst_20927 = inst_20926;
var inst_20928 = (0);
var state_20963__$1 = (function (){var statearr_20966 = state_20963;
(statearr_20966[(7)] = inst_20927);

(statearr_20966[(8)] = inst_20928);

return statearr_20966;
})();
var statearr_20967_20999 = state_20963__$1;
(statearr_20967_20999[(2)] = null);

(statearr_20967_20999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (4))){
var inst_20931 = (state_20963[(9)]);
var inst_20931__$1 = (state_20963[(2)]);
var inst_20932 = (inst_20931__$1 == null);
var inst_20933 = cljs.core.not.call(null,inst_20932);
var state_20963__$1 = (function (){var statearr_20968 = state_20963;
(statearr_20968[(9)] = inst_20931__$1);

return statearr_20968;
})();
if(inst_20933){
var statearr_20969_21000 = state_20963__$1;
(statearr_20969_21000[(1)] = (5));

} else {
var statearr_20970_21001 = state_20963__$1;
(statearr_20970_21001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (15))){
var inst_20953 = (state_20963[(2)]);
var state_20963__$1 = state_20963;
var statearr_20971_21002 = state_20963__$1;
(statearr_20971_21002[(2)] = inst_20953);

(statearr_20971_21002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (13))){
var state_20963__$1 = state_20963;
var statearr_20972_21003 = state_20963__$1;
(statearr_20972_21003[(2)] = null);

(statearr_20972_21003[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (6))){
var inst_20928 = (state_20963[(8)]);
var inst_20949 = (inst_20928 > (0));
var state_20963__$1 = state_20963;
if(cljs.core.truth_(inst_20949)){
var statearr_20973_21004 = state_20963__$1;
(statearr_20973_21004[(1)] = (12));

} else {
var statearr_20974_21005 = state_20963__$1;
(statearr_20974_21005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (3))){
var inst_20961 = (state_20963[(2)]);
var state_20963__$1 = state_20963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20963__$1,inst_20961);
} else {
if((state_val_20964 === (12))){
var inst_20927 = (state_20963[(7)]);
var inst_20951 = cljs.core.vec.call(null,inst_20927);
var state_20963__$1 = state_20963;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20963__$1,(15),out,inst_20951);
} else {
if((state_val_20964 === (2))){
var state_20963__$1 = state_20963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20963__$1,(4),ch);
} else {
if((state_val_20964 === (11))){
var inst_20943 = (state_20963[(2)]);
var inst_20944 = (new Array(n));
var inst_20927 = inst_20944;
var inst_20928 = (0);
var state_20963__$1 = (function (){var statearr_20975 = state_20963;
(statearr_20975[(7)] = inst_20927);

(statearr_20975[(8)] = inst_20928);

(statearr_20975[(10)] = inst_20943);

return statearr_20975;
})();
var statearr_20976_21006 = state_20963__$1;
(statearr_20976_21006[(2)] = null);

(statearr_20976_21006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (9))){
var inst_20927 = (state_20963[(7)]);
var inst_20941 = cljs.core.vec.call(null,inst_20927);
var state_20963__$1 = state_20963;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20963__$1,(11),out,inst_20941);
} else {
if((state_val_20964 === (5))){
var inst_20927 = (state_20963[(7)]);
var inst_20936 = (state_20963[(11)]);
var inst_20931 = (state_20963[(9)]);
var inst_20928 = (state_20963[(8)]);
var inst_20935 = (inst_20927[inst_20928] = inst_20931);
var inst_20936__$1 = (inst_20928 + (1));
var inst_20937 = (inst_20936__$1 < n);
var state_20963__$1 = (function (){var statearr_20977 = state_20963;
(statearr_20977[(11)] = inst_20936__$1);

(statearr_20977[(12)] = inst_20935);

return statearr_20977;
})();
if(cljs.core.truth_(inst_20937)){
var statearr_20978_21007 = state_20963__$1;
(statearr_20978_21007[(1)] = (8));

} else {
var statearr_20979_21008 = state_20963__$1;
(statearr_20979_21008[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (14))){
var inst_20956 = (state_20963[(2)]);
var inst_20957 = cljs.core.async.close_BANG_.call(null,out);
var state_20963__$1 = (function (){var statearr_20981 = state_20963;
(statearr_20981[(13)] = inst_20956);

return statearr_20981;
})();
var statearr_20982_21009 = state_20963__$1;
(statearr_20982_21009[(2)] = inst_20957);

(statearr_20982_21009[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (10))){
var inst_20947 = (state_20963[(2)]);
var state_20963__$1 = state_20963;
var statearr_20983_21010 = state_20963__$1;
(statearr_20983_21010[(2)] = inst_20947);

(statearr_20983_21010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20964 === (8))){
var inst_20927 = (state_20963[(7)]);
var inst_20936 = (state_20963[(11)]);
var tmp20980 = inst_20927;
var inst_20927__$1 = tmp20980;
var inst_20928 = inst_20936;
var state_20963__$1 = (function (){var statearr_20984 = state_20963;
(statearr_20984[(7)] = inst_20927__$1);

(statearr_20984[(8)] = inst_20928);

return statearr_20984;
})();
var statearr_20985_21011 = state_20963__$1;
(statearr_20985_21011[(2)] = null);

(statearr_20985_21011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___20997,out))
;
return ((function (switch__18225__auto__,c__18337__auto___20997,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_20989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20989[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_20989[(1)] = (1));

return statearr_20989;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_20963){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_20963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e20990){if((e20990 instanceof Object)){
var ex__18229__auto__ = e20990;
var statearr_20991_21012 = state_20963;
(statearr_20991_21012[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20990;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21013 = state_20963;
state_20963 = G__21013;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_20963){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_20963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___20997,out))
})();
var state__18339__auto__ = (function (){var statearr_20992 = f__18338__auto__.call(null);
(statearr_20992[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___20997);

return statearr_20992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___20997,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21014 = [];
var len__7276__auto___21088 = arguments.length;
var i__7277__auto___21089 = (0);
while(true){
if((i__7277__auto___21089 < len__7276__auto___21088)){
args21014.push((arguments[i__7277__auto___21089]));

var G__21090 = (i__7277__auto___21089 + (1));
i__7277__auto___21089 = G__21090;
continue;
} else {
}
break;
}

var G__21016 = args21014.length;
switch (G__21016) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21014.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18337__auto___21092 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18337__auto___21092,out){
return (function (){
var f__18338__auto__ = (function (){var switch__18225__auto__ = ((function (c__18337__auto___21092,out){
return (function (state_21058){
var state_val_21059 = (state_21058[(1)]);
if((state_val_21059 === (7))){
var inst_21054 = (state_21058[(2)]);
var state_21058__$1 = state_21058;
var statearr_21060_21093 = state_21058__$1;
(statearr_21060_21093[(2)] = inst_21054);

(statearr_21060_21093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (1))){
var inst_21017 = [];
var inst_21018 = inst_21017;
var inst_21019 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21058__$1 = (function (){var statearr_21061 = state_21058;
(statearr_21061[(7)] = inst_21018);

(statearr_21061[(8)] = inst_21019);

return statearr_21061;
})();
var statearr_21062_21094 = state_21058__$1;
(statearr_21062_21094[(2)] = null);

(statearr_21062_21094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (4))){
var inst_21022 = (state_21058[(9)]);
var inst_21022__$1 = (state_21058[(2)]);
var inst_21023 = (inst_21022__$1 == null);
var inst_21024 = cljs.core.not.call(null,inst_21023);
var state_21058__$1 = (function (){var statearr_21063 = state_21058;
(statearr_21063[(9)] = inst_21022__$1);

return statearr_21063;
})();
if(inst_21024){
var statearr_21064_21095 = state_21058__$1;
(statearr_21064_21095[(1)] = (5));

} else {
var statearr_21065_21096 = state_21058__$1;
(statearr_21065_21096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (15))){
var inst_21048 = (state_21058[(2)]);
var state_21058__$1 = state_21058;
var statearr_21066_21097 = state_21058__$1;
(statearr_21066_21097[(2)] = inst_21048);

(statearr_21066_21097[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (13))){
var state_21058__$1 = state_21058;
var statearr_21067_21098 = state_21058__$1;
(statearr_21067_21098[(2)] = null);

(statearr_21067_21098[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (6))){
var inst_21018 = (state_21058[(7)]);
var inst_21043 = inst_21018.length;
var inst_21044 = (inst_21043 > (0));
var state_21058__$1 = state_21058;
if(cljs.core.truth_(inst_21044)){
var statearr_21068_21099 = state_21058__$1;
(statearr_21068_21099[(1)] = (12));

} else {
var statearr_21069_21100 = state_21058__$1;
(statearr_21069_21100[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (3))){
var inst_21056 = (state_21058[(2)]);
var state_21058__$1 = state_21058;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21058__$1,inst_21056);
} else {
if((state_val_21059 === (12))){
var inst_21018 = (state_21058[(7)]);
var inst_21046 = cljs.core.vec.call(null,inst_21018);
var state_21058__$1 = state_21058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21058__$1,(15),out,inst_21046);
} else {
if((state_val_21059 === (2))){
var state_21058__$1 = state_21058;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21058__$1,(4),ch);
} else {
if((state_val_21059 === (11))){
var inst_21026 = (state_21058[(10)]);
var inst_21022 = (state_21058[(9)]);
var inst_21036 = (state_21058[(2)]);
var inst_21037 = [];
var inst_21038 = inst_21037.push(inst_21022);
var inst_21018 = inst_21037;
var inst_21019 = inst_21026;
var state_21058__$1 = (function (){var statearr_21070 = state_21058;
(statearr_21070[(11)] = inst_21036);

(statearr_21070[(12)] = inst_21038);

(statearr_21070[(7)] = inst_21018);

(statearr_21070[(8)] = inst_21019);

return statearr_21070;
})();
var statearr_21071_21101 = state_21058__$1;
(statearr_21071_21101[(2)] = null);

(statearr_21071_21101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (9))){
var inst_21018 = (state_21058[(7)]);
var inst_21034 = cljs.core.vec.call(null,inst_21018);
var state_21058__$1 = state_21058;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21058__$1,(11),out,inst_21034);
} else {
if((state_val_21059 === (5))){
var inst_21026 = (state_21058[(10)]);
var inst_21022 = (state_21058[(9)]);
var inst_21019 = (state_21058[(8)]);
var inst_21026__$1 = f.call(null,inst_21022);
var inst_21027 = cljs.core._EQ_.call(null,inst_21026__$1,inst_21019);
var inst_21028 = cljs.core.keyword_identical_QMARK_.call(null,inst_21019,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21029 = (inst_21027) || (inst_21028);
var state_21058__$1 = (function (){var statearr_21072 = state_21058;
(statearr_21072[(10)] = inst_21026__$1);

return statearr_21072;
})();
if(cljs.core.truth_(inst_21029)){
var statearr_21073_21102 = state_21058__$1;
(statearr_21073_21102[(1)] = (8));

} else {
var statearr_21074_21103 = state_21058__$1;
(statearr_21074_21103[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (14))){
var inst_21051 = (state_21058[(2)]);
var inst_21052 = cljs.core.async.close_BANG_.call(null,out);
var state_21058__$1 = (function (){var statearr_21076 = state_21058;
(statearr_21076[(13)] = inst_21051);

return statearr_21076;
})();
var statearr_21077_21104 = state_21058__$1;
(statearr_21077_21104[(2)] = inst_21052);

(statearr_21077_21104[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (10))){
var inst_21041 = (state_21058[(2)]);
var state_21058__$1 = state_21058;
var statearr_21078_21105 = state_21058__$1;
(statearr_21078_21105[(2)] = inst_21041);

(statearr_21078_21105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21059 === (8))){
var inst_21026 = (state_21058[(10)]);
var inst_21022 = (state_21058[(9)]);
var inst_21018 = (state_21058[(7)]);
var inst_21031 = inst_21018.push(inst_21022);
var tmp21075 = inst_21018;
var inst_21018__$1 = tmp21075;
var inst_21019 = inst_21026;
var state_21058__$1 = (function (){var statearr_21079 = state_21058;
(statearr_21079[(14)] = inst_21031);

(statearr_21079[(7)] = inst_21018__$1);

(statearr_21079[(8)] = inst_21019);

return statearr_21079;
})();
var statearr_21080_21106 = state_21058__$1;
(statearr_21080_21106[(2)] = null);

(statearr_21080_21106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18337__auto___21092,out))
;
return ((function (switch__18225__auto__,c__18337__auto___21092,out){
return (function() {
var cljs$core$async$state_machine__18226__auto__ = null;
var cljs$core$async$state_machine__18226__auto____0 = (function (){
var statearr_21084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21084[(0)] = cljs$core$async$state_machine__18226__auto__);

(statearr_21084[(1)] = (1));

return statearr_21084;
});
var cljs$core$async$state_machine__18226__auto____1 = (function (state_21058){
while(true){
var ret_value__18227__auto__ = (function (){try{while(true){
var result__18228__auto__ = switch__18225__auto__.call(null,state_21058);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18228__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18228__auto__;
}
break;
}
}catch (e21085){if((e21085 instanceof Object)){
var ex__18229__auto__ = e21085;
var statearr_21086_21107 = state_21058;
(statearr_21086_21107[(5)] = ex__18229__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21058);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21085;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18227__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21108 = state_21058;
state_21058 = G__21108;
continue;
} else {
return ret_value__18227__auto__;
}
break;
}
});
cljs$core$async$state_machine__18226__auto__ = function(state_21058){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18226__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18226__auto____1.call(this,state_21058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18226__auto____0;
cljs$core$async$state_machine__18226__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18226__auto____1;
return cljs$core$async$state_machine__18226__auto__;
})()
;})(switch__18225__auto__,c__18337__auto___21092,out))
})();
var state__18339__auto__ = (function (){var statearr_21087 = f__18338__auto__.call(null);
(statearr_21087[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18337__auto___21092);

return statearr_21087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18339__auto__);
});})(c__18337__auto___21092,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1466954743534