// Compiled by ClojureScript 1.8.40 {}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('clojure.string');
if(cljs.core.vector_QMARK_.call(null,taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(11),(0)], null));
} else {
taoensso.encore.assert_min_encore_version.call(null,2.11);
}
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_.call(null,x))){
return new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915);
} else {
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count.call(null,x)))){
return new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281);
} else {
var vec__21972 = x;
var ev_id = cljs.core.nth.call(null,vec__21972,(0),null);
var _ = cljs.core.nth.call(null,vec__21972,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689);
} else {
if(cljs.core.not.call(null,cljs.core.namespace.call(null,ev_id))){
return new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772);
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event.call(null,x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_.call(null,x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__4657__auto__ = taoensso.sente.validate_event.call(null,x);
if(cljs.core.truth_(temp__4657__auto__)){
var _QMARK_err = temp__4657__auto__;
var err_fmt = [cljs.core.str((function (){var G__21974 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__21974) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(_QMARK_err)].join('')));

}
})()),cljs.core.str(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.call(null,taoensso.encore.format.call(null,err_fmt,[cljs.core.str(x)].join('')),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"malformed-event","malformed-event",-2090896605),x], null));
} else {
return null;
}
});
taoensso.sente.client_event_msg_QMARK_ = (function taoensso$sente$client_event_msg_QMARK_(x){
var and__6195__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6195__auto__){
var and__6195__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6195__auto____$1)){
var map__21978 = x;
var map__21978__$1 = ((((!((map__21978 == null)))?((((map__21978.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21978.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21978):map__21978);
var ch_recv = cljs.core.get.call(null,map__21978__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__21978__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__21978__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__21978__$1,new cljs.core.Keyword(null,"event","event",301435442));
var and__6195__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6195__auto____$2)){
var and__6195__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6195__auto____$3){
var and__6195__auto____$4 = taoensso.encore.atom_QMARK_.call(null,state);
if(cljs.core.truth_(and__6195__auto____$4)){
return taoensso.sente.event_QMARK_.call(null,event);
} else {
return and__6195__auto____$4;
}
} else {
return and__6195__auto____$3;
}
} else {
return and__6195__auto____$2;
}
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
});
taoensso.sente.server_event_msg_QMARK_ = (function taoensso$sente$server_event_msg_QMARK_(x){
var and__6195__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__6195__auto__){
var and__6195__auto____$1 = taoensso.encore.keys_EQ_.call(null,x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),null,new cljs.core.Keyword(null,"uid","uid",-1447769400),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null));
if(cljs.core.truth_(and__6195__auto____$1)){
var map__21982 = x;
var map__21982__$1 = ((((!((map__21982 == null)))?((((map__21982.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21982.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21982):map__21982);
var ch_recv = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var connected_uids = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231));
var ring_req = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961));
var client_id = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var event = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__21982__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var and__6195__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(cljs.core.truth_(and__6195__auto____$2)){
var and__6195__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__6195__auto____$3){
var and__6195__auto____$4 = taoensso.encore.atom_QMARK_.call(null,connected_uids);
if(cljs.core.truth_(and__6195__auto____$4)){
var and__6195__auto____$5 = cljs.core.map_QMARK_.call(null,ring_req);
if(and__6195__auto____$5){
var and__6195__auto____$6 = taoensso.encore.nblank_str_QMARK_.call(null,client_id);
if(cljs.core.truth_(and__6195__auto____$6)){
var and__6195__auto____$7 = taoensso.sente.event_QMARK_.call(null,event);
if(cljs.core.truth_(and__6195__auto____$7)){
return ((_QMARK_reply_fn == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_reply_fn));
} else {
return and__6195__auto____$7;
}
} else {
return and__6195__auto____$6;
}
} else {
return and__6195__auto____$5;
}
} else {
return and__6195__auto____$4;
}
} else {
return and__6195__auto____$3;
}
} else {
return and__6195__auto____$2;
}
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
});
/**
 * All server `event-msg`s go through this
 */
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_ = (function taoensso$sente$put_server_event_msg_GT_ch_recv_BANG_(ch_recv,p__21984){
var map__21988 = p__21984;
var map__21988__$1 = ((((!((map__21988 == null)))?((((map__21988.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21988.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21988):map__21988);
var ev_msg = map__21988__$1;
var event = cljs.core.get.call(null,map__21988__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__21988__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var vec__21990 = taoensso.sente.as_event.call(null,event);
var ev_id = cljs.core.nth.call(null,vec__21990,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__21990,(1),null);
var valid_event = vec__21990;
var ev_msg_STAR_ = cljs.core.merge.call(null,ev_msg,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"event","event",301435442),valid_event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null));
if(cljs.core.not.call(null,taoensso.sente.server_event_msg_QMARK_.call(null,ev_msg_STAR_))){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",159,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__21990,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__21988,map__21988__$1,ev_msg,event,_QMARK_reply_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad ev-msg: %s",ev_msg], null);
});})(vec__21990,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__21988,map__21988__$1,ev_msg,event,_QMARK_reply_fn))
,null)),null);
} else {
return cljs.core.async.put_BANG_.call(null,ch_recv,ev_msg_STAR_);
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null).call(null,cb_reply_clj);
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not.call(null,taoensso.sente.cb_error_QMARK_.call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack.call(null,packer,(function (){var __x = pstr;
try{if(typeof __x === 'string'){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e21994){if((e21994 instanceof Error)){
var __t = e21994;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(string? pstr)",__x,__t,null);
} else {
throw e21994;

}
}})());
}catch (e21993){var t = e21993;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",175,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (t){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-package","chsk/bad-package",501893679),pstr], null);
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq.call(null,_QMARK_m)){
return cljs.core.with_meta.call(null,x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args21995 = [];
var len__7276__auto___21998 = arguments.length;
var i__7277__auto___21999 = (0);
while(true){
if((i__7277__auto___21999 < len__7276__auto___21998)){
args21995.push((arguments[i__7277__auto___21999]));

var G__22000 = (i__7277__auto___21999 + (1));
i__7277__auto___21999 = G__22000;
continue;
} else {
}
break;
}

var G__21997 = args21995.length;
switch (G__21997) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21995.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str("-"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str("+"),cljs.core.str(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22003 = arguments.length;
var i__7277__auto___22004 = (0);
while(true){
if((i__7277__auto___22004 < len__7276__auto___22003)){
args__7283__auto__.push((arguments[i__7277__auto___22004]));

var G__22005 = (i__7277__auto___22004 + (1));
i__7277__auto___22004 = G__22005;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.call(null,taoensso.sente.pack_STAR_,args);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",193,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing: %s -> %s",args,pstr], null);
});})(pstr))
,null)),null);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq22002){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq22002));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
var __x_22012 = prefixed_pstr;
try{if(typeof __x_22012 === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22009){if((e22009 instanceof Error)){
var __t_22013 = e22009;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(string? prefixed-pstr)",__x_22012,__t_22013,null);
} else {
throw e22009;

}
}
var prefix = taoensso.encore.substr.call(null,prefixed_pstr,(0),(1));
var pstr = taoensso.encore.substr.call(null,prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_.call(null,packer,pstr);
var wrapped_QMARK_ = (function (){var G__22011 = prefix;
switch (G__22011) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(prefix)].join('')));

}
})();
var vec__22010 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.call(null,vec__22010,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22010,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,(0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",205,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (prefix,pstr,clj,wrapped_QMARK_,vec__22010,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(prefix,pstr,clj,wrapped_QMARK_,vec__22010,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * Takes a web server adapter[1] and returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *  :send-fn ; (fn [user-id ev] for server>user push.
 *  :ajax-post-fn                ; (fn [ring-req]) for Ring CSRF-POST + chsk URL.
 *  :ajax-get-or-ws-handshake-fn ; (fn [ring-req]) for Ring GET + chsk URL.
 *  :connected-uids ; Watchable, read-only (atom {:ws #{_} :ajax #{_} :any #{_}}).
 * 
 *   Common options:
 *  :user-id-fn        ; (fn [ring-req]) -> unique user-id for server>user push.
 *  :csrf-token-fn     ; (fn [ring-req]) -> CSRF token for Ajax POSTs.
 *  :handshake-data-fn ; (fn [ring-req]) -> arb user data to append to handshake evs.
 *  :send-buf-ms-ajax  ; [2]
 *  :send-buf-ms-ws    ; [2]
 *  :packer            ; :edn (default), or an IPacker implementation (experimental).
 * 
 *   [1] e.g. `taoensso.sente.server-adapters.http-kit/http-kit-adapter` or
 *         `taoensso.sente.server-adapters.immutant/immutant-adapter`.
 *    You must have the necessary web-server dependency in your project.clj and
 *    the necessary entry in your namespace's `ns` form.
 * 
 *   [2] Optimization to allow transparent batching of rapidly-triggered
 *    server>user pushes. This is esp. important for Ajax clients which use a
 *    (slow) reconnecting poller. Actual event dispatch may occur <= given ms
 *    after send call (larger values => larger batch windows).
 */
taoensso.sente.make_channel_socket_server_BANG_ = (function taoensso$sente$make_channel_socket_server_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22184 = arguments.length;
var i__7277__auto___22185 = (0);
while(true){
if((i__7277__auto___22185 < len__7276__auto___22184)){
args__7283__auto__.push((arguments[i__7277__auto___22185]));

var G__22186 = (i__7277__auto___22185 + (1));
i__7277__auto___22185 = G__22186;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (web_server_adapter,p__22018){
var vec__22019 = p__22018;
var map__22020 = cljs.core.nth.call(null,vec__22019,(0),null);
var map__22020__$1 = ((((!((map__22020 == null)))?((((map__22020.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22020.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22020):map__22020);
var recv_buf_or_n = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(1000)));
var send_buf_ms_ajax = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"send-buf-ms-ajax","send-buf-ms-ajax",1546129037),(100));
var send_buf_ms_ws = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"send-buf-ms-ws","send-buf-ms-ws",-1149586238),(30));
var user_id_fn = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"user-id-fn","user-id-fn",-1532150029),((function (vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws){
return (function (ring_req){
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"uid","uid",-1447769400)], null));
});})(vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws))
);
var csrf_token_fn = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"csrf-token-fn","csrf-token-fn",-1846298394),((function (vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn){
return (function (ring_req){
var or__6207__auto__ = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var or__6207__auto____$1 = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword("ring.middleware.anti-forgery","anti-forgery-token","ring.middleware.anti-forgery/anti-forgery-token",571563484)], null));
if(cljs.core.truth_(or__6207__auto____$1)){
return or__6207__auto____$1;
} else {
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),"__anti-forgery-token"], null));
}
}
});})(vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn))
);
var handshake_data_fn = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"handshake-data-fn","handshake-data-fn",2011983089),((function (vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn){
return (function (ring_req){
return null;
});})(vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn))
);
var packer = cljs.core.get.call(null,map__22020__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
if(cljs.core.truth_(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var __x = send_buf_ms_ajax;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22022){if((e22022 instanceof Error)){
var __t = e22022;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/pos-int? send-buf-ms-ajax)",__x,__t,null);
} else {
throw e22022;

}
}})(),(function (){var __x = send_buf_ms_ws;
try{if(cljs.core.truth_(taoensso.encore.pos_int_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22023){if((e22023 instanceof Error)){
var __t = e22023;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/pos-int? send-buf-ms-ws)",__x,__t,null);
} else {
throw e22023;

}
}})()], null))){
} else {
throw (new Error("Assert failed: (have? enc/pos-int? send-buf-ms-ajax send-buf-ms-ws)"));
}

if(cljs.core.truth_((function (){var __x = web_server_adapter;
try{if(((function (__x,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p1__22015_SHARP_){
if(!((p1__22015_SHARP_ == null))){
if((false) || (p1__22015_SHARP_.taoensso$sente$interfaces$IServerChanAdapter$)){
return true;
} else {
if((!p1__22015_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__22015_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__22015_SHARP_);
}
});})(__x,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
.call(null,__x)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22024){if((e22024 instanceof Error)){
var __t = e22024;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22015#] (satisfies? interfaces/IServerChanAdapter p1__22015#)) web-server-adapter)",__x,__t,null);
} else {
throw e22024;

}
}})())){
} else {
throw (new Error("Assert failed: (have? (fn* [p1__22015#] (satisfies? interfaces/IServerChanAdapter p1__22015#)) web-server-adapter)"));
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var ch_recv = cljs.core.async.chan.call(null,recv_buf_or_n);
var conns_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var connected_uids_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.PersistentHashSet.EMPTY], null));
var send_buffers_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var user_id_fn__$1 = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req,client_id){
var or__6207__auto__ = user_id_fn.call(null,cljs.core.assoc.call(null,ring_req,new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id));
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486);
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var connect_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type,uid){
if(cljs.core.truth_((function (){var __x = uid;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22026){if((e22026 instanceof Error)){
var __t = e22026;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? uid)",__x,__t,null);
} else {
throw e22026;

}
}})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_connected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22027){
var map__22028 = p__22027;
var map__22028__$1 = ((((!((map__22028 == null)))?((((map__22028.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22028.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22028):map__22028);
var old_m = map__22028__$1;
var ws = cljs.core.get.call(null,map__22028__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__22028__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__22028__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var new_m = (function (){var G__22030 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22030) {
case "ws":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.conj.call(null,ws,uid),new cljs.core.Keyword(null,"ajax","ajax",814345549),ajax,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
case "ajax":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),ws,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.conj.call(null,ajax,uid),new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((!(cljs.core.contains_QMARK_.call(null,old_any,uid))) && (cljs.core.contains_QMARK_.call(null,new_any,uid))){
return new cljs.core.Keyword(null,"newly-connected","newly-connected",-2029862681);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_connected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var upd_connected_uid_BANG_ = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (uid){
if(cljs.core.truth_((function (){var __x = uid;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22031){if((e22031 instanceof Error)){
var __t = e22031;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? uid)",__x,__t,null);
} else {
throw e22031;

}
}})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_disconnected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22032){
var map__22033 = p__22032;
var map__22033__$1 = ((((!((map__22033 == null)))?((((map__22033.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22033.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22033):map__22033);
var old_m = map__22033__$1;
var ws = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__22033__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var conns_SINGLEQUOTE_ = cljs.core.deref.call(null,conns_);
var any_ws_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_ajax_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_clients_QMARK_ = (any_ws_clients_QMARK_) || (any_ajax_clients_QMARK_);
var new_m = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),((any_ws_clients_QMARK_)?cljs.core.conj.call(null,ws,uid):cljs.core.disj.call(null,ws,uid)),new cljs.core.Keyword(null,"ajax","ajax",814345549),((any_ajax_clients_QMARK_)?cljs.core.conj.call(null,ajax,uid):cljs.core.disj.call(null,ajax,uid)),new cljs.core.Keyword(null,"any","any",1705907423),((any_clients_QMARK_)?cljs.core.conj.call(null,any,uid):cljs.core.disj.call(null,any,uid))], null);
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((cljs.core.contains_QMARK_.call(null,old_any,uid)) && (!(cljs.core.contains_QMARK_.call(null,new_any,uid)))){
return new cljs.core.Keyword(null,"newly-disconnected","newly-disconnected",-1586164962);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_disconnected_QMARK_;
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var send_fn = ((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__22188__delegate = function (user_id,ev,p__22035){
var vec__22036 = p__22035;
var map__22037 = cljs.core.nth.call(null,vec__22036,(0),null);
var map__22037__$1 = ((((!((map__22037 == null)))?((((map__22037.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22037.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22037):map__22037);
var opts = map__22037__$1;
var flush_QMARK_ = cljs.core.get.call(null,map__22037__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var uid_22189 = ((cljs.core._EQ_.call(null,user_id,new cljs.core.Keyword("sente","all-users-without-uid","sente/all-users-without-uid",-42979578)))?new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486):user_id);
var __22190 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",324,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_22189,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (->uid %s) %s",uid_22189,ev], null);
});})(uid_22189,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);
var __22191__$1 = (cljs.core.truth_(uid_22189)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Support for sending to `nil` user-ids has been REMOVED. "),cljs.core.str("Please send to `:sente/all-users-without-uid` instead.")].join('')),cljs.core.str("\n"),cljs.core.str("uid")].join('')))})());
var __22192__$2 = taoensso.sente.assert_event.call(null,ev);
var ev_uuid_22193 = taoensso.encore.uuid_str.call(null);
var flush_buffer_BANG__22194 = ((function (uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (type){
var temp__4657__auto__ = taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [type], null),((function (uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (m){
var vec__22039 = cljs.core.get.call(null,m,uid_22189);
var ___$3 = cljs.core.nth.call(null,vec__22039,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22039,(1),null);
if(cljs.core.contains_QMARK_.call(null,ev_uuids,ev_uuid_22193)){
return taoensso.encore.swapped.call(null,cljs.core.dissoc.call(null,m,uid_22189),cljs.core.get.call(null,m,uid_22189));
} else {
return taoensso.encore.swapped.call(null,m,null);
}
});})(uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
if(cljs.core.truth_(temp__4657__auto__)){
var pulled = temp__4657__auto__;
var vec__22040 = pulled;
var buffered_evs = cljs.core.nth.call(null,vec__22040,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22040,(1),null);
var __x_22195 = buffered_evs;
try{if(cljs.core.vector_QMARK_.call(null,__x_22195)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22041){if((e22041 instanceof Error)){
var __t_22196 = e22041;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(vector? buffered-evs)",__x_22195,__t_22196,null);
} else {
throw e22041;

}
}
var __x_22197 = ev_uuids;
try{if(cljs.core.set_QMARK_.call(null,__x_22197)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22042){if((e22042 instanceof Error)){
var __t_22198 = e22042;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(set? ev-uuids)",__x_22197,__t_22198,null);
} else {
throw e22042;

}
}
var packer_metas = cljs.core.mapv.call(null,cljs.core.meta,buffered_evs);
var combined_packer_meta = cljs.core.reduce.call(null,cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,packer_metas);
var buffered_evs_ppstr = taoensso.sente.pack.call(null,packer__$1,combined_packer_meta,buffered_evs);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",357,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__22040,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["buffered-evs-ppstr: %s (with meta %s)",buffered_evs_ppstr,combined_packer_meta], null);
});})(packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__22040,buffered_evs,ev_uuids,pulled,temp__4657__auto__,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var G__22043 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22043) {
case "ws":
return taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.call(null,conns_,uid_22189,buffered_evs_ppstr);

break;
case "ajax":
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.call(null,conns_,uid_22189,buffered_evs_ppstr);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
} else {
return null;
}
});})(uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(cljs.core._EQ_.call(null,ev,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","close","chsk/close",1840295819)], null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",367,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk closing (client may reconnect): %s",uid_22189], null);
});})(uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

if(cljs.core.truth_(flush_QMARK_)){
var seq__22044_22200 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__22045_22201 = null;
var count__22046_22202 = (0);
var i__22047_22203 = (0);
while(true){
if((i__22047_22203 < count__22046_22202)){
var type_22204 = cljs.core._nth.call(null,chunk__22045_22201,i__22047_22203);
flush_buffer_BANG__22194.call(null,type_22204);

var G__22205 = seq__22044_22200;
var G__22206 = chunk__22045_22201;
var G__22207 = count__22046_22202;
var G__22208 = (i__22047_22203 + (1));
seq__22044_22200 = G__22205;
chunk__22045_22201 = G__22206;
count__22046_22202 = G__22207;
i__22047_22203 = G__22208;
continue;
} else {
var temp__4657__auto___22209 = cljs.core.seq.call(null,seq__22044_22200);
if(temp__4657__auto___22209){
var seq__22044_22210__$1 = temp__4657__auto___22209;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22044_22210__$1)){
var c__7018__auto___22211 = cljs.core.chunk_first.call(null,seq__22044_22210__$1);
var G__22212 = cljs.core.chunk_rest.call(null,seq__22044_22210__$1);
var G__22213 = c__7018__auto___22211;
var G__22214 = cljs.core.count.call(null,c__7018__auto___22211);
var G__22215 = (0);
seq__22044_22200 = G__22212;
chunk__22045_22201 = G__22213;
count__22046_22202 = G__22214;
i__22047_22203 = G__22215;
continue;
} else {
var type_22216 = cljs.core.first.call(null,seq__22044_22210__$1);
flush_buffer_BANG__22194.call(null,type_22216);

var G__22217 = cljs.core.next.call(null,seq__22044_22210__$1);
var G__22218 = null;
var G__22219 = (0);
var G__22220 = (0);
seq__22044_22200 = G__22217;
chunk__22045_22201 = G__22218;
count__22046_22202 = G__22219;
i__22047_22203 = G__22220;
continue;
}
} else {
}
}
break;
}
} else {
}

var seq__22048_22221 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid_22189], null))));
var chunk__22049_22222 = null;
var count__22050_22223 = (0);
var i__22051_22224 = (0);
while(true){
if((i__22051_22224 < count__22050_22223)){
var server_ch_22225 = cljs.core._nth.call(null,chunk__22049_22222,i__22051_22224);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22225);

var G__22226 = seq__22048_22221;
var G__22227 = chunk__22049_22222;
var G__22228 = count__22050_22223;
var G__22229 = (i__22051_22224 + (1));
seq__22048_22221 = G__22226;
chunk__22049_22222 = G__22227;
count__22050_22223 = G__22228;
i__22051_22224 = G__22229;
continue;
} else {
var temp__4657__auto___22230 = cljs.core.seq.call(null,seq__22048_22221);
if(temp__4657__auto___22230){
var seq__22048_22231__$1 = temp__4657__auto___22230;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22048_22231__$1)){
var c__7018__auto___22232 = cljs.core.chunk_first.call(null,seq__22048_22231__$1);
var G__22233 = cljs.core.chunk_rest.call(null,seq__22048_22231__$1);
var G__22234 = c__7018__auto___22232;
var G__22235 = cljs.core.count.call(null,c__7018__auto___22232);
var G__22236 = (0);
seq__22048_22221 = G__22233;
chunk__22049_22222 = G__22234;
count__22050_22223 = G__22235;
i__22051_22224 = G__22236;
continue;
} else {
var server_ch_22237 = cljs.core.first.call(null,seq__22048_22231__$1);
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22237);

var G__22238 = cljs.core.next.call(null,seq__22048_22231__$1);
var G__22239 = null;
var G__22240 = (0);
var G__22241 = (0);
seq__22048_22221 = G__22238;
chunk__22049_22222 = G__22239;
count__22050_22223 = G__22240;
i__22051_22224 = G__22241;
continue;
}
} else {
}
}
break;
}

var seq__22052_22242 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid_22189], null))));
var chunk__22053_22243 = null;
var count__22054_22244 = (0);
var i__22055_22245 = (0);
while(true){
if((i__22055_22245 < count__22054_22244)){
var vec__22056_22246 = cljs.core._nth.call(null,chunk__22053_22243,i__22055_22245);
var _QMARK_server_ch_22247 = cljs.core.nth.call(null,vec__22056_22246,(0),null);
var __22248__$3 = cljs.core.nth.call(null,vec__22056_22246,(1),null);
var temp__4657__auto___22249 = _QMARK_server_ch_22247;
if(cljs.core.truth_(temp__4657__auto___22249)){
var server_ch_22250 = temp__4657__auto___22249;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22250);
} else {
}

var G__22251 = seq__22052_22242;
var G__22252 = chunk__22053_22243;
var G__22253 = count__22054_22244;
var G__22254 = (i__22055_22245 + (1));
seq__22052_22242 = G__22251;
chunk__22053_22243 = G__22252;
count__22054_22244 = G__22253;
i__22055_22245 = G__22254;
continue;
} else {
var temp__4657__auto___22255 = cljs.core.seq.call(null,seq__22052_22242);
if(temp__4657__auto___22255){
var seq__22052_22256__$1 = temp__4657__auto___22255;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22052_22256__$1)){
var c__7018__auto___22257 = cljs.core.chunk_first.call(null,seq__22052_22256__$1);
var G__22258 = cljs.core.chunk_rest.call(null,seq__22052_22256__$1);
var G__22259 = c__7018__auto___22257;
var G__22260 = cljs.core.count.call(null,c__7018__auto___22257);
var G__22261 = (0);
seq__22052_22242 = G__22258;
chunk__22053_22243 = G__22259;
count__22054_22244 = G__22260;
i__22055_22245 = G__22261;
continue;
} else {
var vec__22057_22262 = cljs.core.first.call(null,seq__22052_22256__$1);
var _QMARK_server_ch_22263 = cljs.core.nth.call(null,vec__22057_22262,(0),null);
var __22264__$3 = cljs.core.nth.call(null,vec__22057_22262,(1),null);
var temp__4657__auto___22265__$1 = _QMARK_server_ch_22263;
if(cljs.core.truth_(temp__4657__auto___22265__$1)){
var server_ch_22266 = temp__4657__auto___22265__$1;
taoensso.sente.interfaces.sch_close_BANG_.call(null,server_ch_22266);
} else {
}

var G__22267 = cljs.core.next.call(null,seq__22052_22256__$1);
var G__22268 = null;
var G__22269 = (0);
var G__22270 = (0);
seq__22052_22242 = G__22267;
chunk__22053_22243 = G__22268;
count__22054_22244 = G__22269;
i__22055_22245 = G__22270;
continue;
}
} else {
}
}
break;
}
} else {
var seq__22058_22271 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__22059_22272 = null;
var count__22060_22273 = (0);
var i__22061_22274 = (0);
while(true){
if((i__22061_22274 < count__22060_22273)){
var type_22275 = cljs.core._nth.call(null,chunk__22059_22272,i__22061_22274);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_22275,uid_22189], null),((function (seq__22058_22271,chunk__22059_22272,count__22060_22273,i__22061_22274,type_22275,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_22193], true)], null);
} else {
var vec__22062 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__22062,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22062,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_22193)], null);
}
});})(seq__22058_22271,chunk__22059_22272,count__22060_22273,i__22061_22274,type_22275,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__22276 = seq__22058_22271;
var G__22277 = chunk__22059_22272;
var G__22278 = count__22060_22273;
var G__22279 = (i__22061_22274 + (1));
seq__22058_22271 = G__22276;
chunk__22059_22272 = G__22277;
count__22060_22273 = G__22278;
i__22061_22274 = G__22279;
continue;
} else {
var temp__4657__auto___22280 = cljs.core.seq.call(null,seq__22058_22271);
if(temp__4657__auto___22280){
var seq__22058_22281__$1 = temp__4657__auto___22280;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22058_22281__$1)){
var c__7018__auto___22282 = cljs.core.chunk_first.call(null,seq__22058_22281__$1);
var G__22283 = cljs.core.chunk_rest.call(null,seq__22058_22281__$1);
var G__22284 = c__7018__auto___22282;
var G__22285 = cljs.core.count.call(null,c__7018__auto___22282);
var G__22286 = (0);
seq__22058_22271 = G__22283;
chunk__22059_22272 = G__22284;
count__22060_22273 = G__22285;
i__22061_22274 = G__22286;
continue;
} else {
var type_22287 = cljs.core.first.call(null,seq__22058_22281__$1);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type_22287,uid_22189], null),((function (seq__22058_22271,chunk__22059_22272,count__22060_22273,i__22061_22274,type_22287,seq__22058_22281__$1,temp__4657__auto___22280,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.fromArray([ev_uuid_22193], true)], null);
} else {
var vec__22063 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__22063,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__22063,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_22193)], null);
}
});})(seq__22058_22271,chunk__22059_22272,count__22060_22273,i__22061_22274,type_22287,seq__22058_22281__$1,temp__4657__auto___22280,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__22288 = cljs.core.next.call(null,seq__22058_22281__$1);
var G__22289 = null;
var G__22290 = (0);
var G__22291 = (0);
seq__22058_22271 = G__22288;
chunk__22059_22272 = G__22289;
count__22060_22273 = G__22290;
i__22061_22274 = G__22291;
continue;
}
} else {
}
}
break;
}

var c__18332__auto___22292 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22073){
var state_val_22074 = (state_22073[(1)]);
if((state_val_22074 === (1))){
var state_22073__$1 = state_22073;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_22075_22293 = state_22073__$1;
(statearr_22075_22293[(1)] = (2));

} else {
var statearr_22076_22294 = state_22073__$1;
(statearr_22076_22294[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22074 === (2))){
var state_22073__$1 = state_22073;
var statearr_22077_22295 = state_22073__$1;
(statearr_22077_22295[(2)] = null);

(statearr_22077_22295[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22074 === (3))){
var inst_22066 = cljs.core.async.timeout.call(null,send_buf_ms_ws);
var state_22073__$1 = state_22073;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22073__$1,(5),inst_22066);
} else {
if((state_val_22074 === (4))){
var inst_22070 = (state_22073[(2)]);
var inst_22071 = flush_buffer_BANG__22194.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));
var state_22073__$1 = (function (){var statearr_22078 = state_22073;
(statearr_22078[(7)] = inst_22070);

return statearr_22078;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22073__$1,inst_22071);
} else {
if((state_val_22074 === (5))){
var inst_22068 = (state_22073[(2)]);
var state_22073__$1 = state_22073;
var statearr_22079_22296 = state_22073__$1;
(statearr_22079_22296[(2)] = inst_22068);

(statearr_22079_22296[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18220__auto__,c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22083 = [null,null,null,null,null,null,null,null];
(statearr_22083[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22083[(1)] = (1));

return statearr_22083;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22073){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22073);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22084){if((e22084 instanceof Object)){
var ex__18224__auto__ = e22084;
var statearr_22085_22297 = state_22073;
(statearr_22085_22297[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22073);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22084;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22298 = state_22073;
state_22073 = G__22298;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22073){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18334__auto__ = (function (){var statearr_22086 = f__18333__auto__.call(null);
(statearr_22086[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___22292);

return statearr_22086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___22292,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);


var c__18332__auto___22299 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22096){
var state_val_22097 = (state_22096[(1)]);
if((state_val_22097 === (1))){
var state_22096__$1 = state_22096;
if(cljs.core.truth_(flush_QMARK_)){
var statearr_22098_22300 = state_22096__$1;
(statearr_22098_22300[(1)] = (2));

} else {
var statearr_22099_22301 = state_22096__$1;
(statearr_22099_22301[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22097 === (2))){
var state_22096__$1 = state_22096;
var statearr_22100_22302 = state_22096__$1;
(statearr_22100_22302[(2)] = null);

(statearr_22100_22302[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22097 === (3))){
var inst_22089 = cljs.core.async.timeout.call(null,send_buf_ms_ajax);
var state_22096__$1 = state_22096;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22096__$1,(5),inst_22089);
} else {
if((state_val_22097 === (4))){
var inst_22093 = (state_22096[(2)]);
var inst_22094 = flush_buffer_BANG__22194.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var state_22096__$1 = (function (){var statearr_22101 = state_22096;
(statearr_22101[(7)] = inst_22093);

return statearr_22101;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22096__$1,inst_22094);
} else {
if((state_val_22097 === (5))){
var inst_22091 = (state_22096[(2)]);
var state_22096__$1 = state_22096;
var statearr_22102_22303 = state_22096__$1;
(statearr_22102_22303[(2)] = inst_22091);

(statearr_22102_22303[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});})(c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18220__auto__,c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22106 = [null,null,null,null,null,null,null,null];
(statearr_22106[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22106[(1)] = (1));

return statearr_22106;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22096){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22096);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22107){if((e22107 instanceof Object)){
var ex__18224__auto__ = e22107;
var statearr_22108_22304 = state_22096;
(statearr_22108_22304[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22096);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22107;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22305 = state_22096;
state_22096 = G__22305;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22096){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18334__auto__ = (function (){var statearr_22109 = f__18333__auto__.call(null);
(statearr_22109[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___22299);

return statearr_22109;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___22299,uid_22189,__22190,__22191__$1,__22192__$2,ev_uuid_22193,flush_buffer_BANG__22194,vec__22036,map__22037,map__22037__$1,opts,flush_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

}

return null;
};
var G__22188 = function (user_id,ev,var_args){
var p__22035 = null;
if (arguments.length > 2) {
var G__22306__i = 0, G__22306__a = new Array(arguments.length -  2);
while (G__22306__i < G__22306__a.length) {G__22306__a[G__22306__i] = arguments[G__22306__i + 2]; ++G__22306__i;}
  p__22035 = new cljs.core.IndexedSeq(G__22306__a,0);
} 
return G__22188__delegate.call(this,user_id,ev,p__22035);};
G__22188.cljs$lang$maxFixedArity = 2;
G__22188.cljs$lang$applyTo = (function (arglist__22307){
var user_id = cljs.core.first(arglist__22307);
arglist__22307 = cljs.core.next(arglist__22307);
var ev = cljs.core.first(arglist__22307);
var p__22035 = cljs.core.rest(arglist__22307);
return G__22188__delegate(user_id,ev,p__22035);
});
G__22188.cljs$core$IFn$_invoke$arity$variadic = G__22188__delegate;
return G__22188;
})()
;})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var ev_msg_const = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_], null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_,new cljs.core.Keyword(null,"ajax-post-fn","ajax-post-fn",1830071264),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var ppstr = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var vec__22110 = taoensso.sente.unpack.call(null,packer__$1,ppstr);
var clj = cljs.core.nth.call(null,vec__22110,(0),null);
var has_cb_QMARK_ = cljs.core.nth.call(null,vec__22110,(1),null);
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),clj,new cljs.core.Keyword(null,"uid","uid",-1447769400),user_id_fn__$1.call(null,ring_req,client_id),new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),(cljs.core.truth_(has_cb_QMARK_)?((function (params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",435,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): %s",resp_clj], null);
});})(params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
});})(params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null)], null)));

if(cljs.core.truth_(has_cb_QMARK_)){
return null;
} else {
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",442,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax reply): dummy-cb-200"], null);
});})(params,ppstr,client_id,vec__22110,clj,has_cb_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337)),new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"ajax-get-or-ws-handshake-fn","ajax-get-or-ws-handshake-fn",-1210409233),((function (packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
var csrf_token = csrf_token_fn.call(null,ring_req);
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var uid = user_id_fn__$1.call(null,ring_req,client_id);
var websocket_QMARK_ = new cljs.core.Keyword(null,"websocket?","websocket?",1552493139).cljs$core$IFn$_invoke$arity$1(ring_req);
var receive_event_msg_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__22308__delegate = function (event,p__22111){
var vec__22112 = p__22111;
var _QMARK_reply_fn = cljs.core.nth.call(null,vec__22112,(0),null);
return taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null)));
};
var G__22308 = function (event,var_args){
var p__22111 = null;
if (arguments.length > 1) {
var G__22309__i = 0, G__22309__a = new Array(arguments.length -  1);
while (G__22309__i < G__22309__a.length) {G__22309__a[G__22309__i] = arguments[G__22309__i + 1]; ++G__22309__i;}
  p__22111 = new cljs.core.IndexedSeq(G__22309__a,0);
} 
return G__22308__delegate.call(this,event,p__22111);};
G__22308.cljs$lang$maxFixedArity = 1;
G__22308.cljs$lang$applyTo = (function (arglist__22310){
var event = cljs.core.first(arglist__22310);
var p__22111 = cljs.core.rest(arglist__22310);
return G__22308__delegate(event,p__22111);
});
G__22308.cljs$core$IFn$_invoke$arity$variadic = G__22308__delegate;
return G__22308;
})()
;})(csrf_token,params,client_id,uid,websocket_QMARK_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var handshake_BANG_ = ((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",467,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Handshake!"], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

var _QMARK_handshake_data = handshake_data_fn.call(null,ring_req);
var handshake_ev = ((!((_QMARK_handshake_data == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token,_QMARK_handshake_data], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token], null)], null));
return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,null,handshake_ev),cljs.core.not.call(null,websocket_QMARK_));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(clojure.string.blank_QMARK_.call(null,client_id)){
var err_msg = "Client's Ring request doesn't have a client id. Does your server have the necessary keyword Ring middleware (`wrap-params` & `wrap-keyword-params`)?";
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",479,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(err_msg),cljs.core.str(": %s")].join(''),ring_req], null);
});})(err_msg,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

throw cljs.core.ex_info.call(null,err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req], null));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",487,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New WebSocket channel: %s (%s)",uid,[cljs.core.str(server_ch)].join('')], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

taoensso.encore.reset_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id], null),server_ch);

if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

return handshake_BANG_.call(null,server_ch);
} else {
var initial_conn_from_client_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
return taoensso.encore.swapped.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [server_ch,taoensso.encore.now_udt.call(null)], null),(_QMARK_v == null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
var handshake_QMARK_ = (function (){var or__6207__auto__ = initial_conn_from_client_QMARK_;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"handshake?","handshake?",-423743093).cljs$core$IFn$_invoke$arity$1(params);
}
})();
if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954)], null));
} else {
}

if(cljs.core.truth_(handshake_QMARK_)){
return handshake_BANG_.call(null,server_ch);
} else {
return null;
}
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-msg","on-msg",-2021925279),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,req_ppstr){
var vec__22113 = taoensso.sente.unpack.call(null,packer__$1,req_ppstr);
var clj = cljs.core.nth.call(null,vec__22113,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22113,(1),null);
return receive_event_msg_BANG_.call(null,clj,(cljs.core.truth_(_QMARK_cb_uuid)?((function (vec__22113,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",514,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22113,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ws reply): %s",resp_clj], null);
});})(vec__22113,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj,_QMARK_cb_uuid));
});})(vec__22113,clj,_QMARK_cb_uuid,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null));
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,status){
if(cljs.core.truth_(websocket_QMARK_)){
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
if(cljs.core.empty_QMARK_.call(null,new_m)){
return new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782);
} else {
return new_m;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22127){
var state_val_22128 = (state_22127[(1)]);
if((state_val_22128 === (1))){
var inst_22114 = cljs.core.async.timeout.call(null,(5000));
var state_22127__$1 = state_22127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22127__$1,(2),inst_22114);
} else {
if((state_val_22128 === (2))){
var inst_22116 = (state_22127[(2)]);
var inst_22117 = upd_connected_uid_BANG_.call(null,uid);
var state_22127__$1 = (function (){var statearr_22129 = state_22127;
(statearr_22129[(7)] = inst_22116);

return statearr_22129;
})();
if(cljs.core.truth_(inst_22117)){
var statearr_22130_22311 = state_22127__$1;
(statearr_22130_22311[(1)] = (3));

} else {
var statearr_22131_22312 = state_22127__$1;
(statearr_22131_22312[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22128 === (3))){
var inst_22119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22120 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_22121 = (new cljs.core.PersistentVector(null,1,(5),inst_22119,inst_22120,null));
var inst_22122 = receive_event_msg_BANG_.call(null,inst_22121);
var state_22127__$1 = state_22127;
var statearr_22132_22313 = state_22127__$1;
(statearr_22132_22313[(2)] = inst_22122);

(statearr_22132_22313[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22128 === (4))){
var state_22127__$1 = state_22127;
var statearr_22133_22314 = state_22127__$1;
(statearr_22133_22314[(2)] = null);

(statearr_22133_22314[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22128 === (5))){
var inst_22125 = (state_22127[(2)]);
var state_22127__$1 = state_22127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22127__$1,inst_22125);
} else {
return null;
}
}
}
}
}
});})(c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18220__auto__,c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22137 = [null,null,null,null,null,null,null,null];
(statearr_22137[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22137[(1)] = (1));

return statearr_22137;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22127){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22138){if((e22138 instanceof Object)){
var ex__18224__auto__ = e22138;
var statearr_22139_22315 = state_22127;
(statearr_22139_22315[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22138;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22316 = state_22127;
state_22127 = G__22316;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22127){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18334__auto__ = (function (){var statearr_22140 = f__18333__auto__.call(null);
(statearr_22140[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_22140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__18332__auto__;
} else {
taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,new cljs.core.Keyword(null,"ajax","ajax",814345549),client_id], null),((function (csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__22141){
var vec__22142 = p__22141;
var server_ch__$1 = cljs.core.nth.call(null,vec__22142,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__22142,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null);
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var udt_disconnected = taoensso.encore.now_udt.call(null);
var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_22165){
var state_val_22166 = (state_22165[(1)]);
if((state_val_22166 === (1))){
var inst_22143 = cljs.core.async.timeout.call(null,(5000));
var state_22165__$1 = state_22165;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22165__$1,(2),inst_22143);
} else {
if((state_val_22166 === (2))){
var inst_22145 = (state_22165[(2)]);
var inst_22146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22147 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_22148 = (new cljs.core.PersistentVector(null,2,(5),inst_22146,inst_22147,null));
var inst_22149 = (function (){return ((function (inst_22145,inst_22146,inst_22147,inst_22148,state_val_22166,c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
var vec__22167 = cljs.core.get.call(null,_QMARK_m,client_id);
var _ = cljs.core.nth.call(null,vec__22167,(0),null);
var _QMARK_udt_last_connected = cljs.core.nth.call(null,vec__22167,(1),null);
var disconnected_QMARK_ = (function (){var and__6195__auto__ = _QMARK_udt_last_connected;
if(cljs.core.truth_(and__6195__auto__)){
return (udt_disconnected >= _QMARK_udt_last_connected);
} else {
return and__6195__auto__;
}
})();
if(cljs.core.not.call(null,disconnected_QMARK_)){
return taoensso.encore.swapped.call(null,_QMARK_m,cljs.core.not.call(null,new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586)));
} else {
var new_m = cljs.core.dissoc.call(null,_QMARK_m,client_id);
return taoensso.encore.swapped.call(null,((cljs.core.empty_QMARK_.call(null,new_m))?new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782):new_m),new cljs.core.Keyword(null,"disconnected","disconnected",-1908014586));
}
});
;})(inst_22145,inst_22146,inst_22147,inst_22148,state_val_22166,c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_22150 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_22148,inst_22149);
var state_22165__$1 = (function (){var statearr_22168 = state_22165;
(statearr_22168[(7)] = inst_22145);

return statearr_22168;
})();
if(cljs.core.truth_(inst_22150)){
var statearr_22169_22317 = state_22165__$1;
(statearr_22169_22317[(1)] = (3));

} else {
var statearr_22170_22318 = state_22165__$1;
(statearr_22170_22318[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22166 === (3))){
var inst_22152 = upd_connected_uid_BANG_.call(null,uid);
var state_22165__$1 = state_22165;
if(cljs.core.truth_(inst_22152)){
var statearr_22171_22319 = state_22165__$1;
(statearr_22171_22319[(1)] = (6));

} else {
var statearr_22172_22320 = state_22165__$1;
(statearr_22172_22320[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22166 === (4))){
var state_22165__$1 = state_22165;
var statearr_22173_22321 = state_22165__$1;
(statearr_22173_22321[(2)] = null);

(statearr_22173_22321[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22166 === (5))){
var inst_22163 = (state_22165[(2)]);
var state_22165__$1 = state_22165;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22165__$1,inst_22163);
} else {
if((state_val_22166 === (6))){
var inst_22154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22155 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678)];
var inst_22156 = (new cljs.core.PersistentVector(null,1,(5),inst_22154,inst_22155,null));
var inst_22157 = receive_event_msg_BANG_.call(null,inst_22156);
var state_22165__$1 = state_22165;
var statearr_22174_22322 = state_22165__$1;
(statearr_22174_22322[(2)] = inst_22157);

(statearr_22174_22322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22166 === (7))){
var state_22165__$1 = state_22165;
var statearr_22175_22323 = state_22165__$1;
(statearr_22175_22323[(2)] = null);

(statearr_22175_22323[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22166 === (8))){
var inst_22160 = (state_22165[(2)]);
var state_22165__$1 = state_22165;
var statearr_22176_22324 = state_22165__$1;
(statearr_22176_22324[(2)] = inst_22160);

(statearr_22176_22324[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__18220__auto__,c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22180 = [null,null,null,null,null,null,null,null];
(statearr_22180[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22180[(1)] = (1));

return statearr_22180;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22165){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22165);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22181){if((e22181 instanceof Object)){
var ex__18224__auto__ = e22181;
var statearr_22182_22325 = state_22165;
(statearr_22182_22325[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22165);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22181;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22326 = state_22165;
state_22165 = G__22326;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22165){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__18334__auto__ = (function (){var statearr_22183 = f__18333__auto__.call(null);
(statearr_22183[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_22183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__,udt_disconnected,csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__18332__auto__;
}
});})(csrf_token,params,client_id,uid,websocket_QMARK_,receive_event_msg_BANG_,handshake_BANG_,packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
}
});})(packer__$1,ch_recv,conns_,connected_uids_,send_buffers_,user_id_fn__$1,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__22019,map__22020,map__22020__$1,recv_buf_or_n,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$applyTo = (function (seq22016){
var G__22017 = cljs.core.first.call(null,seq22016);
var seq22016__$1 = cljs.core.next.call(null,seq22016);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22017,seq22016__$1);
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's WebSocket conns.
 */
taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ws_clients_BANG_(conns_,uid,buffered_evs_pstr){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",576,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ws-clients!: %s",buffered_evs_pstr], null);
}),null)),null);

var seq__22331 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null))));
var chunk__22332 = null;
var count__22333 = (0);
var i__22334 = (0);
while(true){
if((i__22334 < count__22333)){
var server_ch = cljs.core._nth.call(null,chunk__22332,i__22334);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__22335 = seq__22331;
var G__22336 = chunk__22332;
var G__22337 = count__22333;
var G__22338 = (i__22334 + (1));
seq__22331 = G__22335;
chunk__22332 = G__22336;
count__22333 = G__22337;
i__22334 = G__22338;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22331);
if(temp__4657__auto__){
var seq__22331__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22331__$1)){
var c__7018__auto__ = cljs.core.chunk_first.call(null,seq__22331__$1);
var G__22339 = cljs.core.chunk_rest.call(null,seq__22331__$1);
var G__22340 = c__7018__auto__;
var G__22341 = cljs.core.count.call(null,c__7018__auto__);
var G__22342 = (0);
seq__22331 = G__22339;
chunk__22332 = G__22340;
count__22333 = G__22341;
i__22334 = G__22342;
continue;
} else {
var server_ch = cljs.core.first.call(null,seq__22331__$1);
taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,buffered_evs_pstr);

var G__22343 = cljs.core.next.call(null,seq__22331__$1);
var G__22344 = null;
var G__22345 = (0);
var G__22346 = (0);
seq__22331 = G__22343;
chunk__22332 = G__22344;
count__22333 = G__22345;
i__22334 = G__22346;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's Ajax conns.
 *   Allows some time for possible Ajax poller reconnects.
 */
taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22436 = arguments.length;
var i__7277__auto___22437 = (0);
while(true){
if((i__7277__auto___22437 < len__7276__auto___22436)){
args__7283__auto__.push((arguments[i__7277__auto___22437]));

var G__22438 = (i__7277__auto___22437 + (1));
i__7277__auto___22437 = G__22438;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((3) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((3)),(0),null)):null);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7284__auto__);
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (conns_,uid,buffered_evs_pstr,p__22351){
var vec__22352 = p__22351;
var map__22353 = cljs.core.nth.call(null,vec__22352,(0),null);
var map__22353__$1 = ((((!((map__22353 == null)))?((((map__22353.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22353.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22353):map__22353);
var nmax_attempts = cljs.core.get.call(null,map__22353__$1,new cljs.core.Keyword(null,"nmax-attempts","nmax-attempts",1471144610),(7));
var ms_base = cljs.core.get.call(null,map__22353__$1,new cljs.core.Keyword(null,"ms-base","ms-base",-1962784511),(90));
var ms_rand = cljs.core.get.call(null,map__22353__$1,new cljs.core.Keyword(null,"ms-rand","ms-rand",1169398874),(90));

taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",589,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ajax-clients!: %s",buffered_evs_pstr], null);
});})(vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
,null)),null);

var client_ids_unsatisfied = cljs.core.keys.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid], null)));
if(cljs.core.empty_QMARK_.call(null,client_ids_unsatisfied)){
return null;
} else {
var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (state_22402){
var state_val_22403 = (state_22402[(1)]);
if((state_val_22403 === (7))){
var inst_22363 = (state_22402[(7)]);
var inst_22357 = (state_22402[(8)]);
var inst_22356 = (state_22402[(9)]);
var inst_22374 = (function (){var n = inst_22356;
var client_ids_satisfied = inst_22357;
var _QMARK_pulled = inst_22363;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_22363,inst_22357,inst_22356,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (s,client_id,p__22373){
var vec__22404 = p__22373;
var _QMARK_server_ch = cljs.core.nth.call(null,vec__22404,(0),null);
var _ = cljs.core.nth.call(null,vec__22404,(1),null);
if(((_QMARK_server_ch == null)) || (cljs.core.not.call(null,taoensso.sente.interfaces.sch_send_BANG_.call(null,_QMARK_server_ch,buffered_evs_pstr,new cljs.core.Keyword(null,"close-after-send","close-after-send",1264946103))))){
return s;
} else {
return cljs.core.conj.call(null,s,client_id);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_22363,inst_22357,inst_22356,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22375 = cljs.core.PersistentHashSet.EMPTY;
var inst_22376 = cljs.core.reduce_kv.call(null,inst_22374,inst_22375,inst_22363);
var state_22402__$1 = state_22402;
var statearr_22405_22439 = state_22402__$1;
(statearr_22405_22439[(2)] = inst_22376);

(statearr_22405_22439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (1))){
var inst_22355 = cljs.core.PersistentHashSet.EMPTY;
var inst_22356 = (0);
var inst_22357 = inst_22355;
var state_22402__$1 = (function (){var statearr_22406 = state_22402;
(statearr_22406[(8)] = inst_22357);

(statearr_22406[(9)] = inst_22356);

return statearr_22406;
})();
var statearr_22407_22440 = state_22402__$1;
(statearr_22407_22440[(2)] = null);

(statearr_22407_22440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (4))){
var state_22402__$1 = state_22402;
var statearr_22408_22441 = state_22402__$1;
(statearr_22408_22441[(2)] = true);

(statearr_22408_22441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (15))){
var inst_22398 = (state_22402[(2)]);
var state_22402__$1 = state_22402;
var statearr_22409_22442 = state_22402__$1;
(statearr_22409_22442[(2)] = inst_22398);

(statearr_22409_22442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (13))){
var inst_22389 = cljs.core.rand_int.call(null,ms_rand);
var inst_22390 = (ms_base + inst_22389);
var inst_22391 = cljs.core.async.timeout.call(null,inst_22390);
var state_22402__$1 = state_22402;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22402__$1,(16),inst_22391);
} else {
if((state_val_22403 === (6))){
var inst_22363 = (state_22402[(7)]);
var inst_22371 = (state_22402[(2)]);
var state_22402__$1 = (function (){var statearr_22410 = state_22402;
(statearr_22410[(10)] = inst_22371);

return statearr_22410;
})();
if(cljs.core.truth_(inst_22363)){
var statearr_22411_22443 = state_22402__$1;
(statearr_22411_22443[(1)] = (7));

} else {
var statearr_22412_22444 = state_22402__$1;
(statearr_22412_22444[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (3))){
var inst_22400 = (state_22402[(2)]);
var state_22402__$1 = state_22402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22402__$1,inst_22400);
} else {
if((state_val_22403 === (12))){
var inst_22387 = (state_22402[(2)]);
var state_22402__$1 = state_22402;
if(cljs.core.truth_(inst_22387)){
var statearr_22413_22445 = state_22402__$1;
(statearr_22413_22445[(1)] = (13));

} else {
var statearr_22414_22446 = state_22402__$1;
(statearr_22414_22446[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (2))){
var inst_22363 = (state_22402[(7)]);
var inst_22357 = (state_22402[(8)]);
var inst_22356 = (state_22402[(9)]);
var inst_22359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22360 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_22361 = (new cljs.core.PersistentVector(null,2,(5),inst_22359,inst_22360,null));
var inst_22362 = (function (){var n = inst_22356;
var client_ids_satisfied = inst_22357;
return ((function (n,client_ids_satisfied,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (m){
var ks_to_pull = cljs.core.remove.call(null,client_ids_satisfied,cljs.core.keys.call(null,m));
if(cljs.core.empty_QMARK_.call(null,ks_to_pull)){
return taoensso.encore.swapped.call(null,m,null);
} else {
return taoensso.encore.swapped.call(null,cljs.core.reduce.call(null,((function (ks_to_pull,n,client_ids_satisfied,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (m__$1,k){
var vec__22415 = cljs.core.get.call(null,m__$1,k);
var _QMARK_server_ch = cljs.core.nth.call(null,vec__22415,(0),null);
var udt_last_connected = cljs.core.nth.call(null,vec__22415,(1),null);
return cljs.core.assoc.call(null,m__$1,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt_last_connected], null));
});})(ks_to_pull,n,client_ids_satisfied,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
,m,ks_to_pull),cljs.core.select_keys.call(null,m,ks_to_pull));
}
});
;})(n,client_ids_satisfied,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22363__$1 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_22361,inst_22362);
var inst_22364 = (function (){var n = inst_22356;
var client_ids_satisfied = inst_22357;
var _QMARK_pulled = inst_22363__$1;
var __x = inst_22363__$1;
return ((function (n,client_ids_satisfied,_QMARK_pulled,__x,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,inst_22362,inst_22363__$1,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function (__x__$1){
var or__6207__auto__ = taoensso.truss.impl.non_throwing.call(null,cljs.core.nil_QMARK_).call(null,__x__$1);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.truss.impl.non_throwing.call(null,cljs.core.map_QMARK_).call(null,__x__$1);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,__x,inst_22363,inst_22357,inst_22356,inst_22359,inst_22360,inst_22361,inst_22362,inst_22363__$1,state_val_22403,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
})();
var inst_22365 = inst_22364.call(null,inst_22363__$1);
var state_22402__$1 = (function (){var statearr_22416 = state_22402;
(statearr_22416[(7)] = inst_22363__$1);

return statearr_22416;
})();
if(cljs.core.truth_(inst_22365)){
var statearr_22417_22447 = state_22402__$1;
(statearr_22417_22447[(1)] = (4));

} else {
var statearr_22418_22448 = state_22402__$1;
(statearr_22418_22448[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (11))){
var inst_22381 = (state_22402[(11)]);
var state_22402__$1 = state_22402;
var statearr_22419_22449 = state_22402__$1;
(statearr_22419_22449[(2)] = inst_22381);

(statearr_22419_22449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (9))){
var inst_22381 = (state_22402[(11)]);
var inst_22357 = (state_22402[(8)]);
var inst_22356 = (state_22402[(9)]);
var inst_22379 = (state_22402[(2)]);
var inst_22380 = cljs.core.into.call(null,inst_22357,inst_22379);
var inst_22381__$1 = (inst_22356 < nmax_attempts);
var state_22402__$1 = (function (){var statearr_22420 = state_22402;
(statearr_22420[(12)] = inst_22380);

(statearr_22420[(11)] = inst_22381__$1);

return statearr_22420;
})();
if(cljs.core.truth_(inst_22381__$1)){
var statearr_22421_22450 = state_22402__$1;
(statearr_22421_22450[(1)] = (10));

} else {
var statearr_22422_22451 = state_22402__$1;
(statearr_22422_22451[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (5))){
var inst_22363 = (state_22402[(7)]);
var inst_22368 = "([:or nil? map?] ?pulled)";
var inst_22369 = taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,inst_22368,inst_22363,null,null);
var state_22402__$1 = state_22402;
var statearr_22423_22452 = state_22402__$1;
(statearr_22423_22452[(2)] = inst_22369);

(statearr_22423_22452[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (14))){
var state_22402__$1 = state_22402;
var statearr_22424_22453 = state_22402__$1;
(statearr_22424_22453[(2)] = null);

(statearr_22424_22453[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (16))){
var inst_22380 = (state_22402[(12)]);
var inst_22356 = (state_22402[(9)]);
var inst_22393 = (state_22402[(2)]);
var inst_22394 = (inst_22356 + (1));
var inst_22356__$1 = inst_22394;
var inst_22357 = inst_22380;
var state_22402__$1 = (function (){var statearr_22425 = state_22402;
(statearr_22425[(13)] = inst_22393);

(statearr_22425[(8)] = inst_22357);

(statearr_22425[(9)] = inst_22356__$1);

return statearr_22425;
})();
var statearr_22426_22454 = state_22402__$1;
(statearr_22426_22454[(2)] = null);

(statearr_22426_22454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (10))){
var inst_22380 = (state_22402[(12)]);
var inst_22383 = cljs.core.complement.call(null,inst_22380);
var inst_22384 = cljs.core.some.call(null,inst_22383,client_ids_unsatisfied);
var state_22402__$1 = state_22402;
var statearr_22427_22455 = state_22402__$1;
(statearr_22427_22455[(2)] = inst_22384);

(statearr_22427_22455[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22403 === (8))){
var state_22402__$1 = state_22402;
var statearr_22428_22456 = state_22402__$1;
(statearr_22428_22456[(2)] = null);

(statearr_22428_22456[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
;
return ((function (switch__18220__auto__,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22432 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22432[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22432[(1)] = (1));

return statearr_22432;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22402){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22433){if((e22433 instanceof Object)){
var ex__18224__auto__ = e22433;
var statearr_22434_22457 = state_22402;
(statearr_22434_22457[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22402);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22433;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22458 = state_22402;
state_22402 = G__22458;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22402){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
})();
var state__18334__auto__ = (function (){var statearr_22435 = f__18333__auto__.call(null);
(statearr_22435[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_22435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__,client_ids_unsatisfied,vec__22352,map__22353,map__22353__$1,nmax_attempts,ms_base,ms_rand))
);

return c__18332__auto__;
}
});

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$lang$applyTo = (function (seq22347){
var G__22348 = cljs.core.first.call(null,seq22347);
var seq22347__$1 = cljs.core.next.call(null,seq22347);
var G__22349 = cljs.core.first.call(null,seq22347__$1);
var seq22347__$2 = cljs.core.next.call(null,seq22347__$1);
var G__22350 = cljs.core.first.call(null,seq22347__$2);
var seq22347__$3 = cljs.core.next.call(null,seq22347__$2);
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22348,G__22349,G__22350,seq22347__$3);
});
/**
 * Alias of `taoensso.encore/ajax-lite`
 */
taoensso.sente.ajax_lite = taoensso.encore.ajax_lite;

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail
 */
taoensso.sente._chsk_connect_BANG_ = (function taoensso$sente$_chsk_connect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente._chsk_connect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente._chsk_connect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-connect!",chsk);
}
}
}
});

/**
 * Implementation detail
 */
taoensso.sente._chsk_send_BANG_ = (function taoensso$sente$_chsk_send_BANG_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(chsk,ev,opts);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente._chsk_send_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk,ev,opts);
} else {
var m__6871__auto____$1 = (taoensso.sente._chsk_send_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk,ev,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-send!",chsk);
}
}
}
});

/**
 * DEPRECATED: Please use `chsk-disconnect!` instead
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Disconnects channel socket
 */
taoensso.sente.chsk_disconnect_BANG_ = (function taoensso$sente$chsk_disconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_disconnect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_disconnect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-disconnect!",chsk);
}
}
}
});

/**
 * Reconnects channel socket (useful for reauthenticating after login/logout, etc.)
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__6870__auto__ = (((chsk == null))?null:chsk);
var m__6871__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,chsk);
} else {
var m__6871__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args22459 = [];
var len__7276__auto___22462 = arguments.length;
var i__7277__auto___22463 = (0);
while(true){
if((i__7277__auto___22463 < len__7276__auto___22462)){
args22459.push((arguments[i__7277__auto___22463]));

var G__22464 = (i__7277__auto___22463 + (1));
i__7277__auto___22463 = G__22464;
continue;
} else {
}
break;
}

var G__22461 = args22459.length;
switch (G__22461) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22459.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",646,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null);

return taoensso.sente._chsk_send_BANG_.call(null,chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event.call(null,x);

if(cljs.core.truth_((function (){var or__6207__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__6207__auto__){
return or__6207__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_.call(null,_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb requires a timeout; timeout-ms should be a +ive integer: %s",_QMARK_timeout_ms)),cljs.core.str("\n"),cljs.core.str("(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nneg-int? ?timeout-ms)))")].join('')));
}

if(cljs.core.truth_((function (){var or__6207__auto__ = (_QMARK_cb == null);
if(or__6207__auto__){
return or__6207__auto__;
} else {
var or__6207__auto____$1 = cljs.core.ifn_QMARK_.call(null,_QMARK_cb);
if(or__6207__auto____$1){
return or__6207__auto____$1;
} else {
return taoensso.encore.chan_QMARK_.call(null,_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(taoensso.encore.format.call(null,"cb should be nil, an ifn, or a channel: %s",cljs.core.type.call(null,_QMARK_cb))),cljs.core.str("\n"),cljs.core.str("(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))")].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__4657__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto__)){
var cb_uuid = temp__4657__auto__;
return taoensso.encore.swap_in_BANG_.call(null,cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__4657__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__4657__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__22466,merge_state){
var map__22470 = p__22466;
var map__22470__$1 = ((((!((map__22470 == null)))?((((map__22470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22470):map__22470);
var chsk = map__22470__$1;
var chs = cljs.core.get.call(null,map__22470__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var state_ = cljs.core.get.call(null,map__22470__$1,new cljs.core.Keyword(null,"state_","state_",957667102));
var vec__22472 = taoensso.encore.swap_in_BANG_.call(null,state_,cljs.core.PersistentVector.EMPTY,((function (map__22470,map__22470__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.call(null,old_state,merge_state);
var new_state__$1 = ((cljs.core.not.call(null,(function (){var and__6195__auto__ = new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116).cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__6195__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})()))?new_state:cljs.core.assoc.call(null,cljs.core.dissoc.call(null,new_state,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116)),new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666),true));
return taoensso.encore.swapped.call(null,new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__22470,map__22470__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.call(null,vec__22472,(0),null);
var new_state = cljs.core.nth.call(null,vec__22472,(1),null);
if(cljs.core.not_EQ_.call(null,old_state,new_state)){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb))){
return _QMARK_cb;
} else {
var __x_22477 = _QMARK_cb;
try{if(cljs.core.truth_(taoensso.encore.chan_QMARK_.call(null,__x_22477))){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22475){if((e22475 instanceof Error)){
var __t_22478 = e22475;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/chan? ?cb)",__x_22477,__t_22478,null);
} else {
throw e22475;

}
}
taoensso.sente.assert_event.call(null,ev);

var vec__22476 = ev;
var ev_id = cljs.core.nth.call(null,vec__22476,(0),null);
var _ = cljs.core.nth.call(null,vec__22476,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__22476,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.call(null,cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,[cljs.core.str(taoensso.encore.fq_name.call(null,ev_id)),cljs.core.str(".cb")].join('')),reply], null));
});
;})(vec__22476,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",703,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null);

var buffered_evs = (function (){var __x = clj;
try{if(cljs.core.vector_QMARK_.call(null,__x)){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22484){if((e22484 instanceof Error)){
var __t = e22484;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(vector? clj)",__x,__t,null);
} else {
throw e22484;

}
}})();
var seq__22485 = cljs.core.seq.call(null,buffered_evs);
var chunk__22486 = null;
var count__22487 = (0);
var i__22488 = (0);
while(true){
if((i__22488 < count__22487)){
var ev = cljs.core._nth.call(null,chunk__22486,i__22488);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__22489 = seq__22485;
var G__22490 = chunk__22486;
var G__22491 = count__22487;
var G__22492 = (i__22488 + (1));
seq__22485 = G__22489;
chunk__22486 = G__22490;
count__22487 = G__22491;
i__22488 = G__22492;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__22485);
if(temp__4657__auto__){
var seq__22485__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22485__$1)){
var c__7018__auto__ = cljs.core.chunk_first.call(null,seq__22485__$1);
var G__22493 = cljs.core.chunk_rest.call(null,seq__22485__$1);
var G__22494 = c__7018__auto__;
var G__22495 = cljs.core.count.call(null,c__7018__auto__);
var G__22496 = (0);
seq__22485 = G__22493;
chunk__22486 = G__22494;
count__22487 = G__22495;
i__22488 = G__22496;
continue;
} else {
var ev = cljs.core.first.call(null,seq__22485__$1);
taoensso.sente.assert_event.call(null,ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__22497 = cljs.core.next.call(null,seq__22485__$1);
var G__22498 = null;
var G__22499 = (0);
var G__22500 = (0);
seq__22485 = G__22497;
chunk__22486 = G__22498;
count__22487 = G__22499;
i__22488 = G__22500;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_.call(null,clj)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,clj),new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686)));
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",713,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["handle-when-handshake (%s): %s",((handshake_QMARK_)?new cljs.core.Keyword(null,"handshake","handshake",68079331):new cljs.core.Keyword(null,"non-handshake","non-handshake",576986062)),clj], null);
});})(handshake_QMARK_))
,null)),null);

if(handshake_QMARK_){
var vec__22503 = clj;
var _ = cljs.core.nth.call(null,vec__22503,(0),null);
var vec__22504 = cljs.core.nth.call(null,vec__22503,(1),null);
var _QMARK_uid = cljs.core.nth.call(null,vec__22504,(0),null);
var _QMARK_csrf_token = cljs.core.nth.call(null,vec__22504,(1),null);
var _QMARK_handshake_data = cljs.core.nth.call(null,vec__22504,(2),null);
var handshake_ev = vec__22503;
if(clojure.string.blank_QMARK_.call(null,_QMARK_csrf_token)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",719,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22503,_,vec__22504,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SECURITY WARNING: no CSRF token available for use by Sente"], null);
});})(vec__22503,_,vec__22504,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,handshake_ev,handshake_QMARK_))
,null)),null);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),_QMARK_csrf_token], null));

taoensso.sente.assert_event.call(null,handshake_ev);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.cbs_waiting_ = cbs_waiting_;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.active_retry_id_ = active_retry_id_;
this.retry_count_ = retry_count_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6829__auto__,k__6830__auto__){
var self__ = this;
var this__6829__auto____$1 = this;
return cljs.core._lookup.call(null,this__6829__auto____$1,k__6830__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6831__auto__,k22506,else__6832__auto__){
var self__ = this;
var this__6831__auto____$1 = this;
var G__22508 = (((k22506 instanceof cljs.core.Keyword))?k22506.fqn:null);
switch (G__22508) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "retry-count_":
return self__.retry_count_;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22506,else__6832__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6843__auto__,writer__6844__auto__,opts__6845__auto__){
var self__ = this;
var this__6843__auto____$1 = this;
var pr_pair__6846__auto__ = ((function (this__6843__auto____$1){
return (function (keyval__6847__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,cljs.core.pr_writer,""," ","",opts__6845__auto__,keyval__6847__auto__);
});})(this__6843__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,pr_pair__6846__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__6845__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22505){
var self__ = this;
var G__22505__$1 = this;
return (new cljs.core.RecordIter((0),G__22505__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6823__auto__){
var self__ = this;
var this__6823__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6833__auto__){
var self__ = this;
var this__6833__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6824__auto__){
var self__ = this;
var this__6824__auto____$1 = this;
var h__6642__auto__ = self__.__hash;
if(!((h__6642__auto__ == null))){
return h__6642__auto__;
} else {
var h__6642__auto____$1 = cljs.core.hash_imap.call(null,this__6824__auto____$1);
self__.__hash = h__6642__auto____$1;

return h__6642__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6825__auto__,other__6826__auto__){
var self__ = this;
var this__6825__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6195__auto__ = other__6826__auto__;
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = (this__6825__auto____$1.constructor === other__6826__auto__.constructor);
if(and__6195__auto____$1){
return cljs.core.equiv_map.call(null,this__6825__auto____$1,other__6826__auto__);
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6838__auto__,k__6839__auto__){
var self__ = this;
var this__6838__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6839__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6838__auto____$1),self__.__meta),k__6839__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6839__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6836__auto__,k__6837__auto__,G__22505){
var self__ = this;
var this__6836__auto____$1 = this;
var pred__22509 = cljs.core.keyword_identical_QMARK_;
var expr__22510 = k__6837__auto__;
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__22510))){
return (new taoensso.sente.ChWebSocket(G__22505,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__22505,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,G__22505,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,G__22505,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__22505,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__22505,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__22505,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,G__22505,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,G__22505,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,G__22505,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__22505,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__22505,self__.active_retry_id_,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,G__22505,self__.retry_count_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22509.call(null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),expr__22510))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,G__22505,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6837__auto__,G__22505),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6841__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6828__auto__,G__22505){
var self__ = this;
var this__6828__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.cbs_waiting_,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.backoff_ms_fn,self__.active_retry_id_,self__.retry_count_,G__22505,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6834__auto__,entry__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6835__auto__)){
return cljs.core._assoc.call(null,this__6834__auto____$1,cljs.core._nth.call(null,entry__6835__auto__,(0)),cljs.core._nth.call(null,entry__6835__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6834__auto____$1,entry__6835__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__22512){
var self__ = this;
var map__22513 = p__22512;
var map__22513__$1 = ((((!((map__22513 == null)))?((((map__22513.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22513.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22513):map__22513);
var opts = map__22513__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__22513__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__22513__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__22513__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",750,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.call(null,(6)):null);
var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,_QMARK_cb_uuid);
var temp__4657__auto___22549 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___22549)){
var cb_uuid_22550 = temp__4657__auto___22549;
taoensso.encore.reset_in_BANG_.call(null,self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_22550], null),(function (){var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22515){if((e22515 instanceof Error)){
var __t = e22515;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? ?cb-fn)",__x,__t,null);
} else {
throw e22515;

}
}})());

var temp__4657__auto___22551__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__4657__auto___22551__$1)){
var timeout_ms_22552 = temp__4657__auto___22551__$1;
var c__18332__auto___22553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_22526){
var state_val_22527 = (state_22526[(1)]);
if((state_val_22527 === (1))){
var inst_22516 = cljs.core.async.timeout.call(null,timeout_ms_22552);
var state_22526__$1 = state_22526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22526__$1,(2),inst_22516);
} else {
if((state_val_22527 === (2))){
var inst_22519 = (state_22526[(7)]);
var inst_22518 = (state_22526[(2)]);
var inst_22519__$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,_QMARK_cb_uuid);
var state_22526__$1 = (function (){var statearr_22528 = state_22526;
(statearr_22528[(7)] = inst_22519__$1);

(statearr_22528[(8)] = inst_22518);

return statearr_22528;
})();
if(cljs.core.truth_(inst_22519__$1)){
var statearr_22529_22554 = state_22526__$1;
(statearr_22529_22554[(1)] = (3));

} else {
var statearr_22530_22555 = state_22526__$1;
(statearr_22530_22555[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22527 === (3))){
var inst_22519 = (state_22526[(7)]);
var inst_22521 = inst_22519.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_22526__$1 = state_22526;
var statearr_22531_22556 = state_22526__$1;
(statearr_22531_22556[(2)] = inst_22521);

(statearr_22531_22556[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22527 === (4))){
var state_22526__$1 = state_22526;
var statearr_22532_22557 = state_22526__$1;
(statearr_22532_22557[(2)] = null);

(statearr_22532_22557[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22527 === (5))){
var inst_22524 = (state_22526[(2)]);
var state_22526__$1 = state_22526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22526__$1,inst_22524);
} else {
return null;
}
}
}
}
}
});})(c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__18220__auto__,c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__18221__auto__ = null;
var taoensso$sente$state_machine__18221__auto____0 = (function (){
var statearr_22536 = [null,null,null,null,null,null,null,null,null];
(statearr_22536[(0)] = taoensso$sente$state_machine__18221__auto__);

(statearr_22536[(1)] = (1));

return statearr_22536;
});
var taoensso$sente$state_machine__18221__auto____1 = (function (state_22526){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e22537){if((e22537 instanceof Object)){
var ex__18224__auto__ = e22537;
var statearr_22538_22558 = state_22526;
(statearr_22538_22558[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22526);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22537;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22559 = state_22526;
state_22526 = G__22559;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$state_machine__18221__auto__ = function(state_22526){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__18221__auto____1.call(this,state_22526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__18221__auto____0;
taoensso$sente$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__18221__auto____1;
return taoensso$sente$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__18334__auto__ = (function (){var statearr_22539 = f__18333__auto__.call(null);
(statearr_22539[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___22553);

return statearr_22539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___22553,timeout_ms_22552,temp__4657__auto___22551__$1,cb_uuid_22550,temp__4657__auto___22549,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{cljs.core.deref.call(null,self__.socket_).send(ppstr);

cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e22540){if((e22540 instanceof Error)){
var e = e22540;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",769,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__22513,map__22513__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

var temp__4657__auto___22560 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4657__auto___22560)){
var cb_uuid_22561 = temp__4657__auto___22560;
var cb_fn_STAR__22562 = (function (){var or__6207__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid_22561);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var __x = _QMARK_cb_fn;
try{if(cljs.core.truth_(taoensso.truss.impl.nnil_QMARK_.call(null,__x))){
return __x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22541){if((e22541 instanceof Error)){
var __t = e22541;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(taoensso.truss.impl/nnil? ?cb-fn)",__x,__t,null);
} else {
throw e22541;

}
}}
})();
cb_fn_STAR__22562.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
}

return false;
} else {
throw e22540;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto__)){
var s = temp__4657__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___22563 = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__4657__auto___22563)){
var s_22564 = temp__4657__auto___22563;
s_22564.close((3000),"SENTE_RECONNECT");
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__4657__auto__ = (function (){var or__6207__auto__ = taoensso.encore.oget.call(null,window,"WebSocket");
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.encore.oget.call(null,window,"MozWebSocket");
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var WebSocket = temp__4657__auto__;
var retry_id = taoensso.encore.uuid_str.call(null);
var connect_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function taoensso$sente$connect_fn(){
var retry_fn = ((function (retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = cljs.core.swap_BANG_.call(null,self__.retry_count_,cljs.core.inc);
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
window.clearInterval(cljs.core.deref.call(null,self__.kalive_timer_));

taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",800,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return window.setTimeout(taoensso$sente$connect_fn,backoff_ms);
} else {
return null;
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
var _QMARK_socket = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string.call(null,self__.url,cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null)))));
}catch (e22545){if((e22545 instanceof Error)){
var e = e22545;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",811,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket js/Error"], null);
});})(e,retry_fn,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);

return null;
} else {
throw e22545;

}
}})();
if(cljs.core.not.call(null,_QMARK_socket)){
return retry_fn.call(null);
} else {
return cljs.core.reset_BANG_.call(null,self__.socket_,(function (){var G__22546 = _QMARK_socket;
(G__22546["onerror"] = ((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",820,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",ws_ev], null);
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22546["onmessage"] = ((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.call(null,ws_ev,"data");
var vec__22547 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__22547,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__22547,(1),null);
var or__6207__auto__ = (function (){var and__6195__auto__ = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__6195__auto__)){
return cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var temp__4655__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__4655__auto__)){
var cb_uuid = temp__4655__auto__;
var temp__4655__auto____$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__4655__auto____$1)){
var cb_fn = temp__4655__auto____$1;
return cb_fn.call(null,clj);
} else {
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",838,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6207__auto__,ppstr,vec__22547,clj,_QMARK_cb_uuid,G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__4655__auto____$1,cb_uuid,temp__4655__auto__,or__6207__auto__,ppstr,vec__22547,clj,_QMARK_cb_uuid,G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,null)),null);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22546["onopen"] = ((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
return cljs.core.reset_BANG_.call(null,self__.kalive_timer_,window.setInterval(((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,self__.kalive_due_QMARK__))){
taoensso.sente.chsk_send_BANG_.call(null,chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)], null));
} else {
}

return cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true);
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
,self__.kalive_ms));
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

(G__22546["onclose"] = ((function (G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);
});})(G__22546,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__4657__auto__,chsk__$1))
);

return G__22546;
})());
}
});})(retry_id,WebSocket,temp__4657__auto__,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));

connect_fn.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null),new cljs.core.Symbol(null,"kalive-ms","kalive-ms",1851265548,null),new cljs.core.Symbol(null,"kalive-timer_","kalive-timer_",-1096022620,null),new cljs.core.Symbol(null,"kalive-due?_","kalive-due?_",1679969599,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"retry-count_","retry-count_",1660769620,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__6863__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__6863__auto__,writer__6864__auto__){
return cljs.core._write.call(null,writer__6864__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_){
return (new taoensso.sente.ChWebSocket(client_id,chs,params,packer,url,state_,cbs_waiting_,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,backoff_ms_fn,active_retry_id_,retry_count_,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__22507){
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__22507),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093).cljs$core$IFn$_invoke$arity$1(G__22507),null,cljs.core.dissoc.call(null,G__22507,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.active_retry_id_ = active_retry_id_;
this.backoff_ms_fn = backoff_ms_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6829__auto__,k__6830__auto__){
var self__ = this;
var this__6829__auto____$1 = this;
return cljs.core._lookup.call(null,this__6829__auto____$1,k__6830__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6831__auto__,k22566,else__6832__auto__){
var self__ = this;
var this__6831__auto____$1 = this;
var G__22568 = (((k22566 instanceof cljs.core.Keyword))?k22566.fqn:null);
switch (G__22568) {
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22566,else__6832__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6843__auto__,writer__6844__auto__,opts__6845__auto__){
var self__ = this;
var this__6843__auto____$1 = this;
var pr_pair__6846__auto__ = ((function (this__6843__auto____$1){
return (function (keyval__6847__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,cljs.core.pr_writer,""," ","",opts__6845__auto__,keyval__6847__auto__);
});})(this__6843__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__6844__auto__,pr_pair__6846__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__6845__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = true;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22565){
var self__ = this;
var G__22565__$1 = this;
return (new cljs.core.RecordIter((0),G__22565__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)], null),cljs.core._iterator.call(null,self__.__extmap)));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6827__auto__){
var self__ = this;
var this__6827__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6823__auto__){
var self__ = this;
var this__6823__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6833__auto__){
var self__ = this;
var this__6833__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6824__auto__){
var self__ = this;
var this__6824__auto____$1 = this;
var h__6642__auto__ = self__.__hash;
if(!((h__6642__auto__ == null))){
return h__6642__auto__;
} else {
var h__6642__auto____$1 = cljs.core.hash_imap.call(null,this__6824__auto____$1);
self__.__hash = h__6642__auto____$1;

return h__6642__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6825__auto__,other__6826__auto__){
var self__ = this;
var this__6825__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6195__auto__ = other__6826__auto__;
if(cljs.core.truth_(and__6195__auto__)){
var and__6195__auto____$1 = (this__6825__auto____$1.constructor === other__6826__auto__.constructor);
if(and__6195__auto____$1){
return cljs.core.equiv_map.call(null,this__6825__auto____$1,other__6826__auto__);
} else {
return and__6195__auto____$1;
}
} else {
return and__6195__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6838__auto__,k__6839__auto__){
var self__ = this;
var this__6838__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__6839__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__6838__auto____$1),self__.__meta),k__6839__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__6839__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6836__auto__,k__6837__auto__,G__22565){
var self__ = this;
var this__6836__auto____$1 = this;
var pred__22569 = cljs.core.keyword_identical_QMARK_;
var expr__22570 = k__6837__auto__;
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(G__22565,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__22565,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,G__22565,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,G__22565,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__22565,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__22565,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__22565,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,G__22565,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,G__22565,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__22565,self__.backoff_ms_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22569.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__22570))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,G__22565,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__6837__auto__,G__22565),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6841__auto__){
var self__ = this;
var this__6841__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6828__auto__,G__22565){
var self__ = this;
var this__6828__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.active_retry_id_,self__.backoff_ms_fn,G__22565,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6834__auto__,entry__6835__auto__){
var self__ = this;
var this__6834__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__6835__auto__)){
return cljs.core._assoc.call(null,this__6834__auto____$1,cljs.core._nth.call(null,entry__6835__auto__,(0)),cljs.core._nth.call(null,entry__6835__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__6834__auto____$1,entry__6835__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = true;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,p__22572){
var self__ = this;
var map__22573 = p__22572;
var map__22573__$1 = ((((!((map__22573 == null)))?((((map__22573.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22573.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22573):map__22573);
var opts = map__22573__$1;
var _QMARK_timeout_ms = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__22573__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var chsk__$1 = this;
taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",879,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
});})(_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
return null;
}
} else {
var csrf_token = new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_));
taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),csrf_token], null)),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token,new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null));
})()], null)),((function (csrf_token,_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__22575){
var map__22579 = p__22575;
var map__22579__$1 = ((((!((map__22579 == null)))?((((map__22579.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22579.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22579):map__22579);
var _QMARK_error = cljs.core.get.call(null,map__22579__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__22579__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__22581 = taoensso.sente.unpack.call(null,self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.call(null,vec__22581,(0),null);
var _ = cljs.core.nth.call(null,vec__22581,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,resp_clj);
} else {
if(cljs.core.not_EQ_.call(null,resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",919,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (content,resp_ppstr,vec__22581,resp_clj,_,map__22579,map__22579__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__22581,resp_clj,_,map__22579,map__22579__$1,_QMARK_error,_QMARK_content,csrf_token,_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),null);
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}
});})(csrf_token,_QMARK_cb_fn,chsk__$1,map__22573,map__22573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
return taoensso.sente.chsk_disconnect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_disconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"disconnected");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

var temp__4657__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto__)){
var x = temp__4657__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"reconnecting");

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));

var temp__4657__auto___22597 = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__4657__auto___22597)){
var x_22598 = temp__4657__auto___22597;
x_22598.abort();
} else {
}

return taoensso.sente._chsk_connect_BANG_.call(null,chsk__$1);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var retry_id = taoensso.encore.uuid_str.call(null);
var poll_fn = ((function (retry_id,chsk__$1){
return (function taoensso$sente$poll_fn(retry_count){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",940,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(retry_id,chsk__$1))
,null)),null);

var retry_fn = ((function (retry_id,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = (retry_count + (1));
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",946,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,null)),null);

return window.setTimeout(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return taoensso$sente$poll_fn.call(null,retry_count_STAR_);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,backoff_ms);
} else {
return null;
}
});})(retry_id,chsk__$1))
;
return cljs.core.reset_BANG_.call(null,self__.curr_xhr_,taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),self__.timeout_ms,new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"_","_",1453416199),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null)))], null)),((function (retry_fn,retry_id,chsk__$1){
return (function taoensso$sente$poll_fn_$_ajax_cb(p__22589){
var map__22593 = p__22589;
var map__22593__$1 = ((((!((map__22593 == null)))?((((map__22593.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22593.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22593):map__22593);
var _QMARK_error = cljs.core.get.call(null,map__22593__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__22593__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$poll_fn.call(null,(0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__22595 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__22595,(0),null);
var _ = cljs.core.nth.call(null,vec__22595,(1),null);
var or__6207__auto___22599 = taoensso.sente.handle_when_handshake_BANG_.call(null,chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__6207__auto___22599)){
} else {
var buffered_evs_22600 = clj;
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs_22600);

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}

return taoensso$sente$poll_fn.call(null,(0));
}
});})(retry_fn,retry_id,chsk__$1))
));
});})(retry_id,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

poll_fn.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"timeout-ms","timeout-ms",-1900214363,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__6863__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__6863__auto__,writer__6864__auto__){
return cljs.core._write.call(null,writer__6864__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn){
return (new taoensso.sente.ChAjaxSocket(client_id,chs,params,packer,url,state_,timeout_ms,ajax_opts,curr_xhr_,active_retry_id_,backoff_ms_fn,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__22567){
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__22567),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__22567),null,cljs.core.dissoc.call(null,G__22567,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955)),null));
});

taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,chsk_host,chsk_path,type){
var protocol__$1 = (function (){var G__22602 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__22602) {
case "ajax":
return protocol;

break;
case "ws":
if(cljs.core._EQ_.call(null,protocol,"https:")){
return "wss:";
} else {
return "ws:";
}

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}
})();
return [cljs.core.str(protocol__$1),cljs.core.str("//"),cljs.core.str(taoensso.encore.path.call(null,chsk_host,chsk_path))].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :host           ; Server host (defaults to current page's host)
 *  :params         ; Map of any params to incl. in chsk Ring requests (handy for
 *                  ; application-level auth, etc.)
 *  :ws-kalive-ms   ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                  ; number of milliseconds
 *  :lp-timeout-ms  ; Ping to keep a long-polling (Ajax) conn alive '' [1]
 *  :packer         ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`
 *  :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 * 
 *   [1] If you're using Immutant and override the default :lp-timeout-ms, you'll
 *    need to provide the same timeout value to
 *    `taoensso.sente.server-adapters.immutant/make-immutant-adapter` and use
 *    the result of that function as the web server adapter to your server-side
 *    `make-channel-socket-server!`.
 */
taoensso.sente.make_channel_socket_client_BANG_ = (function taoensso$sente$make_channel_socket_client_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___22618 = arguments.length;
var i__7277__auto___22619 = (0);
while(true){
if((i__7277__auto___22619 < len__7276__auto___22618)){
args__7283__auto__.push((arguments[i__7277__auto___22619]));

var G__22620 = (i__7277__auto___22619 + (1));
i__7277__auto___22619 = G__22620;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__22607){
var vec__22608 = p__22607;
var map__22609 = cljs.core.nth.call(null,vec__22608,(0),null);
var map__22609__$1 = ((((!((map__22609 == null)))?((((map__22609.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22609.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22609):map__22609);
var opts = map__22609__$1;
var ajax_opts = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var ws_kalive_ms = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),(25000));
var lp_timeout_ms = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),(25000));
var client_id = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__6207__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return taoensso.encore.uuid_str.call(null);
}
})());
var packer = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var host = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(2048)));
var backoff_ms_fn = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.call(null,map__22609__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.call(null,vec__22608,(1),null);
if(cljs.core.truth_((function (){var __x = type;
try{if(((function (__x,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (__x__$1){
return cljs.core.contains_QMARK_.call(null,taoensso.truss.impl.set_STAR_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)),__x__$1);
});})(__x,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,__x)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22611){if((e22611 instanceof Error)){
var __t = e22611;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"([:in #{:ws :ajax :auto}] type)",__x,__t,null);
} else {
throw e22611;

}
}})())){
} else {
throw (new Error("Assert failed: (have? [:in #{:ws :ajax :auto}] type)"));
}

if(cljs.core.truth_((function (){var __x = client_id;
try{if(cljs.core.truth_(taoensso.encore.nblank_str_QMARK_.call(null,__x))){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22612){if((e22612 instanceof Error)){
var __t = e22612;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"(enc/nblank-str? client-id)",__x,__t,null);
} else {
throw e22612;

}
}})())){
} else {
throw (new Error("Assert failed: (have? enc/nblank-str? client-id)"));
}

if(!((_deprecated_more_opts == null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",1055,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket-client!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",1057,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null);
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer.call(null,packer);
var win_location = taoensso.encore.get_window_location.call(null);
var win_protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_location);
var host__$1 = (function (){var or__6207__auto__ = host;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var path__$1 = (function (){var or__6207__auto__ = path;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_location);
}
})();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),cljs.core.async.chan.call(null,recv_buf_or_n)], null);
var ever_opened_QMARK__ = cljs.core.atom.call(null,false);
var state_STAR_ = ((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__6207__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(state));
if(or__6207__auto__){
return or__6207__auto__;
} else {
return cljs.core.deref.call(null,ever_opened_QMARK__);
}
})())){
return state;
} else {
cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true);

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),true);
}
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),state_STAR_.call(null,state)], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs)),(function (){var _LT_server_ch = new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs);
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
} else {
return cljs.core.async.map_LT_.call(null,((function (_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__22613 = ev;
var id = cljs.core.nth.call(null,vec__22613,(0),null);
var _QMARK_data = cljs.core.nth.call(null,vec__22613,(1),null);
var __x_22621 = (function (){try{return cljs.core.namespace.call(null,id);
}catch (e22614){if((e22614 instanceof Error)){
var __t = e22614;
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22604#] (not= p1__22604# \"chsk\")) (namespace id))",taoensso.truss.impl._invar_undefined_val,__t,null);
} else {
throw e22614;

}
}})();
try{if(((function (__x_22621,vec__22613,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (p1__22604_SHARP_){
return cljs.core.not_EQ_.call(null,p1__22604_SHARP_,"chsk");
});})(__x_22621,vec__22613,id,_QMARK_data,_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,__x_22621)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null);
}
}catch (e22615){if((e22615 instanceof Error)){
var __t_22622 = e22615;
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",null,"((fn* [p1__22604#] (not= p1__22604# \"chsk\")) (namespace id))",__x_22621,__t_22622,null);
} else {
throw e22615;

}
}
return ev;
});})(_LT_server_ch,packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,_LT_server_ch);
}
})()], null));
var chsk = (function (){var or__6207__auto__ = (function (){var and__6195__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ajax","ajax",814345549));
if(and__6195__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChWebSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"kalive-ms","kalive-ms",210734021),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"kalive-due?_","kalive-due?_",39438072),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"kalive-timer_","kalive-timer_",1558413149),new cljs.core.Keyword(null,"state_","state_",957667102)],[client_id,ws_kalive_ms,packer__$1,private_chs,params,cljs.core.atom.call(null,(0)),backoff_ms_fn,cljs.core.atom.call(null,null),(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ws","ws",86841443));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
}
})(),cljs.core.atom.call(null,"pending"),cljs.core.atom.call(null,true),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.atom.call(null,null),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var and__6195__auto__ = cljs.core.not_EQ_.call(null,type,new cljs.core.Keyword(null,"ws","ws",86841443));
if(and__6195__auto__){
return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.map__GT_ChAjaxSocket.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),new cljs.core.Keyword(null,"state_","state_",957667102)],[cljs.core.atom.call(null,null),client_id,packer__$1,private_chs,params,backoff_ms_fn,(function (){var temp__4655__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return f.call(null,path__$1,win_location,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
return taoensso.sente.get_chsk_url.call(null,win_protocol,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
}
})(),cljs.core.atom.call(null,"pending"),ajax_opts,lp_timeout_ms,cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null))])));
} else {
return and__6195__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Failed to create channel socket"),cljs.core.str("\n"),cljs.core.str("chsk")].join('')))})());
var send_fn = cljs.core.partial.call(null,taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_.call(null,((function (packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__22617 = taoensso.sente.as_event.call(null,ev);
var ev_id = cljs.core.nth.call(null,vec__22617,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__22617,(1),null);
var ev__$1 = vec__22617;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk),new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(packer__$1,win_location,win_protocol,host__$1,path__$1,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__22608,map__22609,map__22609__$1,opts,ajax_opts,ws_kalive_ms,lp_timeout_ms,client_id,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),public_ch_recv__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$applyTo = (function (seq22605){
var G__22606 = cljs.core.first.call(null,seq22605);
var seq22605__$1 = cljs.core.next.call(null,seq22605);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22606,seq22605__$1);
});
taoensso.sente._start_chsk_router_BANG_ = (function taoensso$sente$_start_chsk_router_BANG_(server_QMARK_,ch_recv,event_msg_handler,opts){
var map__22829 = opts;
var map__22829__$1 = ((((!((map__22829 == null)))?((((map__22829.cljs$lang$protocol_mask$partition0$ & (64))) || (map__22829.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22829):map__22829);
var trace_evs_QMARK_ = cljs.core.get.call(null,map__22829__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__22829__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var ch_ctrl = cljs.core.async.chan.call(null);
var c__18332__auto___23035 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (state_22960){
var state_val_22961 = (state_22960[(1)]);
if((state_val_22961 === (7))){
var inst_22956 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_22962_23036 = state_22960__$1;
(statearr_22962_23036[(2)] = inst_22956);

(statearr_22962_23036[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (20))){
var inst_22838 = (state_22960[(7)]);
var inst_22865 = (state_22960[(8)]);
var inst_22837 = (state_22960[(9)]);
var inst_22840 = (state_22960[(10)]);
var inst_22864 = (state_22960[(11)]);
var inst_22839 = (state_22960[(12)]);
var inst_22875 = (function (){var vec__22832 = inst_22837;
var v = inst_22838;
var p = inst_22839;
var stop_QMARK_ = inst_22840;
var map__22843 = inst_22864;
var event_msg = inst_22864;
var event = inst_22865;
return ((function (vec__22832,v,p,stop_QMARK_,map__22843,event_msg,event,inst_22838,inst_22865,inst_22837,inst_22840,inst_22864,inst_22839,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});
;})(vec__22832,v,p,stop_QMARK_,map__22843,event_msg,event,inst_22838,inst_22865,inst_22837,inst_22840,inst_22864,inst_22839,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22876 = (new cljs.core.Delay(inst_22875,null));
var inst_22877 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",1176,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22876,null);
var state_22960__$1 = state_22960;
var statearr_22963_23037 = state_22960__$1;
(statearr_22963_23037[(2)] = inst_22877);

(statearr_22963_23037[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (27))){
var inst_22864 = (state_22960[(11)]);
var inst_22882 = (state_22960[(2)]);
var inst_22883 = "(server-event-msg? event-msg)";
var inst_22884 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",null,inst_22883,inst_22864,inst_22882,null);
var state_22960__$1 = state_22960;
var statearr_22964_23038 = state_22960__$1;
(statearr_22964_23038[(2)] = inst_22884);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (1))){
var state_22960__$1 = state_22960;
var statearr_22965_23039 = state_22960__$1;
(statearr_22965_23039[(2)] = null);

(statearr_22965_23039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (24))){
var state_22960__$1 = state_22960;
var statearr_22966_23040 = state_22960__$1;
(statearr_22966_23040[(2)] = null);

(statearr_22966_23040[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (39))){
var state_22960__$1 = state_22960;
var statearr_22967_23041 = state_22960__$1;
(statearr_22967_23041[(2)] = null);

(statearr_22967_23041[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (46))){
var inst_22929 = (state_22960[(13)]);
var inst_22937 = (state_22960[(2)]);
var inst_22938 = [inst_22937,null];
var inst_22939 = (new cljs.core.PersistentVector(null,2,(5),inst_22929,inst_22938,null));
var state_22960__$1 = state_22960;
var statearr_22968_23042 = state_22960__$1;
(statearr_22968_23042[(2)] = inst_22939);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (4))){
var inst_22837 = (state_22960[(9)]);
var inst_22840 = (state_22960[(10)]);
var inst_22839 = (state_22960[(12)]);
var inst_22837__$1 = (state_22960[(2)]);
var inst_22838 = cljs.core.nth.call(null,inst_22837__$1,(0),null);
var inst_22839__$1 = cljs.core.nth.call(null,inst_22837__$1,(1),null);
var inst_22840__$1 = taoensso.encore.kw_identical_QMARK_.call(null,inst_22839__$1,ch_ctrl);
var state_22960__$1 = (function (){var statearr_22969 = state_22960;
(statearr_22969[(7)] = inst_22838);

(statearr_22969[(9)] = inst_22837__$1);

(statearr_22969[(10)] = inst_22840__$1);

(statearr_22969[(12)] = inst_22839__$1);

return statearr_22969;
})();
if(cljs.core.truth_(inst_22840__$1)){
var statearr_22970_23043 = state_22960__$1;
(statearr_22970_23043[(1)] = (5));

} else {
var statearr_22971_23044 = state_22960__$1;
(statearr_22971_23044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (15))){
var inst_22838 = (state_22960[(7)]);
var state_22960__$1 = state_22960;
var statearr_22972_23045 = state_22960__$1;
(statearr_22972_23045[(2)] = inst_22838);

(statearr_22972_23045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (48))){
var state_22960__$1 = state_22960;
var statearr_22973_23046 = state_22960__$1;
(statearr_22973_23046[(2)] = null);

(statearr_22973_23046[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (21))){
var state_22960__$1 = state_22960;
var statearr_22974_23047 = state_22960__$1;
(statearr_22974_23047[(2)] = null);

(statearr_22974_23047[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (31))){
var inst_22893 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_22975_23048 = state_22960__$1;
(statearr_22975_23048[(2)] = inst_22893);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (32))){
var inst_22910 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_22976_23049 = state_22960__$1;
(statearr_22976_23049[(2)] = inst_22910);

(statearr_22976_23049[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (40))){
var inst_22953 = (state_22960[(2)]);
var state_22960__$1 = (function (){var statearr_22977 = state_22960;
(statearr_22977[(14)] = inst_22953);

return statearr_22977;
})();
var statearr_22978_23050 = state_22960__$1;
(statearr_22978_23050[(2)] = null);

(statearr_22978_23050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (33))){
var inst_22864 = (state_22960[(11)]);
var inst_22897 = (state_22960[(2)]);
var inst_22898 = "(client-event-msg? event-msg)";
var inst_22899 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",null,inst_22898,inst_22864,inst_22897,null);
var state_22960__$1 = state_22960;
var statearr_22979_23051 = state_22960__$1;
(statearr_22979_23051[(2)] = inst_22899);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (13))){
var inst_22856 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_22980_23052 = state_22960__$1;
(statearr_22980_23052[(2)] = inst_22856);

(statearr_22980_23052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (22))){
var inst_22880 = (state_22960[(2)]);
var state_22960__$1 = (function (){var statearr_22981 = state_22960;
(statearr_22981[(15)] = inst_22880);

return statearr_22981;
})();
if(cljs.core.truth_(server_QMARK_)){
var statearr_22982_23053 = state_22960__$1;
(statearr_22982_23053[(1)] = (23));

} else {
var statearr_22983_23054 = state_22960__$1;
(statearr_22983_23054[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (36))){
var inst_22906 = taoensso.truss.impl._invar_violation_BANG_.call(null);
var state_22960__$1 = state_22960;
var statearr_22984_23055 = state_22960__$1;
(statearr_22984_23055[(2)] = inst_22906);

(statearr_22984_23055[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (41))){
var inst_22941 = (state_22960[(16)]);
var inst_22943 = (state_22960[(17)]);
var inst_22941__$1 = (state_22960[(2)]);
var inst_22942 = cljs.core.nth.call(null,inst_22941__$1,(0),null);
var inst_22943__$1 = cljs.core.nth.call(null,inst_22941__$1,(1),null);
var state_22960__$1 = (function (){var statearr_22985 = state_22960;
(statearr_22985[(18)] = inst_22942);

(statearr_22985[(16)] = inst_22941__$1);

(statearr_22985[(17)] = inst_22943__$1);

return statearr_22985;
})();
if(cljs.core.truth_(inst_22943__$1)){
var statearr_22986_23056 = state_22960__$1;
(statearr_22986_23056[(1)] = (47));

} else {
var statearr_22987_23057 = state_22960__$1;
(statearr_22987_23057[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (43))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22960,(42),Error,null,(41));
var inst_22929 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22960__$1 = (function (){var statearr_22988 = state_22960;
(statearr_22988[(13)] = inst_22929);

return statearr_22988;
})();
if(cljs.core.truth_(error_handler)){
var statearr_22989_23058 = state_22960__$1;
(statearr_22989_23058[(1)] = (44));

} else {
var statearr_22990_23059 = state_22960__$1;
(statearr_22990_23059[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (29))){
var inst_22864 = (state_22960[(11)]);
var state_22960__$1 = state_22960;
var statearr_22991_23060 = state_22960__$1;
(statearr_22991_23060[(2)] = inst_22864);

(statearr_22991_23060[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (44))){
var inst_22919 = (state_22960[(19)]);
var inst_22864 = (state_22960[(11)]);
var inst_22931 = error_handler.call(null,inst_22919,inst_22864);
var state_22960__$1 = state_22960;
var statearr_22992_23061 = state_22960__$1;
(statearr_22992_23061[(2)] = inst_22931);

(statearr_22992_23061[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (6))){
var inst_22838 = (state_22960[(7)]);
var inst_22846 = (inst_22838 == null);
var inst_22847 = cljs.core.not.call(null,inst_22846);
var state_22960__$1 = state_22960;
if(inst_22847){
var statearr_22993_23062 = state_22960__$1;
(statearr_22993_23062[(1)] = (8));

} else {
var statearr_22994_23063 = state_22960__$1;
(statearr_22994_23063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (28))){
var inst_22864 = (state_22960[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22960,(27),Error,null,(26));
var inst_22888 = taoensso.sente.server_event_msg_QMARK_.call(null,inst_22864);
var state_22960__$1 = state_22960;
if(cljs.core.truth_(inst_22888)){
var statearr_22995_23064 = state_22960__$1;
(statearr_22995_23064[(1)] = (29));

} else {
var statearr_22996_23065 = state_22960__$1;
(statearr_22996_23065[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (25))){
var inst_22873 = (state_22960[(20)]);
var inst_22912 = (state_22960[(2)]);
var inst_22913 = event_msg_handler.call(null,inst_22912);
var inst_22914 = [inst_22913,null];
var inst_22915 = (new cljs.core.PersistentVector(null,2,(5),inst_22873,inst_22914,null));
var state_22960__$1 = state_22960;
var statearr_22997_23066 = state_22960__$1;
(statearr_22997_23066[(2)] = inst_22915);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (34))){
var inst_22864 = (state_22960[(11)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22960,(33),Error,null,(32));
var inst_22903 = taoensso.sente.client_event_msg_QMARK_.call(null,inst_22864);
var state_22960__$1 = state_22960;
if(cljs.core.truth_(inst_22903)){
var statearr_22998_23067 = state_22960__$1;
(statearr_22998_23067[(1)] = (35));

} else {
var statearr_22999_23068 = state_22960__$1;
(statearr_22999_23068[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (17))){
var inst_22917 = (state_22960[(21)]);
var inst_22919 = (state_22960[(19)]);
var inst_22917__$1 = (state_22960[(2)]);
var inst_22918 = cljs.core.nth.call(null,inst_22917__$1,(0),null);
var inst_22919__$1 = cljs.core.nth.call(null,inst_22917__$1,(1),null);
var state_22960__$1 = (function (){var statearr_23000 = state_22960;
(statearr_23000[(21)] = inst_22917__$1);

(statearr_23000[(19)] = inst_22919__$1);

(statearr_23000[(22)] = inst_22918);

return statearr_23000;
})();
if(cljs.core.truth_(inst_22919__$1)){
var statearr_23001_23069 = state_22960__$1;
(statearr_23001_23069[(1)] = (38));

} else {
var statearr_23002_23070 = state_22960__$1;
(statearr_23002_23070[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (3))){
var inst_22958 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22960__$1,inst_22958);
} else {
if((state_val_22961 === (12))){
var state_22960__$1 = state_22960;
var statearr_23003_23071 = state_22960__$1;
(statearr_23003_23071[(2)] = false);

(statearr_23003_23071[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (2))){
var inst_22833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22834 = [ch_recv,ch_ctrl];
var inst_22835 = (new cljs.core.PersistentVector(null,2,(5),inst_22833,inst_22834,null));
var state_22960__$1 = state_22960;
return cljs.core.async.ioc_alts_BANG_.call(null,state_22960__$1,(4),inst_22835);
} else {
if((state_val_22961 === (23))){
var state_22960__$1 = state_22960;
var statearr_23004_23072 = state_22960__$1;
(statearr_23004_23072[(2)] = null);

(statearr_23004_23072[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (47))){
var inst_22838 = (state_22960[(7)]);
var inst_22917 = (state_22960[(21)]);
var inst_22865 = (state_22960[(8)]);
var inst_22919 = (state_22960[(19)]);
var inst_22942 = (state_22960[(18)]);
var inst_22837 = (state_22960[(9)]);
var inst_22840 = (state_22960[(10)]);
var inst_22864 = (state_22960[(11)]);
var inst_22839 = (state_22960[(12)]);
var inst_22941 = (state_22960[(16)]);
var inst_22943 = (state_22960[(17)]);
var inst_22945 = (function (){var vec__22844 = inst_22917;
var p = inst_22839;
var _QMARK_error = inst_22919;
var v = inst_22838;
var _ = inst_22942;
var e2 = inst_22943;
var vec__22921 = inst_22941;
var _QMARK_error2 = inst_22943;
var event_msg = inst_22864;
var map__22843 = inst_22864;
var e = inst_22919;
var vec__22832 = inst_22837;
var temp__4657__auto__ = inst_22943;
var event = inst_22865;
var stop_QMARK_ = inst_22840;
return ((function (vec__22844,p,_QMARK_error,v,_,e2,vec__22921,_QMARK_error2,event_msg,map__22843,e,vec__22832,temp__4657__auto__,event,stop_QMARK_,inst_22838,inst_22917,inst_22865,inst_22919,inst_22942,inst_22837,inst_22840,inst_22864,inst_22839,inst_22941,inst_22943,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});
;})(vec__22844,p,_QMARK_error,v,_,e2,vec__22921,_QMARK_error2,event_msg,map__22843,e,vec__22832,temp__4657__auto__,event,stop_QMARK_,inst_22838,inst_22917,inst_22865,inst_22919,inst_22942,inst_22837,inst_22840,inst_22864,inst_22839,inst_22941,inst_22943,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22946 = (new cljs.core.Delay(inst_22945,null));
var inst_22947 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",1189,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22946,null);
var state_22960__$1 = state_22960;
var statearr_23005_23073 = state_22960__$1;
(statearr_23005_23073[(2)] = inst_22947);

(statearr_23005_23073[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (35))){
var inst_22864 = (state_22960[(11)]);
var state_22960__$1 = state_22960;
var statearr_23006_23074 = state_22960__$1;
(statearr_23006_23074[(2)] = inst_22864);

(statearr_23006_23074[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (19))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_22960,(18),Error,null,(17));
var inst_22873 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22960__$1 = (function (){var statearr_23007 = state_22960;
(statearr_23007[(20)] = inst_22873);

return statearr_23007;
})();
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_23008_23075 = state_22960__$1;
(statearr_23008_23075[(1)] = (20));

} else {
var statearr_23009_23076 = state_22960__$1;
(statearr_23009_23076[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (11))){
var state_22960__$1 = state_22960;
var statearr_23010_23077 = state_22960__$1;
(statearr_23010_23077[(2)] = true);

(statearr_23010_23077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (9))){
var state_22960__$1 = state_22960;
var statearr_23011_23078 = state_22960__$1;
(statearr_23011_23078[(2)] = false);

(statearr_23011_23078[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (5))){
var state_22960__$1 = state_22960;
var statearr_23012_23079 = state_22960__$1;
(statearr_23012_23079[(2)] = null);

(statearr_23012_23079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (14))){
var inst_22838 = (state_22960[(7)]);
var inst_22861 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22838);
var state_22960__$1 = state_22960;
var statearr_23013_23080 = state_22960__$1;
(statearr_23013_23080[(2)] = inst_22861);

(statearr_23013_23080[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (45))){
var inst_22838 = (state_22960[(7)]);
var inst_22917 = (state_22960[(21)]);
var inst_22865 = (state_22960[(8)]);
var inst_22919 = (state_22960[(19)]);
var inst_22837 = (state_22960[(9)]);
var inst_22840 = (state_22960[(10)]);
var inst_22918 = (state_22960[(22)]);
var inst_22864 = (state_22960[(11)]);
var inst_22839 = (state_22960[(12)]);
var inst_22933 = (function (){var vec__22844 = inst_22917;
var p = inst_22839;
var _QMARK_error = inst_22919;
var v = inst_22838;
var temp__4655__auto__ = error_handler;
var _ = inst_22918;
var event_msg = inst_22864;
var map__22843 = inst_22864;
var e = inst_22919;
var vec__22832 = inst_22837;
var temp__4657__auto__ = inst_22919;
var event = inst_22865;
var stop_QMARK_ = inst_22840;
return ((function (vec__22844,p,_QMARK_error,v,temp__4655__auto__,_,event_msg,map__22843,e,vec__22832,temp__4657__auto__,event,stop_QMARK_,inst_22838,inst_22917,inst_22865,inst_22919,inst_22837,inst_22840,inst_22918,inst_22864,inst_22839,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk router `event-msg-handler` error: %s",event], null);
});
;})(vec__22844,p,_QMARK_error,v,temp__4655__auto__,_,event_msg,map__22843,e,vec__22832,temp__4657__auto__,event,stop_QMARK_,inst_22838,inst_22917,inst_22865,inst_22919,inst_22837,inst_22840,inst_22918,inst_22864,inst_22839,state_val_22961,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_22934 = (new cljs.core.Delay(inst_22933,null));
var inst_22935 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/kc/yqpfnjnd51b29r40p3g13cqr0000gn/T/form-init6975461653102107462.clj",1187,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_22934,null);
var state_22960__$1 = state_22960;
var statearr_23014_23081 = state_22960__$1;
(statearr_23014_23081[(2)] = inst_22935);

(statearr_23014_23081[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (26))){
var inst_22895 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_23015_23082 = state_22960__$1;
(statearr_23015_23082[(2)] = inst_22895);

(statearr_23015_23082[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (16))){
var inst_22864 = (state_22960[(11)]);
var inst_22864__$1 = (state_22960[(2)]);
var inst_22865 = cljs.core.get.call(null,inst_22864__$1,new cljs.core.Keyword(null,"event","event",301435442));
var state_22960__$1 = (function (){var statearr_23016 = state_22960;
(statearr_23016[(8)] = inst_22865);

(statearr_23016[(11)] = inst_22864__$1);

return statearr_23016;
})();
var statearr_23017_23083 = state_22960__$1;
(statearr_23017_23083[(2)] = null);

(statearr_23017_23083[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (38))){
var state_22960__$1 = state_22960;
var statearr_23018_23084 = state_22960__$1;
(statearr_23018_23084[(2)] = null);

(statearr_23018_23084[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (30))){
var inst_22891 = taoensso.truss.impl._invar_violation_BANG_.call(null);
var state_22960__$1 = state_22960;
var statearr_23019_23085 = state_22960__$1;
(statearr_23019_23085[(2)] = inst_22891);

(statearr_23019_23085[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (10))){
var inst_22859 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
if(cljs.core.truth_(inst_22859)){
var statearr_23020_23086 = state_22960__$1;
(statearr_23020_23086[(1)] = (14));

} else {
var statearr_23021_23087 = state_22960__$1;
(statearr_23021_23087[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (18))){
var inst_22866 = (state_22960[(2)]);
var inst_22867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22868 = [null,inst_22866];
var inst_22869 = (new cljs.core.PersistentVector(null,2,(5),inst_22867,inst_22868,null));
var state_22960__$1 = state_22960;
var statearr_23022_23088 = state_22960__$1;
(statearr_23022_23088[(2)] = inst_22869);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (42))){
var inst_22922 = (state_22960[(2)]);
var inst_22923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22924 = [null,inst_22922];
var inst_22925 = (new cljs.core.PersistentVector(null,2,(5),inst_22923,inst_22924,null));
var state_22960__$1 = state_22960;
var statearr_23023_23089 = state_22960__$1;
(statearr_23023_23089[(2)] = inst_22925);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (37))){
var inst_22908 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_23024_23090 = state_22960__$1;
(statearr_23024_23090[(2)] = inst_22908);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (8))){
var inst_22838 = (state_22960[(7)]);
var inst_22849 = inst_22838.cljs$lang$protocol_mask$partition0$;
var inst_22850 = (inst_22849 & (64));
var inst_22851 = inst_22838.cljs$core$ISeq$;
var inst_22852 = (inst_22850) || (inst_22851);
var state_22960__$1 = state_22960;
if(cljs.core.truth_(inst_22852)){
var statearr_23025_23091 = state_22960__$1;
(statearr_23025_23091[(1)] = (11));

} else {
var statearr_23026_23092 = state_22960__$1;
(statearr_23026_23092[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22961 === (49))){
var inst_22950 = (state_22960[(2)]);
var state_22960__$1 = state_22960;
var statearr_23027_23093 = state_22960__$1;
(statearr_23027_23093[(2)] = inst_22950);

(statearr_23027_23093[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
;
return ((function (switch__18220__auto__,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function() {
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__ = null;
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____0 = (function (){
var statearr_23031 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23031[(0)] = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__);

(statearr_23031[(1)] = (1));

return statearr_23031;
});
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____1 = (function (state_22960){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_22960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e23032){if((e23032 instanceof Object)){
var ex__18224__auto__ = e23032;
var statearr_23033_23094 = state_22960;
(statearr_23033_23094[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22960);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e23032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23095 = state_22960;
state_22960 = G__23095;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__ = function(state_22960){
switch(arguments.length){
case 0:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____0.call(this);
case 1:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____1.call(this,state_22960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____0;
taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto____1;
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var state__18334__auto__ = (function (){var statearr_23034 = f__18333__auto__.call(null);
(statearr_23034[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___23035);

return statearr_23034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___23035,map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
);


return ((function (map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function taoensso$sente$_start_chsk_router_BANG__$_stop_BANG_(){
return cljs.core.async.close_BANG_.call(null,ch_ctrl);
});
;})(map__22829,map__22829__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
});
/**
 * Creates a go-loop to call `(event-msg-handler <server-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_server_chsk_router_BANG_ = (function taoensso$sente$start_server_chsk_router_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___23103 = arguments.length;
var i__7277__auto___23104 = (0);
while(true){
if((i__7277__auto___23104 < len__7276__auto___23103)){
args__7283__auto__.push((arguments[i__7277__auto___23104]));

var G__23105 = (i__7277__auto___23104 + (1));
i__7277__auto___23104 = G__23105;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((2) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7284__auto__);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__23099){
var vec__23100 = p__23099;
var map__23101 = cljs.core.nth.call(null,vec__23100,(0),null);
var map__23101__$1 = ((((!((map__23101 == null)))?((((map__23101.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23101.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23101):map__23101);
var opts = map__23101__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__23101__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__23101__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,new cljs.core.Keyword(null,"server","server",1499190120),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$applyTo = (function (seq23096){
var G__23097 = cljs.core.first.call(null,seq23096);
var seq23096__$1 = cljs.core.next.call(null,seq23096);
var G__23098 = cljs.core.first.call(null,seq23096__$1);
var seq23096__$2 = cljs.core.next.call(null,seq23096__$1);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23097,G__23098,seq23096__$2);
});
/**
 * Creates a go-loop to call `(event-msg-handler <client-event-msg>)` and
 *   returns a `(fn stop! [])`. Catches & logs errors.
 * 
 *   Advanced users may instead prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_client_chsk_router_BANG_ = (function taoensso$sente$start_client_chsk_router_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___23113 = arguments.length;
var i__7277__auto___23114 = (0);
while(true){
if((i__7277__auto___23114 < len__7276__auto___23113)){
args__7283__auto__.push((arguments[i__7277__auto___23114]));

var G__23115 = (i__7277__auto___23114 + (1));
i__7277__auto___23114 = G__23115;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((2) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7284__auto__);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__23109){
var vec__23110 = p__23109;
var map__23111 = cljs.core.nth.call(null,vec__23110,(0),null);
var map__23111__$1 = ((((!((map__23111 == null)))?((((map__23111.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23111.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23111):map__23111);
var opts = map__23111__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__23111__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__23111__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,cljs.core.not.call(null,new cljs.core.Keyword(null,"server","server",1499190120)),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$applyTo = (function (seq23106){
var G__23107 = cljs.core.first.call(null,seq23106);
var seq23106__$1 = cljs.core.next.call(null,seq23106);
var G__23108 = cljs.core.first.call(null,seq23106__$1);
var seq23106__$2 = cljs.core.next.call(null,seq23106__$1);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__23107,G__23108,seq23106__$2);
});
taoensso.sente.event_msg_QMARK_ = taoensso.sente.client_event_msg_QMARK_;
taoensso.sente.make_channel_socket_BANG_ = taoensso.sente.make_channel_socket_client_BANG_;
taoensso.sente.start_chsk_router_BANG_ = taoensso.sente.start_client_chsk_router_BANG_;
/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_client_chsk_router_BANG_.call(null,ch_recv,(function (ev_msg){
return event_handler.call(null,new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg),new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg));
}));
});
/**
 * DEPRECATED. Please use `timbre/set-level!` instead.
 */
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.timbre.set_level_BANG_.call(null,level);
});
/**
 * DEPRECATED: Please use `ajax-lite` instead.
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
/**
 * DEPRECATED
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__23116,websocket_QMARK_){
var map__23119 = p__23116;
var map__23119__$1 = ((((!((map__23119 == null)))?((((map__23119.cljs$lang$protocol_mask$partition0$ & (64))) || (map__23119.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23119):map__23119);
var location = map__23119__$1;
var adjusted_protocol = cljs.core.get.call(null,map__23119__$1,new cljs.core.Keyword(null,"adjusted-protocol","adjusted-protocol",37431492));
var host = cljs.core.get.call(null,map__23119__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.call(null,map__23119__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
return [cljs.core.str(adjusted_protocol),cljs.core.str("//"),cljs.core.str(host),cljs.core.str((function (){var or__6207__auto__ = path;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return pathname;
}
})())].join('');
});

//# sourceMappingURL=sente.js.map?rel=1466741597307