// Compiled by ClojureScript 1.8.40 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.dom !== 'undefined'){
} else {
reagent.dom.dom = (function (){var or__6207__auto__ = (function (){var and__6195__auto__ = typeof ReactDOM !== 'undefined';
if(and__6195__auto__){
return ReactDOM;
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
var and__6195__auto__ = typeof require !== 'undefined';
if(and__6195__auto__){
return require("react-dom");
} else {
return and__6195__auto__;
}
}
})();
}
if(cljs.core.truth_(reagent.dom.dom)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Could not find ReactDOM"),cljs.core.str("\n"),cljs.core.str("dom")].join('')));
}
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.dom["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_17104 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.dom["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_17104){
return (function (){
var _STAR_always_update_STAR_17105 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_17105;
}});})(_STAR_always_update_STAR_17104))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_17104;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args17106 = [];
var len__7276__auto___17109 = arguments.length;
var i__7277__auto___17110 = (0);
while(true){
if((i__7277__auto___17110 < len__7276__auto___17109)){
args17106.push((arguments[i__7277__auto___17110]));

var G__17111 = (i__7277__auto___17110 + (1));
i__7277__auto___17110 = G__17111;
continue;
} else {
}
break;
}

var G__17108 = args17106.length;
switch (G__17108) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17106.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;
reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.dom["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
var seq__17117_17121 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__17118_17122 = null;
var count__17119_17123 = (0);
var i__17120_17124 = (0);
while(true){
if((i__17120_17124 < count__17119_17123)){
var v_17125 = cljs.core._nth.call(null,chunk__17118_17122,i__17120_17124);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_17125);

var G__17126 = seq__17117_17121;
var G__17127 = chunk__17118_17122;
var G__17128 = count__17119_17123;
var G__17129 = (i__17120_17124 + (1));
seq__17117_17121 = G__17126;
chunk__17118_17122 = G__17127;
count__17119_17123 = G__17128;
i__17120_17124 = G__17129;
continue;
} else {
var temp__4657__auto___17130 = cljs.core.seq.call(null,seq__17117_17121);
if(temp__4657__auto___17130){
var seq__17117_17131__$1 = temp__4657__auto___17130;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17117_17131__$1)){
var c__7018__auto___17132 = cljs.core.chunk_first.call(null,seq__17117_17131__$1);
var G__17133 = cljs.core.chunk_rest.call(null,seq__17117_17131__$1);
var G__17134 = c__7018__auto___17132;
var G__17135 = cljs.core.count.call(null,c__7018__auto___17132);
var G__17136 = (0);
seq__17117_17121 = G__17133;
chunk__17118_17122 = G__17134;
count__17119_17123 = G__17135;
i__17120_17124 = G__17136;
continue;
} else {
var v_17137 = cljs.core.first.call(null,seq__17117_17131__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_17137);

var G__17138 = cljs.core.next.call(null,seq__17117_17131__$1);
var G__17139 = null;
var G__17140 = (0);
var G__17141 = (0);
seq__17117_17121 = G__17138;
chunk__17118_17122 = G__17139;
count__17119_17123 = G__17140;
i__17120_17124 = G__17141;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1466741593794