// Compiled by ClojureScript 1.8.40 {}
goog.provide('re_frame.utils');
goog.require('cljs.core');
goog.require('clojure.set');
re_frame.utils.default_loggers = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"log","log",-1595516004),(function (p1__17226_SHARP_){
return console.log(p1__17226_SHARP_);
}),new cljs.core.Keyword(null,"warn","warn",-436710552),(function (p1__17227_SHARP_){
return console.warn(p1__17227_SHARP_);
}),new cljs.core.Keyword(null,"error","error",-978969032),(function (p1__17228_SHARP_){
return console.error(p1__17228_SHARP_);
}),new cljs.core.Keyword(null,"group","group",582596132),(function (p1__17229_SHARP_){
if(cljs.core.truth_(console.groupCollapsed)){
return console.groupCollapsed(p1__17229_SHARP_);
} else {
return console.log(p1__17229_SHARP_);
}
}),new cljs.core.Keyword(null,"groupEnd","groupEnd",-337721382),(function (){
if(cljs.core.truth_(console.groupEnd)){
return console.groupEnd();
} else {
return null;
}
})], null);
re_frame.utils.loggers = cljs.core.atom.call(null,re_frame.utils.default_loggers);
/**
 * Change the set (subset?) of logging functions used by re-frame.
 *   'new-loggers' should be a map which looks like default-loggers
 */
re_frame.utils.set_loggers_BANG_ = (function re_frame$utils$set_loggers_BANG_(new_loggers){
if(cljs.core.empty_QMARK_.call(null,clojure.set.difference.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,new_loggers)),cljs.core.set.call(null,cljs.core.keys.call(null,re_frame.utils.default_loggers))))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Unknown keys in new-loggers"),cljs.core.str("\n"),cljs.core.str("(empty? (difference (set (keys new-loggers)) (set (keys default-loggers))))")].join('')));
}

return cljs.core.swap_BANG_.call(null,re_frame.utils.loggers,cljs.core.merge,new_loggers);
});
re_frame.utils.log = (function re_frame$utils$log(var_args){
var args__7283__auto__ = [];
var len__7276__auto___17231 = arguments.length;
var i__7277__auto___17232 = (0);
while(true){
if((i__7277__auto___17232 < len__7276__auto___17231)){
args__7283__auto__.push((arguments[i__7277__auto___17232]));

var G__17233 = (i__7277__auto___17232 + (1));
i__7277__auto___17232 = G__17233;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return re_frame.utils.log.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

re_frame.utils.log.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.utils.loggers)).call(null,cljs.core.apply.call(null,cljs.core.str,args));
});

re_frame.utils.log.cljs$lang$maxFixedArity = (0);

re_frame.utils.log.cljs$lang$applyTo = (function (seq17230){
return re_frame.utils.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17230));
});
re_frame.utils.warn = (function re_frame$utils$warn(var_args){
var args__7283__auto__ = [];
var len__7276__auto___17235 = arguments.length;
var i__7277__auto___17236 = (0);
while(true){
if((i__7277__auto___17236 < len__7276__auto___17235)){
args__7283__auto__.push((arguments[i__7277__auto___17236]));

var G__17237 = (i__7277__auto___17236 + (1));
i__7277__auto___17236 = G__17237;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return new cljs.core.Keyword(null,"warn","warn",-436710552).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.utils.loggers)).call(null,cljs.core.apply.call(null,cljs.core.str,args));
});

re_frame.utils.warn.cljs$lang$maxFixedArity = (0);

re_frame.utils.warn.cljs$lang$applyTo = (function (seq17234){
return re_frame.utils.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17234));
});
re_frame.utils.group = (function re_frame$utils$group(var_args){
var args__7283__auto__ = [];
var len__7276__auto___17239 = arguments.length;
var i__7277__auto___17240 = (0);
while(true){
if((i__7277__auto___17240 < len__7276__auto___17239)){
args__7283__auto__.push((arguments[i__7277__auto___17240]));

var G__17241 = (i__7277__auto___17240 + (1));
i__7277__auto___17240 = G__17241;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return re_frame.utils.group.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

re_frame.utils.group.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.utils.loggers)).call(null,cljs.core.apply.call(null,cljs.core.str,args));
});

re_frame.utils.group.cljs$lang$maxFixedArity = (0);

re_frame.utils.group.cljs$lang$applyTo = (function (seq17238){
return re_frame.utils.group.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17238));
});
re_frame.utils.groupEnd = (function re_frame$utils$groupEnd(var_args){
var args__7283__auto__ = [];
var len__7276__auto___17243 = arguments.length;
var i__7277__auto___17244 = (0);
while(true){
if((i__7277__auto___17244 < len__7276__auto___17243)){
args__7283__auto__.push((arguments[i__7277__auto___17244]));

var G__17245 = (i__7277__auto___17244 + (1));
i__7277__auto___17244 = G__17245;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return re_frame.utils.groupEnd.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

re_frame.utils.groupEnd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return new cljs.core.Keyword(null,"groupEnd","groupEnd",-337721382).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.utils.loggers)).call(null,cljs.core.apply.call(null,cljs.core.str,args));
});

re_frame.utils.groupEnd.cljs$lang$maxFixedArity = (0);

re_frame.utils.groupEnd.cljs$lang$applyTo = (function (seq17242){
return re_frame.utils.groupEnd.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17242));
});
re_frame.utils.error = (function re_frame$utils$error(var_args){
var args__7283__auto__ = [];
var len__7276__auto___17247 = arguments.length;
var i__7277__auto___17248 = (0);
while(true){
if((i__7277__auto___17248 < len__7276__auto___17247)){
args__7283__auto__.push((arguments[i__7277__auto___17248]));

var G__17249 = (i__7277__auto___17248 + (1));
i__7277__auto___17248 = G__17249;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((0) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((0)),(0),null)):null);
return re_frame.utils.error.cljs$core$IFn$_invoke$arity$variadic(argseq__7284__auto__);
});

re_frame.utils.error.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.utils.loggers)).call(null,cljs.core.apply.call(null,cljs.core.str,args));
});

re_frame.utils.error.cljs$lang$maxFixedArity = (0);

re_frame.utils.error.cljs$lang$applyTo = (function (seq17246){
return re_frame.utils.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17246));
});
re_frame.utils.first_in_vector = (function re_frame$utils$first_in_vector(v){
if(cljs.core.vector_QMARK_.call(null,v)){
return cljs.core.first.call(null,v);
} else {
return re_frame.utils.error.call(null,"re-frame: expected a vector event, but got: ",v);
}
});

//# sourceMappingURL=utils.js.map?rel=1466741593953