// Compiled by ClojureScript 1.8.40 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args18377 = [];
var len__7276__auto___18383 = arguments.length;
var i__7277__auto___18384 = (0);
while(true){
if((i__7277__auto___18384 < len__7276__auto___18383)){
args18377.push((arguments[i__7277__auto___18384]));

var G__18385 = (i__7277__auto___18384 + (1));
i__7277__auto___18384 = G__18385;
continue;
} else {
}
break;
}

var G__18379 = args18377.length;
switch (G__18379) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18377.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async18380 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18380 = (function (f,blockable,meta18381){
this.f = f;
this.blockable = blockable;
this.meta18381 = meta18381;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18382,meta18381__$1){
var self__ = this;
var _18382__$1 = this;
return (new cljs.core.async.t_cljs$core$async18380(self__.f,self__.blockable,meta18381__$1));
});

cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18382){
var self__ = this;
var _18382__$1 = this;
return self__.meta18381;
});

cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async18380.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async18380.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta18381","meta18381",623553470,null)], null);
});

cljs.core.async.t_cljs$core$async18380.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18380.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18380";

cljs.core.async.t_cljs$core$async18380.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18380");
});

cljs.core.async.__GT_t_cljs$core$async18380 = (function cljs$core$async$__GT_t_cljs$core$async18380(f__$1,blockable__$1,meta18381){
return (new cljs.core.async.t_cljs$core$async18380(f__$1,blockable__$1,meta18381));
});

}

return (new cljs.core.async.t_cljs$core$async18380(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args18389 = [];
var len__7276__auto___18392 = arguments.length;
var i__7277__auto___18393 = (0);
while(true){
if((i__7277__auto___18393 < len__7276__auto___18392)){
args18389.push((arguments[i__7277__auto___18393]));

var G__18394 = (i__7277__auto___18393 + (1));
i__7277__auto___18393 = G__18394;
continue;
} else {
}
break;
}

var G__18391 = args18389.length;
switch (G__18391) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18389.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args18396 = [];
var len__7276__auto___18399 = arguments.length;
var i__7277__auto___18400 = (0);
while(true){
if((i__7277__auto___18400 < len__7276__auto___18399)){
args18396.push((arguments[i__7277__auto___18400]));

var G__18401 = (i__7277__auto___18400 + (1));
i__7277__auto___18400 = G__18401;
continue;
} else {
}
break;
}

var G__18398 = args18396.length;
switch (G__18398) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18396.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args18403 = [];
var len__7276__auto___18406 = arguments.length;
var i__7277__auto___18407 = (0);
while(true){
if((i__7277__auto___18407 < len__7276__auto___18406)){
args18403.push((arguments[i__7277__auto___18407]));

var G__18408 = (i__7277__auto___18407 + (1));
i__7277__auto___18407 = G__18408;
continue;
} else {
}
break;
}

var G__18405 = args18403.length;
switch (G__18405) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18403.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_18410 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_18410);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_18410,ret){
return (function (){
return fn1.call(null,val_18410);
});})(val_18410,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args18411 = [];
var len__7276__auto___18414 = arguments.length;
var i__7277__auto___18415 = (0);
while(true){
if((i__7277__auto___18415 < len__7276__auto___18414)){
args18411.push((arguments[i__7277__auto___18415]));

var G__18416 = (i__7277__auto___18415 + (1));
i__7277__auto___18415 = G__18416;
continue;
} else {
}
break;
}

var G__18413 = args18411.length;
switch (G__18413) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18411.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7121__auto___18418 = n;
var x_18419 = (0);
while(true){
if((x_18419 < n__7121__auto___18418)){
(a[x_18419] = (0));

var G__18420 = (x_18419 + (1));
x_18419 = G__18420;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__18421 = (i + (1));
i = G__18421;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async18425 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18425 = (function (alt_flag,flag,meta18426){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta18426 = meta18426;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18427,meta18426__$1){
var self__ = this;
var _18427__$1 = this;
return (new cljs.core.async.t_cljs$core$async18425(self__.alt_flag,self__.flag,meta18426__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18427){
var self__ = this;
var _18427__$1 = this;
return self__.meta18426;
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta18426","meta18426",614557361,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18425.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18425.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18425";

cljs.core.async.t_cljs$core$async18425.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18425");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18425 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18425(alt_flag__$1,flag__$1,meta18426){
return (new cljs.core.async.t_cljs$core$async18425(alt_flag__$1,flag__$1,meta18426));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18425(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18431 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18431 = (function (alt_handler,flag,cb,meta18432){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta18432 = meta18432;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18433,meta18432__$1){
var self__ = this;
var _18433__$1 = this;
return (new cljs.core.async.t_cljs$core$async18431(self__.alt_handler,self__.flag,self__.cb,meta18432__$1));
});

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18433){
var self__ = this;
var _18433__$1 = this;
return self__.meta18432;
});

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18431.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18431.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta18432","meta18432",-1780972233,null)], null);
});

cljs.core.async.t_cljs$core$async18431.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18431.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18431";

cljs.core.async.t_cljs$core$async18431.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async18431");
});

cljs.core.async.__GT_t_cljs$core$async18431 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18431(alt_handler__$1,flag__$1,cb__$1,meta18432){
return (new cljs.core.async.t_cljs$core$async18431(alt_handler__$1,flag__$1,cb__$1,meta18432));
});

}

return (new cljs.core.async.t_cljs$core$async18431(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18434_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18434_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18435_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18435_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6207__auto__ = wport;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18436 = (i + (1));
i = G__18436;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6207__auto__ = ret;
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6195__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6195__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6195__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___18442 = arguments.length;
var i__7277__auto___18443 = (0);
while(true){
if((i__7277__auto___18443 < len__7276__auto___18442)){
args__7283__auto__.push((arguments[i__7277__auto___18443]));

var G__18444 = (i__7277__auto___18443 + (1));
i__7277__auto___18443 = G__18444;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((1) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7284__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18439){
var map__18440 = p__18439;
var map__18440__$1 = ((((!((map__18440 == null)))?((((map__18440.cljs$lang$protocol_mask$partition0$ & (64))) || (map__18440.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__18440):map__18440);
var opts = map__18440__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18437){
var G__18438 = cljs.core.first.call(null,seq18437);
var seq18437__$1 = cljs.core.next.call(null,seq18437);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18438,seq18437__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18445 = [];
var len__7276__auto___18495 = arguments.length;
var i__7277__auto___18496 = (0);
while(true){
if((i__7277__auto___18496 < len__7276__auto___18495)){
args18445.push((arguments[i__7277__auto___18496]));

var G__18497 = (i__7277__auto___18496 + (1));
i__7277__auto___18496 = G__18497;
continue;
} else {
}
break;
}

var G__18447 = args18445.length;
switch (G__18447) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18445.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18332__auto___18499 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___18499){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___18499){
return (function (state_18471){
var state_val_18472 = (state_18471[(1)]);
if((state_val_18472 === (7))){
var inst_18467 = (state_18471[(2)]);
var state_18471__$1 = state_18471;
var statearr_18473_18500 = state_18471__$1;
(statearr_18473_18500[(2)] = inst_18467);

(statearr_18473_18500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (1))){
var state_18471__$1 = state_18471;
var statearr_18474_18501 = state_18471__$1;
(statearr_18474_18501[(2)] = null);

(statearr_18474_18501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (4))){
var inst_18450 = (state_18471[(7)]);
var inst_18450__$1 = (state_18471[(2)]);
var inst_18451 = (inst_18450__$1 == null);
var state_18471__$1 = (function (){var statearr_18475 = state_18471;
(statearr_18475[(7)] = inst_18450__$1);

return statearr_18475;
})();
if(cljs.core.truth_(inst_18451)){
var statearr_18476_18502 = state_18471__$1;
(statearr_18476_18502[(1)] = (5));

} else {
var statearr_18477_18503 = state_18471__$1;
(statearr_18477_18503[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (13))){
var state_18471__$1 = state_18471;
var statearr_18478_18504 = state_18471__$1;
(statearr_18478_18504[(2)] = null);

(statearr_18478_18504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (6))){
var inst_18450 = (state_18471[(7)]);
var state_18471__$1 = state_18471;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18471__$1,(11),to,inst_18450);
} else {
if((state_val_18472 === (3))){
var inst_18469 = (state_18471[(2)]);
var state_18471__$1 = state_18471;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18471__$1,inst_18469);
} else {
if((state_val_18472 === (12))){
var state_18471__$1 = state_18471;
var statearr_18479_18505 = state_18471__$1;
(statearr_18479_18505[(2)] = null);

(statearr_18479_18505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (2))){
var state_18471__$1 = state_18471;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18471__$1,(4),from);
} else {
if((state_val_18472 === (11))){
var inst_18460 = (state_18471[(2)]);
var state_18471__$1 = state_18471;
if(cljs.core.truth_(inst_18460)){
var statearr_18480_18506 = state_18471__$1;
(statearr_18480_18506[(1)] = (12));

} else {
var statearr_18481_18507 = state_18471__$1;
(statearr_18481_18507[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (9))){
var state_18471__$1 = state_18471;
var statearr_18482_18508 = state_18471__$1;
(statearr_18482_18508[(2)] = null);

(statearr_18482_18508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (5))){
var state_18471__$1 = state_18471;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18483_18509 = state_18471__$1;
(statearr_18483_18509[(1)] = (8));

} else {
var statearr_18484_18510 = state_18471__$1;
(statearr_18484_18510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (14))){
var inst_18465 = (state_18471[(2)]);
var state_18471__$1 = state_18471;
var statearr_18485_18511 = state_18471__$1;
(statearr_18485_18511[(2)] = inst_18465);

(statearr_18485_18511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (10))){
var inst_18457 = (state_18471[(2)]);
var state_18471__$1 = state_18471;
var statearr_18486_18512 = state_18471__$1;
(statearr_18486_18512[(2)] = inst_18457);

(statearr_18486_18512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18472 === (8))){
var inst_18454 = cljs.core.async.close_BANG_.call(null,to);
var state_18471__$1 = state_18471;
var statearr_18487_18513 = state_18471__$1;
(statearr_18487_18513[(2)] = inst_18454);

(statearr_18487_18513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___18499))
;
return ((function (switch__18220__auto__,c__18332__auto___18499){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_18491 = [null,null,null,null,null,null,null,null];
(statearr_18491[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_18491[(1)] = (1));

return statearr_18491;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_18471){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18471);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18492){if((e18492 instanceof Object)){
var ex__18224__auto__ = e18492;
var statearr_18493_18514 = state_18471;
(statearr_18493_18514[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18471);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18492;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18515 = state_18471;
state_18471 = G__18515;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_18471){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_18471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___18499))
})();
var state__18334__auto__ = (function (){var statearr_18494 = f__18333__auto__.call(null);
(statearr_18494[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___18499);

return statearr_18494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___18499))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__18699){
var vec__18700 = p__18699;
var v = cljs.core.nth.call(null,vec__18700,(0),null);
var p = cljs.core.nth.call(null,vec__18700,(1),null);
var job = vec__18700;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__18332__auto___18882 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results){
return (function (state_18705){
var state_val_18706 = (state_18705[(1)]);
if((state_val_18706 === (1))){
var state_18705__$1 = state_18705;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18705__$1,(2),res,v);
} else {
if((state_val_18706 === (2))){
var inst_18702 = (state_18705[(2)]);
var inst_18703 = cljs.core.async.close_BANG_.call(null,res);
var state_18705__$1 = (function (){var statearr_18707 = state_18705;
(statearr_18707[(7)] = inst_18702);

return statearr_18707;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18705__$1,inst_18703);
} else {
return null;
}
}
});})(c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results))
;
return ((function (switch__18220__auto__,c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_18711 = [null,null,null,null,null,null,null,null];
(statearr_18711[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__);

(statearr_18711[(1)] = (1));

return statearr_18711;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1 = (function (state_18705){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18705);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18712){if((e18712 instanceof Object)){
var ex__18224__auto__ = e18712;
var statearr_18713_18883 = state_18705;
(statearr_18713_18883[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18705);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18884 = state_18705;
state_18705 = G__18884;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = function(state_18705){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1.call(this,state_18705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results))
})();
var state__18334__auto__ = (function (){var statearr_18714 = f__18333__auto__.call(null);
(statearr_18714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___18882);

return statearr_18714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___18882,res,vec__18700,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18715){
var vec__18716 = p__18715;
var v = cljs.core.nth.call(null,vec__18716,(0),null);
var p = cljs.core.nth.call(null,vec__18716,(1),null);
var job = vec__18716;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7121__auto___18885 = n;
var __18886 = (0);
while(true){
if((__18886 < n__7121__auto___18885)){
var G__18717_18887 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__18717_18887) {
case "compute":
var c__18332__auto___18889 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18886,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (__18886,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function (state_18730){
var state_val_18731 = (state_18730[(1)]);
if((state_val_18731 === (1))){
var state_18730__$1 = state_18730;
var statearr_18732_18890 = state_18730__$1;
(statearr_18732_18890[(2)] = null);

(statearr_18732_18890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18731 === (2))){
var state_18730__$1 = state_18730;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18730__$1,(4),jobs);
} else {
if((state_val_18731 === (3))){
var inst_18728 = (state_18730[(2)]);
var state_18730__$1 = state_18730;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18730__$1,inst_18728);
} else {
if((state_val_18731 === (4))){
var inst_18720 = (state_18730[(2)]);
var inst_18721 = process.call(null,inst_18720);
var state_18730__$1 = state_18730;
if(cljs.core.truth_(inst_18721)){
var statearr_18733_18891 = state_18730__$1;
(statearr_18733_18891[(1)] = (5));

} else {
var statearr_18734_18892 = state_18730__$1;
(statearr_18734_18892[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18731 === (5))){
var state_18730__$1 = state_18730;
var statearr_18735_18893 = state_18730__$1;
(statearr_18735_18893[(2)] = null);

(statearr_18735_18893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18731 === (6))){
var state_18730__$1 = state_18730;
var statearr_18736_18894 = state_18730__$1;
(statearr_18736_18894[(2)] = null);

(statearr_18736_18894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18731 === (7))){
var inst_18726 = (state_18730[(2)]);
var state_18730__$1 = state_18730;
var statearr_18737_18895 = state_18730__$1;
(statearr_18737_18895[(2)] = inst_18726);

(statearr_18737_18895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18886,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
;
return ((function (__18886,switch__18220__auto__,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_18741 = [null,null,null,null,null,null,null];
(statearr_18741[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__);

(statearr_18741[(1)] = (1));

return statearr_18741;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1 = (function (state_18730){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18730);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18742){if((e18742 instanceof Object)){
var ex__18224__auto__ = e18742;
var statearr_18743_18896 = state_18730;
(statearr_18743_18896[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18730);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18742;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18897 = state_18730;
state_18730 = G__18897;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = function(state_18730){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1.call(this,state_18730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__;
})()
;})(__18886,switch__18220__auto__,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
})();
var state__18334__auto__ = (function (){var statearr_18744 = f__18333__auto__.call(null);
(statearr_18744[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___18889);

return statearr_18744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(__18886,c__18332__auto___18889,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
);


break;
case "async":
var c__18332__auto___18898 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__18886,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (__18886,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function (state_18757){
var state_val_18758 = (state_18757[(1)]);
if((state_val_18758 === (1))){
var state_18757__$1 = state_18757;
var statearr_18759_18899 = state_18757__$1;
(statearr_18759_18899[(2)] = null);

(statearr_18759_18899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18758 === (2))){
var state_18757__$1 = state_18757;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18757__$1,(4),jobs);
} else {
if((state_val_18758 === (3))){
var inst_18755 = (state_18757[(2)]);
var state_18757__$1 = state_18757;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18757__$1,inst_18755);
} else {
if((state_val_18758 === (4))){
var inst_18747 = (state_18757[(2)]);
var inst_18748 = async.call(null,inst_18747);
var state_18757__$1 = state_18757;
if(cljs.core.truth_(inst_18748)){
var statearr_18760_18900 = state_18757__$1;
(statearr_18760_18900[(1)] = (5));

} else {
var statearr_18761_18901 = state_18757__$1;
(statearr_18761_18901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18758 === (5))){
var state_18757__$1 = state_18757;
var statearr_18762_18902 = state_18757__$1;
(statearr_18762_18902[(2)] = null);

(statearr_18762_18902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18758 === (6))){
var state_18757__$1 = state_18757;
var statearr_18763_18903 = state_18757__$1;
(statearr_18763_18903[(2)] = null);

(statearr_18763_18903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18758 === (7))){
var inst_18753 = (state_18757[(2)]);
var state_18757__$1 = state_18757;
var statearr_18764_18904 = state_18757__$1;
(statearr_18764_18904[(2)] = inst_18753);

(statearr_18764_18904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__18886,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
;
return ((function (__18886,switch__18220__auto__,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_18768 = [null,null,null,null,null,null,null];
(statearr_18768[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__);

(statearr_18768[(1)] = (1));

return statearr_18768;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1 = (function (state_18757){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18757);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18769){if((e18769 instanceof Object)){
var ex__18224__auto__ = e18769;
var statearr_18770_18905 = state_18757;
(statearr_18770_18905[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18757);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18906 = state_18757;
state_18757 = G__18906;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = function(state_18757){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1.call(this,state_18757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__;
})()
;})(__18886,switch__18220__auto__,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
})();
var state__18334__auto__ = (function (){var statearr_18771 = f__18333__auto__.call(null);
(statearr_18771[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___18898);

return statearr_18771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(__18886,c__18332__auto___18898,G__18717_18887,n__7121__auto___18885,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18907 = (__18886 + (1));
__18886 = G__18907;
continue;
} else {
}
break;
}

var c__18332__auto___18908 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___18908,jobs,results,process,async){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___18908,jobs,results,process,async){
return (function (state_18793){
var state_val_18794 = (state_18793[(1)]);
if((state_val_18794 === (1))){
var state_18793__$1 = state_18793;
var statearr_18795_18909 = state_18793__$1;
(statearr_18795_18909[(2)] = null);

(statearr_18795_18909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (2))){
var state_18793__$1 = state_18793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18793__$1,(4),from);
} else {
if((state_val_18794 === (3))){
var inst_18791 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18793__$1,inst_18791);
} else {
if((state_val_18794 === (4))){
var inst_18774 = (state_18793[(7)]);
var inst_18774__$1 = (state_18793[(2)]);
var inst_18775 = (inst_18774__$1 == null);
var state_18793__$1 = (function (){var statearr_18796 = state_18793;
(statearr_18796[(7)] = inst_18774__$1);

return statearr_18796;
})();
if(cljs.core.truth_(inst_18775)){
var statearr_18797_18910 = state_18793__$1;
(statearr_18797_18910[(1)] = (5));

} else {
var statearr_18798_18911 = state_18793__$1;
(statearr_18798_18911[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (5))){
var inst_18777 = cljs.core.async.close_BANG_.call(null,jobs);
var state_18793__$1 = state_18793;
var statearr_18799_18912 = state_18793__$1;
(statearr_18799_18912[(2)] = inst_18777);

(statearr_18799_18912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (6))){
var inst_18774 = (state_18793[(7)]);
var inst_18779 = (state_18793[(8)]);
var inst_18779__$1 = cljs.core.async.chan.call(null,(1));
var inst_18780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18781 = [inst_18774,inst_18779__$1];
var inst_18782 = (new cljs.core.PersistentVector(null,2,(5),inst_18780,inst_18781,null));
var state_18793__$1 = (function (){var statearr_18800 = state_18793;
(statearr_18800[(8)] = inst_18779__$1);

return statearr_18800;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18793__$1,(8),jobs,inst_18782);
} else {
if((state_val_18794 === (7))){
var inst_18789 = (state_18793[(2)]);
var state_18793__$1 = state_18793;
var statearr_18801_18913 = state_18793__$1;
(statearr_18801_18913[(2)] = inst_18789);

(statearr_18801_18913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18794 === (8))){
var inst_18779 = (state_18793[(8)]);
var inst_18784 = (state_18793[(2)]);
var state_18793__$1 = (function (){var statearr_18802 = state_18793;
(statearr_18802[(9)] = inst_18784);

return statearr_18802;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18793__$1,(9),results,inst_18779);
} else {
if((state_val_18794 === (9))){
var inst_18786 = (state_18793[(2)]);
var state_18793__$1 = (function (){var statearr_18803 = state_18793;
(statearr_18803[(10)] = inst_18786);

return statearr_18803;
})();
var statearr_18804_18914 = state_18793__$1;
(statearr_18804_18914[(2)] = null);

(statearr_18804_18914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___18908,jobs,results,process,async))
;
return ((function (switch__18220__auto__,c__18332__auto___18908,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_18808 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18808[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__);

(statearr_18808[(1)] = (1));

return statearr_18808;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1 = (function (state_18793){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18809){if((e18809 instanceof Object)){
var ex__18224__auto__ = e18809;
var statearr_18810_18915 = state_18793;
(statearr_18810_18915[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18793);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18809;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18916 = state_18793;
state_18793 = G__18916;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = function(state_18793){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1.call(this,state_18793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___18908,jobs,results,process,async))
})();
var state__18334__auto__ = (function (){var statearr_18811 = f__18333__auto__.call(null);
(statearr_18811[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___18908);

return statearr_18811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___18908,jobs,results,process,async))
);


var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__,jobs,results,process,async){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__,jobs,results,process,async){
return (function (state_18849){
var state_val_18850 = (state_18849[(1)]);
if((state_val_18850 === (7))){
var inst_18845 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18851_18917 = state_18849__$1;
(statearr_18851_18917[(2)] = inst_18845);

(statearr_18851_18917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (20))){
var state_18849__$1 = state_18849;
var statearr_18852_18918 = state_18849__$1;
(statearr_18852_18918[(2)] = null);

(statearr_18852_18918[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (1))){
var state_18849__$1 = state_18849;
var statearr_18853_18919 = state_18849__$1;
(statearr_18853_18919[(2)] = null);

(statearr_18853_18919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (4))){
var inst_18814 = (state_18849[(7)]);
var inst_18814__$1 = (state_18849[(2)]);
var inst_18815 = (inst_18814__$1 == null);
var state_18849__$1 = (function (){var statearr_18854 = state_18849;
(statearr_18854[(7)] = inst_18814__$1);

return statearr_18854;
})();
if(cljs.core.truth_(inst_18815)){
var statearr_18855_18920 = state_18849__$1;
(statearr_18855_18920[(1)] = (5));

} else {
var statearr_18856_18921 = state_18849__$1;
(statearr_18856_18921[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (15))){
var inst_18827 = (state_18849[(8)]);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18849__$1,(18),to,inst_18827);
} else {
if((state_val_18850 === (21))){
var inst_18840 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18857_18922 = state_18849__$1;
(statearr_18857_18922[(2)] = inst_18840);

(statearr_18857_18922[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (13))){
var inst_18842 = (state_18849[(2)]);
var state_18849__$1 = (function (){var statearr_18858 = state_18849;
(statearr_18858[(9)] = inst_18842);

return statearr_18858;
})();
var statearr_18859_18923 = state_18849__$1;
(statearr_18859_18923[(2)] = null);

(statearr_18859_18923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (6))){
var inst_18814 = (state_18849[(7)]);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18849__$1,(11),inst_18814);
} else {
if((state_val_18850 === (17))){
var inst_18835 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
if(cljs.core.truth_(inst_18835)){
var statearr_18860_18924 = state_18849__$1;
(statearr_18860_18924[(1)] = (19));

} else {
var statearr_18861_18925 = state_18849__$1;
(statearr_18861_18925[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (3))){
var inst_18847 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18849__$1,inst_18847);
} else {
if((state_val_18850 === (12))){
var inst_18824 = (state_18849[(10)]);
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18849__$1,(14),inst_18824);
} else {
if((state_val_18850 === (2))){
var state_18849__$1 = state_18849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18849__$1,(4),results);
} else {
if((state_val_18850 === (19))){
var state_18849__$1 = state_18849;
var statearr_18862_18926 = state_18849__$1;
(statearr_18862_18926[(2)] = null);

(statearr_18862_18926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (11))){
var inst_18824 = (state_18849[(2)]);
var state_18849__$1 = (function (){var statearr_18863 = state_18849;
(statearr_18863[(10)] = inst_18824);

return statearr_18863;
})();
var statearr_18864_18927 = state_18849__$1;
(statearr_18864_18927[(2)] = null);

(statearr_18864_18927[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (9))){
var state_18849__$1 = state_18849;
var statearr_18865_18928 = state_18849__$1;
(statearr_18865_18928[(2)] = null);

(statearr_18865_18928[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (5))){
var state_18849__$1 = state_18849;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18866_18929 = state_18849__$1;
(statearr_18866_18929[(1)] = (8));

} else {
var statearr_18867_18930 = state_18849__$1;
(statearr_18867_18930[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (14))){
var inst_18829 = (state_18849[(11)]);
var inst_18827 = (state_18849[(8)]);
var inst_18827__$1 = (state_18849[(2)]);
var inst_18828 = (inst_18827__$1 == null);
var inst_18829__$1 = cljs.core.not.call(null,inst_18828);
var state_18849__$1 = (function (){var statearr_18868 = state_18849;
(statearr_18868[(11)] = inst_18829__$1);

(statearr_18868[(8)] = inst_18827__$1);

return statearr_18868;
})();
if(inst_18829__$1){
var statearr_18869_18931 = state_18849__$1;
(statearr_18869_18931[(1)] = (15));

} else {
var statearr_18870_18932 = state_18849__$1;
(statearr_18870_18932[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (16))){
var inst_18829 = (state_18849[(11)]);
var state_18849__$1 = state_18849;
var statearr_18871_18933 = state_18849__$1;
(statearr_18871_18933[(2)] = inst_18829);

(statearr_18871_18933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (10))){
var inst_18821 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18872_18934 = state_18849__$1;
(statearr_18872_18934[(2)] = inst_18821);

(statearr_18872_18934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (18))){
var inst_18832 = (state_18849[(2)]);
var state_18849__$1 = state_18849;
var statearr_18873_18935 = state_18849__$1;
(statearr_18873_18935[(2)] = inst_18832);

(statearr_18873_18935[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18850 === (8))){
var inst_18818 = cljs.core.async.close_BANG_.call(null,to);
var state_18849__$1 = state_18849;
var statearr_18874_18936 = state_18849__$1;
(statearr_18874_18936[(2)] = inst_18818);

(statearr_18874_18936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto__,jobs,results,process,async))
;
return ((function (switch__18220__auto__,c__18332__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_18878 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18878[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__);

(statearr_18878[(1)] = (1));

return statearr_18878;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1 = (function (state_18849){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e18879){if((e18879 instanceof Object)){
var ex__18224__auto__ = e18879;
var statearr_18880_18937 = state_18849;
(statearr_18880_18937[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18938 = state_18849;
state_18849 = G__18938;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__ = function(state_18849){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1.call(this,state_18849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__,jobs,results,process,async))
})();
var state__18334__auto__ = (function (){var statearr_18881 = f__18333__auto__.call(null);
(statearr_18881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_18881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__,jobs,results,process,async))
);

return c__18332__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18939 = [];
var len__7276__auto___18942 = arguments.length;
var i__7277__auto___18943 = (0);
while(true){
if((i__7277__auto___18943 < len__7276__auto___18942)){
args18939.push((arguments[i__7277__auto___18943]));

var G__18944 = (i__7277__auto___18943 + (1));
i__7277__auto___18943 = G__18944;
continue;
} else {
}
break;
}

var G__18941 = args18939.length;
switch (G__18941) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18939.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18946 = [];
var len__7276__auto___18949 = arguments.length;
var i__7277__auto___18950 = (0);
while(true){
if((i__7277__auto___18950 < len__7276__auto___18949)){
args18946.push((arguments[i__7277__auto___18950]));

var G__18951 = (i__7277__auto___18950 + (1));
i__7277__auto___18950 = G__18951;
continue;
} else {
}
break;
}

var G__18948 = args18946.length;
switch (G__18948) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18946.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18953 = [];
var len__7276__auto___19006 = arguments.length;
var i__7277__auto___19007 = (0);
while(true){
if((i__7277__auto___19007 < len__7276__auto___19006)){
args18953.push((arguments[i__7277__auto___19007]));

var G__19008 = (i__7277__auto___19007 + (1));
i__7277__auto___19007 = G__19008;
continue;
} else {
}
break;
}

var G__18955 = args18953.length;
switch (G__18955) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18953.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__18332__auto___19010 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___19010,tc,fc){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___19010,tc,fc){
return (function (state_18981){
var state_val_18982 = (state_18981[(1)]);
if((state_val_18982 === (7))){
var inst_18977 = (state_18981[(2)]);
var state_18981__$1 = state_18981;
var statearr_18983_19011 = state_18981__$1;
(statearr_18983_19011[(2)] = inst_18977);

(statearr_18983_19011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (1))){
var state_18981__$1 = state_18981;
var statearr_18984_19012 = state_18981__$1;
(statearr_18984_19012[(2)] = null);

(statearr_18984_19012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (4))){
var inst_18958 = (state_18981[(7)]);
var inst_18958__$1 = (state_18981[(2)]);
var inst_18959 = (inst_18958__$1 == null);
var state_18981__$1 = (function (){var statearr_18985 = state_18981;
(statearr_18985[(7)] = inst_18958__$1);

return statearr_18985;
})();
if(cljs.core.truth_(inst_18959)){
var statearr_18986_19013 = state_18981__$1;
(statearr_18986_19013[(1)] = (5));

} else {
var statearr_18987_19014 = state_18981__$1;
(statearr_18987_19014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (13))){
var state_18981__$1 = state_18981;
var statearr_18988_19015 = state_18981__$1;
(statearr_18988_19015[(2)] = null);

(statearr_18988_19015[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (6))){
var inst_18958 = (state_18981[(7)]);
var inst_18964 = p.call(null,inst_18958);
var state_18981__$1 = state_18981;
if(cljs.core.truth_(inst_18964)){
var statearr_18989_19016 = state_18981__$1;
(statearr_18989_19016[(1)] = (9));

} else {
var statearr_18990_19017 = state_18981__$1;
(statearr_18990_19017[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (3))){
var inst_18979 = (state_18981[(2)]);
var state_18981__$1 = state_18981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18981__$1,inst_18979);
} else {
if((state_val_18982 === (12))){
var state_18981__$1 = state_18981;
var statearr_18991_19018 = state_18981__$1;
(statearr_18991_19018[(2)] = null);

(statearr_18991_19018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (2))){
var state_18981__$1 = state_18981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18981__$1,(4),ch);
} else {
if((state_val_18982 === (11))){
var inst_18958 = (state_18981[(7)]);
var inst_18968 = (state_18981[(2)]);
var state_18981__$1 = state_18981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18981__$1,(8),inst_18968,inst_18958);
} else {
if((state_val_18982 === (9))){
var state_18981__$1 = state_18981;
var statearr_18992_19019 = state_18981__$1;
(statearr_18992_19019[(2)] = tc);

(statearr_18992_19019[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (5))){
var inst_18961 = cljs.core.async.close_BANG_.call(null,tc);
var inst_18962 = cljs.core.async.close_BANG_.call(null,fc);
var state_18981__$1 = (function (){var statearr_18993 = state_18981;
(statearr_18993[(8)] = inst_18961);

return statearr_18993;
})();
var statearr_18994_19020 = state_18981__$1;
(statearr_18994_19020[(2)] = inst_18962);

(statearr_18994_19020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (14))){
var inst_18975 = (state_18981[(2)]);
var state_18981__$1 = state_18981;
var statearr_18995_19021 = state_18981__$1;
(statearr_18995_19021[(2)] = inst_18975);

(statearr_18995_19021[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (10))){
var state_18981__$1 = state_18981;
var statearr_18996_19022 = state_18981__$1;
(statearr_18996_19022[(2)] = fc);

(statearr_18996_19022[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18982 === (8))){
var inst_18970 = (state_18981[(2)]);
var state_18981__$1 = state_18981;
if(cljs.core.truth_(inst_18970)){
var statearr_18997_19023 = state_18981__$1;
(statearr_18997_19023[(1)] = (12));

} else {
var statearr_18998_19024 = state_18981__$1;
(statearr_18998_19024[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___19010,tc,fc))
;
return ((function (switch__18220__auto__,c__18332__auto___19010,tc,fc){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_19002 = [null,null,null,null,null,null,null,null,null];
(statearr_19002[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_19002[(1)] = (1));

return statearr_19002;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_18981){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_18981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e19003){if((e19003 instanceof Object)){
var ex__18224__auto__ = e19003;
var statearr_19004_19025 = state_18981;
(statearr_19004_19025[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19026 = state_18981;
state_18981 = G__19026;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_18981){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_18981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___19010,tc,fc))
})();
var state__18334__auto__ = (function (){var statearr_19005 = f__18333__auto__.call(null);
(statearr_19005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___19010);

return statearr_19005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___19010,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__){
return (function (state_19090){
var state_val_19091 = (state_19090[(1)]);
if((state_val_19091 === (7))){
var inst_19086 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
var statearr_19092_19113 = state_19090__$1;
(statearr_19092_19113[(2)] = inst_19086);

(statearr_19092_19113[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (1))){
var inst_19070 = init;
var state_19090__$1 = (function (){var statearr_19093 = state_19090;
(statearr_19093[(7)] = inst_19070);

return statearr_19093;
})();
var statearr_19094_19114 = state_19090__$1;
(statearr_19094_19114[(2)] = null);

(statearr_19094_19114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (4))){
var inst_19073 = (state_19090[(8)]);
var inst_19073__$1 = (state_19090[(2)]);
var inst_19074 = (inst_19073__$1 == null);
var state_19090__$1 = (function (){var statearr_19095 = state_19090;
(statearr_19095[(8)] = inst_19073__$1);

return statearr_19095;
})();
if(cljs.core.truth_(inst_19074)){
var statearr_19096_19115 = state_19090__$1;
(statearr_19096_19115[(1)] = (5));

} else {
var statearr_19097_19116 = state_19090__$1;
(statearr_19097_19116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (6))){
var inst_19077 = (state_19090[(9)]);
var inst_19073 = (state_19090[(8)]);
var inst_19070 = (state_19090[(7)]);
var inst_19077__$1 = f.call(null,inst_19070,inst_19073);
var inst_19078 = cljs.core.reduced_QMARK_.call(null,inst_19077__$1);
var state_19090__$1 = (function (){var statearr_19098 = state_19090;
(statearr_19098[(9)] = inst_19077__$1);

return statearr_19098;
})();
if(inst_19078){
var statearr_19099_19117 = state_19090__$1;
(statearr_19099_19117[(1)] = (8));

} else {
var statearr_19100_19118 = state_19090__$1;
(statearr_19100_19118[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (3))){
var inst_19088 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19090__$1,inst_19088);
} else {
if((state_val_19091 === (2))){
var state_19090__$1 = state_19090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19090__$1,(4),ch);
} else {
if((state_val_19091 === (9))){
var inst_19077 = (state_19090[(9)]);
var inst_19070 = inst_19077;
var state_19090__$1 = (function (){var statearr_19101 = state_19090;
(statearr_19101[(7)] = inst_19070);

return statearr_19101;
})();
var statearr_19102_19119 = state_19090__$1;
(statearr_19102_19119[(2)] = null);

(statearr_19102_19119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (5))){
var inst_19070 = (state_19090[(7)]);
var state_19090__$1 = state_19090;
var statearr_19103_19120 = state_19090__$1;
(statearr_19103_19120[(2)] = inst_19070);

(statearr_19103_19120[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (10))){
var inst_19084 = (state_19090[(2)]);
var state_19090__$1 = state_19090;
var statearr_19104_19121 = state_19090__$1;
(statearr_19104_19121[(2)] = inst_19084);

(statearr_19104_19121[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19091 === (8))){
var inst_19077 = (state_19090[(9)]);
var inst_19080 = cljs.core.deref.call(null,inst_19077);
var state_19090__$1 = state_19090;
var statearr_19105_19122 = state_19090__$1;
(statearr_19105_19122[(2)] = inst_19080);

(statearr_19105_19122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto__))
;
return ((function (switch__18220__auto__,c__18332__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18221__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18221__auto____0 = (function (){
var statearr_19109 = [null,null,null,null,null,null,null,null,null,null];
(statearr_19109[(0)] = cljs$core$async$reduce_$_state_machine__18221__auto__);

(statearr_19109[(1)] = (1));

return statearr_19109;
});
var cljs$core$async$reduce_$_state_machine__18221__auto____1 = (function (state_19090){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_19090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e19110){if((e19110 instanceof Object)){
var ex__18224__auto__ = e19110;
var statearr_19111_19123 = state_19090;
(statearr_19111_19123[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19090);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19124 = state_19090;
state_19090 = G__19124;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18221__auto__ = function(state_19090){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18221__auto____1.call(this,state_19090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18221__auto____0;
cljs$core$async$reduce_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18221__auto____1;
return cljs$core$async$reduce_$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__))
})();
var state__18334__auto__ = (function (){var statearr_19112 = f__18333__auto__.call(null);
(statearr_19112[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_19112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__))
);

return c__18332__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args19125 = [];
var len__7276__auto___19177 = arguments.length;
var i__7277__auto___19178 = (0);
while(true){
if((i__7277__auto___19178 < len__7276__auto___19177)){
args19125.push((arguments[i__7277__auto___19178]));

var G__19179 = (i__7277__auto___19178 + (1));
i__7277__auto___19178 = G__19179;
continue;
} else {
}
break;
}

var G__19127 = args19125.length;
switch (G__19127) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19125.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__){
return (function (state_19152){
var state_val_19153 = (state_19152[(1)]);
if((state_val_19153 === (7))){
var inst_19134 = (state_19152[(2)]);
var state_19152__$1 = state_19152;
var statearr_19154_19181 = state_19152__$1;
(statearr_19154_19181[(2)] = inst_19134);

(statearr_19154_19181[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (1))){
var inst_19128 = cljs.core.seq.call(null,coll);
var inst_19129 = inst_19128;
var state_19152__$1 = (function (){var statearr_19155 = state_19152;
(statearr_19155[(7)] = inst_19129);

return statearr_19155;
})();
var statearr_19156_19182 = state_19152__$1;
(statearr_19156_19182[(2)] = null);

(statearr_19156_19182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (4))){
var inst_19129 = (state_19152[(7)]);
var inst_19132 = cljs.core.first.call(null,inst_19129);
var state_19152__$1 = state_19152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19152__$1,(7),ch,inst_19132);
} else {
if((state_val_19153 === (13))){
var inst_19146 = (state_19152[(2)]);
var state_19152__$1 = state_19152;
var statearr_19157_19183 = state_19152__$1;
(statearr_19157_19183[(2)] = inst_19146);

(statearr_19157_19183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (6))){
var inst_19137 = (state_19152[(2)]);
var state_19152__$1 = state_19152;
if(cljs.core.truth_(inst_19137)){
var statearr_19158_19184 = state_19152__$1;
(statearr_19158_19184[(1)] = (8));

} else {
var statearr_19159_19185 = state_19152__$1;
(statearr_19159_19185[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (3))){
var inst_19150 = (state_19152[(2)]);
var state_19152__$1 = state_19152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19152__$1,inst_19150);
} else {
if((state_val_19153 === (12))){
var state_19152__$1 = state_19152;
var statearr_19160_19186 = state_19152__$1;
(statearr_19160_19186[(2)] = null);

(statearr_19160_19186[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (2))){
var inst_19129 = (state_19152[(7)]);
var state_19152__$1 = state_19152;
if(cljs.core.truth_(inst_19129)){
var statearr_19161_19187 = state_19152__$1;
(statearr_19161_19187[(1)] = (4));

} else {
var statearr_19162_19188 = state_19152__$1;
(statearr_19162_19188[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (11))){
var inst_19143 = cljs.core.async.close_BANG_.call(null,ch);
var state_19152__$1 = state_19152;
var statearr_19163_19189 = state_19152__$1;
(statearr_19163_19189[(2)] = inst_19143);

(statearr_19163_19189[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (9))){
var state_19152__$1 = state_19152;
if(cljs.core.truth_(close_QMARK_)){
var statearr_19164_19190 = state_19152__$1;
(statearr_19164_19190[(1)] = (11));

} else {
var statearr_19165_19191 = state_19152__$1;
(statearr_19165_19191[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (5))){
var inst_19129 = (state_19152[(7)]);
var state_19152__$1 = state_19152;
var statearr_19166_19192 = state_19152__$1;
(statearr_19166_19192[(2)] = inst_19129);

(statearr_19166_19192[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (10))){
var inst_19148 = (state_19152[(2)]);
var state_19152__$1 = state_19152;
var statearr_19167_19193 = state_19152__$1;
(statearr_19167_19193[(2)] = inst_19148);

(statearr_19167_19193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19153 === (8))){
var inst_19129 = (state_19152[(7)]);
var inst_19139 = cljs.core.next.call(null,inst_19129);
var inst_19129__$1 = inst_19139;
var state_19152__$1 = (function (){var statearr_19168 = state_19152;
(statearr_19168[(7)] = inst_19129__$1);

return statearr_19168;
})();
var statearr_19169_19194 = state_19152__$1;
(statearr_19169_19194[(2)] = null);

(statearr_19169_19194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto__))
;
return ((function (switch__18220__auto__,c__18332__auto__){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_19173 = [null,null,null,null,null,null,null,null];
(statearr_19173[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_19173[(1)] = (1));

return statearr_19173;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_19152){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_19152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e19174){if((e19174 instanceof Object)){
var ex__18224__auto__ = e19174;
var statearr_19175_19195 = state_19152;
(statearr_19175_19195[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19174;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19196 = state_19152;
state_19152 = G__19196;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_19152){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_19152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__))
})();
var state__18334__auto__ = (function (){var statearr_19176 = f__18333__auto__.call(null);
(statearr_19176[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_19176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__))
);

return c__18332__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6870__auto__ = (((_ == null))?null:_);
var m__6871__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,_);
} else {
var m__6871__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__6871__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m);
} else {
var m__6871__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19418 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19418 = (function (mult,ch,cs,meta19419){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta19419 = meta19419;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19420,meta19419__$1){
var self__ = this;
var _19420__$1 = this;
return (new cljs.core.async.t_cljs$core$async19418(self__.mult,self__.ch,self__.cs,meta19419__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19420){
var self__ = this;
var _19420__$1 = this;
return self__.meta19419;
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta19419","meta19419",1834465236,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19418.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19418.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19418";

cljs.core.async.t_cljs$core$async19418.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async19418");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19418 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19418(mult__$1,ch__$1,cs__$1,meta19419){
return (new cljs.core.async.t_cljs$core$async19418(mult__$1,ch__$1,cs__$1,meta19419));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19418(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18332__auto___19639 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___19639,cs,m,dchan,dctr,done){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___19639,cs,m,dchan,dctr,done){
return (function (state_19551){
var state_val_19552 = (state_19551[(1)]);
if((state_val_19552 === (7))){
var inst_19547 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19553_19640 = state_19551__$1;
(statearr_19553_19640[(2)] = inst_19547);

(statearr_19553_19640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (20))){
var inst_19452 = (state_19551[(7)]);
var inst_19462 = cljs.core.first.call(null,inst_19452);
var inst_19463 = cljs.core.nth.call(null,inst_19462,(0),null);
var inst_19464 = cljs.core.nth.call(null,inst_19462,(1),null);
var state_19551__$1 = (function (){var statearr_19554 = state_19551;
(statearr_19554[(8)] = inst_19463);

return statearr_19554;
})();
if(cljs.core.truth_(inst_19464)){
var statearr_19555_19641 = state_19551__$1;
(statearr_19555_19641[(1)] = (22));

} else {
var statearr_19556_19642 = state_19551__$1;
(statearr_19556_19642[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (27))){
var inst_19499 = (state_19551[(9)]);
var inst_19492 = (state_19551[(10)]);
var inst_19494 = (state_19551[(11)]);
var inst_19423 = (state_19551[(12)]);
var inst_19499__$1 = cljs.core._nth.call(null,inst_19492,inst_19494);
var inst_19500 = cljs.core.async.put_BANG_.call(null,inst_19499__$1,inst_19423,done);
var state_19551__$1 = (function (){var statearr_19557 = state_19551;
(statearr_19557[(9)] = inst_19499__$1);

return statearr_19557;
})();
if(cljs.core.truth_(inst_19500)){
var statearr_19558_19643 = state_19551__$1;
(statearr_19558_19643[(1)] = (30));

} else {
var statearr_19559_19644 = state_19551__$1;
(statearr_19559_19644[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (1))){
var state_19551__$1 = state_19551;
var statearr_19560_19645 = state_19551__$1;
(statearr_19560_19645[(2)] = null);

(statearr_19560_19645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (24))){
var inst_19452 = (state_19551[(7)]);
var inst_19469 = (state_19551[(2)]);
var inst_19470 = cljs.core.next.call(null,inst_19452);
var inst_19432 = inst_19470;
var inst_19433 = null;
var inst_19434 = (0);
var inst_19435 = (0);
var state_19551__$1 = (function (){var statearr_19561 = state_19551;
(statearr_19561[(13)] = inst_19432);

(statearr_19561[(14)] = inst_19469);

(statearr_19561[(15)] = inst_19433);

(statearr_19561[(16)] = inst_19435);

(statearr_19561[(17)] = inst_19434);

return statearr_19561;
})();
var statearr_19562_19646 = state_19551__$1;
(statearr_19562_19646[(2)] = null);

(statearr_19562_19646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (39))){
var state_19551__$1 = state_19551;
var statearr_19566_19647 = state_19551__$1;
(statearr_19566_19647[(2)] = null);

(statearr_19566_19647[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (4))){
var inst_19423 = (state_19551[(12)]);
var inst_19423__$1 = (state_19551[(2)]);
var inst_19424 = (inst_19423__$1 == null);
var state_19551__$1 = (function (){var statearr_19567 = state_19551;
(statearr_19567[(12)] = inst_19423__$1);

return statearr_19567;
})();
if(cljs.core.truth_(inst_19424)){
var statearr_19568_19648 = state_19551__$1;
(statearr_19568_19648[(1)] = (5));

} else {
var statearr_19569_19649 = state_19551__$1;
(statearr_19569_19649[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (15))){
var inst_19432 = (state_19551[(13)]);
var inst_19433 = (state_19551[(15)]);
var inst_19435 = (state_19551[(16)]);
var inst_19434 = (state_19551[(17)]);
var inst_19448 = (state_19551[(2)]);
var inst_19449 = (inst_19435 + (1));
var tmp19563 = inst_19432;
var tmp19564 = inst_19433;
var tmp19565 = inst_19434;
var inst_19432__$1 = tmp19563;
var inst_19433__$1 = tmp19564;
var inst_19434__$1 = tmp19565;
var inst_19435__$1 = inst_19449;
var state_19551__$1 = (function (){var statearr_19570 = state_19551;
(statearr_19570[(13)] = inst_19432__$1);

(statearr_19570[(15)] = inst_19433__$1);

(statearr_19570[(16)] = inst_19435__$1);

(statearr_19570[(17)] = inst_19434__$1);

(statearr_19570[(18)] = inst_19448);

return statearr_19570;
})();
var statearr_19571_19650 = state_19551__$1;
(statearr_19571_19650[(2)] = null);

(statearr_19571_19650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (21))){
var inst_19473 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19575_19651 = state_19551__$1;
(statearr_19575_19651[(2)] = inst_19473);

(statearr_19575_19651[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (31))){
var inst_19499 = (state_19551[(9)]);
var inst_19503 = done.call(null,null);
var inst_19504 = cljs.core.async.untap_STAR_.call(null,m,inst_19499);
var state_19551__$1 = (function (){var statearr_19576 = state_19551;
(statearr_19576[(19)] = inst_19503);

return statearr_19576;
})();
var statearr_19577_19652 = state_19551__$1;
(statearr_19577_19652[(2)] = inst_19504);

(statearr_19577_19652[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (32))){
var inst_19492 = (state_19551[(10)]);
var inst_19493 = (state_19551[(20)]);
var inst_19494 = (state_19551[(11)]);
var inst_19491 = (state_19551[(21)]);
var inst_19506 = (state_19551[(2)]);
var inst_19507 = (inst_19494 + (1));
var tmp19572 = inst_19492;
var tmp19573 = inst_19493;
var tmp19574 = inst_19491;
var inst_19491__$1 = tmp19574;
var inst_19492__$1 = tmp19572;
var inst_19493__$1 = tmp19573;
var inst_19494__$1 = inst_19507;
var state_19551__$1 = (function (){var statearr_19578 = state_19551;
(statearr_19578[(10)] = inst_19492__$1);

(statearr_19578[(20)] = inst_19493__$1);

(statearr_19578[(11)] = inst_19494__$1);

(statearr_19578[(22)] = inst_19506);

(statearr_19578[(21)] = inst_19491__$1);

return statearr_19578;
})();
var statearr_19579_19653 = state_19551__$1;
(statearr_19579_19653[(2)] = null);

(statearr_19579_19653[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (40))){
var inst_19519 = (state_19551[(23)]);
var inst_19523 = done.call(null,null);
var inst_19524 = cljs.core.async.untap_STAR_.call(null,m,inst_19519);
var state_19551__$1 = (function (){var statearr_19580 = state_19551;
(statearr_19580[(24)] = inst_19523);

return statearr_19580;
})();
var statearr_19581_19654 = state_19551__$1;
(statearr_19581_19654[(2)] = inst_19524);

(statearr_19581_19654[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (33))){
var inst_19510 = (state_19551[(25)]);
var inst_19512 = cljs.core.chunked_seq_QMARK_.call(null,inst_19510);
var state_19551__$1 = state_19551;
if(inst_19512){
var statearr_19582_19655 = state_19551__$1;
(statearr_19582_19655[(1)] = (36));

} else {
var statearr_19583_19656 = state_19551__$1;
(statearr_19583_19656[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (13))){
var inst_19442 = (state_19551[(26)]);
var inst_19445 = cljs.core.async.close_BANG_.call(null,inst_19442);
var state_19551__$1 = state_19551;
var statearr_19584_19657 = state_19551__$1;
(statearr_19584_19657[(2)] = inst_19445);

(statearr_19584_19657[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (22))){
var inst_19463 = (state_19551[(8)]);
var inst_19466 = cljs.core.async.close_BANG_.call(null,inst_19463);
var state_19551__$1 = state_19551;
var statearr_19585_19658 = state_19551__$1;
(statearr_19585_19658[(2)] = inst_19466);

(statearr_19585_19658[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (36))){
var inst_19510 = (state_19551[(25)]);
var inst_19514 = cljs.core.chunk_first.call(null,inst_19510);
var inst_19515 = cljs.core.chunk_rest.call(null,inst_19510);
var inst_19516 = cljs.core.count.call(null,inst_19514);
var inst_19491 = inst_19515;
var inst_19492 = inst_19514;
var inst_19493 = inst_19516;
var inst_19494 = (0);
var state_19551__$1 = (function (){var statearr_19586 = state_19551;
(statearr_19586[(10)] = inst_19492);

(statearr_19586[(20)] = inst_19493);

(statearr_19586[(11)] = inst_19494);

(statearr_19586[(21)] = inst_19491);

return statearr_19586;
})();
var statearr_19587_19659 = state_19551__$1;
(statearr_19587_19659[(2)] = null);

(statearr_19587_19659[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (41))){
var inst_19510 = (state_19551[(25)]);
var inst_19526 = (state_19551[(2)]);
var inst_19527 = cljs.core.next.call(null,inst_19510);
var inst_19491 = inst_19527;
var inst_19492 = null;
var inst_19493 = (0);
var inst_19494 = (0);
var state_19551__$1 = (function (){var statearr_19588 = state_19551;
(statearr_19588[(27)] = inst_19526);

(statearr_19588[(10)] = inst_19492);

(statearr_19588[(20)] = inst_19493);

(statearr_19588[(11)] = inst_19494);

(statearr_19588[(21)] = inst_19491);

return statearr_19588;
})();
var statearr_19589_19660 = state_19551__$1;
(statearr_19589_19660[(2)] = null);

(statearr_19589_19660[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (43))){
var state_19551__$1 = state_19551;
var statearr_19590_19661 = state_19551__$1;
(statearr_19590_19661[(2)] = null);

(statearr_19590_19661[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (29))){
var inst_19535 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19591_19662 = state_19551__$1;
(statearr_19591_19662[(2)] = inst_19535);

(statearr_19591_19662[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (44))){
var inst_19544 = (state_19551[(2)]);
var state_19551__$1 = (function (){var statearr_19592 = state_19551;
(statearr_19592[(28)] = inst_19544);

return statearr_19592;
})();
var statearr_19593_19663 = state_19551__$1;
(statearr_19593_19663[(2)] = null);

(statearr_19593_19663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (6))){
var inst_19483 = (state_19551[(29)]);
var inst_19482 = cljs.core.deref.call(null,cs);
var inst_19483__$1 = cljs.core.keys.call(null,inst_19482);
var inst_19484 = cljs.core.count.call(null,inst_19483__$1);
var inst_19485 = cljs.core.reset_BANG_.call(null,dctr,inst_19484);
var inst_19490 = cljs.core.seq.call(null,inst_19483__$1);
var inst_19491 = inst_19490;
var inst_19492 = null;
var inst_19493 = (0);
var inst_19494 = (0);
var state_19551__$1 = (function (){var statearr_19594 = state_19551;
(statearr_19594[(30)] = inst_19485);

(statearr_19594[(10)] = inst_19492);

(statearr_19594[(20)] = inst_19493);

(statearr_19594[(11)] = inst_19494);

(statearr_19594[(29)] = inst_19483__$1);

(statearr_19594[(21)] = inst_19491);

return statearr_19594;
})();
var statearr_19595_19664 = state_19551__$1;
(statearr_19595_19664[(2)] = null);

(statearr_19595_19664[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (28))){
var inst_19510 = (state_19551[(25)]);
var inst_19491 = (state_19551[(21)]);
var inst_19510__$1 = cljs.core.seq.call(null,inst_19491);
var state_19551__$1 = (function (){var statearr_19596 = state_19551;
(statearr_19596[(25)] = inst_19510__$1);

return statearr_19596;
})();
if(inst_19510__$1){
var statearr_19597_19665 = state_19551__$1;
(statearr_19597_19665[(1)] = (33));

} else {
var statearr_19598_19666 = state_19551__$1;
(statearr_19598_19666[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (25))){
var inst_19493 = (state_19551[(20)]);
var inst_19494 = (state_19551[(11)]);
var inst_19496 = (inst_19494 < inst_19493);
var inst_19497 = inst_19496;
var state_19551__$1 = state_19551;
if(cljs.core.truth_(inst_19497)){
var statearr_19599_19667 = state_19551__$1;
(statearr_19599_19667[(1)] = (27));

} else {
var statearr_19600_19668 = state_19551__$1;
(statearr_19600_19668[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (34))){
var state_19551__$1 = state_19551;
var statearr_19601_19669 = state_19551__$1;
(statearr_19601_19669[(2)] = null);

(statearr_19601_19669[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (17))){
var state_19551__$1 = state_19551;
var statearr_19602_19670 = state_19551__$1;
(statearr_19602_19670[(2)] = null);

(statearr_19602_19670[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (3))){
var inst_19549 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19551__$1,inst_19549);
} else {
if((state_val_19552 === (12))){
var inst_19478 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19603_19671 = state_19551__$1;
(statearr_19603_19671[(2)] = inst_19478);

(statearr_19603_19671[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (2))){
var state_19551__$1 = state_19551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19551__$1,(4),ch);
} else {
if((state_val_19552 === (23))){
var state_19551__$1 = state_19551;
var statearr_19604_19672 = state_19551__$1;
(statearr_19604_19672[(2)] = null);

(statearr_19604_19672[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (35))){
var inst_19533 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19605_19673 = state_19551__$1;
(statearr_19605_19673[(2)] = inst_19533);

(statearr_19605_19673[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (19))){
var inst_19452 = (state_19551[(7)]);
var inst_19456 = cljs.core.chunk_first.call(null,inst_19452);
var inst_19457 = cljs.core.chunk_rest.call(null,inst_19452);
var inst_19458 = cljs.core.count.call(null,inst_19456);
var inst_19432 = inst_19457;
var inst_19433 = inst_19456;
var inst_19434 = inst_19458;
var inst_19435 = (0);
var state_19551__$1 = (function (){var statearr_19606 = state_19551;
(statearr_19606[(13)] = inst_19432);

(statearr_19606[(15)] = inst_19433);

(statearr_19606[(16)] = inst_19435);

(statearr_19606[(17)] = inst_19434);

return statearr_19606;
})();
var statearr_19607_19674 = state_19551__$1;
(statearr_19607_19674[(2)] = null);

(statearr_19607_19674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (11))){
var inst_19452 = (state_19551[(7)]);
var inst_19432 = (state_19551[(13)]);
var inst_19452__$1 = cljs.core.seq.call(null,inst_19432);
var state_19551__$1 = (function (){var statearr_19608 = state_19551;
(statearr_19608[(7)] = inst_19452__$1);

return statearr_19608;
})();
if(inst_19452__$1){
var statearr_19609_19675 = state_19551__$1;
(statearr_19609_19675[(1)] = (16));

} else {
var statearr_19610_19676 = state_19551__$1;
(statearr_19610_19676[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (9))){
var inst_19480 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19611_19677 = state_19551__$1;
(statearr_19611_19677[(2)] = inst_19480);

(statearr_19611_19677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (5))){
var inst_19430 = cljs.core.deref.call(null,cs);
var inst_19431 = cljs.core.seq.call(null,inst_19430);
var inst_19432 = inst_19431;
var inst_19433 = null;
var inst_19434 = (0);
var inst_19435 = (0);
var state_19551__$1 = (function (){var statearr_19612 = state_19551;
(statearr_19612[(13)] = inst_19432);

(statearr_19612[(15)] = inst_19433);

(statearr_19612[(16)] = inst_19435);

(statearr_19612[(17)] = inst_19434);

return statearr_19612;
})();
var statearr_19613_19678 = state_19551__$1;
(statearr_19613_19678[(2)] = null);

(statearr_19613_19678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (14))){
var state_19551__$1 = state_19551;
var statearr_19614_19679 = state_19551__$1;
(statearr_19614_19679[(2)] = null);

(statearr_19614_19679[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (45))){
var inst_19541 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19615_19680 = state_19551__$1;
(statearr_19615_19680[(2)] = inst_19541);

(statearr_19615_19680[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (26))){
var inst_19483 = (state_19551[(29)]);
var inst_19537 = (state_19551[(2)]);
var inst_19538 = cljs.core.seq.call(null,inst_19483);
var state_19551__$1 = (function (){var statearr_19616 = state_19551;
(statearr_19616[(31)] = inst_19537);

return statearr_19616;
})();
if(inst_19538){
var statearr_19617_19681 = state_19551__$1;
(statearr_19617_19681[(1)] = (42));

} else {
var statearr_19618_19682 = state_19551__$1;
(statearr_19618_19682[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (16))){
var inst_19452 = (state_19551[(7)]);
var inst_19454 = cljs.core.chunked_seq_QMARK_.call(null,inst_19452);
var state_19551__$1 = state_19551;
if(inst_19454){
var statearr_19619_19683 = state_19551__$1;
(statearr_19619_19683[(1)] = (19));

} else {
var statearr_19620_19684 = state_19551__$1;
(statearr_19620_19684[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (38))){
var inst_19530 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19621_19685 = state_19551__$1;
(statearr_19621_19685[(2)] = inst_19530);

(statearr_19621_19685[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (30))){
var state_19551__$1 = state_19551;
var statearr_19622_19686 = state_19551__$1;
(statearr_19622_19686[(2)] = null);

(statearr_19622_19686[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (10))){
var inst_19433 = (state_19551[(15)]);
var inst_19435 = (state_19551[(16)]);
var inst_19441 = cljs.core._nth.call(null,inst_19433,inst_19435);
var inst_19442 = cljs.core.nth.call(null,inst_19441,(0),null);
var inst_19443 = cljs.core.nth.call(null,inst_19441,(1),null);
var state_19551__$1 = (function (){var statearr_19623 = state_19551;
(statearr_19623[(26)] = inst_19442);

return statearr_19623;
})();
if(cljs.core.truth_(inst_19443)){
var statearr_19624_19687 = state_19551__$1;
(statearr_19624_19687[(1)] = (13));

} else {
var statearr_19625_19688 = state_19551__$1;
(statearr_19625_19688[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (18))){
var inst_19476 = (state_19551[(2)]);
var state_19551__$1 = state_19551;
var statearr_19626_19689 = state_19551__$1;
(statearr_19626_19689[(2)] = inst_19476);

(statearr_19626_19689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (42))){
var state_19551__$1 = state_19551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19551__$1,(45),dchan);
} else {
if((state_val_19552 === (37))){
var inst_19510 = (state_19551[(25)]);
var inst_19519 = (state_19551[(23)]);
var inst_19423 = (state_19551[(12)]);
var inst_19519__$1 = cljs.core.first.call(null,inst_19510);
var inst_19520 = cljs.core.async.put_BANG_.call(null,inst_19519__$1,inst_19423,done);
var state_19551__$1 = (function (){var statearr_19627 = state_19551;
(statearr_19627[(23)] = inst_19519__$1);

return statearr_19627;
})();
if(cljs.core.truth_(inst_19520)){
var statearr_19628_19690 = state_19551__$1;
(statearr_19628_19690[(1)] = (39));

} else {
var statearr_19629_19691 = state_19551__$1;
(statearr_19629_19691[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19552 === (8))){
var inst_19435 = (state_19551[(16)]);
var inst_19434 = (state_19551[(17)]);
var inst_19437 = (inst_19435 < inst_19434);
var inst_19438 = inst_19437;
var state_19551__$1 = state_19551;
if(cljs.core.truth_(inst_19438)){
var statearr_19630_19692 = state_19551__$1;
(statearr_19630_19692[(1)] = (10));

} else {
var statearr_19631_19693 = state_19551__$1;
(statearr_19631_19693[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___19639,cs,m,dchan,dctr,done))
;
return ((function (switch__18220__auto__,c__18332__auto___19639,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18221__auto__ = null;
var cljs$core$async$mult_$_state_machine__18221__auto____0 = (function (){
var statearr_19635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19635[(0)] = cljs$core$async$mult_$_state_machine__18221__auto__);

(statearr_19635[(1)] = (1));

return statearr_19635;
});
var cljs$core$async$mult_$_state_machine__18221__auto____1 = (function (state_19551){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_19551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e19636){if((e19636 instanceof Object)){
var ex__18224__auto__ = e19636;
var statearr_19637_19694 = state_19551;
(statearr_19637_19694[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19636;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19695 = state_19551;
state_19551 = G__19695;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18221__auto__ = function(state_19551){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18221__auto____1.call(this,state_19551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18221__auto____0;
cljs$core$async$mult_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18221__auto____1;
return cljs$core$async$mult_$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___19639,cs,m,dchan,dctr,done))
})();
var state__18334__auto__ = (function (){var statearr_19638 = f__18333__auto__.call(null);
(statearr_19638[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___19639);

return statearr_19638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___19639,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args19696 = [];
var len__7276__auto___19699 = arguments.length;
var i__7277__auto___19700 = (0);
while(true){
if((i__7277__auto___19700 < len__7276__auto___19699)){
args19696.push((arguments[i__7277__auto___19700]));

var G__19701 = (i__7277__auto___19700 + (1));
i__7277__auto___19700 = G__19701;
continue;
} else {
}
break;
}

var G__19698 = args19696.length;
switch (G__19698) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19696.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m);
} else {
var m__6871__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,state_map);
} else {
var m__6871__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6870__auto__ = (((m == null))?null:m);
var m__6871__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,m,mode);
} else {
var m__6871__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7283__auto__ = [];
var len__7276__auto___19713 = arguments.length;
var i__7277__auto___19714 = (0);
while(true){
if((i__7277__auto___19714 < len__7276__auto___19713)){
args__7283__auto__.push((arguments[i__7277__auto___19714]));

var G__19715 = (i__7277__auto___19714 + (1));
i__7277__auto___19714 = G__19715;
continue;
} else {
}
break;
}

var argseq__7284__auto__ = ((((3) < args__7283__auto__.length))?(new cljs.core.IndexedSeq(args__7283__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7284__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19707){
var map__19708 = p__19707;
var map__19708__$1 = ((((!((map__19708 == null)))?((((map__19708.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19708.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19708):map__19708);
var opts = map__19708__$1;
var statearr_19710_19716 = state;
(statearr_19710_19716[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__19708,map__19708__$1,opts){
return (function (val){
var statearr_19711_19717 = state;
(statearr_19711_19717[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__19708,map__19708__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_19712_19718 = state;
(statearr_19712_19718[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19703){
var G__19704 = cljs.core.first.call(null,seq19703);
var seq19703__$1 = cljs.core.next.call(null,seq19703);
var G__19705 = cljs.core.first.call(null,seq19703__$1);
var seq19703__$2 = cljs.core.next.call(null,seq19703__$1);
var G__19706 = cljs.core.first.call(null,seq19703__$2);
var seq19703__$3 = cljs.core.next.call(null,seq19703__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19704,G__19705,G__19706,seq19703__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19882 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19882 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta19883){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta19883 = meta19883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19884,meta19883__$1){
var self__ = this;
var _19884__$1 = this;
return (new cljs.core.async.t_cljs$core$async19882(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta19883__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19884){
var self__ = this;
var _19884__$1 = this;
return self__.meta19883;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta19883","meta19883",1613198559,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19882.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19882";

cljs.core.async.t_cljs$core$async19882.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async19882");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19882 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19882(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19883){
return (new cljs.core.async.t_cljs$core$async19882(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta19883));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19882(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18332__auto___20045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19982){
var state_val_19983 = (state_19982[(1)]);
if((state_val_19983 === (7))){
var inst_19900 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_19984_20046 = state_19982__$1;
(statearr_19984_20046[(2)] = inst_19900);

(statearr_19984_20046[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (20))){
var inst_19912 = (state_19982[(7)]);
var state_19982__$1 = state_19982;
var statearr_19985_20047 = state_19982__$1;
(statearr_19985_20047[(2)] = inst_19912);

(statearr_19985_20047[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (27))){
var state_19982__$1 = state_19982;
var statearr_19986_20048 = state_19982__$1;
(statearr_19986_20048[(2)] = null);

(statearr_19986_20048[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (1))){
var inst_19888 = (state_19982[(8)]);
var inst_19888__$1 = calc_state.call(null);
var inst_19890 = (inst_19888__$1 == null);
var inst_19891 = cljs.core.not.call(null,inst_19890);
var state_19982__$1 = (function (){var statearr_19987 = state_19982;
(statearr_19987[(8)] = inst_19888__$1);

return statearr_19987;
})();
if(inst_19891){
var statearr_19988_20049 = state_19982__$1;
(statearr_19988_20049[(1)] = (2));

} else {
var statearr_19989_20050 = state_19982__$1;
(statearr_19989_20050[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (24))){
var inst_19942 = (state_19982[(9)]);
var inst_19956 = (state_19982[(10)]);
var inst_19935 = (state_19982[(11)]);
var inst_19956__$1 = inst_19935.call(null,inst_19942);
var state_19982__$1 = (function (){var statearr_19990 = state_19982;
(statearr_19990[(10)] = inst_19956__$1);

return statearr_19990;
})();
if(cljs.core.truth_(inst_19956__$1)){
var statearr_19991_20051 = state_19982__$1;
(statearr_19991_20051[(1)] = (29));

} else {
var statearr_19992_20052 = state_19982__$1;
(statearr_19992_20052[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (4))){
var inst_19903 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19903)){
var statearr_19993_20053 = state_19982__$1;
(statearr_19993_20053[(1)] = (8));

} else {
var statearr_19994_20054 = state_19982__$1;
(statearr_19994_20054[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (15))){
var inst_19929 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19929)){
var statearr_19995_20055 = state_19982__$1;
(statearr_19995_20055[(1)] = (19));

} else {
var statearr_19996_20056 = state_19982__$1;
(statearr_19996_20056[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (21))){
var inst_19934 = (state_19982[(12)]);
var inst_19934__$1 = (state_19982[(2)]);
var inst_19935 = cljs.core.get.call(null,inst_19934__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19936 = cljs.core.get.call(null,inst_19934__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19937 = cljs.core.get.call(null,inst_19934__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_19982__$1 = (function (){var statearr_19997 = state_19982;
(statearr_19997[(13)] = inst_19936);

(statearr_19997[(11)] = inst_19935);

(statearr_19997[(12)] = inst_19934__$1);

return statearr_19997;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_19982__$1,(22),inst_19937);
} else {
if((state_val_19983 === (31))){
var inst_19964 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19964)){
var statearr_19998_20057 = state_19982__$1;
(statearr_19998_20057[(1)] = (32));

} else {
var statearr_19999_20058 = state_19982__$1;
(statearr_19999_20058[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (32))){
var inst_19941 = (state_19982[(14)]);
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19982__$1,(35),out,inst_19941);
} else {
if((state_val_19983 === (33))){
var inst_19934 = (state_19982[(12)]);
var inst_19912 = inst_19934;
var state_19982__$1 = (function (){var statearr_20000 = state_19982;
(statearr_20000[(7)] = inst_19912);

return statearr_20000;
})();
var statearr_20001_20059 = state_19982__$1;
(statearr_20001_20059[(2)] = null);

(statearr_20001_20059[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (13))){
var inst_19912 = (state_19982[(7)]);
var inst_19919 = inst_19912.cljs$lang$protocol_mask$partition0$;
var inst_19920 = (inst_19919 & (64));
var inst_19921 = inst_19912.cljs$core$ISeq$;
var inst_19922 = (inst_19920) || (inst_19921);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19922)){
var statearr_20002_20060 = state_19982__$1;
(statearr_20002_20060[(1)] = (16));

} else {
var statearr_20003_20061 = state_19982__$1;
(statearr_20003_20061[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (22))){
var inst_19941 = (state_19982[(14)]);
var inst_19942 = (state_19982[(9)]);
var inst_19940 = (state_19982[(2)]);
var inst_19941__$1 = cljs.core.nth.call(null,inst_19940,(0),null);
var inst_19942__$1 = cljs.core.nth.call(null,inst_19940,(1),null);
var inst_19943 = (inst_19941__$1 == null);
var inst_19944 = cljs.core._EQ_.call(null,inst_19942__$1,change);
var inst_19945 = (inst_19943) || (inst_19944);
var state_19982__$1 = (function (){var statearr_20004 = state_19982;
(statearr_20004[(14)] = inst_19941__$1);

(statearr_20004[(9)] = inst_19942__$1);

return statearr_20004;
})();
if(cljs.core.truth_(inst_19945)){
var statearr_20005_20062 = state_19982__$1;
(statearr_20005_20062[(1)] = (23));

} else {
var statearr_20006_20063 = state_19982__$1;
(statearr_20006_20063[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (36))){
var inst_19934 = (state_19982[(12)]);
var inst_19912 = inst_19934;
var state_19982__$1 = (function (){var statearr_20007 = state_19982;
(statearr_20007[(7)] = inst_19912);

return statearr_20007;
})();
var statearr_20008_20064 = state_19982__$1;
(statearr_20008_20064[(2)] = null);

(statearr_20008_20064[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (29))){
var inst_19956 = (state_19982[(10)]);
var state_19982__$1 = state_19982;
var statearr_20009_20065 = state_19982__$1;
(statearr_20009_20065[(2)] = inst_19956);

(statearr_20009_20065[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (6))){
var state_19982__$1 = state_19982;
var statearr_20010_20066 = state_19982__$1;
(statearr_20010_20066[(2)] = false);

(statearr_20010_20066[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (28))){
var inst_19952 = (state_19982[(2)]);
var inst_19953 = calc_state.call(null);
var inst_19912 = inst_19953;
var state_19982__$1 = (function (){var statearr_20011 = state_19982;
(statearr_20011[(7)] = inst_19912);

(statearr_20011[(15)] = inst_19952);

return statearr_20011;
})();
var statearr_20012_20067 = state_19982__$1;
(statearr_20012_20067[(2)] = null);

(statearr_20012_20067[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (25))){
var inst_19978 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_20013_20068 = state_19982__$1;
(statearr_20013_20068[(2)] = inst_19978);

(statearr_20013_20068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (34))){
var inst_19976 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_20014_20069 = state_19982__$1;
(statearr_20014_20069[(2)] = inst_19976);

(statearr_20014_20069[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (17))){
var state_19982__$1 = state_19982;
var statearr_20015_20070 = state_19982__$1;
(statearr_20015_20070[(2)] = false);

(statearr_20015_20070[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (3))){
var state_19982__$1 = state_19982;
var statearr_20016_20071 = state_19982__$1;
(statearr_20016_20071[(2)] = false);

(statearr_20016_20071[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (12))){
var inst_19980 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19982__$1,inst_19980);
} else {
if((state_val_19983 === (2))){
var inst_19888 = (state_19982[(8)]);
var inst_19893 = inst_19888.cljs$lang$protocol_mask$partition0$;
var inst_19894 = (inst_19893 & (64));
var inst_19895 = inst_19888.cljs$core$ISeq$;
var inst_19896 = (inst_19894) || (inst_19895);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19896)){
var statearr_20017_20072 = state_19982__$1;
(statearr_20017_20072[(1)] = (5));

} else {
var statearr_20018_20073 = state_19982__$1;
(statearr_20018_20073[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (23))){
var inst_19941 = (state_19982[(14)]);
var inst_19947 = (inst_19941 == null);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19947)){
var statearr_20019_20074 = state_19982__$1;
(statearr_20019_20074[(1)] = (26));

} else {
var statearr_20020_20075 = state_19982__$1;
(statearr_20020_20075[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (35))){
var inst_19967 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
if(cljs.core.truth_(inst_19967)){
var statearr_20021_20076 = state_19982__$1;
(statearr_20021_20076[(1)] = (36));

} else {
var statearr_20022_20077 = state_19982__$1;
(statearr_20022_20077[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (19))){
var inst_19912 = (state_19982[(7)]);
var inst_19931 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19912);
var state_19982__$1 = state_19982;
var statearr_20023_20078 = state_19982__$1;
(statearr_20023_20078[(2)] = inst_19931);

(statearr_20023_20078[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (11))){
var inst_19912 = (state_19982[(7)]);
var inst_19916 = (inst_19912 == null);
var inst_19917 = cljs.core.not.call(null,inst_19916);
var state_19982__$1 = state_19982;
if(inst_19917){
var statearr_20024_20079 = state_19982__$1;
(statearr_20024_20079[(1)] = (13));

} else {
var statearr_20025_20080 = state_19982__$1;
(statearr_20025_20080[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (9))){
var inst_19888 = (state_19982[(8)]);
var state_19982__$1 = state_19982;
var statearr_20026_20081 = state_19982__$1;
(statearr_20026_20081[(2)] = inst_19888);

(statearr_20026_20081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (5))){
var state_19982__$1 = state_19982;
var statearr_20027_20082 = state_19982__$1;
(statearr_20027_20082[(2)] = true);

(statearr_20027_20082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (14))){
var state_19982__$1 = state_19982;
var statearr_20028_20083 = state_19982__$1;
(statearr_20028_20083[(2)] = false);

(statearr_20028_20083[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (26))){
var inst_19942 = (state_19982[(9)]);
var inst_19949 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_19942);
var state_19982__$1 = state_19982;
var statearr_20029_20084 = state_19982__$1;
(statearr_20029_20084[(2)] = inst_19949);

(statearr_20029_20084[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (16))){
var state_19982__$1 = state_19982;
var statearr_20030_20085 = state_19982__$1;
(statearr_20030_20085[(2)] = true);

(statearr_20030_20085[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (38))){
var inst_19972 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_20031_20086 = state_19982__$1;
(statearr_20031_20086[(2)] = inst_19972);

(statearr_20031_20086[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (30))){
var inst_19936 = (state_19982[(13)]);
var inst_19942 = (state_19982[(9)]);
var inst_19935 = (state_19982[(11)]);
var inst_19959 = cljs.core.empty_QMARK_.call(null,inst_19935);
var inst_19960 = inst_19936.call(null,inst_19942);
var inst_19961 = cljs.core.not.call(null,inst_19960);
var inst_19962 = (inst_19959) && (inst_19961);
var state_19982__$1 = state_19982;
var statearr_20032_20087 = state_19982__$1;
(statearr_20032_20087[(2)] = inst_19962);

(statearr_20032_20087[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (10))){
var inst_19888 = (state_19982[(8)]);
var inst_19908 = (state_19982[(2)]);
var inst_19909 = cljs.core.get.call(null,inst_19908,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_19910 = cljs.core.get.call(null,inst_19908,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_19911 = cljs.core.get.call(null,inst_19908,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_19912 = inst_19888;
var state_19982__$1 = (function (){var statearr_20033 = state_19982;
(statearr_20033[(7)] = inst_19912);

(statearr_20033[(16)] = inst_19911);

(statearr_20033[(17)] = inst_19909);

(statearr_20033[(18)] = inst_19910);

return statearr_20033;
})();
var statearr_20034_20088 = state_19982__$1;
(statearr_20034_20088[(2)] = null);

(statearr_20034_20088[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (18))){
var inst_19926 = (state_19982[(2)]);
var state_19982__$1 = state_19982;
var statearr_20035_20089 = state_19982__$1;
(statearr_20035_20089[(2)] = inst_19926);

(statearr_20035_20089[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (37))){
var state_19982__$1 = state_19982;
var statearr_20036_20090 = state_19982__$1;
(statearr_20036_20090[(2)] = null);

(statearr_20036_20090[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19983 === (8))){
var inst_19888 = (state_19982[(8)]);
var inst_19905 = cljs.core.apply.call(null,cljs.core.hash_map,inst_19888);
var state_19982__$1 = state_19982;
var statearr_20037_20091 = state_19982__$1;
(statearr_20037_20091[(2)] = inst_19905);

(statearr_20037_20091[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18220__auto__,c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18221__auto__ = null;
var cljs$core$async$mix_$_state_machine__18221__auto____0 = (function (){
var statearr_20041 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20041[(0)] = cljs$core$async$mix_$_state_machine__18221__auto__);

(statearr_20041[(1)] = (1));

return statearr_20041;
});
var cljs$core$async$mix_$_state_machine__18221__auto____1 = (function (state_19982){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_19982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20042){if((e20042 instanceof Object)){
var ex__18224__auto__ = e20042;
var statearr_20043_20092 = state_19982;
(statearr_20043_20092[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20042;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20093 = state_19982;
state_19982 = G__20093;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18221__auto__ = function(state_19982){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18221__auto____1.call(this,state_19982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18221__auto____0;
cljs$core$async$mix_$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18221__auto____1;
return cljs$core$async$mix_$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18334__auto__ = (function (){var statearr_20044 = f__18333__auto__.call(null);
(statearr_20044[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20045);

return statearr_20044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20045,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__6871__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v,ch);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args20094 = [];
var len__7276__auto___20097 = arguments.length;
var i__7277__auto___20098 = (0);
while(true){
if((i__7277__auto___20098 < len__7276__auto___20097)){
args20094.push((arguments[i__7277__auto___20098]));

var G__20099 = (i__7277__auto___20098 + (1));
i__7277__auto___20098 = G__20099;
continue;
} else {
}
break;
}

var G__20096 = args20094.length;
switch (G__20096) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20094.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6870__auto__ = (((p == null))?null:p);
var m__6871__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6870__auto__)]);
if(!((m__6871__auto__ == null))){
return m__6871__auto__.call(null,p,v);
} else {
var m__6871__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6871__auto____$1 == null))){
return m__6871__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args20102 = [];
var len__7276__auto___20227 = arguments.length;
var i__7277__auto___20228 = (0);
while(true){
if((i__7277__auto___20228 < len__7276__auto___20227)){
args20102.push((arguments[i__7277__auto___20228]));

var G__20229 = (i__7277__auto___20228 + (1));
i__7277__auto___20228 = G__20229;
continue;
} else {
}
break;
}

var G__20104 = args20102.length;
switch (G__20104) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20102.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6207__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6207__auto__)){
return or__6207__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6207__auto__,mults){
return (function (p1__20101_SHARP_){
if(cljs.core.truth_(p1__20101_SHARP_.call(null,topic))){
return p1__20101_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__20101_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6207__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async20105 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20105 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta20106){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta20106 = meta20106;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_20107,meta20106__$1){
var self__ = this;
var _20107__$1 = this;
return (new cljs.core.async.t_cljs$core$async20105(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta20106__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_20107){
var self__ = this;
var _20107__$1 = this;
return self__.meta20106;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta20106","meta20106",-1202330328,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async20105.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20105.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20105";

cljs.core.async.t_cljs$core$async20105.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20105");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async20105 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async20105(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20106){
return (new cljs.core.async.t_cljs$core$async20105(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta20106));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async20105(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18332__auto___20231 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20231,mults,ensure_mult,p){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20231,mults,ensure_mult,p){
return (function (state_20179){
var state_val_20180 = (state_20179[(1)]);
if((state_val_20180 === (7))){
var inst_20175 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20181_20232 = state_20179__$1;
(statearr_20181_20232[(2)] = inst_20175);

(statearr_20181_20232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (20))){
var state_20179__$1 = state_20179;
var statearr_20182_20233 = state_20179__$1;
(statearr_20182_20233[(2)] = null);

(statearr_20182_20233[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (1))){
var state_20179__$1 = state_20179;
var statearr_20183_20234 = state_20179__$1;
(statearr_20183_20234[(2)] = null);

(statearr_20183_20234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (24))){
var inst_20158 = (state_20179[(7)]);
var inst_20167 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_20158);
var state_20179__$1 = state_20179;
var statearr_20184_20235 = state_20179__$1;
(statearr_20184_20235[(2)] = inst_20167);

(statearr_20184_20235[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (4))){
var inst_20110 = (state_20179[(8)]);
var inst_20110__$1 = (state_20179[(2)]);
var inst_20111 = (inst_20110__$1 == null);
var state_20179__$1 = (function (){var statearr_20185 = state_20179;
(statearr_20185[(8)] = inst_20110__$1);

return statearr_20185;
})();
if(cljs.core.truth_(inst_20111)){
var statearr_20186_20236 = state_20179__$1;
(statearr_20186_20236[(1)] = (5));

} else {
var statearr_20187_20237 = state_20179__$1;
(statearr_20187_20237[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (15))){
var inst_20152 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20188_20238 = state_20179__$1;
(statearr_20188_20238[(2)] = inst_20152);

(statearr_20188_20238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (21))){
var inst_20172 = (state_20179[(2)]);
var state_20179__$1 = (function (){var statearr_20189 = state_20179;
(statearr_20189[(9)] = inst_20172);

return statearr_20189;
})();
var statearr_20190_20239 = state_20179__$1;
(statearr_20190_20239[(2)] = null);

(statearr_20190_20239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (13))){
var inst_20134 = (state_20179[(10)]);
var inst_20136 = cljs.core.chunked_seq_QMARK_.call(null,inst_20134);
var state_20179__$1 = state_20179;
if(inst_20136){
var statearr_20191_20240 = state_20179__$1;
(statearr_20191_20240[(1)] = (16));

} else {
var statearr_20192_20241 = state_20179__$1;
(statearr_20192_20241[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (22))){
var inst_20164 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
if(cljs.core.truth_(inst_20164)){
var statearr_20193_20242 = state_20179__$1;
(statearr_20193_20242[(1)] = (23));

} else {
var statearr_20194_20243 = state_20179__$1;
(statearr_20194_20243[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (6))){
var inst_20110 = (state_20179[(8)]);
var inst_20158 = (state_20179[(7)]);
var inst_20160 = (state_20179[(11)]);
var inst_20158__$1 = topic_fn.call(null,inst_20110);
var inst_20159 = cljs.core.deref.call(null,mults);
var inst_20160__$1 = cljs.core.get.call(null,inst_20159,inst_20158__$1);
var state_20179__$1 = (function (){var statearr_20195 = state_20179;
(statearr_20195[(7)] = inst_20158__$1);

(statearr_20195[(11)] = inst_20160__$1);

return statearr_20195;
})();
if(cljs.core.truth_(inst_20160__$1)){
var statearr_20196_20244 = state_20179__$1;
(statearr_20196_20244[(1)] = (19));

} else {
var statearr_20197_20245 = state_20179__$1;
(statearr_20197_20245[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (25))){
var inst_20169 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20198_20246 = state_20179__$1;
(statearr_20198_20246[(2)] = inst_20169);

(statearr_20198_20246[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (17))){
var inst_20134 = (state_20179[(10)]);
var inst_20143 = cljs.core.first.call(null,inst_20134);
var inst_20144 = cljs.core.async.muxch_STAR_.call(null,inst_20143);
var inst_20145 = cljs.core.async.close_BANG_.call(null,inst_20144);
var inst_20146 = cljs.core.next.call(null,inst_20134);
var inst_20120 = inst_20146;
var inst_20121 = null;
var inst_20122 = (0);
var inst_20123 = (0);
var state_20179__$1 = (function (){var statearr_20199 = state_20179;
(statearr_20199[(12)] = inst_20122);

(statearr_20199[(13)] = inst_20121);

(statearr_20199[(14)] = inst_20145);

(statearr_20199[(15)] = inst_20120);

(statearr_20199[(16)] = inst_20123);

return statearr_20199;
})();
var statearr_20200_20247 = state_20179__$1;
(statearr_20200_20247[(2)] = null);

(statearr_20200_20247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (3))){
var inst_20177 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20179__$1,inst_20177);
} else {
if((state_val_20180 === (12))){
var inst_20154 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20201_20248 = state_20179__$1;
(statearr_20201_20248[(2)] = inst_20154);

(statearr_20201_20248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (2))){
var state_20179__$1 = state_20179;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20179__$1,(4),ch);
} else {
if((state_val_20180 === (23))){
var state_20179__$1 = state_20179;
var statearr_20202_20249 = state_20179__$1;
(statearr_20202_20249[(2)] = null);

(statearr_20202_20249[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (19))){
var inst_20110 = (state_20179[(8)]);
var inst_20160 = (state_20179[(11)]);
var inst_20162 = cljs.core.async.muxch_STAR_.call(null,inst_20160);
var state_20179__$1 = state_20179;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20179__$1,(22),inst_20162,inst_20110);
} else {
if((state_val_20180 === (11))){
var inst_20134 = (state_20179[(10)]);
var inst_20120 = (state_20179[(15)]);
var inst_20134__$1 = cljs.core.seq.call(null,inst_20120);
var state_20179__$1 = (function (){var statearr_20203 = state_20179;
(statearr_20203[(10)] = inst_20134__$1);

return statearr_20203;
})();
if(inst_20134__$1){
var statearr_20204_20250 = state_20179__$1;
(statearr_20204_20250[(1)] = (13));

} else {
var statearr_20205_20251 = state_20179__$1;
(statearr_20205_20251[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (9))){
var inst_20156 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20206_20252 = state_20179__$1;
(statearr_20206_20252[(2)] = inst_20156);

(statearr_20206_20252[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (5))){
var inst_20117 = cljs.core.deref.call(null,mults);
var inst_20118 = cljs.core.vals.call(null,inst_20117);
var inst_20119 = cljs.core.seq.call(null,inst_20118);
var inst_20120 = inst_20119;
var inst_20121 = null;
var inst_20122 = (0);
var inst_20123 = (0);
var state_20179__$1 = (function (){var statearr_20207 = state_20179;
(statearr_20207[(12)] = inst_20122);

(statearr_20207[(13)] = inst_20121);

(statearr_20207[(15)] = inst_20120);

(statearr_20207[(16)] = inst_20123);

return statearr_20207;
})();
var statearr_20208_20253 = state_20179__$1;
(statearr_20208_20253[(2)] = null);

(statearr_20208_20253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (14))){
var state_20179__$1 = state_20179;
var statearr_20212_20254 = state_20179__$1;
(statearr_20212_20254[(2)] = null);

(statearr_20212_20254[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (16))){
var inst_20134 = (state_20179[(10)]);
var inst_20138 = cljs.core.chunk_first.call(null,inst_20134);
var inst_20139 = cljs.core.chunk_rest.call(null,inst_20134);
var inst_20140 = cljs.core.count.call(null,inst_20138);
var inst_20120 = inst_20139;
var inst_20121 = inst_20138;
var inst_20122 = inst_20140;
var inst_20123 = (0);
var state_20179__$1 = (function (){var statearr_20213 = state_20179;
(statearr_20213[(12)] = inst_20122);

(statearr_20213[(13)] = inst_20121);

(statearr_20213[(15)] = inst_20120);

(statearr_20213[(16)] = inst_20123);

return statearr_20213;
})();
var statearr_20214_20255 = state_20179__$1;
(statearr_20214_20255[(2)] = null);

(statearr_20214_20255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (10))){
var inst_20122 = (state_20179[(12)]);
var inst_20121 = (state_20179[(13)]);
var inst_20120 = (state_20179[(15)]);
var inst_20123 = (state_20179[(16)]);
var inst_20128 = cljs.core._nth.call(null,inst_20121,inst_20123);
var inst_20129 = cljs.core.async.muxch_STAR_.call(null,inst_20128);
var inst_20130 = cljs.core.async.close_BANG_.call(null,inst_20129);
var inst_20131 = (inst_20123 + (1));
var tmp20209 = inst_20122;
var tmp20210 = inst_20121;
var tmp20211 = inst_20120;
var inst_20120__$1 = tmp20211;
var inst_20121__$1 = tmp20210;
var inst_20122__$1 = tmp20209;
var inst_20123__$1 = inst_20131;
var state_20179__$1 = (function (){var statearr_20215 = state_20179;
(statearr_20215[(12)] = inst_20122__$1);

(statearr_20215[(17)] = inst_20130);

(statearr_20215[(13)] = inst_20121__$1);

(statearr_20215[(15)] = inst_20120__$1);

(statearr_20215[(16)] = inst_20123__$1);

return statearr_20215;
})();
var statearr_20216_20256 = state_20179__$1;
(statearr_20216_20256[(2)] = null);

(statearr_20216_20256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (18))){
var inst_20149 = (state_20179[(2)]);
var state_20179__$1 = state_20179;
var statearr_20217_20257 = state_20179__$1;
(statearr_20217_20257[(2)] = inst_20149);

(statearr_20217_20257[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20180 === (8))){
var inst_20122 = (state_20179[(12)]);
var inst_20123 = (state_20179[(16)]);
var inst_20125 = (inst_20123 < inst_20122);
var inst_20126 = inst_20125;
var state_20179__$1 = state_20179;
if(cljs.core.truth_(inst_20126)){
var statearr_20218_20258 = state_20179__$1;
(statearr_20218_20258[(1)] = (10));

} else {
var statearr_20219_20259 = state_20179__$1;
(statearr_20219_20259[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20231,mults,ensure_mult,p))
;
return ((function (switch__18220__auto__,c__18332__auto___20231,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20223 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20223[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20223[(1)] = (1));

return statearr_20223;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20179){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20179);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20224){if((e20224 instanceof Object)){
var ex__18224__auto__ = e20224;
var statearr_20225_20260 = state_20179;
(statearr_20225_20260[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20179);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20224;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20261 = state_20179;
state_20179 = G__20261;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20231,mults,ensure_mult,p))
})();
var state__18334__auto__ = (function (){var statearr_20226 = f__18333__auto__.call(null);
(statearr_20226[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20231);

return statearr_20226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20231,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args20262 = [];
var len__7276__auto___20265 = arguments.length;
var i__7277__auto___20266 = (0);
while(true){
if((i__7277__auto___20266 < len__7276__auto___20265)){
args20262.push((arguments[i__7277__auto___20266]));

var G__20267 = (i__7277__auto___20266 + (1));
i__7277__auto___20266 = G__20267;
continue;
} else {
}
break;
}

var G__20264 = args20262.length;
switch (G__20264) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20262.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args20269 = [];
var len__7276__auto___20272 = arguments.length;
var i__7277__auto___20273 = (0);
while(true){
if((i__7277__auto___20273 < len__7276__auto___20272)){
args20269.push((arguments[i__7277__auto___20273]));

var G__20274 = (i__7277__auto___20273 + (1));
i__7277__auto___20273 = G__20274;
continue;
} else {
}
break;
}

var G__20271 = args20269.length;
switch (G__20271) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20269.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args20276 = [];
var len__7276__auto___20347 = arguments.length;
var i__7277__auto___20348 = (0);
while(true){
if((i__7277__auto___20348 < len__7276__auto___20347)){
args20276.push((arguments[i__7277__auto___20348]));

var G__20349 = (i__7277__auto___20348 + (1));
i__7277__auto___20348 = G__20349;
continue;
} else {
}
break;
}

var G__20278 = args20276.length;
switch (G__20278) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20276.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__18332__auto___20351 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_20317){
var state_val_20318 = (state_20317[(1)]);
if((state_val_20318 === (7))){
var state_20317__$1 = state_20317;
var statearr_20319_20352 = state_20317__$1;
(statearr_20319_20352[(2)] = null);

(statearr_20319_20352[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (1))){
var state_20317__$1 = state_20317;
var statearr_20320_20353 = state_20317__$1;
(statearr_20320_20353[(2)] = null);

(statearr_20320_20353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (4))){
var inst_20281 = (state_20317[(7)]);
var inst_20283 = (inst_20281 < cnt);
var state_20317__$1 = state_20317;
if(cljs.core.truth_(inst_20283)){
var statearr_20321_20354 = state_20317__$1;
(statearr_20321_20354[(1)] = (6));

} else {
var statearr_20322_20355 = state_20317__$1;
(statearr_20322_20355[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (15))){
var inst_20313 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20323_20356 = state_20317__$1;
(statearr_20323_20356[(2)] = inst_20313);

(statearr_20323_20356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (13))){
var inst_20306 = cljs.core.async.close_BANG_.call(null,out);
var state_20317__$1 = state_20317;
var statearr_20324_20357 = state_20317__$1;
(statearr_20324_20357[(2)] = inst_20306);

(statearr_20324_20357[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (6))){
var state_20317__$1 = state_20317;
var statearr_20325_20358 = state_20317__$1;
(statearr_20325_20358[(2)] = null);

(statearr_20325_20358[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (3))){
var inst_20315 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20317__$1,inst_20315);
} else {
if((state_val_20318 === (12))){
var inst_20303 = (state_20317[(8)]);
var inst_20303__$1 = (state_20317[(2)]);
var inst_20304 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_20303__$1);
var state_20317__$1 = (function (){var statearr_20326 = state_20317;
(statearr_20326[(8)] = inst_20303__$1);

return statearr_20326;
})();
if(cljs.core.truth_(inst_20304)){
var statearr_20327_20359 = state_20317__$1;
(statearr_20327_20359[(1)] = (13));

} else {
var statearr_20328_20360 = state_20317__$1;
(statearr_20328_20360[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (2))){
var inst_20280 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_20281 = (0);
var state_20317__$1 = (function (){var statearr_20329 = state_20317;
(statearr_20329[(9)] = inst_20280);

(statearr_20329[(7)] = inst_20281);

return statearr_20329;
})();
var statearr_20330_20361 = state_20317__$1;
(statearr_20330_20361[(2)] = null);

(statearr_20330_20361[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (11))){
var inst_20281 = (state_20317[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_20317,(10),Object,null,(9));
var inst_20290 = chs__$1.call(null,inst_20281);
var inst_20291 = done.call(null,inst_20281);
var inst_20292 = cljs.core.async.take_BANG_.call(null,inst_20290,inst_20291);
var state_20317__$1 = state_20317;
var statearr_20331_20362 = state_20317__$1;
(statearr_20331_20362[(2)] = inst_20292);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20317__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (9))){
var inst_20281 = (state_20317[(7)]);
var inst_20294 = (state_20317[(2)]);
var inst_20295 = (inst_20281 + (1));
var inst_20281__$1 = inst_20295;
var state_20317__$1 = (function (){var statearr_20332 = state_20317;
(statearr_20332[(10)] = inst_20294);

(statearr_20332[(7)] = inst_20281__$1);

return statearr_20332;
})();
var statearr_20333_20363 = state_20317__$1;
(statearr_20333_20363[(2)] = null);

(statearr_20333_20363[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (5))){
var inst_20301 = (state_20317[(2)]);
var state_20317__$1 = (function (){var statearr_20334 = state_20317;
(statearr_20334[(11)] = inst_20301);

return statearr_20334;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20317__$1,(12),dchan);
} else {
if((state_val_20318 === (14))){
var inst_20303 = (state_20317[(8)]);
var inst_20308 = cljs.core.apply.call(null,f,inst_20303);
var state_20317__$1 = state_20317;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20317__$1,(16),out,inst_20308);
} else {
if((state_val_20318 === (16))){
var inst_20310 = (state_20317[(2)]);
var state_20317__$1 = (function (){var statearr_20335 = state_20317;
(statearr_20335[(12)] = inst_20310);

return statearr_20335;
})();
var statearr_20336_20364 = state_20317__$1;
(statearr_20336_20364[(2)] = null);

(statearr_20336_20364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (10))){
var inst_20285 = (state_20317[(2)]);
var inst_20286 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_20317__$1 = (function (){var statearr_20337 = state_20317;
(statearr_20337[(13)] = inst_20285);

return statearr_20337;
})();
var statearr_20338_20365 = state_20317__$1;
(statearr_20338_20365[(2)] = inst_20286);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20317__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20318 === (8))){
var inst_20299 = (state_20317[(2)]);
var state_20317__$1 = state_20317;
var statearr_20339_20366 = state_20317__$1;
(statearr_20339_20366[(2)] = inst_20299);

(statearr_20339_20366[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18220__auto__,c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20343[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20343[(1)] = (1));

return statearr_20343;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20317){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20344){if((e20344 instanceof Object)){
var ex__18224__auto__ = e20344;
var statearr_20345_20367 = state_20317;
(statearr_20345_20367[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20344;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20368 = state_20317;
state_20317 = G__20368;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20317){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18334__auto__ = (function (){var statearr_20346 = f__18333__auto__.call(null);
(statearr_20346[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20351);

return statearr_20346;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20351,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20370 = [];
var len__7276__auto___20426 = arguments.length;
var i__7277__auto___20427 = (0);
while(true){
if((i__7277__auto___20427 < len__7276__auto___20426)){
args20370.push((arguments[i__7277__auto___20427]));

var G__20428 = (i__7277__auto___20427 + (1));
i__7277__auto___20427 = G__20428;
continue;
} else {
}
break;
}

var G__20372 = args20370.length;
switch (G__20372) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20370.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___20430 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20430,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20430,out){
return (function (state_20402){
var state_val_20403 = (state_20402[(1)]);
if((state_val_20403 === (7))){
var inst_20382 = (state_20402[(7)]);
var inst_20381 = (state_20402[(8)]);
var inst_20381__$1 = (state_20402[(2)]);
var inst_20382__$1 = cljs.core.nth.call(null,inst_20381__$1,(0),null);
var inst_20383 = cljs.core.nth.call(null,inst_20381__$1,(1),null);
var inst_20384 = (inst_20382__$1 == null);
var state_20402__$1 = (function (){var statearr_20404 = state_20402;
(statearr_20404[(7)] = inst_20382__$1);

(statearr_20404[(9)] = inst_20383);

(statearr_20404[(8)] = inst_20381__$1);

return statearr_20404;
})();
if(cljs.core.truth_(inst_20384)){
var statearr_20405_20431 = state_20402__$1;
(statearr_20405_20431[(1)] = (8));

} else {
var statearr_20406_20432 = state_20402__$1;
(statearr_20406_20432[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (1))){
var inst_20373 = cljs.core.vec.call(null,chs);
var inst_20374 = inst_20373;
var state_20402__$1 = (function (){var statearr_20407 = state_20402;
(statearr_20407[(10)] = inst_20374);

return statearr_20407;
})();
var statearr_20408_20433 = state_20402__$1;
(statearr_20408_20433[(2)] = null);

(statearr_20408_20433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (4))){
var inst_20374 = (state_20402[(10)]);
var state_20402__$1 = state_20402;
return cljs.core.async.ioc_alts_BANG_.call(null,state_20402__$1,(7),inst_20374);
} else {
if((state_val_20403 === (6))){
var inst_20398 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20409_20434 = state_20402__$1;
(statearr_20409_20434[(2)] = inst_20398);

(statearr_20409_20434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (3))){
var inst_20400 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20402__$1,inst_20400);
} else {
if((state_val_20403 === (2))){
var inst_20374 = (state_20402[(10)]);
var inst_20376 = cljs.core.count.call(null,inst_20374);
var inst_20377 = (inst_20376 > (0));
var state_20402__$1 = state_20402;
if(cljs.core.truth_(inst_20377)){
var statearr_20411_20435 = state_20402__$1;
(statearr_20411_20435[(1)] = (4));

} else {
var statearr_20412_20436 = state_20402__$1;
(statearr_20412_20436[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (11))){
var inst_20374 = (state_20402[(10)]);
var inst_20391 = (state_20402[(2)]);
var tmp20410 = inst_20374;
var inst_20374__$1 = tmp20410;
var state_20402__$1 = (function (){var statearr_20413 = state_20402;
(statearr_20413[(11)] = inst_20391);

(statearr_20413[(10)] = inst_20374__$1);

return statearr_20413;
})();
var statearr_20414_20437 = state_20402__$1;
(statearr_20414_20437[(2)] = null);

(statearr_20414_20437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (9))){
var inst_20382 = (state_20402[(7)]);
var state_20402__$1 = state_20402;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20402__$1,(11),out,inst_20382);
} else {
if((state_val_20403 === (5))){
var inst_20396 = cljs.core.async.close_BANG_.call(null,out);
var state_20402__$1 = state_20402;
var statearr_20415_20438 = state_20402__$1;
(statearr_20415_20438[(2)] = inst_20396);

(statearr_20415_20438[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (10))){
var inst_20394 = (state_20402[(2)]);
var state_20402__$1 = state_20402;
var statearr_20416_20439 = state_20402__$1;
(statearr_20416_20439[(2)] = inst_20394);

(statearr_20416_20439[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20403 === (8))){
var inst_20382 = (state_20402[(7)]);
var inst_20374 = (state_20402[(10)]);
var inst_20383 = (state_20402[(9)]);
var inst_20381 = (state_20402[(8)]);
var inst_20386 = (function (){var cs = inst_20374;
var vec__20379 = inst_20381;
var v = inst_20382;
var c = inst_20383;
return ((function (cs,vec__20379,v,c,inst_20382,inst_20374,inst_20383,inst_20381,state_val_20403,c__18332__auto___20430,out){
return (function (p1__20369_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__20369_SHARP_);
});
;})(cs,vec__20379,v,c,inst_20382,inst_20374,inst_20383,inst_20381,state_val_20403,c__18332__auto___20430,out))
})();
var inst_20387 = cljs.core.filterv.call(null,inst_20386,inst_20374);
var inst_20374__$1 = inst_20387;
var state_20402__$1 = (function (){var statearr_20417 = state_20402;
(statearr_20417[(10)] = inst_20374__$1);

return statearr_20417;
})();
var statearr_20418_20440 = state_20402__$1;
(statearr_20418_20440[(2)] = null);

(statearr_20418_20440[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20430,out))
;
return ((function (switch__18220__auto__,c__18332__auto___20430,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20422 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20422[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20422[(1)] = (1));

return statearr_20422;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20402){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20402);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20423){if((e20423 instanceof Object)){
var ex__18224__auto__ = e20423;
var statearr_20424_20441 = state_20402;
(statearr_20424_20441[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20402);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20423;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20442 = state_20402;
state_20402 = G__20442;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20402){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20430,out))
})();
var state__18334__auto__ = (function (){var statearr_20425 = f__18333__auto__.call(null);
(statearr_20425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20430);

return statearr_20425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20430,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20443 = [];
var len__7276__auto___20492 = arguments.length;
var i__7277__auto___20493 = (0);
while(true){
if((i__7277__auto___20493 < len__7276__auto___20492)){
args20443.push((arguments[i__7277__auto___20493]));

var G__20494 = (i__7277__auto___20493 + (1));
i__7277__auto___20493 = G__20494;
continue;
} else {
}
break;
}

var G__20445 = args20443.length;
switch (G__20445) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20443.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___20496 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20496,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20496,out){
return (function (state_20469){
var state_val_20470 = (state_20469[(1)]);
if((state_val_20470 === (7))){
var inst_20451 = (state_20469[(7)]);
var inst_20451__$1 = (state_20469[(2)]);
var inst_20452 = (inst_20451__$1 == null);
var inst_20453 = cljs.core.not.call(null,inst_20452);
var state_20469__$1 = (function (){var statearr_20471 = state_20469;
(statearr_20471[(7)] = inst_20451__$1);

return statearr_20471;
})();
if(inst_20453){
var statearr_20472_20497 = state_20469__$1;
(statearr_20472_20497[(1)] = (8));

} else {
var statearr_20473_20498 = state_20469__$1;
(statearr_20473_20498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (1))){
var inst_20446 = (0);
var state_20469__$1 = (function (){var statearr_20474 = state_20469;
(statearr_20474[(8)] = inst_20446);

return statearr_20474;
})();
var statearr_20475_20499 = state_20469__$1;
(statearr_20475_20499[(2)] = null);

(statearr_20475_20499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (4))){
var state_20469__$1 = state_20469;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20469__$1,(7),ch);
} else {
if((state_val_20470 === (6))){
var inst_20464 = (state_20469[(2)]);
var state_20469__$1 = state_20469;
var statearr_20476_20500 = state_20469__$1;
(statearr_20476_20500[(2)] = inst_20464);

(statearr_20476_20500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (3))){
var inst_20466 = (state_20469[(2)]);
var inst_20467 = cljs.core.async.close_BANG_.call(null,out);
var state_20469__$1 = (function (){var statearr_20477 = state_20469;
(statearr_20477[(9)] = inst_20466);

return statearr_20477;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20469__$1,inst_20467);
} else {
if((state_val_20470 === (2))){
var inst_20446 = (state_20469[(8)]);
var inst_20448 = (inst_20446 < n);
var state_20469__$1 = state_20469;
if(cljs.core.truth_(inst_20448)){
var statearr_20478_20501 = state_20469__$1;
(statearr_20478_20501[(1)] = (4));

} else {
var statearr_20479_20502 = state_20469__$1;
(statearr_20479_20502[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (11))){
var inst_20446 = (state_20469[(8)]);
var inst_20456 = (state_20469[(2)]);
var inst_20457 = (inst_20446 + (1));
var inst_20446__$1 = inst_20457;
var state_20469__$1 = (function (){var statearr_20480 = state_20469;
(statearr_20480[(8)] = inst_20446__$1);

(statearr_20480[(10)] = inst_20456);

return statearr_20480;
})();
var statearr_20481_20503 = state_20469__$1;
(statearr_20481_20503[(2)] = null);

(statearr_20481_20503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (9))){
var state_20469__$1 = state_20469;
var statearr_20482_20504 = state_20469__$1;
(statearr_20482_20504[(2)] = null);

(statearr_20482_20504[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (5))){
var state_20469__$1 = state_20469;
var statearr_20483_20505 = state_20469__$1;
(statearr_20483_20505[(2)] = null);

(statearr_20483_20505[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (10))){
var inst_20461 = (state_20469[(2)]);
var state_20469__$1 = state_20469;
var statearr_20484_20506 = state_20469__$1;
(statearr_20484_20506[(2)] = inst_20461);

(statearr_20484_20506[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20470 === (8))){
var inst_20451 = (state_20469[(7)]);
var state_20469__$1 = state_20469;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20469__$1,(11),out,inst_20451);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20496,out))
;
return ((function (switch__18220__auto__,c__18332__auto___20496,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20488 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20488[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20488[(1)] = (1));

return statearr_20488;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20469){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20469);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20489){if((e20489 instanceof Object)){
var ex__18224__auto__ = e20489;
var statearr_20490_20507 = state_20469;
(statearr_20490_20507[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20469);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20508 = state_20469;
state_20469 = G__20508;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20469){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20496,out))
})();
var state__18334__auto__ = (function (){var statearr_20491 = f__18333__auto__.call(null);
(statearr_20491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20496);

return statearr_20491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20496,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20516 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20516 = (function (map_LT_,f,ch,meta20517){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta20517 = meta20517;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20518,meta20517__$1){
var self__ = this;
var _20518__$1 = this;
return (new cljs.core.async.t_cljs$core$async20516(self__.map_LT_,self__.f,self__.ch,meta20517__$1));
});

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20518){
var self__ = this;
var _20518__$1 = this;
return self__.meta20517;
});

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async20519 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20519 = (function (map_LT_,f,ch,meta20517,_,fn1,meta20520){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta20517 = meta20517;
this._ = _;
this.fn1 = fn1;
this.meta20520 = meta20520;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20521,meta20520__$1){
var self__ = this;
var _20521__$1 = this;
return (new cljs.core.async.t_cljs$core$async20519(self__.map_LT_,self__.f,self__.ch,self__.meta20517,self__._,self__.fn1,meta20520__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20521){
var self__ = this;
var _20521__$1 = this;
return self__.meta20520;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__20509_SHARP_){
return f1.call(null,(((p1__20509_SHARP_ == null))?null:self__.f.call(null,p1__20509_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20517","meta20517",-1102218808,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async20516","cljs.core.async/t_cljs$core$async20516",1900755543,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta20520","meta20520",-85481071,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20519.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20519.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20519";

cljs.core.async.t_cljs$core$async20519.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20519");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async20519 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20519(map_LT___$1,f__$1,ch__$1,meta20517__$1,___$2,fn1__$1,meta20520){
return (new cljs.core.async.t_cljs$core$async20519(map_LT___$1,f__$1,ch__$1,meta20517__$1,___$2,fn1__$1,meta20520));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async20519(self__.map_LT_,self__.f,self__.ch,self__.meta20517,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6195__auto__ = ret;
if(cljs.core.truth_(and__6195__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6195__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20516.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async20516.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20517","meta20517",-1102218808,null)], null);
});

cljs.core.async.t_cljs$core$async20516.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20516.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20516";

cljs.core.async.t_cljs$core$async20516.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20516");
});

cljs.core.async.__GT_t_cljs$core$async20516 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20516(map_LT___$1,f__$1,ch__$1,meta20517){
return (new cljs.core.async.t_cljs$core$async20516(map_LT___$1,f__$1,ch__$1,meta20517));
});

}

return (new cljs.core.async.t_cljs$core$async20516(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20525 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20525 = (function (map_GT_,f,ch,meta20526){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta20526 = meta20526;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20527,meta20526__$1){
var self__ = this;
var _20527__$1 = this;
return (new cljs.core.async.t_cljs$core$async20525(self__.map_GT_,self__.f,self__.ch,meta20526__$1));
});

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20527){
var self__ = this;
var _20527__$1 = this;
return self__.meta20526;
});

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20525.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async20525.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20526","meta20526",-910060309,null)], null);
});

cljs.core.async.t_cljs$core$async20525.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20525.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20525";

cljs.core.async.t_cljs$core$async20525.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20525");
});

cljs.core.async.__GT_t_cljs$core$async20525 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20525(map_GT___$1,f__$1,ch__$1,meta20526){
return (new cljs.core.async.t_cljs$core$async20525(map_GT___$1,f__$1,ch__$1,meta20526));
});

}

return (new cljs.core.async.t_cljs$core$async20525(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async20531 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20531 = (function (filter_GT_,p,ch,meta20532){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta20532 = meta20532;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20533,meta20532__$1){
var self__ = this;
var _20533__$1 = this;
return (new cljs.core.async.t_cljs$core$async20531(self__.filter_GT_,self__.p,self__.ch,meta20532__$1));
});

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20533){
var self__ = this;
var _20533__$1 = this;
return self__.meta20532;
});

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async20531.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async20531.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta20532","meta20532",-1180566220,null)], null);
});

cljs.core.async.t_cljs$core$async20531.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20531.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20531";

cljs.core.async.t_cljs$core$async20531.cljs$lang$ctorPrWriter = (function (this__6813__auto__,writer__6814__auto__,opt__6815__auto__){
return cljs.core._write.call(null,writer__6814__auto__,"cljs.core.async/t_cljs$core$async20531");
});

cljs.core.async.__GT_t_cljs$core$async20531 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20531(filter_GT___$1,p__$1,ch__$1,meta20532){
return (new cljs.core.async.t_cljs$core$async20531(filter_GT___$1,p__$1,ch__$1,meta20532));
});

}

return (new cljs.core.async.t_cljs$core$async20531(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args20534 = [];
var len__7276__auto___20578 = arguments.length;
var i__7277__auto___20579 = (0);
while(true){
if((i__7277__auto___20579 < len__7276__auto___20578)){
args20534.push((arguments[i__7277__auto___20579]));

var G__20580 = (i__7277__auto___20579 + (1));
i__7277__auto___20579 = G__20580;
continue;
} else {
}
break;
}

var G__20536 = args20534.length;
switch (G__20536) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20534.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___20582 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20582,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20582,out){
return (function (state_20557){
var state_val_20558 = (state_20557[(1)]);
if((state_val_20558 === (7))){
var inst_20553 = (state_20557[(2)]);
var state_20557__$1 = state_20557;
var statearr_20559_20583 = state_20557__$1;
(statearr_20559_20583[(2)] = inst_20553);

(statearr_20559_20583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (1))){
var state_20557__$1 = state_20557;
var statearr_20560_20584 = state_20557__$1;
(statearr_20560_20584[(2)] = null);

(statearr_20560_20584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (4))){
var inst_20539 = (state_20557[(7)]);
var inst_20539__$1 = (state_20557[(2)]);
var inst_20540 = (inst_20539__$1 == null);
var state_20557__$1 = (function (){var statearr_20561 = state_20557;
(statearr_20561[(7)] = inst_20539__$1);

return statearr_20561;
})();
if(cljs.core.truth_(inst_20540)){
var statearr_20562_20585 = state_20557__$1;
(statearr_20562_20585[(1)] = (5));

} else {
var statearr_20563_20586 = state_20557__$1;
(statearr_20563_20586[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (6))){
var inst_20539 = (state_20557[(7)]);
var inst_20544 = p.call(null,inst_20539);
var state_20557__$1 = state_20557;
if(cljs.core.truth_(inst_20544)){
var statearr_20564_20587 = state_20557__$1;
(statearr_20564_20587[(1)] = (8));

} else {
var statearr_20565_20588 = state_20557__$1;
(statearr_20565_20588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (3))){
var inst_20555 = (state_20557[(2)]);
var state_20557__$1 = state_20557;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20557__$1,inst_20555);
} else {
if((state_val_20558 === (2))){
var state_20557__$1 = state_20557;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20557__$1,(4),ch);
} else {
if((state_val_20558 === (11))){
var inst_20547 = (state_20557[(2)]);
var state_20557__$1 = state_20557;
var statearr_20566_20589 = state_20557__$1;
(statearr_20566_20589[(2)] = inst_20547);

(statearr_20566_20589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (9))){
var state_20557__$1 = state_20557;
var statearr_20567_20590 = state_20557__$1;
(statearr_20567_20590[(2)] = null);

(statearr_20567_20590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (5))){
var inst_20542 = cljs.core.async.close_BANG_.call(null,out);
var state_20557__$1 = state_20557;
var statearr_20568_20591 = state_20557__$1;
(statearr_20568_20591[(2)] = inst_20542);

(statearr_20568_20591[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (10))){
var inst_20550 = (state_20557[(2)]);
var state_20557__$1 = (function (){var statearr_20569 = state_20557;
(statearr_20569[(8)] = inst_20550);

return statearr_20569;
})();
var statearr_20570_20592 = state_20557__$1;
(statearr_20570_20592[(2)] = null);

(statearr_20570_20592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20558 === (8))){
var inst_20539 = (state_20557[(7)]);
var state_20557__$1 = state_20557;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20557__$1,(11),out,inst_20539);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20582,out))
;
return ((function (switch__18220__auto__,c__18332__auto___20582,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20574 = [null,null,null,null,null,null,null,null,null];
(statearr_20574[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20574[(1)] = (1));

return statearr_20574;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20557){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20557);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20575){if((e20575 instanceof Object)){
var ex__18224__auto__ = e20575;
var statearr_20576_20593 = state_20557;
(statearr_20576_20593[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20557);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20575;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20594 = state_20557;
state_20557 = G__20594;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20557){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20582,out))
})();
var state__18334__auto__ = (function (){var statearr_20577 = f__18333__auto__.call(null);
(statearr_20577[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20582);

return statearr_20577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20582,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args20595 = [];
var len__7276__auto___20598 = arguments.length;
var i__7277__auto___20599 = (0);
while(true){
if((i__7277__auto___20599 < len__7276__auto___20598)){
args20595.push((arguments[i__7277__auto___20599]));

var G__20600 = (i__7277__auto___20599 + (1));
i__7277__auto___20599 = G__20600;
continue;
} else {
}
break;
}

var G__20597 = args20595.length;
switch (G__20597) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20595.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18332__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto__){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto__){
return (function (state_20767){
var state_val_20768 = (state_20767[(1)]);
if((state_val_20768 === (7))){
var inst_20763 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
var statearr_20769_20810 = state_20767__$1;
(statearr_20769_20810[(2)] = inst_20763);

(statearr_20769_20810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (20))){
var inst_20733 = (state_20767[(7)]);
var inst_20744 = (state_20767[(2)]);
var inst_20745 = cljs.core.next.call(null,inst_20733);
var inst_20719 = inst_20745;
var inst_20720 = null;
var inst_20721 = (0);
var inst_20722 = (0);
var state_20767__$1 = (function (){var statearr_20770 = state_20767;
(statearr_20770[(8)] = inst_20721);

(statearr_20770[(9)] = inst_20722);

(statearr_20770[(10)] = inst_20744);

(statearr_20770[(11)] = inst_20720);

(statearr_20770[(12)] = inst_20719);

return statearr_20770;
})();
var statearr_20771_20811 = state_20767__$1;
(statearr_20771_20811[(2)] = null);

(statearr_20771_20811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (1))){
var state_20767__$1 = state_20767;
var statearr_20772_20812 = state_20767__$1;
(statearr_20772_20812[(2)] = null);

(statearr_20772_20812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (4))){
var inst_20708 = (state_20767[(13)]);
var inst_20708__$1 = (state_20767[(2)]);
var inst_20709 = (inst_20708__$1 == null);
var state_20767__$1 = (function (){var statearr_20773 = state_20767;
(statearr_20773[(13)] = inst_20708__$1);

return statearr_20773;
})();
if(cljs.core.truth_(inst_20709)){
var statearr_20774_20813 = state_20767__$1;
(statearr_20774_20813[(1)] = (5));

} else {
var statearr_20775_20814 = state_20767__$1;
(statearr_20775_20814[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (15))){
var state_20767__$1 = state_20767;
var statearr_20779_20815 = state_20767__$1;
(statearr_20779_20815[(2)] = null);

(statearr_20779_20815[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (21))){
var state_20767__$1 = state_20767;
var statearr_20780_20816 = state_20767__$1;
(statearr_20780_20816[(2)] = null);

(statearr_20780_20816[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (13))){
var inst_20721 = (state_20767[(8)]);
var inst_20722 = (state_20767[(9)]);
var inst_20720 = (state_20767[(11)]);
var inst_20719 = (state_20767[(12)]);
var inst_20729 = (state_20767[(2)]);
var inst_20730 = (inst_20722 + (1));
var tmp20776 = inst_20721;
var tmp20777 = inst_20720;
var tmp20778 = inst_20719;
var inst_20719__$1 = tmp20778;
var inst_20720__$1 = tmp20777;
var inst_20721__$1 = tmp20776;
var inst_20722__$1 = inst_20730;
var state_20767__$1 = (function (){var statearr_20781 = state_20767;
(statearr_20781[(14)] = inst_20729);

(statearr_20781[(8)] = inst_20721__$1);

(statearr_20781[(9)] = inst_20722__$1);

(statearr_20781[(11)] = inst_20720__$1);

(statearr_20781[(12)] = inst_20719__$1);

return statearr_20781;
})();
var statearr_20782_20817 = state_20767__$1;
(statearr_20782_20817[(2)] = null);

(statearr_20782_20817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (22))){
var state_20767__$1 = state_20767;
var statearr_20783_20818 = state_20767__$1;
(statearr_20783_20818[(2)] = null);

(statearr_20783_20818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (6))){
var inst_20708 = (state_20767[(13)]);
var inst_20717 = f.call(null,inst_20708);
var inst_20718 = cljs.core.seq.call(null,inst_20717);
var inst_20719 = inst_20718;
var inst_20720 = null;
var inst_20721 = (0);
var inst_20722 = (0);
var state_20767__$1 = (function (){var statearr_20784 = state_20767;
(statearr_20784[(8)] = inst_20721);

(statearr_20784[(9)] = inst_20722);

(statearr_20784[(11)] = inst_20720);

(statearr_20784[(12)] = inst_20719);

return statearr_20784;
})();
var statearr_20785_20819 = state_20767__$1;
(statearr_20785_20819[(2)] = null);

(statearr_20785_20819[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (17))){
var inst_20733 = (state_20767[(7)]);
var inst_20737 = cljs.core.chunk_first.call(null,inst_20733);
var inst_20738 = cljs.core.chunk_rest.call(null,inst_20733);
var inst_20739 = cljs.core.count.call(null,inst_20737);
var inst_20719 = inst_20738;
var inst_20720 = inst_20737;
var inst_20721 = inst_20739;
var inst_20722 = (0);
var state_20767__$1 = (function (){var statearr_20786 = state_20767;
(statearr_20786[(8)] = inst_20721);

(statearr_20786[(9)] = inst_20722);

(statearr_20786[(11)] = inst_20720);

(statearr_20786[(12)] = inst_20719);

return statearr_20786;
})();
var statearr_20787_20820 = state_20767__$1;
(statearr_20787_20820[(2)] = null);

(statearr_20787_20820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (3))){
var inst_20765 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20767__$1,inst_20765);
} else {
if((state_val_20768 === (12))){
var inst_20753 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
var statearr_20788_20821 = state_20767__$1;
(statearr_20788_20821[(2)] = inst_20753);

(statearr_20788_20821[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (2))){
var state_20767__$1 = state_20767;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20767__$1,(4),in$);
} else {
if((state_val_20768 === (23))){
var inst_20761 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
var statearr_20789_20822 = state_20767__$1;
(statearr_20789_20822[(2)] = inst_20761);

(statearr_20789_20822[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (19))){
var inst_20748 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
var statearr_20790_20823 = state_20767__$1;
(statearr_20790_20823[(2)] = inst_20748);

(statearr_20790_20823[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (11))){
var inst_20733 = (state_20767[(7)]);
var inst_20719 = (state_20767[(12)]);
var inst_20733__$1 = cljs.core.seq.call(null,inst_20719);
var state_20767__$1 = (function (){var statearr_20791 = state_20767;
(statearr_20791[(7)] = inst_20733__$1);

return statearr_20791;
})();
if(inst_20733__$1){
var statearr_20792_20824 = state_20767__$1;
(statearr_20792_20824[(1)] = (14));

} else {
var statearr_20793_20825 = state_20767__$1;
(statearr_20793_20825[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (9))){
var inst_20755 = (state_20767[(2)]);
var inst_20756 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_20767__$1 = (function (){var statearr_20794 = state_20767;
(statearr_20794[(15)] = inst_20755);

return statearr_20794;
})();
if(cljs.core.truth_(inst_20756)){
var statearr_20795_20826 = state_20767__$1;
(statearr_20795_20826[(1)] = (21));

} else {
var statearr_20796_20827 = state_20767__$1;
(statearr_20796_20827[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (5))){
var inst_20711 = cljs.core.async.close_BANG_.call(null,out);
var state_20767__$1 = state_20767;
var statearr_20797_20828 = state_20767__$1;
(statearr_20797_20828[(2)] = inst_20711);

(statearr_20797_20828[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (14))){
var inst_20733 = (state_20767[(7)]);
var inst_20735 = cljs.core.chunked_seq_QMARK_.call(null,inst_20733);
var state_20767__$1 = state_20767;
if(inst_20735){
var statearr_20798_20829 = state_20767__$1;
(statearr_20798_20829[(1)] = (17));

} else {
var statearr_20799_20830 = state_20767__$1;
(statearr_20799_20830[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (16))){
var inst_20751 = (state_20767[(2)]);
var state_20767__$1 = state_20767;
var statearr_20800_20831 = state_20767__$1;
(statearr_20800_20831[(2)] = inst_20751);

(statearr_20800_20831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20768 === (10))){
var inst_20722 = (state_20767[(9)]);
var inst_20720 = (state_20767[(11)]);
var inst_20727 = cljs.core._nth.call(null,inst_20720,inst_20722);
var state_20767__$1 = state_20767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20767__$1,(13),out,inst_20727);
} else {
if((state_val_20768 === (18))){
var inst_20733 = (state_20767[(7)]);
var inst_20742 = cljs.core.first.call(null,inst_20733);
var state_20767__$1 = state_20767;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20767__$1,(20),out,inst_20742);
} else {
if((state_val_20768 === (8))){
var inst_20721 = (state_20767[(8)]);
var inst_20722 = (state_20767[(9)]);
var inst_20724 = (inst_20722 < inst_20721);
var inst_20725 = inst_20724;
var state_20767__$1 = state_20767;
if(cljs.core.truth_(inst_20725)){
var statearr_20801_20832 = state_20767__$1;
(statearr_20801_20832[(1)] = (10));

} else {
var statearr_20802_20833 = state_20767__$1;
(statearr_20802_20833[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto__))
;
return ((function (switch__18220__auto__,c__18332__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____0 = (function (){
var statearr_20806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20806[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__);

(statearr_20806[(1)] = (1));

return statearr_20806;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____1 = (function (state_20767){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20767);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20807){if((e20807 instanceof Object)){
var ex__18224__auto__ = e20807;
var statearr_20808_20834 = state_20767;
(statearr_20808_20834[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20767);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20835 = state_20767;
state_20767 = G__20835;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__ = function(state_20767){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____1.call(this,state_20767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18221__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto__))
})();
var state__18334__auto__ = (function (){var statearr_20809 = f__18333__auto__.call(null);
(statearr_20809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto__);

return statearr_20809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto__))
);

return c__18332__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20836 = [];
var len__7276__auto___20839 = arguments.length;
var i__7277__auto___20840 = (0);
while(true){
if((i__7277__auto___20840 < len__7276__auto___20839)){
args20836.push((arguments[i__7277__auto___20840]));

var G__20841 = (i__7277__auto___20840 + (1));
i__7277__auto___20840 = G__20841;
continue;
} else {
}
break;
}

var G__20838 = args20836.length;
switch (G__20838) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20836.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20843 = [];
var len__7276__auto___20846 = arguments.length;
var i__7277__auto___20847 = (0);
while(true){
if((i__7277__auto___20847 < len__7276__auto___20846)){
args20843.push((arguments[i__7277__auto___20847]));

var G__20848 = (i__7277__auto___20847 + (1));
i__7277__auto___20847 = G__20848;
continue;
} else {
}
break;
}

var G__20845 = args20843.length;
switch (G__20845) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20843.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20850 = [];
var len__7276__auto___20901 = arguments.length;
var i__7277__auto___20902 = (0);
while(true){
if((i__7277__auto___20902 < len__7276__auto___20901)){
args20850.push((arguments[i__7277__auto___20902]));

var G__20903 = (i__7277__auto___20902 + (1));
i__7277__auto___20902 = G__20903;
continue;
} else {
}
break;
}

var G__20852 = args20850.length;
switch (G__20852) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20850.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___20905 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20905,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20905,out){
return (function (state_20876){
var state_val_20877 = (state_20876[(1)]);
if((state_val_20877 === (7))){
var inst_20871 = (state_20876[(2)]);
var state_20876__$1 = state_20876;
var statearr_20878_20906 = state_20876__$1;
(statearr_20878_20906[(2)] = inst_20871);

(statearr_20878_20906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (1))){
var inst_20853 = null;
var state_20876__$1 = (function (){var statearr_20879 = state_20876;
(statearr_20879[(7)] = inst_20853);

return statearr_20879;
})();
var statearr_20880_20907 = state_20876__$1;
(statearr_20880_20907[(2)] = null);

(statearr_20880_20907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (4))){
var inst_20856 = (state_20876[(8)]);
var inst_20856__$1 = (state_20876[(2)]);
var inst_20857 = (inst_20856__$1 == null);
var inst_20858 = cljs.core.not.call(null,inst_20857);
var state_20876__$1 = (function (){var statearr_20881 = state_20876;
(statearr_20881[(8)] = inst_20856__$1);

return statearr_20881;
})();
if(inst_20858){
var statearr_20882_20908 = state_20876__$1;
(statearr_20882_20908[(1)] = (5));

} else {
var statearr_20883_20909 = state_20876__$1;
(statearr_20883_20909[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (6))){
var state_20876__$1 = state_20876;
var statearr_20884_20910 = state_20876__$1;
(statearr_20884_20910[(2)] = null);

(statearr_20884_20910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (3))){
var inst_20873 = (state_20876[(2)]);
var inst_20874 = cljs.core.async.close_BANG_.call(null,out);
var state_20876__$1 = (function (){var statearr_20885 = state_20876;
(statearr_20885[(9)] = inst_20873);

return statearr_20885;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20876__$1,inst_20874);
} else {
if((state_val_20877 === (2))){
var state_20876__$1 = state_20876;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20876__$1,(4),ch);
} else {
if((state_val_20877 === (11))){
var inst_20856 = (state_20876[(8)]);
var inst_20865 = (state_20876[(2)]);
var inst_20853 = inst_20856;
var state_20876__$1 = (function (){var statearr_20886 = state_20876;
(statearr_20886[(7)] = inst_20853);

(statearr_20886[(10)] = inst_20865);

return statearr_20886;
})();
var statearr_20887_20911 = state_20876__$1;
(statearr_20887_20911[(2)] = null);

(statearr_20887_20911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (9))){
var inst_20856 = (state_20876[(8)]);
var state_20876__$1 = state_20876;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20876__$1,(11),out,inst_20856);
} else {
if((state_val_20877 === (5))){
var inst_20856 = (state_20876[(8)]);
var inst_20853 = (state_20876[(7)]);
var inst_20860 = cljs.core._EQ_.call(null,inst_20856,inst_20853);
var state_20876__$1 = state_20876;
if(inst_20860){
var statearr_20889_20912 = state_20876__$1;
(statearr_20889_20912[(1)] = (8));

} else {
var statearr_20890_20913 = state_20876__$1;
(statearr_20890_20913[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (10))){
var inst_20868 = (state_20876[(2)]);
var state_20876__$1 = state_20876;
var statearr_20891_20914 = state_20876__$1;
(statearr_20891_20914[(2)] = inst_20868);

(statearr_20891_20914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20877 === (8))){
var inst_20853 = (state_20876[(7)]);
var tmp20888 = inst_20853;
var inst_20853__$1 = tmp20888;
var state_20876__$1 = (function (){var statearr_20892 = state_20876;
(statearr_20892[(7)] = inst_20853__$1);

return statearr_20892;
})();
var statearr_20893_20915 = state_20876__$1;
(statearr_20893_20915[(2)] = null);

(statearr_20893_20915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20905,out))
;
return ((function (switch__18220__auto__,c__18332__auto___20905,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20897 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20897[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20897[(1)] = (1));

return statearr_20897;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20876){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20876);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20898){if((e20898 instanceof Object)){
var ex__18224__auto__ = e20898;
var statearr_20899_20916 = state_20876;
(statearr_20899_20916[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20917 = state_20876;
state_20876 = G__20917;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20876){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20905,out))
})();
var state__18334__auto__ = (function (){var statearr_20900 = f__18333__auto__.call(null);
(statearr_20900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20905);

return statearr_20900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20905,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20918 = [];
var len__7276__auto___20988 = arguments.length;
var i__7277__auto___20989 = (0);
while(true){
if((i__7277__auto___20989 < len__7276__auto___20988)){
args20918.push((arguments[i__7277__auto___20989]));

var G__20990 = (i__7277__auto___20989 + (1));
i__7277__auto___20989 = G__20990;
continue;
} else {
}
break;
}

var G__20920 = args20918.length;
switch (G__20920) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20918.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___20992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___20992,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___20992,out){
return (function (state_20958){
var state_val_20959 = (state_20958[(1)]);
if((state_val_20959 === (7))){
var inst_20954 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20960_20993 = state_20958__$1;
(statearr_20960_20993[(2)] = inst_20954);

(statearr_20960_20993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (1))){
var inst_20921 = (new Array(n));
var inst_20922 = inst_20921;
var inst_20923 = (0);
var state_20958__$1 = (function (){var statearr_20961 = state_20958;
(statearr_20961[(7)] = inst_20923);

(statearr_20961[(8)] = inst_20922);

return statearr_20961;
})();
var statearr_20962_20994 = state_20958__$1;
(statearr_20962_20994[(2)] = null);

(statearr_20962_20994[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (4))){
var inst_20926 = (state_20958[(9)]);
var inst_20926__$1 = (state_20958[(2)]);
var inst_20927 = (inst_20926__$1 == null);
var inst_20928 = cljs.core.not.call(null,inst_20927);
var state_20958__$1 = (function (){var statearr_20963 = state_20958;
(statearr_20963[(9)] = inst_20926__$1);

return statearr_20963;
})();
if(inst_20928){
var statearr_20964_20995 = state_20958__$1;
(statearr_20964_20995[(1)] = (5));

} else {
var statearr_20965_20996 = state_20958__$1;
(statearr_20965_20996[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (15))){
var inst_20948 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20966_20997 = state_20958__$1;
(statearr_20966_20997[(2)] = inst_20948);

(statearr_20966_20997[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (13))){
var state_20958__$1 = state_20958;
var statearr_20967_20998 = state_20958__$1;
(statearr_20967_20998[(2)] = null);

(statearr_20967_20998[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (6))){
var inst_20923 = (state_20958[(7)]);
var inst_20944 = (inst_20923 > (0));
var state_20958__$1 = state_20958;
if(cljs.core.truth_(inst_20944)){
var statearr_20968_20999 = state_20958__$1;
(statearr_20968_20999[(1)] = (12));

} else {
var statearr_20969_21000 = state_20958__$1;
(statearr_20969_21000[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (3))){
var inst_20956 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20958__$1,inst_20956);
} else {
if((state_val_20959 === (12))){
var inst_20922 = (state_20958[(8)]);
var inst_20946 = cljs.core.vec.call(null,inst_20922);
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20958__$1,(15),out,inst_20946);
} else {
if((state_val_20959 === (2))){
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20958__$1,(4),ch);
} else {
if((state_val_20959 === (11))){
var inst_20938 = (state_20958[(2)]);
var inst_20939 = (new Array(n));
var inst_20922 = inst_20939;
var inst_20923 = (0);
var state_20958__$1 = (function (){var statearr_20970 = state_20958;
(statearr_20970[(7)] = inst_20923);

(statearr_20970[(8)] = inst_20922);

(statearr_20970[(10)] = inst_20938);

return statearr_20970;
})();
var statearr_20971_21001 = state_20958__$1;
(statearr_20971_21001[(2)] = null);

(statearr_20971_21001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (9))){
var inst_20922 = (state_20958[(8)]);
var inst_20936 = cljs.core.vec.call(null,inst_20922);
var state_20958__$1 = state_20958;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20958__$1,(11),out,inst_20936);
} else {
if((state_val_20959 === (5))){
var inst_20923 = (state_20958[(7)]);
var inst_20926 = (state_20958[(9)]);
var inst_20922 = (state_20958[(8)]);
var inst_20931 = (state_20958[(11)]);
var inst_20930 = (inst_20922[inst_20923] = inst_20926);
var inst_20931__$1 = (inst_20923 + (1));
var inst_20932 = (inst_20931__$1 < n);
var state_20958__$1 = (function (){var statearr_20972 = state_20958;
(statearr_20972[(12)] = inst_20930);

(statearr_20972[(11)] = inst_20931__$1);

return statearr_20972;
})();
if(cljs.core.truth_(inst_20932)){
var statearr_20973_21002 = state_20958__$1;
(statearr_20973_21002[(1)] = (8));

} else {
var statearr_20974_21003 = state_20958__$1;
(statearr_20974_21003[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (14))){
var inst_20951 = (state_20958[(2)]);
var inst_20952 = cljs.core.async.close_BANG_.call(null,out);
var state_20958__$1 = (function (){var statearr_20976 = state_20958;
(statearr_20976[(13)] = inst_20951);

return statearr_20976;
})();
var statearr_20977_21004 = state_20958__$1;
(statearr_20977_21004[(2)] = inst_20952);

(statearr_20977_21004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (10))){
var inst_20942 = (state_20958[(2)]);
var state_20958__$1 = state_20958;
var statearr_20978_21005 = state_20958__$1;
(statearr_20978_21005[(2)] = inst_20942);

(statearr_20978_21005[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20959 === (8))){
var inst_20922 = (state_20958[(8)]);
var inst_20931 = (state_20958[(11)]);
var tmp20975 = inst_20922;
var inst_20922__$1 = tmp20975;
var inst_20923 = inst_20931;
var state_20958__$1 = (function (){var statearr_20979 = state_20958;
(statearr_20979[(7)] = inst_20923);

(statearr_20979[(8)] = inst_20922__$1);

return statearr_20979;
})();
var statearr_20980_21006 = state_20958__$1;
(statearr_20980_21006[(2)] = null);

(statearr_20980_21006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___20992,out))
;
return ((function (switch__18220__auto__,c__18332__auto___20992,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_20984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20984[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_20984[(1)] = (1));

return statearr_20984;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_20958){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_20958);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e20985){if((e20985 instanceof Object)){
var ex__18224__auto__ = e20985;
var statearr_20986_21007 = state_20958;
(statearr_20986_21007[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21008 = state_20958;
state_20958 = G__21008;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_20958){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_20958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___20992,out))
})();
var state__18334__auto__ = (function (){var statearr_20987 = f__18333__auto__.call(null);
(statearr_20987[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___20992);

return statearr_20987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___20992,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args21009 = [];
var len__7276__auto___21083 = arguments.length;
var i__7277__auto___21084 = (0);
while(true){
if((i__7277__auto___21084 < len__7276__auto___21083)){
args21009.push((arguments[i__7277__auto___21084]));

var G__21085 = (i__7277__auto___21084 + (1));
i__7277__auto___21084 = G__21085;
continue;
} else {
}
break;
}

var G__21011 = args21009.length;
switch (G__21011) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21009.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__18332__auto___21087 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__18332__auto___21087,out){
return (function (){
var f__18333__auto__ = (function (){var switch__18220__auto__ = ((function (c__18332__auto___21087,out){
return (function (state_21053){
var state_val_21054 = (state_21053[(1)]);
if((state_val_21054 === (7))){
var inst_21049 = (state_21053[(2)]);
var state_21053__$1 = state_21053;
var statearr_21055_21088 = state_21053__$1;
(statearr_21055_21088[(2)] = inst_21049);

(statearr_21055_21088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (1))){
var inst_21012 = [];
var inst_21013 = inst_21012;
var inst_21014 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_21053__$1 = (function (){var statearr_21056 = state_21053;
(statearr_21056[(7)] = inst_21013);

(statearr_21056[(8)] = inst_21014);

return statearr_21056;
})();
var statearr_21057_21089 = state_21053__$1;
(statearr_21057_21089[(2)] = null);

(statearr_21057_21089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (4))){
var inst_21017 = (state_21053[(9)]);
var inst_21017__$1 = (state_21053[(2)]);
var inst_21018 = (inst_21017__$1 == null);
var inst_21019 = cljs.core.not.call(null,inst_21018);
var state_21053__$1 = (function (){var statearr_21058 = state_21053;
(statearr_21058[(9)] = inst_21017__$1);

return statearr_21058;
})();
if(inst_21019){
var statearr_21059_21090 = state_21053__$1;
(statearr_21059_21090[(1)] = (5));

} else {
var statearr_21060_21091 = state_21053__$1;
(statearr_21060_21091[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (15))){
var inst_21043 = (state_21053[(2)]);
var state_21053__$1 = state_21053;
var statearr_21061_21092 = state_21053__$1;
(statearr_21061_21092[(2)] = inst_21043);

(statearr_21061_21092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (13))){
var state_21053__$1 = state_21053;
var statearr_21062_21093 = state_21053__$1;
(statearr_21062_21093[(2)] = null);

(statearr_21062_21093[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (6))){
var inst_21013 = (state_21053[(7)]);
var inst_21038 = inst_21013.length;
var inst_21039 = (inst_21038 > (0));
var state_21053__$1 = state_21053;
if(cljs.core.truth_(inst_21039)){
var statearr_21063_21094 = state_21053__$1;
(statearr_21063_21094[(1)] = (12));

} else {
var statearr_21064_21095 = state_21053__$1;
(statearr_21064_21095[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (3))){
var inst_21051 = (state_21053[(2)]);
var state_21053__$1 = state_21053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21053__$1,inst_21051);
} else {
if((state_val_21054 === (12))){
var inst_21013 = (state_21053[(7)]);
var inst_21041 = cljs.core.vec.call(null,inst_21013);
var state_21053__$1 = state_21053;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21053__$1,(15),out,inst_21041);
} else {
if((state_val_21054 === (2))){
var state_21053__$1 = state_21053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21053__$1,(4),ch);
} else {
if((state_val_21054 === (11))){
var inst_21021 = (state_21053[(10)]);
var inst_21017 = (state_21053[(9)]);
var inst_21031 = (state_21053[(2)]);
var inst_21032 = [];
var inst_21033 = inst_21032.push(inst_21017);
var inst_21013 = inst_21032;
var inst_21014 = inst_21021;
var state_21053__$1 = (function (){var statearr_21065 = state_21053;
(statearr_21065[(11)] = inst_21033);

(statearr_21065[(12)] = inst_21031);

(statearr_21065[(7)] = inst_21013);

(statearr_21065[(8)] = inst_21014);

return statearr_21065;
})();
var statearr_21066_21096 = state_21053__$1;
(statearr_21066_21096[(2)] = null);

(statearr_21066_21096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (9))){
var inst_21013 = (state_21053[(7)]);
var inst_21029 = cljs.core.vec.call(null,inst_21013);
var state_21053__$1 = state_21053;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21053__$1,(11),out,inst_21029);
} else {
if((state_val_21054 === (5))){
var inst_21021 = (state_21053[(10)]);
var inst_21017 = (state_21053[(9)]);
var inst_21014 = (state_21053[(8)]);
var inst_21021__$1 = f.call(null,inst_21017);
var inst_21022 = cljs.core._EQ_.call(null,inst_21021__$1,inst_21014);
var inst_21023 = cljs.core.keyword_identical_QMARK_.call(null,inst_21014,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_21024 = (inst_21022) || (inst_21023);
var state_21053__$1 = (function (){var statearr_21067 = state_21053;
(statearr_21067[(10)] = inst_21021__$1);

return statearr_21067;
})();
if(cljs.core.truth_(inst_21024)){
var statearr_21068_21097 = state_21053__$1;
(statearr_21068_21097[(1)] = (8));

} else {
var statearr_21069_21098 = state_21053__$1;
(statearr_21069_21098[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (14))){
var inst_21046 = (state_21053[(2)]);
var inst_21047 = cljs.core.async.close_BANG_.call(null,out);
var state_21053__$1 = (function (){var statearr_21071 = state_21053;
(statearr_21071[(13)] = inst_21046);

return statearr_21071;
})();
var statearr_21072_21099 = state_21053__$1;
(statearr_21072_21099[(2)] = inst_21047);

(statearr_21072_21099[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (10))){
var inst_21036 = (state_21053[(2)]);
var state_21053__$1 = state_21053;
var statearr_21073_21100 = state_21053__$1;
(statearr_21073_21100[(2)] = inst_21036);

(statearr_21073_21100[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21054 === (8))){
var inst_21021 = (state_21053[(10)]);
var inst_21017 = (state_21053[(9)]);
var inst_21013 = (state_21053[(7)]);
var inst_21026 = inst_21013.push(inst_21017);
var tmp21070 = inst_21013;
var inst_21013__$1 = tmp21070;
var inst_21014 = inst_21021;
var state_21053__$1 = (function (){var statearr_21074 = state_21053;
(statearr_21074[(14)] = inst_21026);

(statearr_21074[(7)] = inst_21013__$1);

(statearr_21074[(8)] = inst_21014);

return statearr_21074;
})();
var statearr_21075_21101 = state_21053__$1;
(statearr_21075_21101[(2)] = null);

(statearr_21075_21101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18332__auto___21087,out))
;
return ((function (switch__18220__auto__,c__18332__auto___21087,out){
return (function() {
var cljs$core$async$state_machine__18221__auto__ = null;
var cljs$core$async$state_machine__18221__auto____0 = (function (){
var statearr_21079 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21079[(0)] = cljs$core$async$state_machine__18221__auto__);

(statearr_21079[(1)] = (1));

return statearr_21079;
});
var cljs$core$async$state_machine__18221__auto____1 = (function (state_21053){
while(true){
var ret_value__18222__auto__ = (function (){try{while(true){
var result__18223__auto__ = switch__18220__auto__.call(null,state_21053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18223__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18223__auto__;
}
break;
}
}catch (e21080){if((e21080 instanceof Object)){
var ex__18224__auto__ = e21080;
var statearr_21081_21102 = state_21053;
(statearr_21081_21102[(5)] = ex__18224__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21053);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21080;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18222__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21103 = state_21053;
state_21053 = G__21103;
continue;
} else {
return ret_value__18222__auto__;
}
break;
}
});
cljs$core$async$state_machine__18221__auto__ = function(state_21053){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18221__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18221__auto____1.call(this,state_21053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18221__auto____0;
cljs$core$async$state_machine__18221__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18221__auto____1;
return cljs$core$async$state_machine__18221__auto__;
})()
;})(switch__18220__auto__,c__18332__auto___21087,out))
})();
var state__18334__auto__ = (function (){var statearr_21082 = f__18333__auto__.call(null);
(statearr_21082[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18332__auto___21087);

return statearr_21082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__18334__auto__);
});})(c__18332__auto___21087,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=async.js.map?rel=1466741595872