;; gorilla-repl.fileformat = 1

;; **
;;; # Graphing tests
;;; 
;;; A showcase of gorilla-plot graph types. Here I load both the vega and core namespaces. This is useful for development, but if you're just using the library then you only need to load the 'gorilla-plot.core namespace.
;; **

;; @@
(use 'gorilla-plot.vega :reload)
(use 'gorilla-plot.core :reload)
(use 'clojure.pprint)
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; **
;;; Some data to look at. And some gratuitous mathematics @@x = 5@@
;;; 
;;; $$a_i = \int_0^{l_i} \sin(x) dx$$
;; **

;; @@
(def d
  [1 3 5 7 9 5 4 6 9 8 3 5 6])
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;user/d</span>","value":"#'user/d"}
;; <=

;; **
;;; List plot plots data in the style of a scatter plot by default.
;; **

;; @@
(list-plot d)
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g1\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g2\"><path transform=\"translate(0,247.2187957763672)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(33.33333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(66.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(100,61.8046989440918)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(133.33333333333331,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(166.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(200,154.5117473602295)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(233.33333333333331,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(266.66666666666663,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(300,30.9023494720459)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(333.3333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(366.66666666666663,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(400,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path></g><g id=\"g3\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g4\" style=\"pointer-events: none;\"></g><g id=\"g5\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"33.83333333333333\" y1=\"0\" x2=\"33.83333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"67.16666666666666\" y1=\"0\" x2=\"67.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"100.5\" y1=\"0\" x2=\"100.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"133.83333333333331\" y1=\"0\" x2=\"133.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"167.16666666666666\" y1=\"0\" x2=\"167.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.5\" y1=\"0\" x2=\"200.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"233.83333333333331\" y1=\"0\" x2=\"233.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"267.16666666666663\" y1=\"0\" x2=\"267.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"300.5\" y1=\"0\" x2=\"300.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"333.8333333333333\" y1=\"0\" x2=\"333.8333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"367.16666666666663\" y1=\"0\" x2=\"367.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"400.5\" y1=\"0\" x2=\"400.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g6\" style=\"pointer-events: none;\"></g><g id=\"g7\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"33.83333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"67.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"100.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"133.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"167.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"200.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"233.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"267.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"300.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"333.8333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text><text x=\"367.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">11</text><text x=\"400.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">12</text></g><g id=\"g8\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g9\"></g></g></g><g id=\"g10\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g11\" style=\"pointer-events: none;\"></g><g id=\"g12\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"216.8164463043213\" x2=\"0\" y2=\"216.8164463043213\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"185.9140968322754\" x2=\"0\" y2=\"185.9140968322754\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"155.0117473602295\" x2=\"0\" y2=\"155.0117473602295\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"124.1093978881836\" x2=\"0\" y2=\"124.1093978881836\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"93.2070484161377\" x2=\"0\" y2=\"93.2070484161377\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"62.3046989440918\" x2=\"0\" y2=\"62.3046989440918\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"31.4023494720459\" x2=\"0\" y2=\"31.4023494720459\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g13\" style=\"pointer-events: none;\"></g><g id=\"g14\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"216.8164463043213\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"185.9140968322754\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"155.0117473602295\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"124.1093978881836\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"93.2070484161377\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"62.3046989440918\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"31.4023494720459\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g15\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g16\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; There are a number of options that can be given to the plot. At the moment your best bet is to peak at the source code to see what they are.
;; **

;; @@
(list-plot d :joined true :plot-size 600 :aspect-ratio 6 :opacity 0.5 :plot-range [:all :all])
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"660\" height=\"130\"><g transform=\"translate(50,10)\"><g id=\"g17\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"600\" height=\"100\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g18\"><path d=\"M0,100L50,75L100,50L150,25L200,0L249.99999999999997,50L300,62.5L349.99999999999994,37.5L400,0L450,12.5L499.99999999999994,75L550,50L600,37.5\" style=\"fill: none; stroke: rgb(255, 41, 210); stroke-width: 2px; stroke-opacity: 0.5;\"></path></g><g id=\"g19\"><g transform=\"translate(0,100)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g20\" style=\"pointer-events: none;\"></g><g id=\"g21\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"50.5\" y1=\"0\" x2=\"50.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"100.5\" y1=\"0\" x2=\"100.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"150.5\" y1=\"0\" x2=\"150.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.5\" y1=\"0\" x2=\"200.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"250.49999999999997\" y1=\"0\" x2=\"250.49999999999997\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"300.5\" y1=\"0\" x2=\"300.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"350.49999999999994\" y1=\"0\" x2=\"350.49999999999994\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"400.5\" y1=\"0\" x2=\"400.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"450.5\" y1=\"0\" x2=\"450.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"500.49999999999994\" y1=\"0\" x2=\"500.49999999999994\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"550.5\" y1=\"0\" x2=\"550.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"600.5\" y1=\"0\" x2=\"600.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g22\" style=\"pointer-events: none;\"></g><g id=\"g23\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"50.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"100.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"150.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"200.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"250.49999999999997\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"300.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"350.49999999999994\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"400.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"450.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"500.49999999999994\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text><text x=\"550.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">11</text><text x=\"600.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">12</text></g><g id=\"g24\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H600V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g25\"></g></g></g><g id=\"g26\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g27\" style=\"pointer-events: none;\"></g><g id=\"g28\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"100.5\" x2=\"0\" y2=\"100.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"88\" x2=\"0\" y2=\"88\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"75.5\" x2=\"0\" y2=\"75.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"63\" x2=\"0\" y2=\"63\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"50.5\" x2=\"0\" y2=\"50.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"38\" x2=\"0\" y2=\"38\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"25.5\" x2=\"0\" y2=\"25.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"13\" x2=\"0\" y2=\"13\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g29\" style=\"pointer-events: none;\"></g><g id=\"g30\"><text x=\"-9\" y=\"100.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"88\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"75.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"63\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"50.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"38\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"25.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"13\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g31\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V100H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g32\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; You can also plot bar charts. The first argument is the list of category names, the second the category values.
;; **

;; @@
(bar-chart (range (count d)) d)
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g33\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g34\"><rect x=\"5\" y=\"219.75004069010416\" width=\"29\" height=\"27.46875508626303\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"35\" y=\"164.81253051757812\" width=\"29\" height=\"82.40626525878906\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"65\" y=\"109.87502034505206\" width=\"29\" height=\"137.34377543131512\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"95\" y=\"54.93751017252606\" width=\"29\" height=\"192.28128560384113\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"125\" y=\"0\" width=\"29\" height=\"247.2187957763672\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"155\" y=\"109.87502034505206\" width=\"29\" height=\"137.34377543131512\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"185\" y=\"137.34377543131512\" width=\"29\" height=\"109.87502034505206\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"215\" y=\"82.40626525878906\" width=\"29\" height=\"164.81253051757812\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"245\" y=\"0\" width=\"29\" height=\"247.2187957763672\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"275\" y=\"27.46875508626303\" width=\"29\" height=\"219.75004069010416\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"305\" y=\"164.81253051757812\" width=\"29\" height=\"82.40626525878906\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"335\" y=\"109.87502034505206\" width=\"29\" height=\"137.34377543131512\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect><rect x=\"365\" y=\"82.40626525878906\" width=\"29\" height=\"164.81253051757812\" style=\"fill: rgb(70, 130, 180); opacity: 1;\"></rect></g><g id=\"g35\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g36\" style=\"pointer-events: none;\"></g><g id=\"g37\" style=\"pointer-events: none;\"><line x1=\"20.5\" y1=\"0\" x2=\"20.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"50.5\" y1=\"0\" x2=\"50.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"80.5\" y1=\"0\" x2=\"80.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"110.5\" y1=\"0\" x2=\"110.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"140.5\" y1=\"0\" x2=\"140.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"170.5\" y1=\"0\" x2=\"170.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.5\" y1=\"0\" x2=\"200.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"230.5\" y1=\"0\" x2=\"230.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"260.5\" y1=\"0\" x2=\"260.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"290.5\" y1=\"0\" x2=\"290.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"320.5\" y1=\"0\" x2=\"320.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"350.5\" y1=\"0\" x2=\"350.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"380.5\" y1=\"0\" x2=\"380.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g38\" style=\"pointer-events: none;\"></g><g id=\"g39\"><text x=\"20.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"50.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"80.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"110.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"140.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"170.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"200.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"230.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"260.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"290.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"320.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text><text x=\"350.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">11</text><text x=\"380.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">12</text></g><g id=\"g40\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g41\"></g></g></g><g id=\"g42\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g43\" style=\"pointer-events: none;\"></g><g id=\"g44\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"220.25004069010416\" x2=\"0\" y2=\"220.25004069010416\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"192.78128560384116\" x2=\"0\" y2=\"192.78128560384116\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"165.31253051757812\" x2=\"0\" y2=\"165.31253051757812\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"137.84377543131512\" x2=\"0\" y2=\"137.84377543131512\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"110.37502034505206\" x2=\"0\" y2=\"110.37502034505206\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"82.90626525878906\" x2=\"0\" y2=\"82.90626525878906\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"55.43751017252606\" x2=\"0\" y2=\"55.43751017252606\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"27.96875508626303\" x2=\"0\" y2=\"27.96875508626303\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g45\" style=\"pointer-events: none;\"></g><g id=\"g46\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"-9\" y=\"220.25004069010416\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"192.78128560384116\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"165.31253051757812\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"137.84377543131512\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"110.37502034505206\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"82.90626525878906\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"55.43751017252606\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"27.96875508626303\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g47\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g48\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; It's interesting to look at the structure of a plot.
;; **

;; @@
(def p (list-plot d))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;user/p</span>","value":"#'user/p"}
;; <=

;; **
;;; It's nothing but a clojure value, which is interpreted by Gorilla as a Vega visualisation and rendered appropriately.
;; **

;; @@
(pprint p)
;; @@
;; ->
;;; {:content
;;;  {:axes [{:scale &quot;x&quot;, :type &quot;x&quot;} {:scale &quot;y&quot;, :type &quot;y&quot;}],
;;;   :scales
;;;   [{:name &quot;x&quot;,
;;;     :type &quot;linear&quot;,
;;;     :range &quot;width&quot;,
;;;     :zero false,
;;;     :domain
;;;     {:data &quot;ec934504-1aa9-4411-9835-c6bfce60ddd5&quot;, :field &quot;data.x&quot;}}
;;;    {:name &quot;y&quot;,
;;;     :type &quot;linear&quot;,
;;;     :range &quot;height&quot;,
;;;     :nice true,
;;;     :zero false,
;;;     :domain
;;;     {:data &quot;ec934504-1aa9-4411-9835-c6bfce60ddd5&quot;, :field &quot;data.y&quot;}}],
;;;   :marks
;;;   [{:type &quot;symbol&quot;,
;;;     :from {:data &quot;ec934504-1aa9-4411-9835-c6bfce60ddd5&quot;},
;;;     :properties
;;;     {:enter
;;;      {:x {:scale &quot;x&quot;, :field &quot;data.x&quot;},
;;;       :y {:scale &quot;y&quot;, :field &quot;data.y&quot;},
;;;       :fill {:value &quot;steelblue&quot;},
;;;       :fillOpacity {:value 1}},
;;;      :update
;;;      {:shape &quot;circle&quot;,
;;;       :size {:value 70},
;;;       :stroke {:value &quot;transparent&quot;}},
;;;      :hover {:size {:value 210}, :stroke {:value &quot;white&quot;}}}}],
;;;   :data
;;;   [{:name &quot;ec934504-1aa9-4411-9835-c6bfce60ddd5&quot;,
;;;     :values
;;;     ({:x 0, :y 1}
;;;      {:x 1, :y 3}
;;;      {:x 2, :y 5}
;;;      {:x 3, :y 7}
;;;      {:x 4, :y 9}
;;;      {:x 5, :y 5}
;;;      {:x 6, :y 4}
;;;      {:x 7, :y 6}
;;;      {:x 8, :y 9}
;;;      {:x 9, :y 8}
;;;      {:x 10, :y 3}
;;;      {:x 11, :y 5}
;;;      {:x 12, :y 6})}],
;;;   :width 400,
;;;   :height 247.2188,
;;;   :padding {:bottom 20, :top 10, :right 10, :left 50}}}
;;; 
;; <-
;; =>
;;; {"type":"html","content":"<span class='clj-nil'>nil</span>","value":"nil"}
;; <=

;; **
;;; This makes it easy to tweak plot properties 'after the fact'.
;; **

;; @@
(assoc-in p [:content "marks" 0 "properties" "enter" "fill" "value"] "red")
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g49\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g50\"><path transform=\"translate(0,247.2187957763672)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(33.33333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(66.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(100,61.8046989440918)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(133.33333333333331,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(166.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(200,154.5117473602295)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(233.33333333333331,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(266.66666666666663,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(300,30.9023494720459)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(333.3333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(366.66666666666663,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(400,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path></g><g id=\"g51\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g52\" style=\"pointer-events: none;\"></g><g id=\"g53\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"33.83333333333333\" y1=\"0\" x2=\"33.83333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"67.16666666666666\" y1=\"0\" x2=\"67.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"100.5\" y1=\"0\" x2=\"100.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"133.83333333333331\" y1=\"0\" x2=\"133.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"167.16666666666666\" y1=\"0\" x2=\"167.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.5\" y1=\"0\" x2=\"200.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"233.83333333333331\" y1=\"0\" x2=\"233.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"267.16666666666663\" y1=\"0\" x2=\"267.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"300.5\" y1=\"0\" x2=\"300.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"333.8333333333333\" y1=\"0\" x2=\"333.8333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"367.16666666666663\" y1=\"0\" x2=\"367.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"400.5\" y1=\"0\" x2=\"400.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g54\" style=\"pointer-events: none;\"></g><g id=\"g55\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"33.83333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"67.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"100.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"133.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"167.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"200.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"233.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"267.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"300.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"333.8333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text><text x=\"367.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">11</text><text x=\"400.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">12</text></g><g id=\"g56\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g57\"></g></g></g><g id=\"g58\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g59\" style=\"pointer-events: none;\"></g><g id=\"g60\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"216.8164463043213\" x2=\"0\" y2=\"216.8164463043213\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"185.9140968322754\" x2=\"0\" y2=\"185.9140968322754\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"155.0117473602295\" x2=\"0\" y2=\"155.0117473602295\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"124.1093978881836\" x2=\"0\" y2=\"124.1093978881836\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"93.2070484161377\" x2=\"0\" y2=\"93.2070484161377\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"62.3046989440918\" x2=\"0\" y2=\"62.3046989440918\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"31.4023494720459\" x2=\"0\" y2=\"31.4023494720459\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g61\" style=\"pointer-events: none;\"></g><g id=\"g62\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"216.8164463043213\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"185.9140968322754\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"155.0117473602295\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"124.1093978881836\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"93.2070484161377\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"62.3046989440918\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"31.4023494720459\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g63\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g64\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; Another key feature of gorilla-plot, is that because plots are values, it's straighforward to compose them. Here's another plot
;; **

;; @@
(def p2 (list-plot d :joined true :plot-range [:all [1 5]]))
;; @@
;; =>
;;; {"type":"html","content":"<span class='clj-var'>#&#x27;user/p2</span>","value":"#'user/p2"}
;; <=

;; **
;;; And here we compose them to form a single plot. The axes and plot range are taken from the first plot given to compose.
;; **

;; @@
(compose p p2)
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g65\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g66\"><path transform=\"translate(0,247.2187957763672)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(33.33333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(66.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(100,61.8046989440918)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(133.33333333333331,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(166.66666666666666,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(200,154.5117473602295)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(233.33333333333331,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(266.66666666666663,0)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(300,30.9023494720459)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(333.3333333333333,185.4140968322754)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(366.66666666666663,123.6093978881836)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path><path transform=\"translate(400,92.7070484161377)\" d=\"M0,4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,-4.720348719413148A4.720348719413148,4.720348719413148 0 1,1 0,4.720348719413148Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 1; stroke: transparent;\"></path></g><g id=\"g67\"><path d=\"M0,247.2187957763672L33.33333333333333,185.4140968322754L66.66666666666666,123.6093978881836L100,61.8046989440918L133.33333333333331,0L166.66666666666666,123.6093978881836L200,154.5117473602295L233.33333333333331,92.7070484161377L266.66666666666663,0L300,30.9023494720459L333.3333333333333,185.4140968322754L366.66666666666663,123.6093978881836L400,92.7070484161377\" style=\"fill: none; stroke: rgb(255, 41, 210); stroke-width: 2px; stroke-opacity: 1;\"></path></g><g id=\"g68\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g69\" style=\"pointer-events: none;\"></g><g id=\"g70\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"33.83333333333333\" y1=\"0\" x2=\"33.83333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"67.16666666666666\" y1=\"0\" x2=\"67.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"100.5\" y1=\"0\" x2=\"100.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"133.83333333333331\" y1=\"0\" x2=\"133.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"167.16666666666666\" y1=\"0\" x2=\"167.16666666666666\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.5\" y1=\"0\" x2=\"200.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"233.83333333333331\" y1=\"0\" x2=\"233.83333333333331\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"267.16666666666663\" y1=\"0\" x2=\"267.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"300.5\" y1=\"0\" x2=\"300.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"333.8333333333333\" y1=\"0\" x2=\"333.8333333333333\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"367.16666666666663\" y1=\"0\" x2=\"367.16666666666663\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"400.5\" y1=\"0\" x2=\"400.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g71\" style=\"pointer-events: none;\"></g><g id=\"g72\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"33.83333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"67.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"100.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"133.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"167.16666666666666\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"200.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"233.83333333333331\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"267.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"300.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"333.8333333333333\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text><text x=\"367.16666666666663\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">11</text><text x=\"400.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">12</text></g><g id=\"g73\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g74\"></g></g></g><g id=\"g75\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g76\" style=\"pointer-events: none;\"></g><g id=\"g77\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"216.8164463043213\" x2=\"0\" y2=\"216.8164463043213\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"185.9140968322754\" x2=\"0\" y2=\"185.9140968322754\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"155.0117473602295\" x2=\"0\" y2=\"155.0117473602295\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"124.1093978881836\" x2=\"0\" y2=\"124.1093978881836\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"93.2070484161377\" x2=\"0\" y2=\"93.2070484161377\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"62.3046989440918\" x2=\"0\" y2=\"62.3046989440918\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"31.4023494720459\" x2=\"0\" y2=\"31.4023494720459\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g78\" style=\"pointer-events: none;\"></g><g id=\"g79\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"216.8164463043213\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"185.9140968322754\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"155.0117473602295\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"124.1093978881836\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"93.2070484161377\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"62.3046989440918\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"31.4023494720459\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g80\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g81\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; You can also plot functions.
;; **

;; @@
(plot (fn [x] (Math/sin x)) [0 10] :color "orange" :plot-points 50)
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g82\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g83\"><path d=\"M0,123.6093978881836L8.16326530612245,99.05200116871617L16.3265306122449,75.47363039018717L24.489795918367346,53.814280817605464L32.6530612244898,34.937442394048105L40.816326530612244,19.59567512050711L48.97959183673469,8.400606862599432L57.14285714285714,1.7985496769438782L65.3061224489796,0.05270675735420127L73.46938775510203,3.232679353775893L81.63265306122449,11.211691990007779L89.79591836734694,23.671646602025305L97.95918367346938,40.115804104353316L106.12244897959184,59.88858781044112L114.28571428571428,82.20171920714009L122.44897959183673,106.16564413239934L130.6122448979592,130.82499649360975L138.77551020408163,155.1966857000155L146.93877551020407,178.30908938340997L155.10204081632654,199.24078891697474L163.26530612244898,217.15730346931767L171.42857142857142,231.34435812285196L179.59183673469389,241.23635976158127L187.75510204081633,246.43894548447204L195.91836734693877,246.74470461030057L204.08163265306123,242.1414474872367L212.24489795918367,232.81269145581007L220.4081632653061,219.1303445914485L228.57142857142856,201.63987890269382L236.73469387755102,181.03858408291202L244.89795918367346,158.14776876981787L253.06122448979588,133.88001756090597L261.2244897959184,109.20280914429512L269.3877551020408,85.09994597534308L277.55102040816325,62.532333176154594L285.7142857142857,42.39967027953654L293.87755102040813,25.5045830467258L302.0408163265306,12.520625310170203L310.2040816326531,3.9654265069533494L318.3673469387755,0.18005542599919977L326.53061224489795,1.3154228713587202L334.69387755102036,7.326265324500071L342.85714285714283,17.97294945800894L351.0204081632653,32.83102556042962L359.18367346938777,51.30814900733466L367.34693877551024,72.66769517295094L375.51020408163265,96.05812633030777L383.67346938775506,120.54693977423723L391.83673469387753,145.15784376265077L400,168.90967918858564\" style=\"fill: none; stroke: orange; stroke-width: 2px; stroke-opacity: 1;\"></path></g><g id=\"g84\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g85\" style=\"pointer-events: none;\"></g><g id=\"g86\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"41.31632592240159\" y1=\"0\" x2=\"41.31632592240159\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"82.13265184480318\" y1=\"0\" x2=\"82.13265184480318\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"122.94897776720478\" y1=\"0\" x2=\"122.94897776720478\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"163.76530368960636\" y1=\"0\" x2=\"163.76530368960636\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"204.58162961200796\" y1=\"0\" x2=\"204.58162961200796\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"245.39795553440956\" y1=\"0\" x2=\"245.39795553440956\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"286.21428145681114\" y1=\"0\" x2=\"286.21428145681114\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"327.0306073792127\" y1=\"0\" x2=\"327.0306073792127\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"367.84693330161434\" y1=\"0\" x2=\"367.84693330161434\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g87\" style=\"pointer-events: none;\"></g><g id=\"g88\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"41.31632592240159\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"82.13265184480318\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"122.94897776720478\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"163.76530368960636\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"204.58162961200796\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"245.39795553440956\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"286.21428145681114\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"327.0306073792127\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"367.84693330161434\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g89\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g90\"></g></g></g><g id=\"g91\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g92\" style=\"pointer-events: none;\"></g><g id=\"g93\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"222.99691619873047\" x2=\"0\" y2=\"222.99691619873047\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"198.27503662109376\" x2=\"0\" y2=\"198.27503662109376\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"173.55315704345702\" x2=\"0\" y2=\"173.55315704345702\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"148.8312774658203\" x2=\"0\" y2=\"148.8312774658203\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"124.1093978881836\" x2=\"0\" y2=\"124.1093978881836\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"99.38751831054688\" x2=\"0\" y2=\"99.38751831054688\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"74.66563873291017\" x2=\"0\" y2=\"74.66563873291017\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"49.943759155273426\" x2=\"0\" y2=\"49.943759155273426\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"25.221879577636713\" x2=\"0\" y2=\"25.221879577636713\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g94\" style=\"pointer-events: none;\"></g><g id=\"g95\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">-1.0</text><text x=\"-9\" y=\"222.99691619873047\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">-0.8</text><text x=\"-9\" y=\"198.27503662109376\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">-0.6</text><text x=\"-9\" y=\"173.55315704345702\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">-0.4</text><text x=\"-9\" y=\"148.8312774658203\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">-0.2</text><text x=\"-9\" y=\"124.1093978881836\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.0</text><text x=\"-9\" y=\"99.38751831054688\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.2</text><text x=\"-9\" y=\"74.66563873291017\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.4</text><text x=\"-9\" y=\"49.943759155273426\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.6</text><text x=\"-9\" y=\"25.221879577636713\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.8</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1.0</text></g><g id=\"g96\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g97\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; And, of course, these plots compose too.
;; **

;; @@
(compose
  (list-plot (map #(vector % (rand %)) (range 0 10 0.01)) :opacity 0.3 :symbol-size 50)
  (plot (fn [x] (* x (Math/pow (Math/sin x) 2))) [0 10]))
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g98\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g99\"><path transform=\"translate(0,247.2187957763672)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(0.4000000000000068,247.16686462862887)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(0.8000000000000136,246.87862069154014)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(1.2000000000000202,246.52130502797522)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(1.6000000000000272,247.10637993566)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(2.0000000000000338,246.58742381673724)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(2.4000000000000408,245.78439673433985)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(2.800000000000048,245.6241968658985)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(3.2000000000000544,246.71132208232865)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(3.600000000000061,245.54998951096255)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(4.0000000000000675,245.404267222914)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(4.400000000000073,244.69399366817657)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(4.80000000000008,244.4697123275204)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(5.200000000000086,244.317031188726)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(5.600000000000094,244.82730909879166)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(6.000000000000101,244.6107660314287)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(6.400000000000109,243.99146260876364)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(6.800000000000115,245.31088473083364)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(7.200000000000122,245.85731391994113)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(7.600000000000129,243.8233690758631)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(8.000000000000137,243.1974858099288)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(8.400000000000144,246.57395024735203)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(8.80000000000015,243.71300977510182)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(9.200000000000157,244.33202973400256)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(9.600000000000165,242.63023080939354)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(10.00000000000017,245.14144268431326)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(10.400000000000178,246.44356124513496)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(10.800000000000184,241.37511790601008)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(11.200000000000191,241.21391060579427)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(11.600000000000199,245.75500038593097)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(12.000000000000206,240.42019845202404)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(12.400000000000214,240.7026845324042)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(12.80000000000022,242.68199675800463)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(13.200000000000228,240.28471424798988)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(13.600000000000234,241.6673493481387)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(14.000000000000243,239.39386616836066)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(14.400000000000249,244.82318361555156)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(14.800000000000255,247.12479738122278)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(15.200000000000264,245.52652021037454)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(15.60000000000027,239.19827444410006)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(16.000000000000277,245.1026459770572)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(16.400000000000283,244.8658693012749)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(16.800000000000292,238.8190132614006)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(17.200000000000298,238.38145254846853)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(17.600000000000303,242.58994110039873)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(18.000000000000313,242.44287019701903)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(18.40000000000032,238.57240798611014)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(18.800000000000328,243.62965095642838)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(19.200000000000333,240.23718904079746)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(19.600000000000342,244.6328062713407)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(20.000000000000345,240.39056949493042)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(20.400000000000354,240.8468686036875)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(20.80000000000036,238.62987546425748)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(21.200000000000365,244.51149077492514)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(21.600000000000374,242.85703728588373)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(22.00000000000038,243.18885163469383)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(22.40000000000039,242.41485736029878)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(22.800000000000395,240.29416863940438)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(23.200000000000404,244.72343220562817)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(23.60000000000041,241.10932386342907)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(24.000000000000416,236.18043583845466)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(24.400000000000425,240.2361666283513)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(24.80000000000043,243.25077155047026)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(25.20000000000044,232.62968067252302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(25.600000000000446,244.98884960586147)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(26.00000000000045,237.43980439021308)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(26.40000000000046,237.1548656524633)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(26.800000000000466,231.08791949382146)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(27.200000000000475,237.2906399113779)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(27.60000000000048,244.51264696752668)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(28.000000000000487,230.1375409938122)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(28.400000000000496,236.41660246100895)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(28.8000000000005,240.8006719604118)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(29.200000000000507,244.83834442719976)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(29.600000000000513,230.0238327901884)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(30.000000000000522,239.69771012482434)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(30.40000000000053,244.80276234443343)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(30.800000000000537,246.77218681086038)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(31.200000000000543,230.65992411865201)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(31.60000000000055,246.1180855773775)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(32.00000000000056,232.71526126643178)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(32.40000000000057,241.67048489083732)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(32.80000000000057,246.29985678067197)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(33.20000000000058,230.39403870380062)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(33.600000000000584,245.81473721740997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(34.0000000000006,232.00448488969988)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(34.4000000000006,240.1702209313042)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(34.80000000000061,236.93364139009523)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(35.200000000000614,238.6629467742967)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(35.60000000000062,239.02788471723912)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(36.00000000000063,244.9977728096025)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(36.40000000000064,246.0547705773983)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(36.800000000000644,225.4660114239997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(37.20000000000065,240.6487601599419)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(37.60000000000066,234.59058404004404)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(38.00000000000067,243.82969884300303)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(38.400000000000674,240.4327132910547)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(38.80000000000068,227.880259037579)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(39.200000000000685,239.26066887733077)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(39.6000000000007,239.83377530108822)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(40.0000000000007,223.23938512961035)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(40.40000000000071,246.20574375540818)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(40.800000000000715,233.07499596859893)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(41.20000000000072,224.60742545296804)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(41.60000000000073,246.66024115651794)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(42.00000000000074,237.97531695748194)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(42.400000000000745,244.45805642139888)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(42.80000000000075,227.15798127282352)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(43.20000000000076,242.6734934095578)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(43.60000000000077,230.53584727595108)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(44.000000000000774,223.93818791597363)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(44.40000000000078,235.00063730323902)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(44.800000000000786,232.23416500448033)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(45.2000000000008,246.22764868371212)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(45.600000000000804,232.64510096757394)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(46.00000000000081,228.4037031883286)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(46.400000000000816,240.64633411594355)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(46.80000000000082,225.31309548200267)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(47.20000000000083,223.4915302070164)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(47.60000000000083,227.3048940389959)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(48.00000000000084,241.12769092455673)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(48.40000000000085,221.36034589043962)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(48.80000000000086,222.3245357746848)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(49.20000000000086,231.4913025356968)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(49.60000000000087,221.09235119094794)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(50.000000000000874,218.26508886773894)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(50.40000000000089,237.36408038383254)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(50.80000000000089,246.83247352929186)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(51.2000000000009,241.70224756137353)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(51.60000000000091,240.88327610266526)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(52.00000000000091,231.03135870685801)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(52.40000000000092,233.797928512309)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(52.80000000000092,234.46799614425373)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(53.200000000000934,242.9776227317975)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(53.600000000000946,223.4914639097365)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(54.000000000000945,223.97366672146754)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(54.40000000000096,240.8969934382552)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(54.800000000000956,229.71812902642048)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(55.20000000000097,220.7944206843656)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(55.60000000000098,224.5186164282654)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(56.00000000000098,234.03345414087107)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(56.40000000000099,241.62351633342945)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(56.80000000000099,221.53001948822146)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(57.200000000001005,223.4273316035305)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(57.60000000000102,243.2606158399246)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(58.000000000001016,218.23526936830635)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(58.40000000000103,217.5178899094348)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(58.80000000000103,240.54668571817402)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(59.20000000000104,210.66102408984554)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(59.60000000000105,229.7774692544395)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(60.00000000000105,244.1705831481468)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(60.400000000001064,240.3465235382976)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(60.80000000000106,215.0093255141775)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(61.200000000001076,210.91609065408153)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(61.60000000000109,242.98934061589375)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(62.00000000000109,231.41656956867294)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(62.4000000000011,221.39111702227729)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(62.8000000000011,235.74201831262369)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(63.20000000000111,211.92023178830237)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(63.600000000001124,230.67290010723244)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(64.00000000000112,225.34685620049237)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(64.40000000000113,216.31071018724487)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(64.80000000000115,228.32012056250534)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(65.20000000000114,223.363965440849)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(65.60000000000116,234.43521102544096)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(66.00000000000115,227.10634336010352)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(66.40000000000117,236.96234059252788)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(66.80000000000118,213.98422462664755)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(67.20000000000118,244.7606322182215)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(67.60000000000119,224.4367344262849)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(68.0000000000012,209.20585969443079)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(68.4000000000012,215.94505286001026)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(68.80000000000122,205.22870246991323)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(69.20000000000121,220.5724080667801)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(69.60000000000123,237.41602457768087)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(70.00000000000122,215.4858698425989)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(70.40000000000124,238.16652326866108)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(70.80000000000125,235.31735069169943)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(71.20000000000125,236.21323030572432)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(71.60000000000126,216.22642222922562)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(72.00000000000126,208.705196400004)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(72.40000000000127,204.33384353256017)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(72.80000000000129,221.59793958138448)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(73.20000000000128,207.84396439761088)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(73.6000000000013,230.26776957415484)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(74.0000000000013,201.68953338079498)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(74.40000000000131,239.29418798421483)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(74.80000000000132,246.95408849183693)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(75.20000000000132,207.1664444087309)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(75.60000000000133,223.8010122049891)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(76.00000000000135,214.83122912631723)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(76.40000000000134,232.3464590613155)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(76.80000000000136,236.25388085393743)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(77.20000000000135,208.12201674589915)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(77.60000000000137,241.53852016125887)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(78.00000000000138,223.20641441119486)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(78.40000000000138,231.5771227690656)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(78.80000000000139,234.74133913342823)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(79.2000000000014,221.18578757788453)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(79.6000000000014,235.86230827213066)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(80.0000000000014,205.78606563456714)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(80.4000000000014,219.53673326910337)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(80.80000000000139,237.88011821026936)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(81.2000000000014,200.93564220398605)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(81.60000000000139,218.8230541393402)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(82.00000000000139,232.84838971469705)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(82.4000000000014,208.88748868079801)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(82.80000000000139,208.02942822196525)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(83.20000000000138,228.27756985773567)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(83.60000000000139,240.28562947618659)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(84.00000000000138,243.16212007751204)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(84.40000000000138,197.95968516403934)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(84.80000000000138,235.6668607923248)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(85.20000000000138,231.42311647851818)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(85.60000000000137,244.90784715811859)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(86.00000000000138,228.81282391390545)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(86.40000000000137,239.50447419389832)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(86.80000000000138,239.5206676225335)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(87.20000000000137,217.4889619624508)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(87.60000000000136,230.73472878907697)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(88.00000000000136,210.6788529537801)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(88.40000000000137,200.87789402182653)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(88.80000000000136,211.84753187568157)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(89.20000000000135,209.87464634856258)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(89.60000000000136,202.2772056696935)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(90.00000000000135,236.2957153103253)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(90.40000000000136,243.3569972557434)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(90.80000000000136,243.86089480747384)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(91.20000000000135,191.03290314651983)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(91.60000000000134,230.00388450401402)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(92.00000000000135,227.55723267914414)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(92.40000000000134,245.46004756941258)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(92.80000000000135,202.81524693184429)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(93.20000000000134,191.60905755931117)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(93.60000000000134,215.6437606122365)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(94.00000000000134,239.92841512625867)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(94.40000000000134,233.94941012711877)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(94.80000000000133,233.09554686024242)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(95.20000000000132,215.81324058659828)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(95.60000000000133,208.65092725274093)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(96.00000000000134,231.97060718751155)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(96.40000000000133,243.47050145219418)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(96.80000000000133,224.01554363781622)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(97.20000000000132,212.98535388745066)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(97.60000000000132,194.54530848256616)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(98.00000000000132,191.42660133475243)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(98.40000000000131,242.55798235889034)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(98.80000000000132,224.3898584971295)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(99.20000000000132,210.2478660330716)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(99.60000000000132,238.01143412222135)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(100.00000000000131,232.34383062265695)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(100.40000000000131,224.13667511328305)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(100.8000000000013,187.48762313446156)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(101.20000000000131,188.89436030516455)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(101.60000000000132,240.68296770336977)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(102.00000000000131,199.74927433339627)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(102.40000000000128,204.62916131597817)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(102.80000000000129,188.88991705861812)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(103.2000000000013,239.26383439876997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(103.60000000000129,208.95866245950032)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(104.0000000000013,243.17212813858947)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(104.40000000000128,231.5628469361198)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(104.80000000000129,183.72346112636313)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(105.2000000000013,225.2956521139772)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(105.60000000000129,217.28910305512352)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(106.0000000000013,191.80400036425306)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(106.4000000000013,189.11339131157976)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(106.80000000000128,233.9776817121306)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(107.20000000000127,240.76802168669332)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(107.60000000000127,234.77822485328122)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(108.00000000000128,245.78104256342542)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(108.40000000000127,188.96323557035936)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(108.80000000000128,228.8186409788885)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(109.20000000000127,189.0352583202716)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(109.60000000000127,239.01709757867405)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(110.00000000000128,185.46959857946158)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(110.40000000000127,191.75503019425653)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(110.80000000000125,236.06656658506486)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(111.20000000000125,195.06432747350885)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(111.60000000000126,210.84820703265933)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(112.00000000000125,237.84756495682018)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(112.40000000000126,224.80364540702655)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(112.80000000000126,243.56652351078222)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(113.20000000000125,184.59026958318879)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(113.60000000000126,228.11085362114719)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(114.00000000000125,243.93988278415455)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(114.40000000000126,190.87336457291877)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(114.80000000000126,210.1771392564174)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(115.20000000000124,232.96030578695368)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(115.60000000000123,180.17517314651545)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(116.00000000000124,179.42510730797633)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(116.40000000000124,232.48897467603794)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(116.80000000000123,191.14867582022822)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(117.20000000000124,203.31735296939303)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(117.60000000000123,205.8307863657842)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(118.00000000000124,200.25250303864527)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(118.40000000000124,220.37692115426276)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(118.80000000000123,206.79548925706268)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(119.20000000000121,241.39506620647506)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(119.60000000000122,238.00605290837723)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(120.00000000000122,174.05021729270305)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(120.40000000000121,215.4998140352506)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(120.80000000000122,206.72044598979562)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(121.20000000000121,203.5932310341498)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(121.60000000000122,216.4706834661198)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(122.00000000000122,179.4640037553703)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(122.40000000000121,217.68895969958277)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(122.80000000000122,173.38661060051237)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(123.2000000000012,230.41044435915626)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(123.6000000000012,238.27461646752337)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(124.0000000000012,196.20638504139396)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(124.4000000000012,239.1917103809543)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(124.8000000000012,227.60530663655896)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(125.2000000000012,187.31612937753883)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(125.6000000000012,228.3537269423479)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(126.0000000000012,247.07632473860096)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(126.4000000000012,233.3597964143929)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(126.8000000000012,182.5809109677756)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(127.2000000000012,237.5443479039216)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(127.60000000000117,213.78389399193796)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(128.0000000000012,226.11596937814807)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(128.40000000000117,230.8470374323875)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(128.80000000000118,168.70595183787677)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(129.20000000000118,217.02868869914136)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(129.6000000000012,202.27726635706983)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(130.0000000000012,221.91815568769607)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(130.40000000000117,192.12363414078462)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(130.80000000000118,219.48652194721132)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(131.20000000000118,194.23736907782882)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(131.60000000000116,200.66314109540815)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(132.00000000000117,228.1291851383547)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(132.40000000000117,210.9692856697159)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(132.80000000000115,218.00131865037156)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(133.20000000000115,235.13057967954688)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(133.60000000000116,230.5176206849302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(134.00000000000117,164.6300981130011)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(134.40000000000117,217.97968429591606)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(134.80000000000118,182.32704851890276)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(135.20000000000115,244.01539722688938)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(135.60000000000113,187.42958862444968)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(136.00000000000114,185.5791265189124)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(136.40000000000114,187.37839351137436)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(136.80000000000115,241.07106924829878)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(137.20000000000115,222.8363834043829)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(137.60000000000113,245.77176073298375)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(138.00000000000114,169.85701151534641)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(138.40000000000114,214.35347628342583)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(138.80000000000115,219.07618914665227)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(139.20000000000115,175.72079326659778)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(139.60000000000116,235.19421247923174)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(140.00000000000114,188.17355257076474)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(140.4000000000011,218.51632565644877)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(140.80000000000112,163.21728112719927)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(141.20000000000113,162.77818241266272)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(141.60000000000113,187.7085112085495)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(142.00000000000114,168.4891697807788)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(142.4000000000011,168.52307333978462)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(142.80000000000112,213.34028122874878)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(143.20000000000113,232.13339003050143)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(143.60000000000113,201.9460102012913)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(144.0000000000011,229.809197590173)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(144.4000000000011,188.37200228841624)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(144.8000000000011,231.96865862340834)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(145.2000000000011,160.9068223366584)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(145.6000000000011,200.96300738047333)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(146.0000000000011,162.29455849179686)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(146.4000000000011,243.6419029303902)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(146.80000000000112,160.27946921530702)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(147.2000000000011,170.35727604503649)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(147.6000000000011,222.04324562976444)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(148.00000000000108,206.2894210288105)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(148.40000000000109,199.3685931702058)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(148.8000000000011,159.40216042178668)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(149.2000000000011,244.0688535856729)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(149.60000000000107,208.17880691694742)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(150.00000000000108,195.77705840907578)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(150.40000000000109,182.67250879488472)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(150.8000000000011,232.74157180786867)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(151.2000000000011,201.8889892752474)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(151.6000000000011,215.77218049110084)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(152.00000000000108,171.506683699789)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(152.40000000000106,224.09930435443394)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(152.80000000000106,242.22369088178613)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(153.20000000000107,174.22137923866097)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(153.60000000000107,191.22241475526747)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(154.00000000000108,217.08636596019366)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(154.40000000000106,163.88714201841526)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(154.80000000000106,155.93427877287434)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(155.20000000000107,204.33684926786822)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(155.60000000000107,162.5861039605855)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(156.00000000000108,223.54645144407732)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(156.40000000000106,156.25802354215796)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(156.80000000000106,161.20575824503572)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(157.20000000000104,229.8486638257592)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(157.60000000000105,229.9278914813646)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(158.00000000000105,179.8099842165483)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(158.40000000000106,240.6874353982807)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(158.80000000000106,190.67414115212588)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(159.20000000000104,205.0313313328585)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(159.60000000000105,168.65041645662365)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(160.00000000000105,218.4591978764255)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(160.40000000000106,197.05948579149498)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(160.80000000000106,187.64240521712674)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(161.20000000000104,149.00233804386653)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(161.60000000000105,225.2286941853336)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(162.00000000000105,153.78842659839341)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(162.40000000000106,243.35563066431072)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(162.80000000000106,212.85847595311282)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(163.20000000000107,177.65418716240328)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(163.60000000000105,148.8173818054911)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(164.00000000000102,210.30177189240786)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(164.40000000000103,157.87156909421228)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(164.80000000000103,230.2795215647704)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(165.20000000000104,229.1600235533017)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(165.60000000000105,163.39919596599833)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(166.00000000000102,205.87847778080038)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(166.40000000000103,158.06568837825284)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(166.80000000000103,144.34387787867865)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(167.20000000000104,194.47141270452468)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(167.60000000000105,191.8711621134985)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(168.00000000000102,198.27557243050478)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(168.40000000000103,233.6016393012223)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(168.800000000001,160.28675768214288)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(169.200000000001,201.43363448784274)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(169.60000000000102,227.93710089675335)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(170.00000000000102,170.36457115955312)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(170.40000000000103,246.28491118047046)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(170.800000000001,243.7095768540085)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(171.200000000001,181.8393503717799)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(171.60000000000102,245.7503751333409)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(172.00000000000102,169.2099394339656)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(172.400000000001,201.53319463119226)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(172.800000000001,182.06289699299623)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(173.200000000001,209.22118178826926)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(173.600000000001,205.9092797587078)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(174.000000000001,150.94001888041487)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(174.400000000001,181.77829959903463)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(174.800000000001,157.22983860207233)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(175.200000000001,237.06940157443924)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(175.600000000001,144.06676531504993)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(176.000000000001,170.25124579055955)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(176.40000000000097,239.12729520391062)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(176.80000000000098,217.5116639362717)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(177.20000000000098,244.53876297672898)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(177.600000000001,160.16018933935916)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(178.00000000000097,204.14316891249732)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(178.40000000000097,153.52527230093506)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(178.80000000000098,165.57407725612586)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(179.20000000000098,198.84058521294452)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(179.600000000001,196.3476250731592)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(180.000000000001,183.99045186249717)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(180.40000000000097,242.16093776992716)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(180.80000000000095,198.38392202289353)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(181.20000000000095,226.8473355190984)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(181.60000000000096,229.513662453094)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(182.00000000000097,208.41682014508822)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(182.40000000000097,146.41820456305697)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(182.80000000000095,245.39708851770604)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(183.20000000000095,232.5694101512518)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(183.60000000000096,220.75175542457123)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(184.00000000000097,165.4049220211636)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(184.40000000000097,169.49443929556182)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(184.80000000000095,223.09169491874673)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(185.20000000000095,166.4247980411475)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(185.60000000000093,207.50944833221118)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(186.00000000000094,229.31394041318876)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(186.40000000000094,228.4164923348126)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(186.80000000000095,189.96471957863153)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(187.20000000000095,224.12969218050975)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(187.60000000000093,151.46839526713245)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(188.00000000000094,151.4724707121371)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(188.40000000000094,164.0774273170503)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(188.80000000000092,227.01714211686902)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(189.20000000000093,139.55199298728405)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(189.60000000000093,157.935974114346)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(190.0000000000009,233.8212799374245)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(190.40000000000092,134.3401356434942)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(190.80000000000092,168.5561640579508)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(191.20000000000093,149.43372733854204)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(191.60000000000093,233.2556460447796)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(192.00000000000094,177.74602453703403)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(192.40000000000092,229.58568242929215)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(192.8000000000009,218.5247470747371)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(193.2000000000009,223.64570455712473)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(193.6000000000009,137.14619715450624)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(194.0000000000009,186.63712182133418)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(194.40000000000092,177.1148063803431)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(194.8000000000009,206.8527931495404)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(195.2000000000009,219.93522435195302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(195.6000000000009,133.15740454242314)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(196.0000000000009,221.4846699714085)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(196.40000000000092,239.54892034158112)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(196.80000000000092,238.53627787159837)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(197.2000000000009,126.0263702504954)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(197.60000000000088,227.2498305035192)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(198.00000000000088,245.8135180856215)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(198.4000000000009,244.4535993934994)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(198.8000000000009,171.7059911887322)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(199.2000000000009,176.89665421489215)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(199.60000000000088,124.50868712584445)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(200.00000000000088,173.06849498878384)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(200.4000000000009,246.84521034074598)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(200.8000000000009,123.72681133961295)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(201.2000000000009,196.8867310555174)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(201.60000000000088,134.99640238946188)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(202.00000000000088,189.4087069328491)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(202.4000000000009,145.3931568015364)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(202.8000000000009,236.37921127657467)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(203.20000000000084,227.81867887292177)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(203.60000000000085,216.2492198584418)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(204.00000000000085,243.96808532458863)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(204.40000000000086,129.67653284239947)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(204.80000000000084,218.67604473422693)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(205.20000000000084,237.8293586768624)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(205.60000000000085,199.80033744762693)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(206.00000000000085,230.28297527954015)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(206.40000000000086,152.86903189160125)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(206.80000000000086,124.87114088005342)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(207.20000000000084,156.77447015823648)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(207.60000000000085,189.95579260139223)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(208.00000000000085,236.88423225975407)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(208.40000000000086,247.12157996170524)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(208.80000000000086,132.76085177102476)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(209.20000000000084,147.84272640214812)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(209.60000000000085,121.27180927581493)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(210.00000000000085,231.45487449164193)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(210.40000000000086,202.68988458842853)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(210.80000000000086,232.78297400860603)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(211.20000000000084,149.45250999486305)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(211.60000000000082,118.01717205894275)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(212.0000000000008,170.73756110765459)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(212.4000000000008,205.90427653757197)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(212.8000000000008,156.24283763430302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(213.2000000000008,242.22187965263402)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(213.60000000000082,165.63627726327474)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(214.00000000000082,128.6291637118769)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(214.4000000000008,245.52123531227346)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(214.8000000000008,230.13950596078232)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(215.2000000000008,219.87857038342128)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(215.60000000000082,241.55397836473665)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(216.00000000000082,225.72559000941732)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(216.4000000000008,216.18374828859697)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(216.8000000000008,201.9361610981308)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(217.2000000000008,234.9806105663715)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(217.60000000000082,230.01527996939217)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(218.00000000000082,166.5083074576174)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(218.40000000000083,227.38250901760136)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(218.8000000000008,138.09651830110394)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(219.2000000000008,200.2019140622839)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(219.60000000000082,113.32533519818921)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(220.00000000000077,152.85212062225702)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(220.40000000000077,197.32809815196512)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(220.80000000000078,166.18245290260853)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(221.20000000000078,128.88599277865205)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(221.60000000000076,146.6381194491073)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(222.00000000000077,211.54101582160752)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(222.40000000000077,244.59458702347902)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(222.80000000000078,245.7226835748487)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(223.20000000000078,164.1153289240912)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(223.60000000000076,212.79975282306566)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(224.00000000000077,236.41793890999756)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(224.40000000000077,176.58830722038493)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(224.80000000000078,132.91660502200978)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(225.20000000000078,233.31160431317775)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(225.6000000000008,156.20703710731698)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(226.00000000000077,244.56458046226726)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(226.40000000000077,119.16578028380195)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(226.80000000000078,236.54137188711164)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(227.20000000000078,231.86773764178378)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(227.6000000000008,238.56389355334116)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(228.00000000000074,228.3482190145306)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(228.40000000000074,238.322726335349)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(228.80000000000075,193.71109514504815)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(229.20000000000073,214.0197120559487)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(229.60000000000073,168.4143305224406)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(230.00000000000074,138.76085917136174)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(230.40000000000074,189.77128208681665)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(230.80000000000075,176.483057968477)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(231.20000000000073,245.16183715396093)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(231.60000000000073,159.03022046139347)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(232.00000000000074,180.94511272074323)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(232.40000000000074,233.9911062444553)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(232.80000000000075,120.95258689691813)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(233.20000000000073,107.3741679652899)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(233.60000000000073,112.3982696470699)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(234.00000000000074,208.09643903324093)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(234.40000000000074,169.57777506016032)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(234.80000000000075,166.61319678878934)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(235.20000000000073,238.8151753045412)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(235.60000000000073,151.42659112849566)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(236.00000000000074,129.97007441567456)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(236.4000000000007,174.1320652637006)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(236.8000000000007,230.9157029093458)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(237.2000000000007,237.5778857583923)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(237.6000000000007,230.06686305959016)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(238.0000000000007,104.52080091396724)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(238.4000000000007,215.2174838855688)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(238.8000000000007,168.58068720396386)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(239.2000000000007,167.970995243997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(239.6000000000007,246.68067677508338)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(240.0000000000007,145.44435547590683)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(240.40000000000072,156.37675828649108)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(240.8000000000007,234.07179947324727)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(241.2000000000007,206.04573292493112)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(241.6000000000007,187.65904928951505)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(242.0000000000007,207.69863450437654)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(242.40000000000072,113.03755483330451)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(242.8000000000007,197.611881194587)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(243.2000000000007,212.05727287238403)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(243.6000000000007,209.87251440973392)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(244.0000000000007,114.06084760988307)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(244.40000000000072,205.01511822481427)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(244.80000000000067,101.69628499284147)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(245.20000000000067,166.6986305601603)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(245.60000000000065,157.43627488050416)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(246.00000000000065,231.02818978925617)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(246.40000000000066,195.124104382212)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(246.80000000000067,229.3270535582352)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(247.20000000000067,129.655133957722)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(247.60000000000068,174.89479839678287)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(248.00000000000065,188.4718296540077)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(248.40000000000066,151.13256804112623)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(248.80000000000067,98.62746028526459)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(249.20000000000067,190.90434887560144)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(249.60000000000068,115.08634577184091)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(250.00000000000065,227.8887749379151)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(250.40000000000066,199.08518009573595)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(250.80000000000067,243.22209999331614)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(251.20000000000067,217.91786817827452)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(251.60000000000068,92.18048962068889)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(252.00000000000068,243.62826793472985)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(252.40000000000066,196.6652861917147)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(252.80000000000067,121.56307740873555)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(253.2000000000006,235.79280571150161)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(253.60000000000062,94.85155018630024)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(254.00000000000063,219.7533067216052)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(254.40000000000063,116.32042652922317)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(254.80000000000064,108.64156134552877)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(255.2000000000006,123.99585801097109)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(255.60000000000062,148.63099417560107)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(256.0000000000006,112.10703365375497)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(256.4000000000006,151.8796511962881)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(256.80000000000064,159.91068467664593)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(257.2000000000006,93.39925012716625)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(257.60000000000065,244.49154336573574)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(258.0000000000006,202.89908454167428)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(258.4000000000006,204.91516706815136)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(258.80000000000064,146.10269301173912)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(259.2000000000006,178.55017248024117)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(259.60000000000065,112.28749596432067)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(260.0000000000006,189.89120167142093)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(260.40000000000066,155.2473860486602)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(260.80000000000064,216.66514648886331)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(261.2000000000006,115.32429447200218)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(261.6000000000006,138.56255269656748)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(262.00000000000057,146.4021972318837)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(262.4000000000006,112.13622966442401)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(262.8000000000006,99.05230849415875)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(263.2000000000006,194.1512945188478)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(263.6000000000006,148.97365427284262)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(264.00000000000057,214.08932587381642)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(264.4000000000006,207.44264000658853)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(264.8000000000006,160.92821218798412)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(265.2000000000006,95.0306816102244)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(265.6000000000006,245.79473184505053)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(266.00000000000057,136.19530215744356)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(266.4000000000006,169.06872805135012)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(266.8000000000006,216.82023804664493)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(267.2000000000006,184.0611464770534)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(267.6000000000006,150.86112452721017)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(268.00000000000057,103.5295241615583)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(268.4000000000006,182.0819933159608)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(268.8000000000006,117.28793757503678)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(269.2000000000006,186.14312815235837)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(269.60000000000053,182.65343690224623)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(270.00000000000057,133.17171625747574)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(270.40000000000055,166.75733585799156)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(270.8000000000005,208.72056065122302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(271.20000000000056,119.44535620922426)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(271.60000000000053,129.73675264754445)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(272.00000000000057,126.88807380677281)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(272.40000000000055,243.13333897278224)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(272.8000000000006,135.8890490009839)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(273.20000000000056,188.71415123841854)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(273.60000000000053,201.54658746716717)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(274.00000000000057,163.80358724721845)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(274.40000000000055,125.26423372413342)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(274.8000000000006,175.36679845336118)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(275.20000000000056,89.26186646876815)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(275.60000000000053,104.80643859421971)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(276.00000000000057,167.2605027173298)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(276.40000000000055,199.65710115521725)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(276.8000000000006,120.52603294807085)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(277.20000000000056,187.10797415859884)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(277.60000000000053,114.37142173502889)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(278.0000000000005,98.58660443719396)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(278.4000000000005,161.62523135519342)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(278.8000000000005,105.78175671675743)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(279.2000000000005,127.55511762882776)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(279.60000000000053,164.45916555895633)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(280.0000000000005,217.803312737103)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(280.4000000000005,167.2707459150085)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(280.8000000000005,191.49915944483888)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(281.2000000000005,242.3190121673365)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(281.60000000000053,194.5694938966904)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(282.0000000000005,165.12292378675343)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(282.40000000000055,199.05808913577)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(282.8000000000005,91.4864490175307)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(283.2000000000005,154.80075424591564)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(283.60000000000053,130.12852444972657)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(284.0000000000005,76.1775792464127)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(284.40000000000055,195.61853719468033)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(284.8000000000005,171.18187227318595)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(285.2000000000005,201.08233539310046)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(285.60000000000053,118.24459666768877)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(286.0000000000005,128.94435515748478)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(286.4000000000005,75.88800909761954)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(286.80000000000047,150.87628000390703)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(287.2000000000005,242.81048289653154)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(287.6000000000005,133.06621001577759)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(288.00000000000045,157.00505728621528)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(288.4000000000005,217.56446259757598)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(288.80000000000047,70.52708405751278)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(289.2000000000005,225.0856561793871)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(289.6000000000005,177.56159931378536)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(290.00000000000045,116.66362995590302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(290.4000000000005,196.92927812803285)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(290.80000000000047,157.3420353237515)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(291.2000000000005,149.94438277798253)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(291.6000000000005,143.6329332037231)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(292.00000000000045,246.07338276892628)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(292.4000000000005,238.16879446071547)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(292.80000000000047,191.13893451260952)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(293.2000000000005,231.08966377813658)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(293.6000000000005,184.02671646395453)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(294.00000000000045,149.3068638038289)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(294.40000000000043,211.50546431828585)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(294.80000000000047,200.2170885156181)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(295.20000000000044,103.1280836013207)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(295.6000000000004,174.8491915326041)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(296.00000000000045,148.88501627098086)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(296.40000000000043,70.84579868992253)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(296.80000000000047,126.32105414556275)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(297.20000000000044,244.51134707471664)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(297.6000000000004,144.98505672432236)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(298.00000000000045,196.72731153371151)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(298.40000000000043,99.05197057922214)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(298.80000000000047,158.55411359186746)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(299.20000000000044,177.71731111576838)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(299.6000000000004,245.17660633246356)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(300.00000000000045,102.76439623211544)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(300.40000000000043,158.6343129790975)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(300.80000000000047,105.58266245566537)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(301.20000000000044,68.44680899793315)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(301.6000000000004,80.25840512597463)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(302.00000000000045,207.76002679346772)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(302.40000000000043,180.51822341041458)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(302.8000000000004,163.3399955710638)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(303.2000000000004,94.09835412885505)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(303.6000000000004,72.85724887838552)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(304.0000000000004,219.30410257504258)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(304.40000000000043,171.12983717238785)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(304.8000000000004,210.7917877152023)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(305.2000000000004,242.78103167833495)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(305.6000000000004,108.28602337624508)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(306.0000000000004,120.93458170437269)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(306.40000000000043,62.906106633229996)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(306.8000000000004,100.6883104486214)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(307.2000000000004,109.96323649166442)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(307.6000000000004,239.2240196284457)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(308.0000000000004,127.01872646114566)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(308.40000000000043,156.48799064990294)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(308.8000000000004,202.18945850353427)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(309.2000000000004,145.25712630409646)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(309.6000000000004,145.47014577220622)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(310.0000000000004,224.49843257010278)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(310.40000000000043,226.10985292768308)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(310.8000000000004,194.85145226686558)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(311.2000000000004,238.3501326955565)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(311.60000000000036,106.25664970230642)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(312.00000000000034,95.53067750189075)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(312.4000000000004,81.75667422118704)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(312.80000000000035,83.35762653347072)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(313.2000000000004,190.0320847645087)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(313.60000000000036,184.00071174143386)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(314.00000000000034,200.7399422796144)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(314.4000000000004,246.0135759633953)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(314.80000000000035,175.54329819312585)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(315.2000000000004,201.5297526410366)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(315.60000000000036,85.60515987428568)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(316.00000000000034,221.9752556025544)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(316.4000000000004,122.30973678132442)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(316.80000000000035,52.92883881585087)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(317.2000000000004,214.20198883003167)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(317.60000000000036,88.4221475319365)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(318.0000000000004,202.68301933746056)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(318.4000000000004,193.2517383949356)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(318.80000000000035,163.61531550690836)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(319.20000000000033,234.05267571033392)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(319.6000000000003,71.08561653136749)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(320.00000000000034,78.7561326394696)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(320.4000000000003,67.24414292945957)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(320.80000000000035,184.54117193174497)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(321.20000000000033,195.76638952329898)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(321.6000000000003,230.88505547064426)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(322.00000000000034,236.08810031003705)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(322.4000000000003,126.32225015590888)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(322.80000000000035,87.59679755024885)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(323.20000000000033,106.32764517770624)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(323.6000000000003,132.6237225837263)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(324.00000000000034,135.96195457168488)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(324.4000000000003,130.6952596967164)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(324.80000000000035,168.27931124146522)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(325.20000000000033,49.35831602022935)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(325.6000000000003,161.6435051335061)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(326.00000000000034,99.35808353482972)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(326.4000000000003,221.7055399247775)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(326.80000000000035,163.111034326526)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(327.20000000000033,193.57121785904803)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(327.6000000000003,210.35871788920787)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(328.0000000000003,245.49637963260585)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(328.4000000000003,193.04570470975145)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(328.8000000000003,64.60516006042758)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(329.2000000000003,162.48898522288044)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(329.6000000000003,130.89595968460995)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(330.0000000000003,174.65169585791566)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(330.4000000000003,83.02337690019363)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(330.8000000000003,246.05955640435107)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(331.2000000000003,48.2322114775302)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(331.6000000000003,194.80737931140666)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(332.0000000000003,119.24376709791318)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(332.4000000000003,227.79575486376646)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(332.8000000000003,94.27634377842787)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(333.2000000000003,89.24107571725068)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(333.6000000000003,225.31220756639553)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(334.0000000000003,173.86665530518155)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(334.4000000000003,60.022687995377254)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(334.8000000000003,56.85857904399015)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(335.2000000000003,84.01928118352612)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(335.6000000000003,95.76841598208924)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(336.0000000000002,177.7722054976162)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(336.40000000000026,151.59221187794736)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(336.80000000000024,121.30925539594824)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(337.2000000000003,74.06924583358315)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(337.60000000000025,197.3616626782199)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(338.0000000000002,141.0501645306361)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(338.40000000000026,50.73361645584788)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(338.80000000000024,237.38332358119794)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(339.2000000000003,144.44079766750633)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(339.60000000000025,43.320257790741664)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(340.0000000000003,184.155060647872)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(340.40000000000026,193.676698725207)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(340.80000000000024,179.10797715121222)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(341.2000000000003,179.13060776693527)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(341.60000000000025,44.34962594567472)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(342.0000000000003,138.81296625130108)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(342.40000000000026,113.51818756173071)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(342.80000000000024,125.28859344496091)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(343.2000000000003,162.783396182389)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(343.60000000000025,184.88645953945243)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(344.0000000000003,104.85856850132188)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(344.4000000000002,114.23946955557338)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(344.80000000000024,184.95763074560932)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(345.2000000000002,121.09933687178457)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(345.6000000000002,144.3324433804969)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(346.0000000000002,108.10645370670846)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(346.4000000000002,205.23599413577386)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(346.80000000000024,89.62446057795364)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(347.2000000000002,76.72984332257312)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(347.6000000000002,45.686477232728265)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(348.0000000000002,94.75553225066864)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(348.4000000000002,65.94560462045268)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(348.80000000000024,157.5535676480609)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(349.2000000000002,182.16504825115004)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(349.60000000000025,216.91439890972677)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(350.0000000000002,112.49964655365505)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(350.4000000000002,156.7769988329324)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(350.80000000000024,187.51305603913883)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(351.2000000000002,203.05726962714192)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(351.60000000000025,93.86171010600262)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(352.0000000000002,137.95670342629617)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(352.4000000000002,164.55667804168655)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(352.8000000000002,196.91341791926953)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(353.20000000000016,92.74661027212613)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(353.6000000000002,29.845745884872997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(354.00000000000017,236.00550290278795)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(354.4000000000002,78.3019079339642)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(354.8000000000002,235.70738117609994)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(355.20000000000016,63.18408263120489)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(355.6000000000002,182.27370357458327)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(356.00000000000017,203.00936112297944)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(356.4000000000002,43.08522577235158)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(356.8000000000002,64.95147989819912)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(357.20000000000016,91.51443496426816)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(357.6000000000002,213.74933873480882)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(358.00000000000017,64.51088335963397)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(358.4000000000002,235.31508591952925)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(358.8000000000002,187.47450692321854)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(359.20000000000016,214.72679937435822)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(359.6000000000002,55.93524556862934)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(360.00000000000017,195.53641284252632)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(360.4000000000002,179.68798403720297)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(360.8000000000001,63.20199103005902)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(361.20000000000016,165.44277384690997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(361.60000000000014,227.46779250141446)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(362.00000000000017,43.00175636447071)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(362.40000000000015,128.8642450499517)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(362.8000000000001,161.9728262194049)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(363.20000000000016,129.6232179844619)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(363.60000000000014,104.37060814970843)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(364.00000000000017,62.83288972943899)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(364.40000000000015,191.7868260832987)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(364.8000000000001,109.50978204293486)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(365.20000000000016,182.46934975610102)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(365.60000000000014,82.36601971128209)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(366.00000000000017,35.03927732198471)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(366.40000000000015,72.5148426046513)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(366.8000000000001,114.60517116272888)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(367.20000000000016,220.00824051784414)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(367.60000000000014,89.36127104625189)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(368.00000000000017,90.31775677446373)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(368.40000000000015,57.76323835892606)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(368.8000000000001,113.80574115978996)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(369.2000000000001,198.59921408841836)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(369.6000000000001,110.75975753631997)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(370.0000000000001,69.28805185890491)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(370.4000000000001,77.7435333708043)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(370.8000000000001,29.321369094867975)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(371.2000000000001,113.46959898782998)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(371.60000000000014,60.59652026102191)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(372.0000000000001,116.46511105606763)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(372.4000000000001,232.4553958935239)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(372.8000000000001,135.08808649726416)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(373.2000000000001,63.497059153250234)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(373.60000000000014,73.1352126377424)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(374.0000000000001,219.68264534366932)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(374.4000000000001,72.73326264832423)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(374.8000000000001,207.60177754397048)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(375.2000000000001,118.87175633109709)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(375.60000000000014,15.140074519238965)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(376.0000000000001,165.12929626065272)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(376.4000000000001,139.7205931940445)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(376.8000000000001,53.28917771681816)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(377.2000000000001,161.45390150372214)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(377.6000000000001,134.17413178833206)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(378.00000000000006,28.134903942197894)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(378.4000000000001,169.75994057008558)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(378.80000000000007,101.67900592121686)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(379.20000000000005,165.35971991773843)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(379.6000000000001,20.07203398586816)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(380.00000000000006,224.07230349048768)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(380.4000000000001,118.97775253806074)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(380.80000000000007,84.76813403229374)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(381.20000000000005,108.426965842274)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(381.6000000000001,174.44278161808597)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(382.00000000000006,70.41724772263393)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(382.4000000000001,210.26994309680245)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(382.80000000000007,39.94909538263093)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(383.20000000000005,167.76691391088667)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(383.6000000000001,116.72113200324583)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(384.00000000000006,55.034524800076184)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(384.4000000000001,9.87360464144112)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(384.80000000000007,232.86020430497038)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(385.2000000000001,204.610563588266)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(385.6,188.44747225060183)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(386.00000000000006,188.5668061193259)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(386.40000000000003,40.677458906597735)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(386.8,238.54125563200063)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(387.20000000000005,38.29497983740799)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(387.6,36.606749643095895)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(388.00000000000006,87.97230147934292)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(388.40000000000003,176.58756216413605)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(388.8,42.378026147426795)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(389.20000000000005,145.84742651095593)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(389.6,94.68040855370333)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(390.00000000000006,178.99965575027028)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(390.40000000000003,218.72062580903818)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(390.8,41.58437458514527)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(391.20000000000005,7.44467318647969)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(391.6,12.671010801674782)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(392.00000000000006,93.98240758613215)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(392.40000000000003,189.20487263416533)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(392.8,170.6021066218973)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(393.20000000000005,170.09204679545294)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(393.6,60.68712053162906)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(394,113.95726142317758)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(394.4,153.40170633801392)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(394.8,128.54230937081417)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(395.2,180.6278102893819)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(395.6,80.96747952205237)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(396,129.7889999493894)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(396.4,96.74910867195263)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(396.8,45.3942969976232)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(397.2,154.0067868992171)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(397.6,151.69869644044667)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(398,144.13989197195664)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(398.4,121.59358829054548)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(398.8,189.70499441754762)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(399.2,217.24325287248635)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(399.6,10.013633735212494)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path><path transform=\"translate(400,245.46569137068607)\" d=\"M0,3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,-3.989422804014327A3.989422804014327,3.989422804014327 0 1,1 0,3.989422804014327Z\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.3; stroke: transparent;\"></path></g><g id=\"g100\"><path d=\"M0,247.2187957763672L4.000000059604712,247.1941561921592L8.000000119209425,247.02364370769706L12.000000178814137,246.5710909637894L16.00000023841885,245.71919967009447L20.00000029802356,244.37764789742323L24.000000357628274,242.48968114005982L28.000000417232982,240.03680517291943L32.0000004768377,237.04129672836748L36.000000536442414,233.56636120125037L40.00000059604712,229.71388940186768L44.00000065565183,225.6198917627844L48.00000071525655,221.44781210530186L52.000000774861256,217.3800379133935L56.000000834465965,213.60802426035045L60.00000089407068,210.3215289635679L64.0000009536754,207.69751299625005L68.00000101328011,205.88928957267322L72.00000107288483,205.01650583484812L76.00000113248953,205.1565122669665L80.00000119209425,206.33761782305072L84.00000125169895,208.53464562319255L88.00000131130366,211.66709858585307L92.00000137090838,215.60012127239196L96.0000014305131,220.14830919168583L100.00000149011781,225.08227616948187L104.00000154972251,230.1377508173661L108.00000160932723,235.0268413847422L112.00000166893193,239.45099082938657L116.00000172853666,243.11504671616635L120.00000178814136,245.7417986151875L124.00000184774606,247.08629298401988L128.0000019073508,246.94922474426141L132.0000019669555,245.1887271132908L136.00000202656022,241.72993641299655L140.00000208616493,236.57179469613033L144.00000214576966,229.7906667775143L148.00000220537436,221.54048495231848L152.00000226497906,212.04928849089362L156.00000232458376,201.61218917435014L160.0000023841885,190.58096131697582L164.0000024437932,179.3506172609836L168.0000025033979,168.34347963102897L172.00000256300262,157.99139250749727L176.00000262260733,148.71681866241738L180.00000268221206,140.91364368712675L184.00000274181676,134.9285461217404L188.00000280142146,131.0437929866462L192.0000028610262,129.46228149293512L196.0000029206309,130.29557098597775L200.00000298023562,133.55553690165902L204.00000303984035,139.15013488758586L208.00000309944502,146.88359395711075L212.00000315904975,156.46116956739576L216.00000321865446,167.49838879268498L220.00000327825916,179.53451889776616L224.00000333786386,192.0497964805012L228.0000033974686,204.48577571295215L232.00000345707332,216.26799933468564L236.000003516678,226.8300723307397L240.00000357628272,235.63813183353014L244.00000363588745,242.21466238172076L248.00000369549213,246.16060616072042L252.00000375509686,247.17476424026057L256.0000038147016,245.06957612544306L260.0000038743063,239.78249817455927L264.000003933911,231.3823717425863L268.0000039935157,220.07037269947224L272.00000405312045,206.17535720054755L276.00000411272515,190.143655066005L280.00000417232985,172.52360190839045L284.00000423193455,153.945333937511L288.0000042915393,135.09658497190946L292.00000435114396,116.69541393384259L296.0000044107487,99.46094430493628L300.0000044703534,84.08330733573516L304.0000045299581,71.19404259802872L308.0000045895628,61.338219082459545L312.0000046491675,54.94949598207623L316.0000047087723,52.32924534383156L320.000004768377,53.630711973175835L324.0000048279817,58.848994590723294L328.0000048875864,67.81740351836339L332.00000494719114,80.2104930998704L336.0000050067958,95.55379200072576L340.00000506640055,113.23997280648953L344.00000512600525,132.55092576626907L348.00000518560995,152.6849419254047L352.00000524521465,172.78797957464067L356.0000053048194,191.98779523483367L360.0000053644241,209.4295751721283L364.0000054240288,224.3116127249584L368.0000054836335,235.91954536925414L372.0000055432382,243.6576958790815L376.0000056028429,247.0761540193539L380.0000056624476,245.892386196052L384.0000057220524,240.00636511852588L388.0000057816571,229.5084621791705L392.0000058412618,214.67963224182466L396.0000059008665,195.98373247187024\" style=\"fill: none; stroke: rgb(255, 41, 210); stroke-width: 2px; stroke-opacity: 1;\"></path></g><g id=\"g101\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g102\" style=\"pointer-events: none;\"></g><g id=\"g103\" style=\"pointer-events: none;\"><line x1=\"0.5\" y1=\"0\" x2=\"0.5\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"40.500000000000675\" y1=\"0\" x2=\"40.500000000000675\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"80.50000000000135\" y1=\"0\" x2=\"80.50000000000135\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"120.50000000000202\" y1=\"0\" x2=\"120.50000000000202\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"160.5000000000027\" y1=\"0\" x2=\"160.5000000000027\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"200.50000000000338\" y1=\"0\" x2=\"200.50000000000338\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"240.50000000000404\" y1=\"0\" x2=\"240.50000000000404\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"280.5000000000047\" y1=\"0\" x2=\"280.5000000000047\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"320.5000000000054\" y1=\"0\" x2=\"320.5000000000054\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"360.500000000006\" y1=\"0\" x2=\"360.500000000006\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g104\" style=\"pointer-events: none;\"></g><g id=\"g105\"><text x=\"0.5\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"40.500000000000675\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"80.50000000000135\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"120.50000000000202\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"160.5000000000027\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"200.50000000000338\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"240.50000000000404\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"280.5000000000047\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"320.5000000000054\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"360.500000000006\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text></g><g id=\"g106\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g107\"></g></g></g><g id=\"g108\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g109\" style=\"pointer-events: none;\"></g><g id=\"g110\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"222.99691619873047\" x2=\"0\" y2=\"222.99691619873047\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"198.27503662109376\" x2=\"0\" y2=\"198.27503662109376\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"173.55315704345702\" x2=\"0\" y2=\"173.55315704345702\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"148.8312774658203\" x2=\"0\" y2=\"148.8312774658203\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"124.1093978881836\" x2=\"0\" y2=\"124.1093978881836\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"99.38751831054685\" x2=\"0\" y2=\"99.38751831054685\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"74.66563873291014\" x2=\"0\" y2=\"74.66563873291014\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"49.943759155273426\" x2=\"0\" y2=\"49.943759155273426\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"25.221879577636713\" x2=\"0\" y2=\"25.221879577636713\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5\" x2=\"0\" y2=\"0.5\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g111\" style=\"pointer-events: none;\"></g><g id=\"g112\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0</text><text x=\"-9\" y=\"222.99691619873047\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"-9\" y=\"198.27503662109376\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"-9\" y=\"173.55315704345702\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"-9\" y=\"148.8312774658203\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"-9\" y=\"124.1093978881836\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"-9\" y=\"99.38751831054685\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"-9\" y=\"74.66563873291014\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"-9\" y=\"49.943759155273426\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"-9\" y=\"25.221879577636713\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"-9\" y=\"0.5\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text></g><g id=\"g113\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g114\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; There's a histogram plot type as well. As above, it composes with list-plots well.
;; **

;; @@
(compose
  (histogram (repeatedly 1000 #(rand 10)) :color "steelblue" :bins 100 :normalize :probability-density)
  (plot (constantly 0.1) [0 10]))
;; @@
;; =>
;;; {"type":"html","content":"<svg class=\"marks\" width=\"460\" height=\"277.2187957763672\"><g transform=\"translate(50,10)\"><g id=\"g115\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"400\" height=\"247.2187957763672\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g116\"><path d=\"M0,247.2187957763672V54.31719529269307H3.96039603960395V109.43193828802853H7.9207920792079V123.2106240368624H11.88118811881185V54.31719529269307H15.8415841584158V95.65325253919465H19.801980198019752V54.31719529269307H23.7623762376237V178.32536703219785H27.72277227722765V81.87456679036077H31.6831683168316V136.98930978569626H35.643564356435554V136.98930978569626H39.603960396039504V136.98930978569626H43.56435643564346V150.76799553453014H47.5247524752474V54.31719529269307H51.48514851485135V136.98930978569626H55.4455445544553V123.2106240368624H59.40594059405926V109.43193828802853H63.3663366336632V95.65325253919465H67.32673267326716V123.2106240368624H71.28712871287111V136.98930978569626H75.24752475247506V54.31719529269307H79.207920792079V136.98930978569626H83.16831683168296V109.43193828802853H87.1287128712869V123.2106240368624H91.08910891089086V12.981138046191433H95.04950495049479V81.87456679036077H99.00990099009877V178.32536703219785H102.97029702970268V123.2106240368624H106.93069306930667V136.98930978569626H110.89108910891059V136.98930978569626H114.85148514851456V136.98930978569626H118.81188118811849V109.43193828802853H122.77227722772245V95.65325253919465H126.7326732673264V109.43193828802853H130.69306930693037V81.87456679036077H134.6534653465343V136.98930978569626H138.61386138613824V150.76799553453014H142.5742574257422V26.759823795025312H146.53465346534617V109.43193828802853H150.4950495049501V123.2106240368624H154.45544554455407V95.65325253919465H158.415841584158V95.65325253919465H162.37623762376197V95.65325253919465H166.33663366336592V95.65325253919465H170.2970297029699V12.981138046191433H174.25742574257384V68.0958810415269H178.21782178217782V26.759823795025312H182.17821782178177V178.32536703219785H186.13861386138578V109.43193828802853H190.09900990098973V136.98930978569626H194.0594059405937V54.31719529269307H198.01980198019766V68.0958810415269H201.98019801980163V123.2106240368624H205.94059405940558V109.43193828802853H209.90099009900956V26.759823795025312H213.8613861386135V136.98930978569626H217.8217821782175V150.76799553453014H221.7821782178215V54.31719529269307H225.74257425742545V123.2106240368624H229.70297029702942V123.2106240368624H233.66336633663337V150.76799553453014H237.62376237623735V192.10405278103173H241.5841584158413V136.98930978569626H245.54455445544528V205.88273852986558H249.50495049504923V123.2106240368624H253.4653465346532V150.76799553453014H257.4257425742572V68.0958810415269H261.38613861386114V109.43193828802853H265.3465346534651V68.0958810415269H269.30693069306903V81.87456679036077H273.26732673267304V95.65325253919465H277.22772277227705V164.54668128336397H281.188118811881V123.2106240368624H285.14851485148495V136.98930978569626H289.1089108910889V68.0958810415269H293.0693069306929V178.32536703219785H297.02970297029685V136.98930978569626H300.9900990099008V40.53850954385919H304.95049504950475V150.76799553453014H308.91089108910876V95.65325253919465H312.8712871287127V136.98930978569626H316.83168316831666V81.87456679036077H320.7920792079206V123.2106240368624H324.7524752475246V123.2106240368624H328.7128712871286V178.32536703219785H332.67326732673257V68.0958810415269H336.6336633663365V12.981138046191433H340.59405940594047V123.2106240368624H344.5544554455445V123.2106240368624H348.5148514851484V109.43193828802853H352.4752475247524V95.65325253919465H356.4356435643563V109.43193828802853H360.39603960396033V68.0958810415269H364.3564356435643V95.65325253919465H368.31683168316823V150.76799553453014H372.27722772277224V81.87456679036077H376.2376237623762V136.98930978569626H380.1980198019802V164.54668128336397H384.15841584158414V164.54668128336397H388.1188118811881V95.65325253919465H392.0792079207921V68.0958810415269H396.03960396039605V247.2187957763672H400\" style=\"fill: rgb(70, 130, 180); fill-opacity: 0.4; stroke: rgb(70, 130, 180); stroke-width: 2px; stroke-opacity: 1;\"></path></g><g id=\"g117\"><path d=\"M-0.2164529910540911,109.87502034505206L3.756719663651399,109.87502034505206L7.729892318356889,109.87502034505206L11.703064973062379,109.87502034505206L15.67623762776787,109.87502034505206L19.649410282473358,109.87502034505206L23.622582937178848,109.87502034505206L27.59575559188434,109.87502034505206L31.568928246589827,109.87502034505206L35.54210090129532,109.87502034505206L39.51527355600081,109.87502034505206L43.4884462107063,109.87502034505206L47.46161886541179,109.87502034505206L51.43479152011729,109.87502034505206L55.407964174822766,109.87502034505206L59.38113682952826,109.87502034505206L63.35430948423375,109.87502034505206L67.32748213893925,109.87502034505206L71.30065479364472,109.87502034505206L75.27382744835022,109.87502034505206L79.24700010305571,109.87502034505206L83.22017275776119,109.87502034505206L87.19334541246668,109.87502034505206L91.16651806717218,109.87502034505206L95.13969072187766,109.87502034505206L99.11286337658315,109.87502034505206L103.08603603128863,109.87502034505206L107.05920868599412,109.87502034505206L111.03238134069962,109.87502034505206L115.00555399540511,109.87502034505206L118.9787266501106,109.87502034505206L122.9518993048161,109.87502034505206L126.92507195952159,109.87502034505206L130.89824461422708,109.87502034505206L134.87141726893256,109.87502034505206L138.84458992363807,109.87502034505206L142.81776257834352,109.87502034505206L146.79093523304903,109.87502034505206L150.7641078877545,109.87502034505206L154.73728054246,109.87502034505206L158.7104531971655,109.87502034505206L162.683625851871,109.87502034505206L166.65679850657648,109.87502034505206L170.629971161282,109.87502034505206L174.60314381598747,109.87502034505206L178.57631647069294,109.87502034505206L182.54948912539842,109.87502034505206L186.52266178010393,109.87502034505206L190.4958344348094,109.87502034505206L194.46900708951492,109.87502034505206L198.4421797442204,109.87502034505206L202.41535239892588,109.87502034505206L206.38852505363138,109.87502034505206L210.36169770833686,109.87502034505206L214.33487036304237,109.87502034505206L218.30804301774785,109.87502034505206L222.28121567245336,109.87502034505206L226.25438832715884,109.87502034505206L230.22756098186434,109.87502034505206L234.20073363656982,109.87502034505206L238.17390629127527,109.87502034505206L242.1470789459808,109.87502034505206L246.12025160068626,109.87502034505206L250.0934242553918,109.87502034505206L254.06659691009725,109.87502034505206L258.0397695648028,109.87502034505206L262.01294221950826,109.87502034505206L265.98611487421374,109.87502034505206L269.9592875289192,109.87502034505206L273.9324601836247,109.87502034505206L277.90563283833023,109.87502034505206L281.87880549303566,109.87502034505206L285.8519781477412,109.87502034505206L289.8251508024467,109.87502034505206L293.79832345715215,109.87502034505206L297.77149611185763,109.87502034505206L301.74466876656317,109.87502034505206L305.71784142126864,109.87502034505206L309.6910140759741,109.87502034505206L313.6641867306796,109.87502034505206L317.6373593853851,109.87502034505206L321.6105320400907,109.87502034505206L325.5837046947961,109.87502034505206L329.55687734950163,109.87502034505206L333.5300500042071,109.87502034505206L337.5032226589126,109.87502034505206L341.47639531361807,109.87502034505206L345.44956796832355,109.87502034505206L349.4227406230291,109.87502034505206L353.39591327773456,109.87502034505206L357.36908593244004,109.87502034505206L361.3422585871455,109.87502034505206L365.31543124185106,109.87502034505206L369.28860389655654,109.87502034505206L373.26177655126196,109.87502034505206L377.2349492059675,109.87502034505206L381.208121860673,109.87502034505206L385.18129451537845,109.87502034505206L389.15446717008393,109.87502034505206L393.12763982478947,109.87502034505206\" style=\"fill: none; stroke: rgb(255, 41, 210); stroke-width: 2px; stroke-opacity: 1;\"></path></g><g id=\"g118\"><g transform=\"translate(0,247.2187957763672)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g119\" style=\"pointer-events: none;\"></g><g id=\"g120\" style=\"pointer-events: none;\"><line x1=\"40.01527296395196\" y1=\"0\" x2=\"40.01527296395196\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"79.746998918958\" y1=\"0\" x2=\"79.746998918958\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"119.47872487396404\" y1=\"0\" x2=\"119.47872487396404\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"159.2104508289701\" y1=\"0\" x2=\"159.2104508289701\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"198.94217678397612\" y1=\"0\" x2=\"198.94217678397612\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"238.6739027389822\" y1=\"0\" x2=\"238.6739027389822\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"278.4056286939882\" y1=\"0\" x2=\"278.4056286939882\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"318.1373546489943\" y1=\"0\" x2=\"318.1373546489943\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"357.8690806040004\" y1=\"0\" x2=\"357.8690806040004\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"397.6008065590064\" y1=\"0\" x2=\"397.6008065590064\" y2=\"6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g121\" style=\"pointer-events: none;\"></g><g id=\"g122\"><text x=\"40.01527296395196\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">1</text><text x=\"79.746998918958\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">2</text><text x=\"119.47872487396404\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">3</text><text x=\"159.2104508289701\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">4</text><text x=\"198.94217678397612\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">5</text><text x=\"238.6739027389822\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">6</text><text x=\"278.4056286939882\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">7</text><text x=\"318.1373546489943\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">8</text><text x=\"357.8690806040004\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">9</text><text x=\"397.6008065590064\" y=\"9\" dy=\".9em\" text-anchor=\"middle\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">10</text></g><g id=\"g123\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M0,6V0H400V6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g124\"></g></g></g><g id=\"g125\"><g transform=\"translate(0,0)\"><rect class=\"background\" width=\"0\" height=\"0\" style=\"pointer-events: none; fill: none;\"></rect><g id=\"g126\" style=\"pointer-events: none;\"></g><g id=\"g127\" style=\"pointer-events: none;\"><line x1=\"-6\" y1=\"247.7187957763672\" x2=\"0\" y2=\"247.7187957763672\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"220.25004069010416\" x2=\"0\" y2=\"220.25004069010416\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"192.78128560384116\" x2=\"0\" y2=\"192.78128560384116\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"165.31253051757812\" x2=\"0\" y2=\"165.31253051757812\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"137.84377543131512\" x2=\"0\" y2=\"137.84377543131512\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"110.37502034505206\" x2=\"0\" y2=\"110.37502034505206\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"82.90626525878906\" x2=\"0\" y2=\"82.90626525878906\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"55.43751017252603\" x2=\"0\" y2=\"55.43751017252603\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"27.96875508626303\" x2=\"0\" y2=\"27.96875508626303\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line><line x1=\"-6\" y1=\"0.5000000000000284\" x2=\"0\" y2=\"0.5000000000000284\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px; opacity: 1;\"></line></g><g id=\"g128\" style=\"pointer-events: none;\"></g><g id=\"g129\"><text x=\"-9\" y=\"247.7187957763672\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.00</text><text x=\"-9\" y=\"220.25004069010416\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.02</text><text x=\"-9\" y=\"192.78128560384116\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.04</text><text x=\"-9\" y=\"165.31253051757812\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.06</text><text x=\"-9\" y=\"137.84377543131512\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.08</text><text x=\"-9\" y=\"110.37502034505206\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.10</text><text x=\"-9\" y=\"82.90626525878906\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.12</text><text x=\"-9\" y=\"55.43751017252603\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.14</text><text x=\"-9\" y=\"27.96875508626303\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.16</text><text x=\"-9\" y=\"0.5000000000000284\" dy=\".35em\" text-anchor=\"end\" style=\"font-style: normal; font-variant: normal; font-weight: normal; font-stretch: normal; font-size: 11px; line-height: normal; font-family: sans-serif; fill: rgb(0, 0, 0); opacity: 1;\">0.18</text></g><g id=\"g130\" style=\"pointer-events: none;\"><path transform=\"translate(0.5,0.5)\" d=\"M-6,0H0V247.2187957763672H-6\" style=\"fill: none; stroke: rgb(0, 0, 0); stroke-width: 1px;\"></path></g><g id=\"g131\"></g></g></g></g></g></g></svg>"}
;; <=

;; **
;;; Something a little fancier!
;; **

;; @@
(compose
  (histogram (repeatedly 10000 #(- (apply + (repeatedly 50 rand)) 25))
             :bins 100
             :normalise :probability-density)
  (plot #(gaussian % 2 0) [-10 10]))
;; @@

;; @@
(compose
  (histogram (repeatedly 10000 #(- (apply + (repeatedly 50 rand)) 25))
             :bins 100
             :normalise :probability-density)
  (histogram (repeatedly 10000 #(- (apply + (repeatedly 50 rand)) 23))
             :bins 100
             :normalise :probability-density
             :colour "green")
  (plot #(gaussian % 2 0) [-10 10])
  (plot #(gaussian % 2 2) [-10 10] :colour "orange"))
;; @@

;; @@

;; @@

;; @@

;; @@
