(ns cloud-clj.util)

(def ^:dynamic *pw-chars*
  (map
    char
    (concat
      (range 48 (+ 48 10))
      (range 65 (+ 65 26))
      (range 97 (+ 97 26)))))

(defn rand-str
  "Generates a string given a sequence of usable chars and a desired string
   length to be generated."
  [usable-chars len]
  (apply str (take len (repeatedly #(rand-nth usable-chars)))))

(defn rand-pw
  "Generates a random password string between 10 and 16 characters in legnth
   using upper case, lower case, and numerical characters."
  []
  (rand-str *pw-chars* (+ 10 (rand-int 7))))


