# cloud-clj 

A Clojure library designed to interact with the Motivis Cloud API.

## Dependencies

[![Clojars Project](https://img.shields.io/clojars/v/com.motivislearning/cloud-clj.svg)](https://clojars.org/com.motivislearning/cloud-clj)

## Usage

Create a session by config or by a file that has a configuration defined.

```clojure
(def session
  (cloud-clj.api/config->session
    {:host "https://some-api.some-domain.some-tld/"
     :user {:instance "someinstance"
            :username "some@username.com"
            :password "somepassword"}}))
```

If a file is used, it must have the same map structure as the example above.

```clojure
(def session
  (cloud-clj.api/file->session "/path/to/config/file.edn"))
```

If you need to make a session without logging in, such as when auth is disabled,
you can make a raw CloudSession which doesn't use the `login` function to make an
authenticated session.

```clojure
(def session
  (api/map->CloudSession
    {:host "http://localhost:8080/"}))
```

Start using the session.

```clojure
(cloud-clj.api/select-data
  session "platform" "user"
  {:where {:email "some@username.com"})
```

Metadata Migration

```clojure
(cloud-clj.schema/migrate-metadata!
  session "/Users/Jon/projects/motivis/cloud-api/src/describe")
```

Column Refresh (if metadata exists but, underlying database table doesn't.)

```clojure
(cloud-clj.schema/refresh-schema-column!
  session
  ["platform" "user_persona"]
  ["platform" "user_id"])
```

If you're logged in as a root user, you can easily create users, with a password,
in any instance. The namespace and instance id are figured out for you.

```clojure
(cloud-clj.user/root-create-user!
  session "qa"
  {:name "someuser@somesite.com"
   :first_name "Some"
   :last_name "User"
   :email "someuser@somesite.com"}
  "somepassword!!!11")
```



