(ns cloud-clj.api.response.data.schema
  (:require
    [cloud-clj.api.response.data.schema.column :as c]
    [clojure.spec.alpha :as s]))

(s/def ::columns (s/coll-of ::c/column-definition))

(s/def ::schema-definition
  (s/and
    map?
    (s/keys
      :req-un [::type ::name ::permissions ::columns ::relationships])))

(s/def ::schema-definition-list
  (s/and
    vector?
    (s/coll-of ::schema-definition)))

(s/def ::data
  (s/or
    :schema-item ::schema-definition 
    :schema-list ::schema-definition-list))
