(ns cloud-clj.api.response
  (:require
    [cloud-clj.api.response.meta :as m]
    [cloud-clj.api.response.data :as d]
    [cloud-clj.api.response.data.schema :as schema]
    [clojure.spec.alpha :as s]))

(s/def ::status #{"success"})

(s/def ::code (s/and integer? (s/int-in 200 500)))
(s/def ::time float?)
(s/def ::size integer?)

(s/def ::generic-body
  (s/keys
    :req-un [::status ::code ::time ::size ::m/meta]))

(s/def ::data-body
  (s/merge
    ::generic-body
    (s/keys :req-un [::d/data])))

(s/def ::schema-body
  (s/merge
    ::generic-body
    (s/keys :req-un [::schema/data])))
