# cloud-clj 

A Clojure libarary designed to interact with the Motivis Cloud API.

## Usage

Create a session by config or by a file that has a configuration defined.

```clojure
(def session
  (cloud-clj/config->session
    {:host "Cloud API Host"
     :user {:username "some@username.com"
            :password "somepassword"}}))
```

If a file is used, it must have the same map structure as the example above.

```clojure
(def session
  (cloud-clj/file->session "/path/to/config/file.edn"))
```

Start using the session.

```clojure
(cloud-clj/select-data
  session "platform" "user"
  {:where {:email {:$eq "some@username.com"})
```

