(ns monkey.glow-inline
  (:require [clojure.walk :as w]
            [glow
             [colorschemes :as cs]
             [html :as h]
             [parse :as p]]
            [hiccup2.core :as hiccup]))

(defn- add-style [m theme]
  (let [c (some-> m :class keyword)]
    (cond-> m
      c (assoc :style {:color (get theme c)}))))

(defn add-styles [tree theme]
  (w/postwalk (fn [x]
                (cond-> x
                  (map? x) (add-style theme)))
              tree))

(def theme-light cs/solarized-dark)
(def theme-dark
  (let [d "#c9d1d9"
        b "#ffa657"
        s "#a5d6ff"
        n "#7ee787"
        k "#ff7b72"
        v "#d2a8ff"]
    {:s-exp d
     :definition n
     :special-form k
     :core-fn k
     :string s
     :character s
     :macro b
     :symbol n
     :keyword b
     :number s
     :boolean s
     :nil s
     :variable b
     :reader-char b
     :regex s
     :repeat d
     :exception s
     :conditional k
     :comment "#8b949e"
     :background "#0d1117"}))

(defn highlight
  "Generates hiccup structure from the given Clojure code"
  [code & [opts]]
  (-> (p/parse code)
      (h/hiccup-transform)
      (add-styles (or (:theme opts) theme-light))))

(defn highlight-html
  "Generates html from clojure code"
  [code & [opts]]
  (-> (highlight code opts)
      (hiccup/html)
      (str)))
