(ns monkey.glow-inline
  (:require [clojure.walk :as w]
            [glow
             [colorschemes :as cs]
             [html :as h]
             [parse :as p]]
            [hiccup2.core :as hiccup]))

(defn- add-style [m theme]
  (let [c (some-> m :class keyword)]
    (cond-> m
      c (assoc :style {:color (get theme c)}))))

(defn add-styles [tree theme]
  (w/postwalk (fn [x]
                (cond-> x
                  (map? x) (add-style theme)))
              tree))

(defn highlight
  "Generates hiccup structure from the given Clojure code"
  [code & [opts]]
  (-> (p/parse code)
      (h/hiccup-transform)
      (add-styles (or (:theme opts) cs/solarized-dark))))

(defn highlight-html
  "Generates html from clojure code"
  [code & [opts]]
  (-> (highlight code opts)
      (hiccup/html)
      (str)))
