(ns monkey.ci.plugin.infra.clj
  "Functions for patching files in the clj dir"
  (:require [clojure.edn :as edn]
            [clojure.pprint :as cp])
  (:import [java.io StringReader StringWriter PushbackReader]))

(def env->path
  ;; Moved all versions into one file
  (constantly "clj/resources/versions.edn"))

(defn parse-edn [s]
  (with-open [r (PushbackReader. (StringReader. s))]
    (edn/read r)))

(def img-map
  {"website" :web
   "monkeyci-gui" :gui
   "monkeyci-api" :api})

(defn update-img-versions [conf env images]
  (reduce-kv (fn [conf img new-v]
               (assoc-in conf [env (img-map img)] new-v))
             conf
             images))

(defn- pprint [obj]
  (with-open [pw (StringWriter.)]
    (cp/pprint obj pw)
    (.toString pw)))

(defn update-versions [edn env images]
  (some-> edn
          (parse-edn)
          (update-img-versions env images)
          (pprint)))

(defn patch-versions
  "Patches the `versions.edn` file in the clj resources for the given env."
  [updater env images]
  (updater (env->path env) #(update-versions % env images)))
