(ns monkey.ci.plugin.terraform
  "Allows basic manipulation of terraform var files"
  (:require [clojure.string :as cs]))

(defn- apply-replace [replacements line]
  (let [[k :as parts] (cs/split line #"=")]
    (if (and parts (contains? replacements k))
      (str k "=\"" (get replacements k) "\"")
      line)))

(defn replace-vars
  "Given the contents of a tfvars file, applies given replacements."
  [contents replacements]
  (->> (cs/split-lines contents)
       (mapv (partial apply-replace replacements))
       (cs/join "\n")))

(defn patch-vars
  "Applies replacements on given file"
  [path repl]
  (-> (slurp path)
      (replace-vars repl)
      (as-> c (spit path c))))
