(ns monkey.ci.runners.interceptors
  "Reusable mailman interceptors for runners"
  (:require [clojure.tools.logging :as log]
            [monkey.ci.events.mailman.interceptors :as emi]
            [monkey.ci.storage :as st]))

(defn save-runner-details [get-details]
  "Interceptor that stores build runner details generated by a function that
   operates on the context.  This assumes the db is present in the context."
  {:name ::save-runner-details
   :enter (fn [ctx]
            (let [sid (get-in ctx [:event :sid])
                  details (get-details ctx)]
              (when details
                (log/debug "Saving runner details:" details)
                (st/save-runner-details (emi/get-db ctx) sid details))
              ctx))})
