/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.scratch;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.nodex.java.scratch.ConnectionHandler;

public class Pool<T> {
    private Queue<T> connections = new ConcurrentLinkedQueue<T>();
    private Queue<ConnectionHandler<T>> waiters = new ConcurrentLinkedQueue<ConnectionHandler<T>>();

    public void get(ConnectionHandler<T> handler) {
        T conn = this.connections.poll();
        if (conn != null) {
            handler.onConnection(conn);
        } else {
            this.waiters.add(handler);
        }
    }

    public void returnConnection(T conn) {
        ConnectionHandler<T> handler = this.waiters.poll();
        if (handler != null) {
            handler.onConnection(conn);
        } else {
            this.connections.add(conn);
        }
    }
}

