/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.streams;

import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.streams.ReadStream;
import org.nodex.java.core.streams.WriteStream;

public class Pump {
    private final ReadStream readStream;
    private final WriteStream writeStream;
    private int pumped;
    private final Handler<Void> drainHandler = new Handler<Void>(){

        @Override
        public void handle(Void v) {
            Pump.this.readStream.resume();
        }
    };
    private final Handler<Buffer> dataHandler = new Handler<Buffer>(){

        @Override
        public void handle(Buffer buffer) {
            Pump.this.writeStream.writeBuffer(buffer);
            Pump.this.pumped += buffer.length();
            if (Pump.this.writeStream.writeQueueFull()) {
                Pump.this.readStream.pause();
                Pump.this.writeStream.drainHandler(Pump.this.drainHandler);
            }
        }
    };

    public Pump(ReadStream rs, WriteStream ws) {
        this.readStream = rs;
        this.writeStream = ws;
    }

    public Pump(ReadStream rs, WriteStream ws, int maxWriteQueueSize) {
        this(rs, ws);
        this.writeStream.setWriteQueueMaxSize(maxWriteQueueSize);
    }

    public void setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
    }

    public void start() {
        this.readStream.dataHandler(this.dataHandler);
    }

    public void stop() {
        this.writeStream.drainHandler(null);
        this.readStream.dataHandler(null);
    }

    public int getBytesPumped() {
        return this.pumped;
    }
}

