/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.stdio;

import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;

class StreamBase {
    protected final long contextID;
    protected final Thread th;
    protected Handler<Exception> exceptionHandler;

    protected StreamBase() {
        Long contextID = Nodex.instance.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("Can only be used inside an event loop");
        }
        this.contextID = contextID;
        this.th = Thread.currentThread();
    }

    protected void checkThread() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread, actual: " + Thread.currentThread() + " expected: " + this.th);
        }
    }

    public void exceptionHandler(Handler<Exception> handler) {
        this.checkThread();
        this.exceptionHandler = handler;
    }
}

