/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.stdio;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.stdio.StreamBase;
import org.nodex.java.core.streams.WriteStream;

public class OutStream
extends StreamBase
implements WriteStream {
    private Handler<Void> drainHandler;
    private int writeQueueMaxSize = 8192;
    private final PrintStream out;
    private final AtomicInteger pendingWrites = new AtomicInteger(0);

    public OutStream(PrintStream out) {
        this.out = out;
    }

    @Override
    public void writeBuffer(Buffer data) {
        this.checkThread();
        final byte[] bytes = data.getBytes();
        this.pendingWrites.addAndGet(bytes.length);
        NodexInternal.instance.executeInBackground(new Runnable(){

            @Override
            public void run() {
                OutStream.this.out.write(bytes, 0, bytes.length);
                int queueSize = OutStream.this.pendingWrites.addAndGet(-bytes.length);
                OutStream.this.checkDrain(queueSize);
            }
        });
    }

    @Override
    public void setWriteQueueMaxSize(int maxSize) {
        this.checkThread();
        this.writeQueueMaxSize = maxSize;
    }

    @Override
    public boolean writeQueueFull() {
        this.checkThread();
        return this.pendingWrites.get() >= this.writeQueueMaxSize;
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.checkThread();
        this.drainHandler = handler;
        if (this.pendingWrites.get() <= this.writeQueueMaxSize / 2 && this.drainHandler != null) {
            this.drainHandler = null;
            handler.handle(null);
        }
    }

    private void checkDrain(int queueSize) {
        if (queueSize <= this.writeQueueMaxSize / 2 && this.drainHandler != null) {
            NodexInternal.instance.executeOnContext(this.contextID, new Runnable(){

                @Override
                public void run() {
                    Handler dh = OutStream.this.drainHandler;
                    if (dh != null) {
                        NodexInternal.instance.setContextID(OutStream.this.contextID);
                        OutStream.this.drainHandler = null;
                        dh.handle(null);
                    }
                }
            });
        }
    }
}

