/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.stdio;

import java.io.IOException;
import java.io.InputStream;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.stdio.StreamBase;
import org.nodex.java.core.streams.ReadStream;

public class InStream
extends StreamBase
implements ReadStream {
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private boolean paused;
    private final InputStream in;
    private static final int BUFFER_SIZE = 1024;

    public InStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void dataHandler(Handler<Buffer> handler) {
        this.checkThread();
        Handler<Buffer> oldHandler = this.dataHandler;
        this.dataHandler = handler;
        if (!this.paused && oldHandler == null && handler != null) {
            this.doRead();
        }
    }

    @Override
    public void pause() {
        this.checkThread();
        this.paused = true;
    }

    @Override
    public void resume() {
        this.checkThread();
        this.paused = false;
        if (this.dataHandler != null) {
            this.doRead();
        }
    }

    @Override
    public void endHandler(Handler<Void> endHandler) {
        this.checkThread();
        this.endHandler = endHandler;
    }

    private void doRead() {
        final NodexInternal nodex = NodexInternal.instance;
        nodex.executeInBackground(new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        byte[] buff = new byte[1024];
                        int bytesRead = InStream.this.in.read(buff);
                        if (bytesRead != -1) {
                            if (bytesRead < 1024) {
                                byte[] buff2 = new byte[bytesRead];
                                System.arraycopy(buff, 0, buff2, 0, bytesRead);
                                buff = buff2;
                            }
                            final Buffer ret = Buffer.create(buff);
                            nodex.executeOnContext(InStream.this.contextID, new Runnable(){

                                @Override
                                public void run() {
                                    nodex.setContextID(InStream.this.contextID);
                                    if (!InStream.this.paused && InStream.this.dataHandler != null) {
                                        InStream.this.dataHandler.handle(ret);
                                        if (!InStream.this.paused && InStream.this.dataHandler != null) {
                                            InStream.this.doRead();
                                        }
                                    }
                                }
                            });
                        } else if (InStream.this.endHandler != null) {
                            InStream.this.endHandler.handle(null);
                        }
                    }
                    catch (IOException e) {
                        if (InStream.this.exceptionHandler == null) break block6;
                        InStream.this.exceptionHandler.handle(e);
                    }
                }
            }
        });
    }
}

