/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.nodex.java.core.shared.SharedUtils;

class SharedMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, V> map = new NonBlockingHashMap();

    SharedMap() {
    }

    @Override
    public V putIfAbsent(K k, V v) {
        k = SharedUtils.checkObject(k);
        v = SharedUtils.checkObject(v);
        return this.map.putIfAbsent(k, v);
    }

    @Override
    public boolean remove(Object o, Object o1) {
        return this.map.remove(o, o1);
    }

    @Override
    public boolean replace(K k, V v, V v1) {
        k = SharedUtils.checkObject(k);
        v1 = SharedUtils.checkObject(v1);
        return this.map.replace(k, v, v1);
    }

    @Override
    public V replace(K k, V v) {
        k = SharedUtils.checkObject(k);
        v = SharedUtils.checkObject(v);
        return this.map.replace(k, v);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    @Override
    public V get(Object o) {
        return this.map.get(o);
    }

    @Override
    public V put(K k, V v) {
        k = SharedUtils.checkObject(k);
        v = SharedUtils.checkObject(v);
        return this.map.put(k, v);
    }

    @Override
    public V remove(Object o) {
        return this.map.remove(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = SharedUtils.checkObject(entry.getKey());
            V v = SharedUtils.checkObject(entry.getValue());
            this.map.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : this.map.entrySet()) {
            entries.add(new Entry(entry));
        }
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final Map.Entry<K, V> internalEntry;

        Entry(Map.Entry<K, V> internalEntry) {
            this.internalEntry = internalEntry;
        }

        @Override
        public K getKey() {
            return this.internalEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.internalEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            V old = this.internalEntry.getValue();
            value = SharedUtils.checkObject(value);
            this.internalEntry.setValue(value);
            return old;
        }
    }
}

