/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.shared;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.nodex.java.core.shared.SharedCounter;
import org.nodex.java.core.shared.SharedMap;
import org.nodex.java.core.shared.SharedQueue;
import org.nodex.java.core.shared.SharedSet;

public class SharedData {
    private static ConcurrentMap<Object, SharedMap<?, ?>> maps = new NonBlockingHashMap();
    private static ConcurrentMap<Object, SharedSet<?>> sets = new NonBlockingHashMap();
    private static ConcurrentMap<Object, SharedCounter> counters = new NonBlockingHashMap();
    private static ConcurrentMap<Object, SharedQueue> queues = new NonBlockingHashMap();

    public static <K, V> Map<K, V> getMap(Object name) {
        SharedMap prev;
        SharedMap map = (SharedMap)maps.get(name);
        if (map == null && (prev = maps.putIfAbsent(name, map = new SharedMap())) != null) {
            map = prev;
        }
        return map;
    }

    public static <E> Set<E> getSet(Object name) {
        SharedSet prev;
        SharedSet set = (SharedSet)sets.get(name);
        if (set == null && (prev = sets.putIfAbsent(name, set = new SharedSet())) != null) {
            set = prev;
        }
        return set;
    }

    public static boolean removeMap(Object name) {
        return maps.remove(name) != null;
    }

    public static boolean removeSet(Object name) {
        return sets.remove(name) != null;
    }
}

