/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TLSHelper {
    public static SSLContext createContext(String ksPath, String ksPassword, String tsPath, String tsPassword, boolean trustAll) {
        try {
            KeyManager[] keyMgrs;
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] keyManagerArray = keyMgrs = ksPath == null ? null : TLSHelper.getKeyMgrs(ksPath, ksPassword);
            TrustManager[] trustMgrs = trustAll ? new TrustManager[]{TLSHelper.createTrustAllTrustManager()} : (tsPath == null ? null : TLSHelper.getTrustMgrs(tsPath, tsPassword));
            context.init(keyMgrs, trustMgrs, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    private static TrustManager[] getTrustMgrs(String tsPath, String tsPassword) throws Exception {
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ts = TLSHelper.loadStore(tsPath, tsPassword);
        fact.init(ts);
        return fact.getTrustManagers();
    }

    private static KeyManager[] getKeyMgrs(String ksPath, String ksPassword) throws Exception {
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = TLSHelper.loadStore(ksPath, ksPassword);
        fact.init(ks, ksPassword.toCharArray());
        return fact.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadStore(String ksPath, String ksPassword) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        InputStream in = null;
        try {
            in = new FileInputStream(new File(ksPath));
            ks.load(in, ksPassword.toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
        }
        return ks;
    }
}

