/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.io.File;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.util.CharsetUtil;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.SimpleHandler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.net.ConnectionBase;
import org.nodex.java.core.streams.ReadStream;
import org.nodex.java.core.streams.WriteStream;

public class NetSocket
extends ConnectionBase
implements ReadStream,
WriteStream {
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Void> drainHandler;
    public final long writeHandlerID = Nodex.instance.registerHandler(new Handler<Buffer>(){

        @Override
        public void handle(Buffer buff) {
            NetSocket.this.writeBuffer(buff);
        }
    });

    NetSocket(Channel channel, long contextID, Thread th) {
        super(channel, contextID, th);
    }

    @Override
    public void writeBuffer(Buffer data) {
        this.doWrite(data.getChannelBuffer());
    }

    public NetSocket write(Buffer data) {
        this.doWrite(data.getChannelBuffer());
        return this;
    }

    public NetSocket write(String str) {
        this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8));
        return this;
    }

    public NetSocket write(String str, String enc) {
        if (enc == null) {
            this.write(str);
        } else {
            this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc)));
        }
        return this;
    }

    public NetSocket write(Buffer data, Handler<Void> doneHandler) {
        this.addFuture(doneHandler, this.doWrite(data.getChannelBuffer()));
        return this;
    }

    public NetSocket write(String str, Handler<Void> doneHandler) {
        this.addFuture(doneHandler, this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8)));
        return this;
    }

    public NetSocket write(String str, String enc, Handler<Void> doneHandler) {
        if (enc == null) {
            this.write(str, enc);
        } else {
            this.addFuture(doneHandler, this.doWrite(ChannelBuffers.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc))));
        }
        return this;
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.checkThread();
        this.dataHandler = dataHandler;
    }

    @Override
    public void endHandler(Handler<Void> endHandler) {
        this.checkThread();
        this.endHandler = endHandler;
    }

    @Override
    public void drainHandler(Handler<Void> drainHandler) {
        this.checkThread();
        this.drainHandler = drainHandler;
        Nodex.instance.nextTick(new SimpleHandler(){

            @Override
            public void handle() {
                NetSocket.this.callDrainHandler();
            }
        });
    }

    public void sendFile(String filename) {
        this.checkThread();
        File f = new File(filename);
        super.sendFile(f);
    }

    @Override
    protected long getContextID() {
        return super.getContextID();
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        this.setContextID();
        Nodex.instance.unregisterHandler(this.writeHandlerID);
        if (this.endHandler != null) {
            try {
                this.endHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
    }

    void handleInterestedOpsChanged() {
        this.setContextID();
        this.callDrainHandler();
    }

    void handleDataReceived(Buffer data) {
        if (this.dataHandler != null) {
            this.setContextID();
            try {
                this.dataHandler.handle(data);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    void internalClose() {
        this.channel.close();
    }

    private ChannelFuture doWrite(ChannelBuffer buff) {
        this.checkThread();
        return this.channel.write((Object)buff);
    }

    private void callDrainHandler() {
        if (this.drainHandler != null && this.channel.isWritable()) {
            try {
                this.drainHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }
}

