/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.net.NetServerBase;
import org.nodex.java.core.net.NetSocket;

public class NetServer
extends NetServerBase {
    private Map<Channel, NetSocket> socketMap = new ConcurrentHashMap<Channel, NetSocket>();
    private Handler<NetSocket> connectHandler;
    private ChannelGroup serverChannelGroup;
    private boolean listening;

    public NetServer connectHandler(Handler<NetSocket> connectHandler) {
        this.checkThread();
        this.connectHandler = connectHandler;
        return this;
    }

    @Override
    public NetServer setSSL(boolean ssl) {
        this.checkThread();
        return (NetServer)super.setSSL(ssl);
    }

    @Override
    public NetServer setKeyStorePath(String path) {
        this.checkThread();
        return (NetServer)super.setKeyStorePath(path);
    }

    @Override
    public NetServer setKeyStorePassword(String pwd) {
        this.checkThread();
        return (NetServer)super.setKeyStorePassword(pwd);
    }

    @Override
    public NetServer setTrustStorePath(String path) {
        this.checkThread();
        return (NetServer)super.setTrustStorePath(path);
    }

    @Override
    public NetServer setTrustStorePassword(String pwd) {
        this.checkThread();
        return (NetServer)super.setTrustStorePassword(pwd);
    }

    @Override
    public NetServer setClientAuthRequired(boolean required) {
        this.checkThread();
        return (NetServer)super.setClientAuthRequired(required);
    }

    @Override
    public NetServer setTcpNoDelay(boolean tcpNoDelay) {
        this.checkThread();
        return (NetServer)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public NetServer setSendBufferSize(int size) {
        this.checkThread();
        return (NetServer)super.setSendBufferSize(size);
    }

    @Override
    public NetServer setReceiveBufferSize(int size) {
        this.checkThread();
        return (NetServer)super.setReceiveBufferSize(size);
    }

    @Override
    public NetServer setTCPKeepAlive(boolean keepAlive) {
        this.checkThread();
        return (NetServer)super.setTCPKeepAlive(keepAlive);
    }

    @Override
    public NetServer setReuseAddress(boolean reuse) {
        this.checkThread();
        return (NetServer)super.setReuseAddress(reuse);
    }

    @Override
    public NetServer setSoLinger(boolean linger) {
        this.checkThread();
        return (NetServer)super.setSoLinger(linger);
    }

    @Override
    public NetServer setTrafficClass(int trafficClass) {
        this.checkThread();
        return (NetServer)super.setTrafficClass(trafficClass);
    }

    public NetServer listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    public NetServer listen(int port, String host) {
        this.checkThread();
        if (this.connectHandler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.serverChannelGroup = new DefaultChannelGroup("nodex-acceptor-channels");
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(NodexInternal.instance.getAcceptorPool(), NodexInternal.instance.getWorkerPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        this.checkSSL();
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NetServer.this.ssl) {
                    SSLEngine engine = NetServer.this.context.createSSLEngine();
                    engine.setUseClientMode(false);
                    switch (NetServer.this.clientAuth) {
                        case REQUEST: {
                            engine.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRED: {
                            engine.setNeedClientAuth(true);
                            break;
                        }
                        case NONE: {
                            engine.setNeedClientAuth(false);
                        }
                    }
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("handler", (ChannelHandler)new ServerHandler());
                return pipeline;
            }
        });
        bootstrap.setOptions(this.connectionOptions);
        try {
            Channel serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(InetAddress.getByName(host), port));
            this.serverChannelGroup.add((Object)serverChannel);
            System.out.println("Net server listening on " + host + ":" + port);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void close() {
        this.close(null);
    }

    public void close(final Handler<Void> done) {
        this.checkThread();
        long cid = Nodex.instance.getContextID();
        for (NetSocket sock : this.socketMap.values()) {
            sock.internalClose();
        }
        NodexInternal.instance.setContextID(cid);
        if (done != null) {
            final Long contextID = Nodex.instance.getContextID();
            this.serverChannelGroup.close().addListener(new ChannelGroupFutureListener(){

                public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            NetServer.this.listening = false;
                            done.handle(null);
                        }
                    };
                    NodexInternal.instance.executeOnContext(contextID, runner);
                }
            });
        }
    }

    private class ServerHandler
    extends SimpleChannelHandler {
        private ServerHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final long contextID = NodexInternal.instance.associateContextWithWorker(ch.getWorker());
            NetServer.this.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    NodexInternal.instance.setContextID(contextID);
                    NetSocket sock = new NetSocket((Channel)ch, contextID, Thread.currentThread());
                    NetServer.this.socketMap.put(ch, sock);
                    NetServer.this.connectHandler.handle(sock);
                }
            });
        }

        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetServer.this.socketMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                NetServer.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleInterestedOpsChanged();
                    }
                });
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetServer.this.socketMap.remove(ch);
            if (sock != null) {
                NetServer.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleClosed();
                        NodexInternal.instance.destroyContext(sock.getContextID());
                    }
                });
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            Channel ch = e.getChannel();
            NetSocket sock = (NetSocket)NetServer.this.socketMap.get(ch);
            ChannelBuffer buff = (ChannelBuffer)e.getMessage();
            sock.handleDataReceived(new Buffer(buff.slice()));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetServer.this.socketMap.get(ch);
            ch.close();
            final Throwable t = e.getCause();
            if (sock != null && t instanceof Exception) {
                NetServer.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleException((Exception)t);
                    }
                });
            } else {
                t.printStackTrace();
            }
        }
    }
}

