/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.net.NetClientBase;
import org.nodex.java.core.net.NetSocket;

public class NetClient
extends NetClientBase {
    private ClientBootstrap bootstrap;
    private NioClientSocketChannelFactory channelFactory;
    private Map<Channel, NetSocket> socketMap = new ConcurrentHashMap<Channel, NetSocket>();
    private Handler<Exception> exceptionHandler;

    public NetClient connect(int port, String host, final Handler<NetSocket> connectHandler) {
        final Long contextID = Nodex.instance.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("Requests must be made from inside an event loop");
        }
        if (this.bootstrap == null) {
            this.channelFactory = new NioClientSocketChannelFactory(NodexInternal.instance.getAcceptorPool(), NodexInternal.instance.getWorkerPool());
            this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
            this.checkSSL();
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline pipeline = Channels.pipeline();
                    if (NetClient.this.ssl) {
                        SSLEngine engine = NetClient.this.context.createSSLEngine();
                        engine.setUseClientMode(true);
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                    pipeline.addLast("handler", (ChannelHandler)new ClientHandler());
                    return pipeline;
                }
            });
        }
        this.channelFactory.setWorker(NodexInternal.instance.getWorkerForContextID(contextID));
        this.bootstrap.setOptions(this.connectionOptions);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    final NioSocketChannel ch = (NioSocketChannel)channelFuture.getChannel();
                    NetClient.this.runOnCorrectThread(ch, new Runnable(){

                        @Override
                        public void run() {
                            NodexInternal.instance.setContextID(contextID);
                            NetSocket sock = new NetSocket((Channel)ch, contextID, Thread.currentThread());
                            NetClient.this.socketMap.put(ch, sock);
                            connectHandler.handle(sock);
                        }
                    });
                } else {
                    Throwable t = channelFuture.getCause();
                    if (t instanceof Exception && NetClient.this.exceptionHandler != null) {
                        NetClient.this.exceptionHandler.handle((Exception)t);
                    } else {
                        t.printStackTrace(System.err);
                    }
                }
            }
        });
        return this;
    }

    public NetClient connect(int port, Handler<NetSocket> connectCallback) {
        return this.connect(port, "localhost", connectCallback);
    }

    public void close() {
        for (NetSocket sock : this.socketMap.values()) {
            sock.close();
        }
    }

    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public NetClient setSSL(boolean ssl) {
        return (NetClient)super.setSSL(ssl);
    }

    @Override
    public NetClient setKeyStorePath(String path) {
        return (NetClient)super.setKeyStorePath(path);
    }

    @Override
    public NetClient setKeyStorePassword(String pwd) {
        return (NetClient)super.setKeyStorePassword(pwd);
    }

    @Override
    public NetClient setTrustStorePath(String path) {
        return (NetClient)super.setTrustStorePath(path);
    }

    @Override
    public NetClient setTrustStorePassword(String pwd) {
        return (NetClient)super.setTrustStorePassword(pwd);
    }

    @Override
    public NetClient setTrustAll(boolean trustAll) {
        return (NetClient)super.setTrustAll(trustAll);
    }

    @Override
    public NetClient setTcpNoDelay(boolean tcpNoDelay) {
        return (NetClient)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public NetClient setSendBufferSize(int size) {
        return (NetClient)super.setSendBufferSize(size);
    }

    @Override
    public NetClient setReceiveBufferSize(int size) {
        return (NetClient)super.setReceiveBufferSize(size);
    }

    @Override
    public NetClient setTCPKeepAlive(boolean keepAlive) {
        return (NetClient)super.setTCPKeepAlive(keepAlive);
    }

    @Override
    public NetClient setReuseAddress(boolean reuse) {
        return (NetClient)super.setReuseAddress(reuse);
    }

    @Override
    public NetClient setSoLinger(boolean linger) {
        return (NetClient)super.setSoLinger(linger);
    }

    @Override
    public NetClient setTrafficClass(int trafficClass) {
        return (NetClient)super.setTrafficClass(trafficClass);
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetClient.this.socketMap.get(ch);
            NetClient.this.socketMap.remove(ch);
            if (sock != null) {
                NetClient.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleClosed();
                    }
                });
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            NetSocket sock = (NetSocket)NetClient.this.socketMap.get(ctx.getChannel());
            if (sock != null) {
                ChannelBuffer cb = (ChannelBuffer)e.getMessage();
                sock.handleDataReceived(new Buffer(cb));
            }
        }

        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetClient.this.socketMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                NetClient.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleInterestedOpsChanged();
                    }
                });
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final NetSocket sock = (NetSocket)NetClient.this.socketMap.get(ch);
            final Throwable t = e.getCause();
            if (sock != null && t instanceof Exception) {
                NetClient.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        sock.handleException((Exception)t);
                        ch.close();
                    }
                });
            } else {
                t.printStackTrace();
            }
        }
    }
}

