/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.net.TLSHelper;

public abstract class NetBase {
    protected Map<String, Object> connectionOptions = new HashMap<String, Object>();
    protected boolean ssl;
    protected String keyStorePath;
    protected String keyStorePassword;
    protected String trustStorePath;
    protected String trustStorePassword;
    protected boolean trustAll;
    protected SSLContext context;
    protected Thread th;
    protected long contextID;

    protected NetBase() {
        Long cid = Nodex.instance.getContextID();
        if (cid == null) {
            throw new IllegalStateException("Can only be used from an event loop");
        }
        this.contextID = cid;
        this.th = Thread.currentThread();
        this.connectionOptions.put("child.tcpNoDelay", true);
        this.connectionOptions.put("child.keepAlive", true);
    }

    protected void checkSSL() {
        if (this.ssl) {
            this.context = TLSHelper.createContext(this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.trustAll);
        }
    }

    protected void checkThread() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread, actual: " + Thread.currentThread() + " expected: " + this.th);
        }
    }

    protected void runOnCorrectThread(NioSocketChannel nch, Runnable runnable) {
        if (Thread.currentThread() != nch.getWorker().getThread()) {
            nch.getWorker().scheduleOtherTask(runnable);
        } else {
            runnable.run();
        }
    }

    public NetBase setTcpNoDelay(boolean tcpNoDelay) {
        this.connectionOptions.put("child.tcpNoDelay", tcpNoDelay);
        return this;
    }

    public NetBase setSendBufferSize(int size) {
        this.connectionOptions.put("child.sendBufferSize", size);
        return this;
    }

    public NetBase setReceiveBufferSize(int size) {
        this.connectionOptions.put("child.receiveBufferSize", size);
        return this;
    }

    public NetBase setTCPKeepAlive(boolean keepAlive) {
        this.connectionOptions.put("child.keepAlive", keepAlive);
        return this;
    }

    public NetBase setReuseAddress(boolean reuse) {
        this.connectionOptions.put("child.reuseAddress", reuse);
        return this;
    }

    public NetBase setSoLinger(boolean linger) {
        this.connectionOptions.put("child.soLinger", linger);
        return this;
    }

    public NetBase setTrafficClass(int trafficClass) {
        this.connectionOptions.put("child.trafficClass", trafficClass);
        return this;
    }

    public NetBase setSSL(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public NetBase setKeyStorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public NetBase setKeyStorePassword(String pwd) {
        this.keyStorePassword = pwd;
        return this;
    }

    public NetBase setTrustStorePath(String path) {
        this.trustStorePath = path;
        return this;
    }

    public NetBase setTrustStorePassword(String pwd) {
        this.trustStorePassword = pwd;
        return this;
    }

    protected static enum ClientAuth {
        NONE,
        REQUEST,
        REQUIRED;

    }
}

