/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.net;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.socket.nio.NioSocketChannelConfig;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedFile;
import org.nodex.java.core.Handler;
import org.nodex.java.core.internal.NodexInternal;

public abstract class ConnectionBase {
    protected final Channel channel;
    protected final long contextID;
    protected final Thread th;
    protected Handler<Exception> exceptionHandler;
    protected Handler<Void> closedHandler;

    protected ConnectionBase(Channel channel, long contextID, Thread th) {
        this.channel = channel;
        this.contextID = contextID;
        this.th = th;
    }

    public void pause() {
        this.checkThread();
        this.channel.setReadable(false);
    }

    public void resume() {
        this.checkThread();
        this.channel.setReadable(true);
    }

    public void setWriteQueueMaxSize(int size) {
        this.checkThread();
        NioSocketChannelConfig conf = (NioSocketChannelConfig)this.channel.getConfig();
        conf.setWriteBufferLowWaterMark(size / 2);
        conf.setWriteBufferHighWaterMark(size);
    }

    public boolean writeQueueFull() {
        this.checkThread();
        return !this.channel.isWritable();
    }

    public void close() {
        this.checkThread();
        this.channel.close();
    }

    public void exceptionHandler(Handler<Exception> handler) {
        this.checkThread();
        this.exceptionHandler = handler;
    }

    public void closedHandler(Handler<Void> handler) {
        this.checkThread();
        this.closedHandler = handler;
    }

    protected long getContextID() {
        return this.contextID;
    }

    protected void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.setContextID();
            try {
                this.exceptionHandler.handle(e);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        } else {
            this.handleHandlerException(e);
        }
    }

    protected void handleClosed() {
        if (this.closedHandler != null) {
            this.setContextID();
            try {
                this.closedHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    protected void addFuture(final Handler<Void> doneHandler, ChannelFuture future) {
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                ConnectionBase.this.setContextID();
                if (channelFuture.isSuccess()) {
                    doneHandler.handle(null);
                } else {
                    Throwable err = channelFuture.getCause();
                    if (ConnectionBase.this.exceptionHandler != null && err instanceof Exception) {
                        ConnectionBase.this.exceptionHandler.handle((Exception)err);
                    } else {
                        err.printStackTrace();
                    }
                }
            }
        });
    }

    protected void checkThread() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread, actual: " + Thread.currentThread() + " expected: " + this.th);
        }
    }

    protected void setContextID() {
        this.checkThread();
        NodexInternal.instance.setContextID(this.contextID);
    }

    protected void handleHandlerException(Throwable t) {
        t.printStackTrace(System.err);
    }

    protected boolean isSSL() {
        return this.channel.getPipeline().get(SslHandler.class) != null;
    }

    protected ChannelFuture sendFile(File file) {
        try {
            ChannelFuture writeFuture;
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            long fileLength = file.length();
            if (this.isSSL()) {
                writeFuture = this.channel.write((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
            } else {
                DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
                writeFuture = this.channel.write((Object)region);
            }
            return writeFuture;
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }
}

