/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import org.jboss.netty.handler.codec.http.websocket.DefaultWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.AbstractConnection;
import org.nodex.java.core.streams.ReadStream;
import org.nodex.java.core.streams.WriteStream;

public class Websocket
implements ReadStream,
WriteStream {
    private final AbstractConnection conn;
    private Handler<Buffer> dataHandler;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private Handler<Void> endHandler;
    public final String uri;

    Websocket(String uri, AbstractConnection conn) {
        this.uri = uri;
        this.conn = conn;
    }

    public void writeBinaryFrame(Buffer data) {
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(128, data.getChannelBuffer());
        this.conn.write(frame);
    }

    public void writeTextFrame(String str) {
        DefaultWebSocketFrame frame = new DefaultWebSocketFrame(str);
        this.conn.write(frame);
    }

    @Override
    public void dataHandler(Handler<Buffer> handler) {
        this.dataHandler = handler;
    }

    @Override
    public void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public void pause() {
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.conn.resume();
    }

    @Override
    public void setWriteQueueMaxSize(int maxSize) {
        this.conn.setWriteQueueMaxSize(maxSize);
    }

    @Override
    public boolean writeQueueFull() {
        return this.conn.writeQueueFull();
    }

    @Override
    public void writeBuffer(Buffer data) {
        this.writeBinaryFrame(data);
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
    }

    public void close() {
        this.conn.close();
    }

    void handleFrame(WebSocketFrame frame) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(new Buffer(frame.getBinaryData()));
        }
    }

    void writable() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }
}

