/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.io.File;
import java.util.LinkedList;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.SimpleHandler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.AbstractConnection;
import org.nodex.java.core.http.HttpServerRequest;
import org.nodex.java.core.http.Websocket;

class ServerConnection
extends AbstractConnection {
    private static final int CHANNEL_PAUSE_QUEUE_SIZE = 5;
    private Handler<HttpServerRequest> requestHandler;
    private Handler<Websocket> wsHandler;
    private HttpServerRequest currentRequest;
    private boolean pendingResponse;
    private Websocket ws;
    private boolean channelPaused;
    private boolean paused;
    private boolean sentCheck;
    private final Queue<Object> pending = new LinkedList<Object>();

    ServerConnection(Channel channel, long contextID, Thread th) {
        super(channel, contextID, th);
    }

    @Override
    public void pause() {
        this.checkThread();
        if (!this.paused) {
            this.paused = true;
        }
    }

    @Override
    public void resume() {
        this.checkThread();
        if (this.paused) {
            this.paused = false;
            this.checkNextTick();
        }
    }

    void handleMessage(Object msg) {
        if (this.paused || msg instanceof HttpRequest && this.pendingResponse || !this.pending.isEmpty()) {
            this.pending.add(msg);
            if (this.pending.size() == 5) {
                super.pause();
                this.channelPaused = true;
            }
        } else {
            this.processMessage(msg);
        }
    }

    void responseComplete() {
        this.pendingResponse = false;
        this.checkNextTick();
    }

    void requestHandler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
    }

    void wsHandler(Handler<Websocket> handler) {
        this.wsHandler = handler;
    }

    void internalClose() {
        this.channel.close();
    }

    private void handleRequest(HttpServerRequest req) {
        this.setContextID();
        try {
            this.currentRequest = req;
            this.pendingResponse = true;
            if (this.requestHandler != null) {
                this.requestHandler.handle(req);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleChunk(Buffer chunk) {
        try {
            this.setContextID();
            this.currentRequest.handleData(chunk);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleEnd() {
        try {
            this.setContextID();
            this.currentRequest.handleEnd();
            this.currentRequest = null;
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleInterestedOpsChanged() {
        try {
            if ((this.channel.getInterestOps() & 4) == 4) {
                this.setContextID();
                if (this.currentRequest != null) {
                    this.currentRequest.response.writable();
                } else if (this.ws != null) {
                    this.ws.writable();
                }
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleWebsocketConnect(Websocket ws) {
        try {
            if (this.wsHandler != null) {
                this.setContextID();
                this.wsHandler.handle(ws);
                this.ws = ws;
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    private void handleWsFrame(WebSocketFrame frame) {
        try {
            if (this.ws != null) {
                this.setContextID();
                this.ws.handleFrame(frame);
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
    }

    @Override
    protected long getContextID() {
        return super.getContextID();
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        }
        if (this.ws != null) {
            this.ws.handleException(e);
        }
    }

    @Override
    protected void addFuture(Handler<Void> doneHandler, ChannelFuture future) {
        super.addFuture(doneHandler, future);
    }

    @Override
    protected boolean isSSL() {
        return super.isSSL();
    }

    @Override
    protected ChannelFuture sendFile(File file) {
        return super.sendFile(file);
    }

    private void processMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            HttpServerRequest req = new HttpServerRequest(this, request);
            this.handleRequest(req);
            ChannelBuffer requestBody = request.getContent();
            if (requestBody.readable()) {
                this.handleChunk(new Buffer(requestBody));
            }
            if (!request.isChunked()) {
                this.handleEnd();
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.getContent().readable()) {
                Buffer buff = new Buffer(chunk.getContent());
                this.handleChunk(buff);
            }
            if (chunk.isLast()) {
                this.handleEnd();
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            this.handleWsFrame(frame);
        }
        this.checkNextTick();
    }

    private void checkNextTick() {
        if (!(this.sentCheck || this.pending.isEmpty() || this.paused || this.pendingResponse && !(this.pending.peek() instanceof HttpChunk))) {
            this.sentCheck = true;
            Nodex.instance.nextTick(new SimpleHandler(){

                @Override
                public void handle() {
                    ServerConnection.this.sentCheck = false;
                    if (!ServerConnection.this.paused) {
                        Object msg = ServerConnection.this.pending.poll();
                        if (msg != null) {
                            ServerConnection.this.processMessage(msg);
                        }
                        if (ServerConnection.this.channelPaused && ServerConnection.this.pending.isEmpty()) {
                            ServerConnection.super.resume();
                            ServerConnection.this.channelPaused = false;
                        }
                    }
                }
            });
        }
    }
}

