/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.ServerConnection;
import org.nodex.java.core.streams.WriteStream;

public class HttpServerResponse
implements WriteStream {
    private final boolean keepAlive;
    private final ServerConnection conn;
    private final HttpResponse response;
    private HttpChunkTrailer trailer;
    private boolean headWritten;
    private ChannelFuture writeFuture;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private long contentLength;
    private long writtenBytes;
    private boolean chunked;
    public int statusCode = HttpResponseStatus.OK.getCode();
    public String statusMessage = null;

    HttpServerResponse(boolean keepAlive, ServerConnection conn) {
        this.keepAlive = keepAlive;
        this.conn = conn;
        this.response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    public HttpServerResponse setChunked(boolean chunked) {
        this.checkWritten();
        if (this.writtenBytes > 0L) {
            throw new IllegalStateException("Cannot set chunked after data has been written on response");
        }
        this.chunked = chunked;
        return this;
    }

    public HttpServerResponse putHeader(String key, Object value) {
        this.checkWritten();
        this.response.setHeader(key, value);
        this.checkContentLengthChunked(key, value);
        return this;
    }

    public HttpServerResponse putAllHeaders(Map<String, ? extends Object> m) {
        this.checkWritten();
        for (Map.Entry<String, ? extends Object> entry : m.entrySet()) {
            this.response.setHeader(entry.getKey(), (Object)entry.getValue().toString());
            this.checkContentLengthChunked(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpServerResponse putTrailer(String key, Object value) {
        this.checkWritten();
        this.checkTrailer();
        this.trailer.setHeader(key, value);
        return this;
    }

    public HttpServerResponse putAllTrailers(Map<String, ? extends Object> m) {
        this.checkWritten();
        this.checkTrailer();
        for (Map.Entry<String, ? extends Object> entry : m.entrySet()) {
            this.trailer.setHeader(entry.getKey(), (Object)entry.getValue().toString());
        }
        return this;
    }

    @Override
    public void setWriteQueueMaxSize(int size) {
        this.checkWritten();
        this.conn.setWriteQueueMaxSize(size);
    }

    @Override
    public boolean writeQueueFull() {
        this.checkWritten();
        return this.conn.writeQueueFull();
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.checkWritten();
        this.drainHandler = handler;
        this.conn.handleInterestedOpsChanged();
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.checkWritten();
        this.exceptionHandler = handler;
    }

    @Override
    public void writeBuffer(Buffer chunk) {
        this.write(chunk.getChannelBuffer(), null);
    }

    public HttpServerResponse write(Buffer chunk) {
        return this.write(chunk.getChannelBuffer(), null);
    }

    public HttpServerResponse write(String chunk, String enc) {
        return this.write(Buffer.create(chunk, enc).getChannelBuffer(), null);
    }

    public HttpServerResponse write(String chunk) {
        return this.write(Buffer.create(chunk).getChannelBuffer(), null);
    }

    public HttpServerResponse write(Buffer chunk, Handler<Void> doneHandler) {
        return this.write(chunk.getChannelBuffer(), doneHandler);
    }

    public HttpServerResponse write(String chunk, String enc, Handler<Void> doneHandler) {
        return this.write(Buffer.create(chunk, enc).getChannelBuffer(), doneHandler);
    }

    public HttpServerResponse write(String chunk, Handler<Void> doneHandler) {
        return this.write(Buffer.create(chunk).getChannelBuffer(), doneHandler);
    }

    public void end() {
        this.checkWritten();
        this.writeHead();
        if (this.chunked) {
            Object nettyChunk = this.trailer == null ? new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER) : this.trailer;
            this.writeFuture = this.conn.write(nettyChunk);
        }
        if (!this.keepAlive) {
            this.writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
        this.written = true;
        this.conn.responseComplete();
    }

    public HttpServerResponse sendFile(String filename) {
        if (this.headWritten) {
            throw new IllegalStateException("Head already written");
        }
        this.checkWritten();
        File file = new File(filename);
        if (!file.exists()) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            this.writeFuture = this.conn.write(response);
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setHeader("Content-Length", (Object)String.valueOf(file.length()));
            try {
                String contenttype = Files.probeContentType(Paths.get(filename, new String[0]));
                if (contenttype != null) {
                    response.setHeader("Content-Type", (Object)contenttype);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.conn.write(response);
            this.writeFuture = this.conn.sendFile(file);
        }
        if (!this.keepAlive) {
            this.writeFuture.addListener(ChannelFutureListener.CLOSE);
        }
        this.written = true;
        this.headWritten = true;
        this.conn.responseComplete();
        return this;
    }

    void writable() {
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    private void checkTrailer() {
        if (this.trailer == null) {
            this.trailer = new DefaultHttpChunkTrailer();
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void checkContentLengthChunked(String key, Object value) {
        if (key.equals("Content-Length")) {
            this.contentLength = Integer.parseInt(value.toString());
            this.chunked = false;
        } else if (key.equals("Transfer-Encoding") && value.equals("chunked")) {
            this.chunked = true;
        }
    }

    private void writeHead() {
        if (!this.headWritten) {
            HttpResponseStatus status = this.statusMessage == null ? HttpResponseStatus.valueOf((int)this.statusCode) : new HttpResponseStatus(this.statusCode, this.statusMessage);
            this.response.setStatus(status);
            if (this.chunked) {
                this.response.setHeader("Transfer-Encoding", (Object)"chunked");
            } else if (this.contentLength == 0L) {
                this.response.setHeader("Content-Length", (Object)"0");
            }
            this.writeFuture = this.conn.write(this.response);
            this.headWritten = true;
        }
    }

    private HttpServerResponse write(ChannelBuffer chunk, Handler<Void> doneHandler) {
        this.checkWritten();
        this.writtenBytes += (long)chunk.readableBytes();
        if (!this.chunked && this.writtenBytes > this.contentLength) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding. Current written: " + this.written + " Current Content-Length: " + this.contentLength);
        }
        this.writeHead();
        ChannelBuffer msg = this.chunked ? new DefaultHttpChunk(chunk) : chunk;
        this.writeFuture = this.conn.write(msg);
        if (doneHandler != null) {
            this.conn.addFuture(doneHandler, this.writeFuture);
        }
        return this;
    }
}

