/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.HeaderUtils;
import org.nodex.java.core.http.HttpServerResponse;
import org.nodex.java.core.http.ServerConnection;
import org.nodex.java.core.streams.ReadStream;

public class HttpServerRequest
implements ReadStream {
    private Map<String, List<String>> params;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Exception> exceptionHandler;
    private final ServerConnection conn;
    private final HttpRequest request;
    private Map<String, String> headers;
    public final String method;
    public final String uri;
    public final String path;
    public final String query;
    public final HttpServerResponse response;

    HttpServerRequest(ServerConnection conn, HttpRequest request) {
        URI theURI;
        this.method = request.getMethod().toString();
        try {
            theURI = new URI(request.getUri());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri " + request.getUri());
        }
        this.uri = request.getUri();
        this.path = theURI.getPath();
        this.query = theURI.getQuery();
        this.conn = conn;
        this.request = request;
        this.response = new HttpServerResponse(HttpHeaders.isKeepAlive((HttpMessage)request), conn);
    }

    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    public Set<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = HeaderUtils.simplifyHeaders(this.request.getHeaders());
        }
        return this.headers;
    }

    public String getParam(String param) {
        List<String> list;
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri);
            this.params = queryStringDecoder.getParameters();
        }
        if ((list = this.params.get(param)) != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    @Override
    public void pause() {
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.conn.resume();
    }

    @Override
    public void endHandler(Handler<Void> handler) {
        this.endHandler = handler;
    }

    void handleData(Buffer data) {
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }
}

