/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.ChannelGroupFutureListener;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.nodex.java.core.Handler;
import org.nodex.java.core.http.HttpServerRequest;
import org.nodex.java.core.http.ServerConnection;
import org.nodex.java.core.http.Websocket;
import org.nodex.java.core.http.WebsocketHandshakeHelper;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.net.NetServerBase;

public class HttpServer
extends NetServerBase {
    private Handler<HttpServerRequest> requestHandler;
    private Handler<Websocket> wsHandler;
    private Map<Channel, ServerConnection> connectionMap = new ConcurrentHashMap<Channel, ServerConnection>();
    private ChannelGroup serverChannelGroup;
    private boolean listening;

    public HttpServer requestHandler(Handler<HttpServerRequest> requestHandler) {
        this.checkThread();
        this.requestHandler = requestHandler;
        return this;
    }

    public HttpServer websocketHandler(Handler<Websocket> wsHandler) {
        this.checkThread();
        this.wsHandler = wsHandler;
        return this;
    }

    public HttpServer listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    public HttpServer listen(int port, String host) {
        this.checkThread();
        if (this.requestHandler == null && this.wsHandler == null) {
            throw new IllegalStateException("Set request or websocket handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.serverChannelGroup = new DefaultChannelGroup("nodex-acceptor-channels");
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory(NodexInternal.instance.getAcceptorPool(), NodexInternal.instance.getWorkerPool());
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setOptions(this.connectionOptions);
        this.checkSSL();
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                if (HttpServer.this.ssl) {
                    SSLEngine engine = HttpServer.this.context.createSSLEngine();
                    engine.setUseClientMode(false);
                    switch (HttpServer.this.clientAuth) {
                        case REQUEST: {
                            engine.setWantClientAuth(true);
                            break;
                        }
                        case REQUIRED: {
                            engine.setNeedClientAuth(true);
                            break;
                        }
                        case NONE: {
                            engine.setNeedClientAuth(false);
                        }
                    }
                    pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("handler", (ChannelHandler)new ServerHandler());
                return pipeline;
            }
        });
        try {
            Channel serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(InetAddress.getByName(host), port));
            this.serverChannelGroup.add((Object)serverChannel);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public HttpServer setSSL(boolean ssl) {
        this.checkThread();
        return (HttpServer)super.setSSL(ssl);
    }

    @Override
    public HttpServer setKeyStorePath(String path) {
        this.checkThread();
        return (HttpServer)super.setKeyStorePath(path);
    }

    @Override
    public HttpServer setKeyStorePassword(String pwd) {
        this.checkThread();
        return (HttpServer)super.setKeyStorePassword(pwd);
    }

    @Override
    public HttpServer setTrustStorePath(String path) {
        this.checkThread();
        return (HttpServer)super.setTrustStorePath(path);
    }

    @Override
    public HttpServer setTrustStorePassword(String pwd) {
        this.checkThread();
        return (HttpServer)super.setTrustStorePassword(pwd);
    }

    @Override
    public HttpServer setClientAuthRequired(boolean required) {
        this.checkThread();
        return (HttpServer)super.setClientAuthRequired(required);
    }

    @Override
    public HttpServer setTcpNoDelay(boolean tcpNoDelay) {
        this.checkThread();
        return (HttpServer)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public HttpServer setSendBufferSize(int size) {
        this.checkThread();
        return (HttpServer)super.setSendBufferSize(size);
    }

    @Override
    public HttpServer setReceiveBufferSize(int size) {
        this.checkThread();
        return (HttpServer)super.setReceiveBufferSize(size);
    }

    @Override
    public HttpServer setTCPKeepAlive(boolean keepAlive) {
        this.checkThread();
        return (HttpServer)super.setTCPKeepAlive(keepAlive);
    }

    @Override
    public HttpServer setReuseAddress(boolean reuse) {
        this.checkThread();
        return (HttpServer)super.setReuseAddress(reuse);
    }

    @Override
    public HttpServer setSoLinger(boolean linger) {
        this.checkThread();
        return (HttpServer)super.setSoLinger(linger);
    }

    @Override
    public HttpServer setTrafficClass(int trafficClass) {
        this.checkThread();
        return (HttpServer)super.setTrafficClass(trafficClass);
    }

    public void close() {
        this.checkThread();
        this.close(null);
    }

    public void close(final Handler<Void> doneHandler) {
        this.checkThread();
        for (ServerConnection conn : this.connectionMap.values()) {
            conn.internalClose();
        }
        if (doneHandler != null) {
            this.serverChannelGroup.close().addListener(new ChannelGroupFutureListener(){

                public void operationComplete(ChannelGroupFuture channelGroupFuture) throws Exception {
                    NodexInternal.instance.executeOnContext(HttpServer.this.contextID, new Runnable(){

                        @Override
                        public void run() {
                            doneHandler.handle(null);
                        }
                    });
                }
            });
        }
    }

    public class ServerHandler
    extends SimpleChannelUpstreamHandler {
        private void calcAndWriteWSHandshakeResponse(Channel ch, HttpRequest request, long c) {
            String key1 = request.getHeader("Sec-WebSocket-Key1");
            String key2 = request.getHeader("Sec-WebSocket-Key2");
            ChannelBuffer output = WebsocketHandshakeHelper.calcResponse(key1, key2, c);
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
            res.setContent(output);
            res.addHeader("Content-Length", (Object)res.getContent().readableBytes());
            res.addHeader("Sec-WebSocket-Origin", (Object)request.getHeader("Origin"));
            res.addHeader("Sec-WebSocket-Location", (Object)this.getWebSocketLocation(request, request.getUri()));
            String protocol = request.getHeader("Sec-WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("Sec-WebSocket-Protocol", (Object)protocol);
            }
            res.addHeader("Upgrade", (Object)"WebSocket");
            res.addHeader("Connection", (Object)"Upgrade");
            ChannelPipeline p = ch.getPipeline();
            p.replace("decoder", "wsdecoder", (ChannelHandler)new WebSocketFrameDecoder());
            ch.write((Object)res);
            p.replace("encoder", "wsencoder", (ChannelHandler)new WebSocketFrameEncoder());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            Object msg = e.getMessage();
            ServerConnection conn = (ServerConnection)HttpServer.this.connectionMap.get(ch);
            if (conn != null) {
                if (msg instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)msg;
                    if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                        ch.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                    }
                    if ("Upgrade".equalsIgnoreCase(request.getHeader("Connection")) && "WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                        Websocket ws = new Websocket(request.getUri(), conn);
                        boolean containsKey1 = request.containsHeader("Sec-WebSocket-Key1");
                        boolean containsKey2 = request.containsHeader("Sec-WebSocket-Key2");
                        if (containsKey1 && containsKey2) {
                            long c = request.getContent().readLong();
                            this.calcAndWriteWSHandshakeResponse((Channel)ch, request, c);
                            conn.handleWebsocketConnect(ws);
                        } else {
                            ch.write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                        }
                    } else {
                        conn.handleMessage(msg);
                    }
                } else {
                    conn.handleMessage(msg);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)HttpServer.this.connectionMap.get(ch);
            ch.close();
            final Throwable t = e.getCause();
            if (conn != null && t instanceof Exception) {
                HttpServer.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleException((Exception)t);
                    }
                });
            } else {
                t.printStackTrace();
            }
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
            final NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final long contextID = NodexInternal.instance.associateContextWithWorker(ch.getWorker());
            HttpServer.this.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    ServerConnection conn = new ServerConnection((Channel)ch, contextID, Thread.currentThread());
                    conn.requestHandler(HttpServer.this.requestHandler);
                    conn.wsHandler(HttpServer.this.wsHandler);
                    HttpServer.this.connectionMap.put(ch, conn);
                }
            });
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)HttpServer.this.connectionMap.remove(ch);
            HttpServer.this.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    conn.handleClosed();
                    NodexInternal.instance.destroyContext(conn.getContextID());
                }
            });
        }

        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ServerConnection conn = (ServerConnection)HttpServer.this.connectionMap.get(ch);
            ChannelState state = e.getState();
            if (state == ChannelState.INTEREST_OPS) {
                HttpServer.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleInterestedOpsChanged();
                    }
                });
            }
        }

        private String getWebSocketLocation(HttpRequest req, String path) {
            return "ws://" + req.getHeader("Host") + path;
        }
    }
}

