/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.ClientConnection;
import org.nodex.java.core.http.HeaderUtils;
import org.nodex.java.core.streams.ReadStream;

public class HttpClientResponse
implements ReadStream {
    private final ClientConnection conn;
    private final Thread th;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Exception> exceptionHandler;
    private final HttpResponse response;
    private HttpChunkTrailer trailer;
    private Map<String, String> headers;
    private Map<String, String> trailers;
    public final int statusCode;
    public final String statusMessage;

    HttpClientResponse(ClientConnection conn, HttpResponse response, Thread th) {
        this.conn = conn;
        this.statusCode = response.getStatus().getCode();
        this.statusMessage = response.getStatus().getReasonPhrase();
        this.response = response;
        this.th = th;
    }

    public String getHeader(String key) {
        this.checkThread();
        return this.response.getHeader(key);
    }

    public Set<String> getHeaderNames() {
        this.checkThread();
        return this.response.getHeaderNames();
    }

    public String getTrailer(String key) {
        this.checkThread();
        return this.trailer.getHeader(key);
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = HeaderUtils.simplifyHeaders(this.response.getHeaders());
        }
        return this.headers;
    }

    public Map<String, String> getTrailers() {
        if (this.trailers == null) {
            this.trailers = this.trailer == null ? new HashMap<String, String>() : HeaderUtils.simplifyHeaders(this.trailer.getHeaders());
        }
        return this.trailers;
    }

    public Set<String> getTrailerNames() {
        this.checkThread();
        return this.trailer.getHeaderNames();
    }

    @Override
    public void dataHandler(Handler<Buffer> dataHandler) {
        this.checkThread();
        this.dataHandler = dataHandler;
    }

    @Override
    public void endHandler(Handler<Void> endHandler) {
        this.checkThread();
        this.endHandler = endHandler;
    }

    @Override
    public void exceptionHandler(Handler<Exception> exceptionHandler) {
        this.checkThread();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void pause() {
        this.checkThread();
        this.conn.pause();
    }

    @Override
    public void resume() {
        this.checkThread();
        this.conn.resume();
    }

    void handleChunk(Buffer data) {
        this.checkThread();
        if (this.dataHandler != null) {
            this.dataHandler.handle(data);
        }
    }

    void handleEnd(HttpChunkTrailer trailer) {
        this.checkThread();
        this.trailer = trailer;
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        this.checkThread();
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        }
    }

    private void checkThread() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread, actual: " + Thread.currentThread() + " expected: " + this.th);
        }
    }
}

