/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.util.LinkedList;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.ClientConnection;
import org.nodex.java.core.http.HttpClient;
import org.nodex.java.core.http.HttpClientResponse;
import org.nodex.java.core.streams.WriteStream;

public class HttpClientRequest
implements WriteStream {
    private final HttpClient client;
    private final HttpRequest request;
    private final Handler<HttpClientResponse> respHandler;
    private Handler<Void> continueHandler;
    private final long contextID;
    final Thread th;
    private boolean chunked;
    private ClientConnection conn;
    private Handler<Void> drainHandler;
    private Handler<Exception> exceptionHandler;
    private boolean headWritten;
    private boolean completed;
    private LinkedList<PendingChunk> pendingChunks;
    private int pendingMaxSize = -1;
    private boolean connecting;
    private boolean writeHead;
    private long written;
    private long contentLength = 0L;

    HttpClientRequest(HttpClient client, String method, String uri, Handler<HttpClientResponse> respHandler, long contextID, Thread th) {
        this.client = client;
        this.request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method), uri);
        this.chunked = false;
        this.respHandler = respHandler;
        this.contextID = contextID;
        this.th = th;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.check();
        if (this.written > 0L) {
            throw new IllegalStateException("Cannot set chunked after data has been written on request");
        }
        this.chunked = chunked;
        return this;
    }

    public HttpClientRequest putHeader(String key, Object value) {
        this.check();
        this.request.setHeader(key, value);
        this.checkContentLengthChunked(key, value);
        return this;
    }

    public HttpClientRequest putAllHeaders(Map<String, ? extends Object> m) {
        this.check();
        for (Map.Entry<String, ? extends Object> entry : m.entrySet()) {
            this.request.setHeader(entry.getKey(), (Object)entry.getValue().toString());
            this.checkContentLengthChunked(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public void writeBuffer(Buffer chunk) {
        this.check();
        this.write(chunk.getChannelBuffer(), null);
    }

    public HttpClientRequest write(Buffer chunk) {
        this.check();
        return this.write(chunk.getChannelBuffer(), null);
    }

    public HttpClientRequest write(String chunk) {
        this.check();
        return this.write(Buffer.create(chunk).getChannelBuffer(), null);
    }

    public HttpClientRequest write(String chunk, String enc) {
        this.check();
        return this.write(Buffer.create(chunk, enc).getChannelBuffer(), null);
    }

    public HttpClientRequest write(Buffer chunk, Handler<Void> doneHandler) {
        this.check();
        return this.write(chunk.getChannelBuffer(), doneHandler);
    }

    public HttpClientRequest write(String chunk, Handler<Void> doneHandler) {
        this.checkThread();
        this.checkComplete();
        return this.write(Buffer.create(chunk).getChannelBuffer(), doneHandler);
    }

    public HttpClientRequest write(String chunk, String enc, Handler<Void> doneHandler) {
        this.check();
        return this.write(Buffer.create(chunk, enc).getChannelBuffer(), doneHandler);
    }

    @Override
    public void setWriteQueueMaxSize(int maxSize) {
        this.check();
        if (this.conn != null) {
            this.conn.setWriteQueueMaxSize(maxSize);
        } else {
            this.pendingMaxSize = maxSize;
        }
    }

    @Override
    public boolean writeQueueFull() {
        this.check();
        if (this.conn != null) {
            return this.conn.writeQueueFull();
        }
        return false;
    }

    @Override
    public void drainHandler(Handler<Void> handler) {
        this.check();
        this.drainHandler = handler;
        if (this.conn != null) {
            this.conn.handleInterestedOpsChanged();
        }
    }

    @Override
    public void exceptionHandler(Handler<Exception> handler) {
        this.check();
        this.exceptionHandler = handler;
    }

    public void continueHandler(Handler<Void> handler) {
        this.check();
        this.continueHandler = handler;
    }

    public HttpClientRequest sendHead() {
        this.check();
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
                this.headWritten = true;
            }
        } else {
            this.connect();
            this.writeHead = true;
        }
        return this;
    }

    public void end() {
        this.check();
        this.completed = true;
        if (this.conn != null) {
            if (!this.headWritten) {
                this.writeHead();
            } else if (this.chunked) {
                this.writeEndChunk();
            }
            this.conn.endRequest();
        } else {
            this.connect();
        }
    }

    void handleInterestedOpsChanged() {
        this.checkThread();
        if (this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    void handleException(Exception e) {
        this.checkThread();
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
        } else {
            e.printStackTrace(System.err);
        }
    }

    void handleResponse(HttpClientResponse resp) {
        try {
            if (resp.statusCode == 100) {
                if (this.continueHandler != null) {
                    this.continueHandler.handle(null);
                }
            } else {
                this.respHandler.handle(resp);
            }
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                this.handleException((Exception)t);
            }
            t.printStackTrace(System.err);
        }
    }

    private void checkContentLengthChunked(String key, Object value) {
        if (key.equals("Content-Length")) {
            this.contentLength = Integer.parseInt(value.toString());
        } else if (key.equals("Transfer-Encoding") && value.equals("chunked")) {
            this.chunked = true;
        }
    }

    private void connect() {
        if (!this.connecting) {
            this.client.getConnection(new Handler<ClientConnection>(){

                @Override
                public void handle(ClientConnection conn) {
                    HttpClientRequest.this.connected(conn);
                }
            }, this.contextID);
            this.connecting = true;
        }
    }

    private void connected(ClientConnection conn) {
        this.checkThread();
        this.conn = conn;
        conn.setCurrentRequest(this);
        this.request.setHeader("Connection", (Object)(conn.keepAlive ? "keep-alive" : "close"));
        if (this.pendingMaxSize != -1) {
            conn.setWriteQueueMaxSize(this.pendingMaxSize);
        }
        if (this.pendingChunks != null || this.writeHead || this.completed) {
            this.writeHead();
            this.headWritten = true;
        }
        if (this.pendingChunks != null) {
            for (PendingChunk chunk : this.pendingChunks) {
                this.sendChunk(chunk.chunk, chunk.doneHandler);
            }
        }
        if (this.completed) {
            if (this.chunked) {
                this.writeEndChunk();
            }
            conn.endRequest();
        }
    }

    void sendDirect(ClientConnection conn, Buffer body) {
        this.conn = conn;
        this.contentLength = body.length();
        this.putHeader("Content-Length", String.valueOf(this.contentLength));
        this.write(body);
        this.writeEndChunk();
        this.completed = true;
    }

    private void writeHead() {
        this.request.setHeader("Host", (Object)this.conn.hostHeader);
        this.request.setChunked(this.chunked);
        if (this.chunked) {
            this.request.setHeader("Transfer-Encoding", (Object)"chunked");
        } else if (this.contentLength == 0L) {
            this.request.setHeader("Content-Length", (Object)"0");
        }
        this.conn.write(this.request);
    }

    private HttpClientRequest write(ChannelBuffer buff, Handler<Void> doneHandler) {
        this.written += (long)buff.readableBytes();
        if (!this.chunked && this.written > this.contentLength) {
            throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding. Current written: " + this.written + " Current Content-Length: " + this.contentLength);
        }
        if (this.conn == null) {
            this.connect();
            if (this.pendingChunks == null) {
                this.pendingChunks = new LinkedList();
            }
            this.pendingChunks.add(new PendingChunk(buff, doneHandler));
        } else {
            if (!this.headWritten) {
                this.writeHead();
                this.headWritten = true;
            }
            this.sendChunk(buff, doneHandler);
        }
        return this;
    }

    private void sendChunk(ChannelBuffer buff, Handler<Void> doneHandler) {
        ChannelBuffer write = this.chunked ? new DefaultHttpChunk(buff) : buff;
        ChannelFuture writeFuture = this.conn.write(write);
        if (doneHandler != null) {
            this.conn.addFuture(doneHandler, writeFuture);
        }
    }

    private void writeEndChunk() {
        this.conn.write(new DefaultHttpChunk(ChannelBuffers.EMPTY_BUFFER));
    }

    private void check() {
        this.checkThread();
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.completed) {
            throw new IllegalStateException("Request already complete");
        }
    }

    private void checkThread() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread, actual: " + Thread.currentThread() + " expected: " + this.th);
        }
    }

    private static class PendingChunk {
        final ChannelBuffer chunk;
        final Handler<Void> doneHandler;

        private PendingChunk(ChannelBuffer chunk, Handler<Void> doneHandler) {
            this.chunk = chunk;
            this.doneHandler = doneHandler;
        }
    }
}

