/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.ssl.SslHandler;
import org.nodex.java.core.ConnectionPool;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.SimpleHandler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.ClientConnection;
import org.nodex.java.core.http.HttpClientRequest;
import org.nodex.java.core.http.HttpClientResponse;
import org.nodex.java.core.http.Websocket;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.net.NetClientBase;

public class HttpClient
extends NetClientBase {
    private ClientBootstrap bootstrap;
    private NioClientSocketChannelFactory channelFactory;
    private Map<Channel, ClientConnection> connectionMap = new ConcurrentHashMap<Channel, ClientConnection>();
    private Handler<Exception> exceptionHandler;
    private int port = 80;
    private String host = "localhost";
    private final ConnectionPool<ClientConnection> pool = new ConnectionPool<ClientConnection>(){

        @Override
        protected void connect(Handler<ClientConnection> connectHandler, long contextID) {
            HttpClient.this.internalConnect(connectHandler, contextID);
        }
    };
    private boolean keepAlive = true;

    public void exceptionHandler(Handler<Exception> handler) {
        this.exceptionHandler = handler;
    }

    public HttpClient setMaxPoolSize(int maxConnections) {
        this.pool.setMaxPoolSize(maxConnections);
        return this;
    }

    public int getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    public HttpClient setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Override
    public HttpClient setSSL(boolean ssl) {
        return (HttpClient)super.setSSL(ssl);
    }

    @Override
    public HttpClient setKeyStorePath(String path) {
        return (HttpClient)super.setKeyStorePath(path);
    }

    @Override
    public HttpClient setKeyStorePassword(String pwd) {
        return (HttpClient)super.setKeyStorePassword(pwd);
    }

    @Override
    public HttpClient setTrustStorePath(String path) {
        return (HttpClient)super.setTrustStorePath(path);
    }

    @Override
    public HttpClient setTrustStorePassword(String pwd) {
        return (HttpClient)super.setTrustStorePassword(pwd);
    }

    @Override
    public HttpClient setTrustAll(boolean trustAll) {
        return (HttpClient)super.setTrustAll(trustAll);
    }

    public HttpClient setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpClient setHost(String host) {
        this.host = host;
        return this;
    }

    public void connectWebsocket(final String uri, final Handler<Websocket> wsConnect) {
        this.getConnection(new Handler<ClientConnection>(){

            @Override
            public void handle(ClientConnection conn) {
                conn.toWebSocket(uri, wsConnect);
            }
        }, Nodex.instance.getContextID());
    }

    public void getNow(String uri, Handler<HttpClientResponse> responseHandler) {
        this.getNow(uri, null, responseHandler);
    }

    public void getNow(String uri, Map<String, ? extends Object> headers, Handler<HttpClientResponse> responseHandler) {
        HttpClientRequest req = this.get(uri, responseHandler);
        if (headers != null) {
            req.putAllHeaders(headers);
        }
        req.end();
    }

    public HttpClientRequest options(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("OPTIONS", uri, responseHandler);
    }

    public HttpClientRequest get(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("GET", uri, responseHandler);
    }

    public HttpClientRequest head(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("HEAD", uri, responseHandler);
    }

    public HttpClientRequest post(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("POST", uri, responseHandler);
    }

    public HttpClientRequest put(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("PUT", uri, responseHandler);
    }

    public HttpClientRequest delete(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("DELETE", uri, responseHandler);
    }

    public HttpClientRequest trace(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("TRACE", uri, responseHandler);
    }

    public HttpClientRequest connect(String uri, Handler<HttpClientResponse> responseHandler) {
        return this.request("CONNECT", uri, responseHandler);
    }

    public HttpClientRequest request(String method, String uri, Handler<HttpClientResponse> responseHandler) {
        Long cid = Nodex.instance.getContextID();
        if (cid == null) {
            throw new IllegalStateException("Requests must be made from inside an event loop");
        }
        return new HttpClientRequest(this, method, uri, responseHandler, cid, Thread.currentThread());
    }

    public void close() {
        this.pool.close();
        for (ClientConnection conn : this.connectionMap.values()) {
            conn.internalClose();
        }
    }

    @Override
    public HttpClient setTcpNoDelay(boolean tcpNoDelay) {
        return (HttpClient)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public HttpClient setSendBufferSize(int size) {
        return (HttpClient)super.setSendBufferSize(size);
    }

    @Override
    public HttpClient setReceiveBufferSize(int size) {
        return (HttpClient)super.setReceiveBufferSize(size);
    }

    @Override
    public HttpClient setTCPKeepAlive(boolean keepAlive) {
        return (HttpClient)super.setTCPKeepAlive(keepAlive);
    }

    @Override
    public HttpClient setReuseAddress(boolean reuse) {
        return (HttpClient)super.setReuseAddress(reuse);
    }

    @Override
    public HttpClient setSoLinger(boolean linger) {
        return (HttpClient)super.setSoLinger(linger);
    }

    @Override
    public HttpClient setTrafficClass(int trafficClass) {
        return (HttpClient)super.setTrafficClass(trafficClass);
    }

    void getConnection(Handler<ClientConnection> handler, long contextID) {
        this.pool.getConnection(handler, contextID);
    }

    void returnConnection(ClientConnection conn) {
        if (!conn.keepAlive) {
            conn.internalClose();
        } else {
            this.pool.returnConnection(conn);
        }
    }

    private void internalConnect(final Handler<ClientConnection> connectHandler, final long contextID) {
        if (this.bootstrap == null) {
            this.channelFactory = new NioClientSocketChannelFactory(NodexInternal.instance.getAcceptorPool(), NodexInternal.instance.getWorkerPool());
            this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
            this.checkSSL();
            this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() throws Exception {
                    ChannelPipeline pipeline = Channels.pipeline();
                    if (HttpClient.this.ssl) {
                        SSLEngine engine = HttpClient.this.context.createSSLEngine();
                        engine.setUseClientMode(true);
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    pipeline.addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
                    pipeline.addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
                    pipeline.addLast("handler", (ChannelHandler)new ClientHandler());
                    return pipeline;
                }
            });
        }
        this.channelFactory.setWorker(NodexInternal.instance.getWorkerForContextID(contextID));
        this.bootstrap.setOptions(this.connectionOptions);
        ChannelFuture future = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.host, this.port));
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    final NioSocketChannel ch = (NioSocketChannel)channelFuture.getChannel();
                    HttpClient.this.runOnCorrectThread(ch, new Runnable(){

                        @Override
                        public void run() {
                            ClientConnection conn = new ClientConnection(HttpClient.this, (Channel)ch, HttpClient.this.host + ":" + HttpClient.this.port, HttpClient.this.ssl, HttpClient.this.keepAlive, contextID, Thread.currentThread());
                            conn.closedHandler(new SimpleHandler(){

                                @Override
                                public void handle() {
                                    HttpClient.this.pool.connectionClosed();
                                }
                            });
                            HttpClient.this.connectionMap.put(ch, conn);
                            NodexInternal.instance.setContextID(contextID);
                            connectHandler.handle(conn);
                        }
                    });
                } else {
                    Throwable t = channelFuture.getCause();
                    if (t instanceof Exception && HttpClient.this.exceptionHandler != null) {
                        HttpClient.this.exceptionHandler.handle((Exception)t);
                    } else {
                        t.printStackTrace(System.err);
                    }
                }
            }
        });
    }

    private class ClientHandler
    extends SimpleChannelUpstreamHandler {
        private ClientHandler() {
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)HttpClient.this.connectionMap.remove(ch);
            if (conn != null) {
                HttpClient.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleClosed();
                    }
                });
            }
        }

        public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)HttpClient.this.connectionMap.get(ch);
            HttpClient.this.runOnCorrectThread(ch, new Runnable(){

                @Override
                public void run() {
                    conn.handleInterestedOpsChanged();
                }
            });
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            NioSocketChannel ch = (NioSocketChannel)e.getChannel();
            final ClientConnection conn = (ClientConnection)HttpClient.this.connectionMap.get(ch);
            final Throwable t = e.getCause();
            if (conn != null && t instanceof Exception) {
                HttpClient.this.runOnCorrectThread(ch, new Runnable(){

                    @Override
                    public void run() {
                        conn.handleException((Exception)t);
                    }
                });
            } else {
                t.printStackTrace(System.err);
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel ch = e.getChannel();
            ClientConnection conn = (ClientConnection)HttpClient.this.connectionMap.get(ch);
            Object msg = e.getMessage();
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                conn.handleResponse(response);
                ChannelBuffer content = response.getContent();
                if (content.readable()) {
                    conn.handleResponseChunk(new Buffer(content));
                }
                if (!response.isChunked()) {
                    conn.handleResponseEnd();
                }
            } else if (msg instanceof HttpChunk) {
                HttpChunk chunk = (HttpChunk)msg;
                if (chunk.getContent().readable()) {
                    Buffer buff = new Buffer(chunk.getContent());
                    conn.handleResponseChunk(buff);
                }
                if (chunk.isLast()) {
                    if (chunk instanceof HttpChunkTrailer) {
                        HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                        conn.handleResponseEnd(trailer);
                    } else {
                        conn.handleResponseEnd();
                    }
                }
            } else if (msg instanceof WebSocketFrame) {
                WebSocketFrame frame = (WebSocketFrame)msg;
                conn.handleWsFrame(frame);
            } else {
                throw new IllegalStateException("Invalid object " + e.getMessage());
            }
        }
    }
}

