/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.http;

import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameEncoder;
import org.nodex.java.core.Handler;
import org.nodex.java.core.SimpleHandler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.http.AbstractConnection;
import org.nodex.java.core.http.HttpClient;
import org.nodex.java.core.http.HttpClientRequest;
import org.nodex.java.core.http.HttpClientResponse;
import org.nodex.java.core.http.Websocket;
import org.nodex.java.core.http.WebsocketHandshakeHelper;

class ClientConnection
extends AbstractConnection {
    final HttpClient client;
    final String hostHeader;
    final boolean keepAlive;
    private final boolean ssl;
    private volatile HttpClientRequest currentRequest;
    private final Queue<HttpClientRequest> requests = new ConcurrentLinkedQueue<HttpClientRequest>();
    private volatile HttpClientResponse currentResponse;
    private Websocket ws;

    ClientConnection(HttpClient client, Channel channel, String hostHeader, boolean ssl, boolean keepAlive, long contextID, Thread th) {
        super(channel, contextID, th);
        this.client = client;
        this.hostHeader = hostHeader;
        this.ssl = ssl;
        this.keepAlive = keepAlive;
    }

    void toWebSocket(final String uri, final Handler<Websocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        String key1 = WebsocketHandshakeHelper.genWSkey();
        String key2 = WebsocketHandshakeHelper.genWSkey();
        long c = new Random().nextLong();
        final Buffer out = new Buffer(WebsocketHandshakeHelper.calcResponse(key1, key2, c));
        ChannelBuffer buff = ChannelBuffers.buffer((int)8);
        buff.writeLong(c);
        HttpClientRequest req = new HttpClientRequest(this.client, "GET", uri, new Handler<HttpClientResponse>(){

            @Override
            public void handle(HttpClientResponse resp) {
                if (resp.statusCode != 101 || !resp.statusMessage.equals("Web Socket Protocol Handshake")) {
                    ClientConnection.this.handleException(new IllegalStateException("Invalid protocol handshake - invalid status: " + resp.statusCode + "msg:" + resp.statusMessage));
                } else if (!resp.getHeader("Connection").equals("Upgrade")) {
                    ClientConnection.this.handleException(new IllegalStateException("Invalid protocol handshake - no Connection header"));
                } else {
                    final Buffer buff = Buffer.create(0);
                    resp.dataHandler(new Handler<Buffer>(){

                        @Override
                        public void handle(Buffer data) {
                            buff.appendBuffer(data);
                        }
                    });
                    resp.endHandler(new SimpleHandler(){

                        @Override
                        public void handle() {
                            boolean matched = true;
                            if (buff.length() == out.length()) {
                                for (int i = 0; i < buff.length(); ++i) {
                                    if (out.getByte(i) == buff.getByte(i)) continue;
                                    matched = false;
                                    break;
                                }
                                if (matched) {
                                    ChannelPipeline p = ClientConnection.this.channel.getPipeline();
                                    p.replace("decoder", "wsdecoder", (ChannelHandler)new WebSocketFrameDecoder());
                                    p.replace("encoder", "wsencoder", (ChannelHandler)new WebSocketFrameEncoder());
                                    ClientConnection.this.ws = new Websocket(uri, ClientConnection.this);
                                    wsConnect.handle(ClientConnection.this.ws);
                                    return;
                                }
                            }
                            ClientConnection.this.handleException(new IllegalStateException("Invalid protocol handshake - wrong response"));
                        }
                    });
                }
            }
        }, this.contextID, Thread.currentThread());
        this.setCurrentRequest(req);
        req.setChunked(false);
        req.putHeader("Upgrade", "WebSocket").putHeader("Connection", "Upgrade").putHeader("Origin", (this.ssl ? "http://" : "https://") + this.hostHeader).putHeader("Sec-WebSocket-Key1", key1).putHeader("Sec-WebSocket-Key2", key2);
        req.sendDirect(this, new Buffer(buff));
    }

    @Override
    public void close() {
        this.client.returnConnection(this);
    }

    void internalClose() {
        this.channel.close();
    }

    void handleInterestedOpsChanged() {
        try {
            if (this.currentRequest != null && (this.channel.getInterestOps() & 4) == 4) {
                this.setContextID();
                this.currentRequest.handleInterestedOpsChanged();
            }
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponse(HttpResponse resp) {
        HttpClientResponse nResp;
        HttpClientRequest req = resp.getStatus().getCode() == 100 ? this.requests.peek() : this.requests.poll();
        if (req == null) {
            throw new IllegalStateException("No response handler");
        }
        this.setContextID();
        this.currentResponse = nResp = new HttpClientResponse(this, resp, req.th);
        req.handleResponse(nResp);
    }

    void handleResponseChunk(Buffer buff) {
        this.setContextID();
        try {
            this.currentResponse.handleChunk(buff);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
    }

    void handleResponseEnd() {
        this.handleResponseEnd(null);
    }

    void handleResponseEnd(HttpChunkTrailer trailer) {
        try {
            this.currentResponse.handleEnd(trailer);
        }
        catch (Throwable t) {
            this.handleHandlerException(t);
        }
        if (!this.keepAlive) {
            this.close();
        }
    }

    void handleWsFrame(WebSocketFrame frame) {
        if (this.ws != null) {
            this.ws.handleFrame(frame);
        }
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
    }

    @Override
    protected long getContextID() {
        return super.getContextID();
    }

    @Override
    protected void handleException(Exception e) {
        super.handleException(e);
        if (this.currentRequest != null) {
            this.currentRequest.handleException(e);
        }
        if (this.currentResponse != null) {
            this.currentResponse.handleException(e);
        }
    }

    @Override
    protected void addFuture(Handler<Void> doneHandler, ChannelFuture future) {
        super.addFuture(doneHandler, future);
    }

    @Override
    ChannelFuture write(Object obj) {
        return this.channel.write(obj);
    }

    void setCurrentRequest(HttpClientRequest req) {
        if (this.currentRequest != null) {
            throw new IllegalStateException("Connection is already writing a request");
        }
        this.currentRequest = req;
        this.requests.add(req);
    }

    void endRequest() {
        if (this.currentRequest == null) {
            throw new IllegalStateException("No write in progress");
        }
        this.currentRequest = null;
        if (this.keepAlive) {
            this.close();
        }
    }
}

