/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.nodex.java.core.BlockingAction;
import org.nodex.java.core.Deferred;
import org.nodex.java.core.Future;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.file.AsyncFile;
import org.nodex.java.core.file.FileProps;
import org.nodex.java.core.file.FileSystemException;
import org.nodex.java.core.file.FileSystemProps;

public class FileSystem {
    public static FileSystem instance = new FileSystem();

    private FileSystem() {
    }

    public Deferred<Void> copyDeferred(String from, String to) {
        return this.copyDeferred(from, to, false);
    }

    public Future<Void> copy(String from, String to) {
        return this.copyDeferred(from, to).execute();
    }

    public Deferred<Void> copyDeferred(String from, String to, final boolean recursive) {
        final Path source = Paths.get(from, new String[0]);
        final Path target = Paths.get(to, new String[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    if (recursive) {
                        Files.walkFileTree(source, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                block2: {
                                    Path targetDir = target.resolve(source.relativize(dir));
                                    try {
                                        Files.copy(dir, targetDir, new CopyOption[0]);
                                    }
                                    catch (FileAlreadyExistsException e) {
                                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                                        throw e;
                                    }
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.copy(file, target.resolve(source.relativize(file)), new CopyOption[0]);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.copy(source, target, new CopyOption[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("File already exists " + e.getMessage());
                }
                return null;
            }
        };
    }

    public Future<Void> copy(String from, String to, boolean recursive) {
        return this.copyDeferred(from, to, recursive).execute();
    }

    public Deferred<Void> moveDeferred(String from, String to) {
        final Path source = Paths.get(from, new String[0]);
        final Path target = Paths.get(to, new String[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    Files.move(source, target, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Failed to move between " + source + " and " + target + ". Target already exists");
                }
                catch (AtomicMoveNotSupportedException e) {
                    throw new FileSystemException("Atomic move not supported between " + source + " and " + target);
                }
                return null;
            }
        };
    }

    public Future<Void> move(String from, String to) {
        return this.moveDeferred(from, to).execute();
    }

    public Deferred<Void> truncateDeferred(final String path, final long len) {
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                if (len < 0L) {
                    throw new FileSystemException("Cannot truncate file to size < 0");
                }
                if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                    throw new FileSystemException("Cannot truncate file " + path + ". Does not exist");
                }
                try (RandomAccessFile raf = null;){
                    raf = new RandomAccessFile(path, "rw");
                    raf.getChannel().truncate(len);
                }
                return null;
            }
        };
    }

    public Future<Void> truncate(String path, long len) {
        return this.truncateDeferred(path, len).execute();
    }

    public Deferred<Void> chmodDeferred(String path, String perms) {
        return this.chmodDeferred(path, perms, null);
    }

    public Future<Void> chmod(String path, String perms) {
        return this.chmodDeferred(path, perms).execute();
    }

    public Deferred<Void> chmodDeferred(String path, String perms, String dirPerms) {
        final Path target = Paths.get(path, new String[0]);
        final Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(perms);
        final Set<PosixFilePermission> dirPermissions = dirPerms == null ? null : PosixFilePermissions.fromString(dirPerms);
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    if (dirPermissions != null) {
                        Files.walkFileTree(target, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(dir, dirPermissions);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.setPosixFilePermissions(file, permissions);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.setPosixFilePermissions(target, permissions);
                    }
                }
                catch (SecurityException e) {
                    throw new FileSystemException("Accessed denied for chmod on " + target);
                }
                return null;
            }
        };
    }

    public Future<Void> chmod(String path, String perms, String dirPerms) {
        return this.chmodDeferred(path, perms, dirPerms).execute();
    }

    public Deferred<FileProps> propsDeferred(String path) {
        return this.props(path, true);
    }

    public Future<FileProps> props(String path) {
        return this.propsDeferred(path).execute();
    }

    public Deferred<FileProps> lpropsDeferred(String path) {
        return this.props(path, false);
    }

    public Future<FileProps> lprops(String path) {
        return this.lpropsDeferred(path).execute();
    }

    private Deferred<FileProps> props(String path, final boolean followLinks) {
        final Path target = Paths.get(path, new String[0]);
        return new BlockingAction<FileProps>(){

            @Override
            public FileProps action() throws Exception {
                try {
                    BasicFileAttributes attrs = followLinks ? Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]) : Files.readAttributes(target, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    return new FileProps(attrs);
                }
                catch (NoSuchFileException e) {
                    throw new FileSystemException("No such file: " + target);
                }
            }
        };
    }

    public Deferred<Void> linkDeferred(String link, String existing) {
        return this.link(link, existing, false);
    }

    public Future<Void> link(String link, String existing) {
        return this.linkDeferred(link, existing).execute();
    }

    public Deferred<Void> symlinkDeferred(String link, String existing) {
        return this.link(link, existing, true);
    }

    public Future<Void> symlink(String link, String existing) {
        return this.symlinkDeferred(link, existing).execute();
    }

    private Deferred<Void> link(String link, String existing, final boolean symbolic) {
        final Path source = Paths.get(link, new String[0]);
        final Path target = Paths.get(existing, new String[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    if (symbolic) {
                        Files.createSymbolicLink(source, target, new FileAttribute[0]);
                    } else {
                        Files.createLink(source, target);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create link, file already exists: " + source);
                }
                return null;
            }
        };
    }

    public Deferred<Void> unlinkDeferred(String link) {
        return this.deleteDeferred(link);
    }

    public Future<Void> unlink(String link) {
        return this.unlinkDeferred(link).execute();
    }

    public Deferred<String> readSymlinkDeferred(String link) {
        final Path source = Paths.get(link, new String[0]);
        return new BlockingAction<String>(){

            @Override
            public String action() throws Exception {
                try {
                    return Files.readSymbolicLink(source).toString();
                }
                catch (NotLinkException e) {
                    throw new FileSystemException("Cannot read " + source + " it's not a symbolic link");
                }
            }
        };
    }

    public Future<String> readSymlink(String link) {
        return this.readSymlinkDeferred(link).execute();
    }

    public Deferred<Void> deleteDeferred(String path) {
        return this.deleteDeferred(path, false);
    }

    public Future<Void> delete(String path) {
        return this.deleteDeferred(path).execute();
    }

    public Deferred<Void> deleteDeferred(String path, final boolean recursive) {
        final Path source = Paths.get(path, new String[0]);
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                if (recursive) {
                    Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                            if (e == null) {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                            throw e;
                        }
                    });
                } else {
                    try {
                        Files.delete(source);
                    }
                    catch (NoSuchFileException e) {
                        throw new FileSystemException("Cannot delete file, it does not exist: " + source);
                    }
                    catch (DirectoryNotEmptyException e) {
                        throw new FileSystemException("Cannot delete directory, it is not empty: " + source + ". Use recursive delete");
                    }
                }
                return null;
            }
        };
    }

    public Future<Void> delete(String path, boolean recursive) {
        return this.deleteDeferred(path, recursive).execute();
    }

    public Deferred<Void> mkdirDeferred(String path) {
        return this.mkdirDeferred(path, null, false);
    }

    public Future<Void> mkdir(String path) {
        return this.mkdirDeferred(path).execute();
    }

    public Deferred<Void> mkdirDeferred(String path, boolean createParents) {
        return this.mkdirDeferred(path, null, createParents);
    }

    public Future<Void> mkdir(String path, boolean createParents) {
        return this.mkdirDeferred(path, createParents).execute();
    }

    public Deferred<Void> mkdirDeferred(String path, String perms) {
        return this.mkdirDeferred(path, perms, false);
    }

    public Future<Void> mkdir(String path, String perms) {
        return this.mkdirDeferred(path, perms).execute();
    }

    public Deferred<Void> mkdirDeferred(String path, String perms, final boolean createParents) {
        final Path source = Paths.get(path, new String[0]);
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    if (createParents) {
                        if (attrs != null) {
                            Files.createDirectories(source, attrs);
                        } else {
                            Files.createDirectories(source, new FileAttribute[0]);
                        }
                    } else if (attrs != null) {
                        Files.createDirectory(source, attrs);
                    } else {
                        Files.createDirectory(source, new FileAttribute[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create directory: " + source + ". It already exists");
                }
                catch (NoSuchFileException e) {
                    throw new FileSystemException("Canot create directory: " + source + " it has parents");
                }
                return null;
            }
        };
    }

    public Future<Void> mkdir(String path, String perms, boolean createParents) {
        return this.mkdirDeferred(path, perms, createParents).execute();
    }

    public Deferred<String[]> readDirDeferred(String path) {
        return this.readDirDeferred(path, null);
    }

    public Future<String[]> readDir(String path) {
        return this.readDirDeferred(path).execute();
    }

    public Deferred<String[]> readDirDeferred(final String path, final String filter) {
        return new BlockingAction<String[]>(){

            @Override
            public String[] action() throws Exception {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileSystemException("Cannot read directory " + path + ". Does not exist");
                }
                if (!file.isDirectory()) {
                    throw new FileSystemException("Cannot read directory " + path + ". It's not a directory");
                }
                FilenameFilter fnFilter = filter != null ? new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return Pattern.matches(filter, name);
                    }
                } : null;
                File[] files = fnFilter == null ? file.listFiles() : file.listFiles(fnFilter);
                String[] ret = new String[files.length];
                int i = 0;
                for (File f : files) {
                    ret[i++] = f.getCanonicalPath();
                }
                return ret;
            }
        };
    }

    public Future<String[]> readDir(String path, String filter) {
        return this.readDirDeferred(path, filter).execute();
    }

    public Deferred<Buffer> readFileDeferred(final String path) {
        return new BlockingAction<Buffer>(){

            @Override
            public Buffer action() throws Exception {
                Path target = Paths.get(path, new String[0]);
                byte[] bytes = Files.readAllBytes(target);
                Buffer buff = Buffer.create(bytes);
                return buff;
            }
        };
    }

    public Future<Buffer> readFile(String path) {
        return this.readFileDeferred(path).execute();
    }

    public Deferred<Void> writeFileDeferred(final String path, final Buffer data) {
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                Path target = Paths.get(path, new String[0]);
                Files.write(target, data.getBytes(), new OpenOption[0]);
                return null;
            }
        };
    }

    public Future<Void> writeFile(String path, Buffer data) {
        return this.writeFileDeferred(path, data).execute();
    }

    public void lock() {
    }

    public void unlock() {
    }

    public void watchFile() {
    }

    public void unwatchFile() {
    }

    public Deferred<AsyncFile> openDeferred(String path) {
        return this.openDeferred(path, null, true, true, true, false);
    }

    public Future<AsyncFile> open(String path) {
        return this.openDeferred(path).execute();
    }

    public Deferred<AsyncFile> openDeferred(String path, String perms) {
        return this.openDeferred(path, perms, true, true, true, false);
    }

    public Future<AsyncFile> open(String path, String perms) {
        return this.openDeferred(path, perms).execute();
    }

    public Deferred<AsyncFile> openDeferred(String path, String perms, boolean createNew) {
        return this.openDeferred(path, perms, true, true, createNew, false);
    }

    public Future<AsyncFile> open(String path, String perms, boolean createNew) {
        return this.openDeferred(path, perms, createNew).execute();
    }

    public Deferred<AsyncFile> openDeferred(String path, String perms, boolean read, boolean write, boolean createNew) {
        return this.openDeferred(path, perms, read, write, createNew, false);
    }

    public Future<AsyncFile> open(String path, String perms, boolean read, boolean write, boolean createNew) {
        return this.openDeferred(path, perms, read, write, createNew).execute();
    }

    public Deferred<AsyncFile> openDeferred(final String path, final String perms, final boolean read, final boolean write, final boolean createNew, final boolean flush) {
        final long contextID = Nodex.instance.getContextID();
        final Thread th = Thread.currentThread();
        return new BlockingAction<AsyncFile>(){

            @Override
            public AsyncFile action() throws Exception {
                return FileSystem.this.doOpen(path, perms, read, write, createNew, flush, contextID, th);
            }
        };
    }

    public Future<AsyncFile> open(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush) {
        return this.openDeferred(path, perms, read, write, createNew, flush).execute();
    }

    private AsyncFile doOpen(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, long contextID, Thread th) throws Exception {
        return new AsyncFile(path, perms, read, write, createNew, flush, contextID, th);
    }

    public Deferred<Void> createFileDeferred(String path) {
        return this.createFileDeferred(path, null);
    }

    public Future<Void> createFile(String path) {
        return this.createFileDeferred(path).execute();
    }

    public Deferred<Void> createFileDeferred(final String path, String perms) {
        final FileAttribute<Set<PosixFilePermission>> attrs = perms == null ? null : PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                try {
                    Path target = Paths.get(path, new String[0]);
                    if (attrs != null) {
                        Files.createFile(target, attrs);
                    } else {
                        Files.createFile(target, new FileAttribute[0]);
                    }
                }
                catch (FileAlreadyExistsException e) {
                    throw new FileSystemException("Cannot create link, file already exists: " + path);
                }
                return null;
            }
        };
    }

    public Future<Void> createFile(String path, String perms) {
        return this.createFileDeferred(path, perms).execute();
    }

    public Deferred<Boolean> existsDeferred(final String path) {
        return new BlockingAction<Boolean>(){

            @Override
            public Boolean action() throws Exception {
                File file = new File(path);
                return file.exists();
            }
        };
    }

    public Future<Boolean> exists(String path) {
        return this.existsDeferred(path).execute();
    }

    public Deferred<FileSystemProps> getFSPropsDeferred(final String path) {
        return new BlockingAction<FileSystemProps>(){

            @Override
            public FileSystemProps action() throws Exception {
                Path target = Paths.get(path, new String[0]);
                FileStore fs = Files.getFileStore(target);
                return new FileSystemProps(fs.getTotalSpace(), fs.getUnallocatedSpace(), fs.getUsableSpace());
            }
        };
    }

    public Future<FileSystemProps> getFSProps(String path) {
        return this.getFSPropsDeferred(path).execute();
    }
}

