/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;
import org.nodex.java.core.BlockingAction;
import org.nodex.java.core.CompletionHandler;
import org.nodex.java.core.Deferred;
import org.nodex.java.core.DeferredAction;
import org.nodex.java.core.Future;
import org.nodex.java.core.Handler;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.file.FileSystemException;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.streams.ReadStream;
import org.nodex.java.core.streams.WriteStream;

public class AsyncFile {
    public static final int BUFFER_SIZE = 8192;
    private final AsynchronousFileChannel ch;
    private final Thread th;
    private final long contextID;
    private boolean closed;
    private ReadStream readStream;
    private WriteStream writeStream;
    private Deferred<Void> closedDeferred;
    private long writesOutstanding;

    AsyncFile(String path, String perms, boolean read, boolean write, boolean createNew, boolean flush, long contextID, Thread th) throws Exception {
        if (!read && !write) {
            throw new FileSystemException("Cannot open file for neither reading nor writing");
        }
        Path file = Paths.get(path, new String[0]);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        if (read) {
            options.add(StandardOpenOption.READ);
        }
        if (write) {
            options.add(StandardOpenOption.WRITE);
        }
        if (createNew) {
            options.add(StandardOpenOption.CREATE);
        }
        if (flush) {
            options.add(StandardOpenOption.DSYNC);
        }
        if (perms != null) {
            FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString(perms));
            this.ch = AsynchronousFileChannel.open(file, options, NodexInternal.instance.getBackgroundPool(), attrs);
        } else {
            this.ch = AsynchronousFileChannel.open(file, options, NodexInternal.instance.getBackgroundPool(), new FileAttribute[0]);
        }
        this.contextID = contextID;
        this.th = th;
    }

    public Deferred<Void> closeDeferred() {
        this.check();
        this.closed = true;
        DeferredAction<Void> deferred = new DeferredAction<Void>(){

            @Override
            public Deferred<Void> execute() {
                if (!this.complete) {
                    if (AsyncFile.this.writesOutstanding == 0L) {
                        this.run();
                        this.complete = true;
                    } else {
                        AsyncFile.this.closedDeferred = this;
                    }
                }
                return this;
            }

            @Override
            public void run() {
                try {
                    AsyncFile.this.ch.close();
                    this.setResult(null);
                }
                catch (IOException e) {
                    this.setException(e);
                }
            }
        };
        return deferred;
    }

    public Future<Void> close() {
        return this.closeDeferred().execute();
    }

    public Deferred<Void> writeDeferred(Buffer buffer, int position) {
        this.check();
        ByteBuffer bb = buffer.getChannelBuffer().toByteBuffer();
        return this.doWrite(bb, position);
    }

    public Future<Void> write(Buffer buffer, int position) {
        return this.writeDeferred(buffer, position).execute();
    }

    public Deferred<Buffer> readDeferred(Buffer buffer, int offset, int position, int length) {
        this.check();
        ByteBuffer bb = ByteBuffer.allocate(length);
        return this.doRead(buffer, offset, bb, position);
    }

    public Future<Buffer> read(Buffer buffer, int offset, int position, int length) {
        return this.readDeferred(buffer, offset, position, length).execute();
    }

    public WriteStream getWriteStream() {
        this.check();
        if (this.writeStream == null) {
            this.writeStream = new WriteStream(){
                Handler<Exception> exceptionHandler;
                Handler<Void> drainHandler;
                int pos;
                int maxWrites = 131072;
                int lwm = this.maxWrites / 2;

                @Override
                public void writeBuffer(Buffer buffer) {
                    AsyncFile.this.check();
                    int length = buffer.length();
                    ByteBuffer bb = buffer.getChannelBuffer().toByteBuffer();
                    Deferred deferred = AsyncFile.this.doWrite(bb, this.pos);
                    deferred.execute();
                    deferred.handler(new CompletionHandler<Void>(){

                        @Override
                        public void handle(Future<Void> deferred) {
                            if (deferred.succeeded()) {
                                AsyncFile.this.checkContext();
                                this.checkDrained();
                                if (AsyncFile.this.writesOutstanding == 0L && AsyncFile.this.closedDeferred != null) {
                                    AsyncFile.this.closedDeferred.execute();
                                }
                            } else {
                                this.handleException(deferred.exception());
                            }
                        }
                    });
                    this.pos += length;
                }

                private void checkDrained() {
                    if (this.drainHandler != null && AsyncFile.this.writesOutstanding <= (long)this.lwm) {
                        Handler<Void> handler = this.drainHandler;
                        this.drainHandler = null;
                        handler.handle(null);
                    }
                }

                @Override
                public void setWriteQueueMaxSize(int maxSize) {
                    AsyncFile.this.check();
                    this.maxWrites = maxSize;
                    this.lwm = this.maxWrites / 2;
                }

                @Override
                public boolean writeQueueFull() {
                    AsyncFile.this.check();
                    return AsyncFile.this.writesOutstanding >= (long)this.maxWrites;
                }

                @Override
                public void drainHandler(Handler<Void> handler) {
                    AsyncFile.this.check();
                    this.drainHandler = handler;
                    this.checkDrained();
                }

                @Override
                public void exceptionHandler(Handler<Exception> handler) {
                    AsyncFile.this.check();
                    this.exceptionHandler = handler;
                }

                void handleException(Exception e) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle(e);
                    } else {
                        e.printStackTrace(System.err);
                    }
                }
            };
        }
        return this.writeStream;
    }

    public ReadStream getReadStream() {
        this.check();
        if (this.readStream == null) {
            this.readStream = new ReadStream(){
                boolean paused;
                Handler<Buffer> dataHandler;
                Handler<Exception> exceptionHandler;
                Handler<Void> endHandler;
                int pos;
                boolean readInProgress;

                void doRead() {
                    if (!this.readInProgress) {
                        this.readInProgress = true;
                        Buffer buff = Buffer.create(8192);
                        Future<Buffer> deferred = AsyncFile.this.read(buff, 0, this.pos, 8192);
                        deferred.handler(new CompletionHandler<Buffer>(){

                            @Override
                            public void handle(Future<Buffer> deferred) {
                                if (deferred.succeeded()) {
                                    readInProgress = false;
                                    Buffer buffer = deferred.result();
                                    if (buffer.length() == 0) {
                                        this.handleEnd();
                                    } else {
                                        pos += buffer.length();
                                        this.handleData(buffer);
                                        if (!paused && dataHandler != null) {
                                            this.doRead();
                                        }
                                    }
                                } else {
                                    this.handleException(deferred.exception());
                                }
                            }
                        });
                    }
                }

                @Override
                public void dataHandler(Handler<Buffer> handler) {
                    AsyncFile.this.check();
                    this.dataHandler = handler;
                    if (this.dataHandler != null && !this.paused && !AsyncFile.this.closed) {
                        this.doRead();
                    }
                }

                @Override
                public void exceptionHandler(Handler<Exception> handler) {
                    AsyncFile.this.check();
                    this.exceptionHandler = handler;
                }

                @Override
                public void endHandler(Handler<Void> handler) {
                    AsyncFile.this.check();
                    this.endHandler = handler;
                }

                @Override
                public void pause() {
                    AsyncFile.this.check();
                    this.paused = true;
                }

                @Override
                public void resume() {
                    AsyncFile.this.check();
                    if (this.paused && !AsyncFile.this.closed) {
                        this.paused = false;
                        if (this.dataHandler != null) {
                            this.doRead();
                        }
                    }
                }

                void handleException(Exception e) {
                    if (this.exceptionHandler != null) {
                        AsyncFile.this.checkContext();
                        this.exceptionHandler.handle(e);
                    } else {
                        e.printStackTrace(System.err);
                    }
                }

                void handleData(Buffer buffer) {
                    if (this.dataHandler != null) {
                        AsyncFile.this.checkContext();
                        this.dataHandler.handle(buffer);
                    }
                }

                void handleEnd() {
                    if (this.endHandler != null) {
                        AsyncFile.this.checkContext();
                        this.endHandler.handle(null);
                    }
                }
            };
        }
        return this.readStream;
    }

    public Deferred<Void> flushDeferred() {
        this.checkClosed();
        this.checkContext();
        return new BlockingAction<Void>(){

            @Override
            public Void action() throws Exception {
                AsyncFile.this.ch.force(false);
                return null;
            }
        };
    }

    public Future<Void> flush() {
        return this.flushDeferred().execute();
    }

    private Deferred<Void> doWrite(final ByteBuffer buff, final int position) {
        this.writesOutstanding += (long)buff.limit();
        DeferredAction<Void> sd = new DeferredAction<Void>(){

            @Override
            public void run() {
                AsyncFile.this.doWrite(buff, position, this);
            }
        };
        return sd;
    }

    private void doWrite(final ByteBuffer buff, final int position, final DeferredAction<Void> deferred) {
        this.ch.write(buff, position, null, new java.nio.channels.CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer bytesWritten, Object attachment) {
                int pos = position;
                if (buff.hasRemaining()) {
                    AsyncFile.this.doWrite(buff, pos += bytesWritten.intValue(), deferred);
                } else {
                    NodexInternal.instance.executeOnContext(AsyncFile.this.contextID, new Runnable(){

                        @Override
                        public void run() {
                            AsyncFile.this.writesOutstanding -= buff.limit();
                            deferred.setResult(null);
                        }
                    });
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    final Exception e = (Exception)exc;
                    NodexInternal.instance.executeOnContext(AsyncFile.this.contextID, new Runnable(){

                        @Override
                        public void run() {
                            deferred.setException(e);
                        }
                    });
                } else {
                    exc.printStackTrace(System.err);
                }
            }
        });
    }

    private Deferred<Buffer> doRead(final Buffer writeBuff, final int offset, final ByteBuffer buff, final int position) {
        DeferredAction<Buffer> sd = new DeferredAction<Buffer>(){

            @Override
            public void run() {
                AsyncFile.this.doRead(writeBuff, offset, buff, position, this);
            }
        };
        return sd;
    }

    private void doRead(final Buffer writeBuff, final int offset, final ByteBuffer buff, final int position, final DeferredAction<Buffer> deferred) {
        this.ch.read(buff, position, null, new java.nio.channels.CompletionHandler<Integer, Object>(){
            int pos;
            {
                this.pos = position;
            }

            private void done() {
                NodexInternal.instance.executeOnContext(AsyncFile.this.contextID, new Runnable(){

                    @Override
                    public void run() {
                        AsyncFile.this.setContextID();
                        buff.flip();
                        writeBuff.setBytes(offset, buff);
                        deferred.setResult(writeBuff);
                    }
                });
            }

            @Override
            public void completed(Integer bytesRead, Object attachment) {
                if (bytesRead == -1) {
                    this.done();
                } else if (buff.hasRemaining()) {
                    this.pos += bytesRead.intValue();
                    AsyncFile.this.doRead(writeBuff, offset, buff, this.pos, deferred);
                } else {
                    this.done();
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                if (exc instanceof Exception) {
                    final Exception e = (Exception)exc;
                    NodexInternal.instance.executeOnContext(AsyncFile.this.contextID, new Runnable(){

                        @Override
                        public void run() {
                            AsyncFile.this.setContextID();
                            deferred.setException(e);
                        }
                    });
                } else {
                    exc.printStackTrace(System.err);
                }
            }
        });
    }

    private void check() {
        this.checkClosed();
        this.checkContext();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("File handle is closed");
        }
    }

    private void setContextID() {
        if (Thread.currentThread() != this.th) {
            throw new IllegalStateException("Invoked with wrong thread");
        }
        NodexInternal.instance.setContextID(this.contextID);
    }

    private void checkContext() {
        if (!Nodex.instance.getContextID().equals(this.contextID)) {
            throw new IllegalStateException("AsyncFile must only be used in the context that created it");
        }
    }
}

