/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.composition;

import java.util.ArrayList;
import java.util.List;
import org.nodex.java.core.CompletionHandler;
import org.nodex.java.core.Deferred;
import org.nodex.java.core.DeferredAction;
import org.nodex.java.core.Future;

public class Composer {
    private List<WaitingBatch> batches = new ArrayList<WaitingBatch>();
    private WaitingBatch currentBatch;
    private boolean executed;

    public <T> Future<T> parallel(Deferred<T> deferred) {
        this.checkExecuted();
        final DeferredAction ret = new DeferredAction<T>(){

            @Override
            public void run() {
            }
        };
        if (!deferred.complete()) {
            if (this.currentBatch == null) {
                this.currentBatch = new WaitingBatch();
                this.batches.add(this.currentBatch);
            }
            this.currentBatch.addFuture(deferred);
            final WaitingBatch batch = this.currentBatch;
            deferred.handler(new CompletionHandler<T>(){

                @Override
                public void handle(Future<T> f) {
                    if (f.succeeded()) {
                        ret.setResult(f.result());
                    } else {
                        ret.setException(f.exception());
                    }
                    batch.complete();
                }
            });
            this.checkAll();
        }
        return ret;
    }

    public <T> Future<T> series(Deferred<T> deferred) {
        this.checkExecuted();
        this.currentBatch = null;
        return this.parallel(deferred);
    }

    public void execute() {
        if (!this.executed) {
            this.executed = true;
            if (!this.batches.isEmpty()) {
                WaitingBatch batch = this.batches.get(0);
                batch.execute();
            }
        }
    }

    private void checkExecuted() {
        if (this.executed) {
            throw new IllegalStateException("Composer has already been executed");
        }
    }

    private void checkAll() {
        if (this.executed) {
            boolean executeNext = false;
            for (WaitingBatch batch : this.batches) {
                if (executeNext) {
                    batch.execute();
                    executeNext = false;
                }
                if (batch.pending != 0) break;
                executeNext = true;
            }
        }
    }

    private class WaitingBatch {
        List<Deferred<?>> futures = new ArrayList();
        int pending;
        boolean batchExecuted;

        private WaitingBatch() {
        }

        void addFuture(Deferred<?> future) {
            if (!future.complete()) {
                ++this.pending;
            }
            this.futures.add(future);
        }

        void complete() {
            --this.pending;
            if (this.pending == 0) {
                Composer.this.checkAll();
            }
        }

        void execute() {
            if (!this.batchExecuted) {
                this.batchExecuted = true;
                for (Deferred<?> future : this.futures) {
                    future.execute();
                }
            }
        }
    }
}

