/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core.buffer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.DynamicChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public class Buffer {
    private DynamicChannelBuffer buffer;

    public static Buffer create(int initialSizeHint) {
        return new Buffer(ChannelBuffers.dynamicBuffer((int)initialSizeHint));
    }

    public static Buffer create(byte[] bytes) {
        return new Buffer(ChannelBuffers.wrappedBuffer((byte[])bytes));
    }

    public static Buffer create(String str, String enc) {
        return new Buffer(ChannelBuffers.copiedBuffer((CharSequence)str, (Charset)Charset.forName(enc)));
    }

    public static Buffer create(String str) {
        return Buffer.create(str, "UTF-8");
    }

    public Buffer(ChannelBuffer buffer) {
        if (buffer instanceof DynamicChannelBuffer) {
            this.buffer = (DynamicChannelBuffer)buffer;
        } else {
            this.buffer = (DynamicChannelBuffer)ChannelBuffers.dynamicBuffer((int)buffer.readableBytes());
            this.buffer.writeBytes(buffer, 0, buffer.readableBytes());
        }
    }

    public String toString() {
        return this.buffer.toString(Charset.forName("UTF-8"));
    }

    public String toString(String enc) {
        return this.buffer.toString(Charset.forName(enc));
    }

    public byte getByte(int pos) {
        return this.buffer.getByte(pos);
    }

    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    public double getDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    public float getFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    public byte[] getBytes() {
        byte[] arr = new byte[this.buffer.writerIndex()];
        this.buffer.getBytes(0, arr);
        return arr;
    }

    public byte[] getBytes(int start, int end) {
        byte[] arr = new byte[end - start];
        this.buffer.getBytes(start, arr, 0, end - start);
        return arr;
    }

    public Buffer appendBuffer(Buffer buff) {
        ChannelBuffer cb = buff.getChannelBuffer();
        this.buffer.writeBytes(buff.getChannelBuffer());
        cb.readerIndex(0);
        return this;
    }

    public Buffer appendBytes(byte[] bytes) {
        this.buffer.writeBytes(bytes);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.buffer.writeByte((int)b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.buffer.writeInt(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.buffer.writeLong(l);
        return this;
    }

    public Buffer appendShort(short s) {
        this.buffer.writeShort((int)s);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.buffer.writeFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.buffer.writeDouble(d);
        return this;
    }

    public Buffer appendString(String str, String enc) {
        return this.append(str, Charset.forName(enc));
    }

    public Buffer appendString(String str) {
        return this.append(str, CharsetUtil.UTF_8);
    }

    public Buffer setByte(int pos, byte b) {
        this.ensureWritable(pos, 1);
        this.buffer.setByte(pos, (int)b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.ensureWritable(pos, 4);
        this.buffer.setInt(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.ensureWritable(pos, 8);
        this.buffer.setLong(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.ensureWritable(pos, 8);
        this.buffer.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.ensureWritable(pos, 4);
        this.buffer.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s) {
        this.ensureWritable(pos, 2);
        this.buffer.setShort(pos, (int)s);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.ensureWritable(pos, b.length());
        this.buffer.setBytes(pos, b.getChannelBuffer());
        return this;
    }

    public Buffer setBytes(int pos, ByteBuffer b) {
        this.ensureWritable(pos, b.limit());
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b) {
        this.ensureWritable(pos, b.length);
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, String str) {
        return this.setBytes(pos, str, CharsetUtil.UTF_8);
    }

    public Buffer setBytes(int pos, String str, String enc) {
        return this.setBytes(pos, str, Charset.forName(enc));
    }

    public int length() {
        return this.buffer.writerIndex();
    }

    public Buffer copy(int start, int end) {
        return new Buffer(this.buffer.copy(start, end - start));
    }

    public Buffer copy() {
        return new Buffer(this.buffer.copy());
    }

    public ChannelBuffer getChannelBuffer() {
        return this.buffer;
    }

    private Buffer append(String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.buffer.writeBytes(bytes);
        return this;
    }

    private Buffer setBytes(int pos, String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        this.ensureWritable(pos, bytes.length);
        this.buffer.setBytes(pos, bytes);
        return this;
    }

    private void ensureWritable(int pos, int len) {
        int ni = pos + len;
        int cap = this.buffer.capacity();
        int over = ni - cap;
        if (over > 0) {
            this.buffer.writerIndex(cap);
            this.buffer.ensureWritableBytes(over);
        }
        if (ni > this.buffer.writerIndex()) {
            this.buffer.writerIndex(ni);
        }
    }
}

