/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core;

import org.nodex.java.core.CompletionHandler;
import org.nodex.java.core.Future;

public class SimpleFuture<T>
implements Future<T> {
    private T result;
    private Exception exception;
    private CompletionHandler<T> completionHandler;
    protected boolean complete;

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Exception exception() {
        return this.exception;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    @Override
    public boolean succeeded() {
        return this.complete && this.exception == null;
    }

    @Override
    public boolean failed() {
        return this.complete && this.exception != null;
    }

    @Override
    public void handler(CompletionHandler<T> completionHandler) {
        this.completionHandler = completionHandler;
        if (this.complete) {
            this.callHandler();
        }
    }

    public void setResult(T result) {
        this.complete = true;
        this.result = result;
        this.callHandler();
    }

    public void setException(Exception e) {
        this.complete = true;
        this.exception = e;
        this.callHandler();
    }

    private void callHandler() {
        if (this.completionHandler != null) {
            this.completionHandler.handle(this);
        }
    }
}

