/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.nodex.java.core.Handler;
import org.nodex.java.core.internal.NodexInternal;

public abstract class OldConnectionPool<T> {
    private final Queue<T> available = new ConcurrentLinkedQueue<T>();
    private int maxPoolSize = 1;
    private final AtomicInteger connectionCount = new AtomicInteger(0);
    private final Queue<Waiter> waiters = new ConcurrentLinkedQueue<Waiter>();

    public void setMaxPoolSize(int maxConnections) {
        this.maxPoolSize = maxConnections;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void getConnection(Handler<T> handler, long contextID) {
        T conn = this.available.poll();
        if (conn != null) {
            handler.handle(conn);
        } else {
            if (this.connectionCount.get() < this.maxPoolSize) {
                if (this.connectionCount.incrementAndGet() <= this.maxPoolSize) {
                    this.connect(handler, contextID);
                    return;
                }
                this.connectionCount.decrementAndGet();
            }
            this.waiters.add(new Waiter(handler, contextID));
        }
    }

    public synchronized void connectionClosed() {
        Waiter waiter;
        if (this.connectionCount.decrementAndGet() < this.maxPoolSize && (waiter = this.waiters.poll()) != null) {
            this.getConnection(waiter.handler, waiter.contextID);
        }
    }

    public synchronized void returnConnection(final T conn) {
        final Waiter waiter = this.waiters.poll();
        if (waiter != null) {
            NodexInternal.instance.executeOnContext(waiter.contextID, new Runnable(){

                @Override
                public void run() {
                    NodexInternal.instance.setContextID(waiter.contextID);
                    waiter.handler.handle(conn);
                }
            });
        } else {
            this.available.add(conn);
        }
    }

    public void close() {
        this.available.clear();
        this.waiters.clear();
    }

    protected abstract void connect(Handler<T> var1, long var2);

    private class Waiter {
        final Handler<T> handler;
        final long contextID;

        private Waiter(Handler<T> handler, long contextID) {
            this.handler = handler;
            this.contextID = contextID;
        }
    }
}

