/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.nodex.java.core.Handler;
import org.nodex.java.core.internal.NodexInternal;
import org.nodex.java.core.shared.SharedUtils;

class NodexImpl
implements NodexInternal {
    private int backgroundPoolSize = 20;
    private int corePoolSize = Runtime.getRuntime().availableProcessors();
    private volatile ExecutorService backgroundPool;
    private volatile ExecutorService corePool;
    private volatile NioWorkerPool workerPool;
    private volatile ExecutorService acceptorPool;
    private Map<Long, NioWorker> workerMap = new ConcurrentHashMap<Long, NioWorker>();
    private static final ThreadLocal<Long> contextIDTL = new ThreadLocal();
    private Map<Long, ActorHolder> actors = new ConcurrentHashMap<Long, ActorHolder>();
    private final HashedWheelTimer timer = new HashedWheelTimer((ThreadFactory)new NodeThreadFactory("node.x-timer-thread"), 20L, TimeUnit.MILLISECONDS);
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final Map<Long, TimeoutHolder> timeouts = new ConcurrentHashMap<Long, TimeoutHolder>();
    private final AtomicLong contextIDSeq = new AtomicLong(0L);
    private final AtomicLong actorSeq = new AtomicLong(0L);

    public synchronized void setCoreThreadPoolSize(int size) {
        if (this.corePool != null) {
            throw new IllegalStateException("Cannot set core pool size after pool has been created");
        }
        this.corePoolSize = size;
    }

    @Override
    public synchronized int getCoreThreadPoolSize() {
        return this.corePoolSize;
    }

    public synchronized void setBackgroundThreadPoolSize(int size) {
        if (this.backgroundPool != null) {
            throw new IllegalStateException("Cannot set background size after pool has been created");
        }
        this.backgroundPoolSize = size;
    }

    public synchronized int getBackgroundThreadPoolSize() {
        return this.backgroundPoolSize;
    }

    @Override
    public <T> long registerHandler(Handler<T> actor) {
        Long contextID = this.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("Cannot register handler with no context");
        }
        long actorID = this.actorSeq.getAndIncrement();
        this.actors.put(actorID, new ActorHolder(actor, this.getContextID()));
        return actorID;
    }

    @Override
    public boolean unregisterHandler(long handlerID) {
        long contextID = this.getContextID();
        ActorHolder holder = this.actors.remove(handlerID);
        if (holder != null) {
            if (contextID != holder.contextID) {
                this.actors.put(handlerID, holder);
                throw new IllegalStateException("Cannot unregister handler from different context");
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> boolean sendToHandler(long handlerID, T message) {
        final T msg = SharedUtils.checkObject(message);
        final ActorHolder holder = this.actors.get(handlerID);
        if (holder != null) {
            final Handler<?> actor = holder.actor;
            this.executeOnContext(holder.contextID, new Runnable(){

                @Override
                public void run() {
                    NodexImpl.this.setContextID(holder.contextID);
                    actor.handle(msg);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void executeInBackground(Runnable runnable) {
        this.getBackgroundPool().execute(runnable);
    }

    @Override
    public void go(final Runnable runnable) {
        final long contextID = NodexInternal.instance.createAndAssociateContext();
        NodexInternal.instance.executeOnContext(contextID, new Runnable(){

            @Override
            public void run() {
                NodexInternal.instance.setContextID(contextID);
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getBackgroundPool() {
        ExecutorService result = this.backgroundPool;
        if (result == null) {
            NodexImpl nodexImpl = this;
            synchronized (nodexImpl) {
                result = this.backgroundPool;
                if (result == null) {
                    this.backgroundPool = result = Executors.newFixedThreadPool(this.backgroundPoolSize, new NodeThreadFactory("node.x-background-thread-"));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NioWorkerPool getWorkerPool() {
        NioWorkerPool result = this.workerPool;
        if (result == null) {
            NodexImpl nodexImpl = this;
            synchronized (nodexImpl) {
                result = this.workerPool;
                if (result == null) {
                    this.corePool = Executors.newFixedThreadPool(this.corePoolSize, new NodeThreadFactory("node.x-core-thread-"));
                    this.workerPool = result = new NioWorkerPool(this.corePoolSize, (Executor)this.corePool);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getAcceptorPool() {
        ExecutorService result = this.acceptorPool;
        if (result == null) {
            NodexImpl nodexImpl = this;
            synchronized (nodexImpl) {
                result = this.acceptorPool;
                if (result == null) {
                    this.acceptorPool = result = Executors.newCachedThreadPool(new NodeThreadFactory("node.x-acceptor-thread-"));
                }
            }
        }
        return result;
    }

    @Override
    public long createAndAssociateContext() {
        NioWorker worker = this.getWorkerPool().nextWorker();
        return this.associateContextWithWorker(worker);
    }

    @Override
    public long associateContextWithWorker(NioWorker worker) {
        long contextID = this.contextIDSeq.getAndIncrement();
        this.workerMap.put(contextID, worker);
        return contextID;
    }

    @Override
    public boolean destroyContext(long contextID) {
        return this.workerMap.remove(contextID) != null;
    }

    @Override
    public void setContextID(long contextID) {
        contextIDTL.set(contextID);
    }

    @Override
    public Long getContextID() {
        return contextIDTL.get();
    }

    @Override
    public NioWorker getWorkerForContextID(long contextID) {
        NioWorker worker = this.workerMap.get(contextID);
        if (worker == null) {
            throw new IllegalStateException("Context is not registered " + contextID);
        }
        return worker;
    }

    @Override
    public void executeOnContext(long contextID, Runnable runnable) {
        this.executeOnContext(contextID, runnable, true);
    }

    @Override
    public void nextTick(final Handler<Void> handler) {
        Long contextID = this.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("No context id");
        }
        this.executeOnContext(contextID, new Runnable(){

            @Override
            public void run() {
                handler.handle(null);
            }
        }, false);
    }

    private void executeOnContext(long contextID, Runnable runnable, boolean sameThreadOptimise) {
        NioWorker worker = this.workerMap.get(contextID);
        if (worker != null) {
            if (sameThreadOptimise && worker.getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                worker.scheduleOtherTask(runnable);
            }
        } else {
            throw new IllegalStateException("Context is not registered " + contextID + " has it been destroyed?");
        }
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.setTimeout(delay, true, handler);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.setTimeout(delay, false, handler);
    }

    NodexImpl() {
        this.timer.start();
    }

    private long checkContextID() {
        Long contextID = this.getContextID();
        if (contextID == null) {
            throw new IllegalStateException("No context id");
        }
        return contextID;
    }

    private long setTimeout(final long delay, boolean periodic, Handler<Long> handler) {
        long timerID;
        long contextID = this.checkContextID();
        InternalTimerHandler myHandler = periodic ? new InternalTimerHandler(contextID, handler){

            @Override
            public void run() {
                super.run();
                NodexImpl.this.scheduleTimeout(this.timerID, this.contextID, this, delay);
            }
        } : new InternalTimerHandler(contextID, handler){

            @Override
            public void run() {
                super.run();
                NodexImpl.this.timeouts.remove(this.timerID);
            }
        };
        myHandler.timerID = timerID = this.scheduleTimeout(-1L, contextID, myHandler, delay);
        return timerID;
    }

    @Override
    public boolean cancelTimer(long id) {
        return this.cancelTimeout(id, true);
    }

    private boolean cancelTimeout(long id, boolean check) {
        TimeoutHolder holder = this.timeouts.remove(id);
        if (holder != null) {
            if (check && holder.contextID != this.checkContextID()) {
                throw new IllegalStateException("Timer can only be cancelled in the context that set it");
            }
            holder.timeout.cancel();
            return true;
        }
        return false;
    }

    private long scheduleTimeout(long id, final long contextID, final Runnable task, long delay) {
        TimerTask ttask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                NodexInternal.instance.executeOnContext(contextID, task);
            }
        };
        if (id != -1L && this.timeouts.get(id) == null) {
            return -1L;
        }
        Timeout timeout = this.timer.newTimeout(ttask, delay, TimeUnit.MILLISECONDS);
        id = id != -1L ? id : this.timeoutCounter.getAndIncrement();
        this.timeouts.put(id, new TimeoutHolder(timeout, contextID));
        return id;
    }

    private static class NodeThreadFactory
    implements ThreadFactory {
        private String prefix;
        private AtomicInteger threadCount = new AtomicInteger(0);

        NodeThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.prefix + this.threadCount.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static class ActorHolder {
        final Handler<?> actor;
        final long contextID;

        ActorHolder(Handler<?> actor, long contextID) {
            this.actor = actor;
            this.contextID = contextID;
        }
    }

    private static class TimeoutHolder {
        final Timeout timeout;
        final long contextID;

        TimeoutHolder(Timeout timeout, long contextID) {
            this.timeout = timeout;
            this.contextID = contextID;
        }
    }

    private static class InternalTimerHandler
    implements Runnable {
        final long contextID;
        final Handler<Long> handler;
        long timerID;

        InternalTimerHandler(long contextID, Handler<Long> runnable) {
            this.contextID = contextID;
            this.handler = runnable;
        }

        @Override
        public void run() {
            NodexInternal.instance.setContextID(this.contextID);
            this.handler.handle(this.timerID);
        }
    }
}

