/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.core;

import java.util.LinkedList;
import java.util.Queue;
import org.nodex.java.core.Handler;
import org.nodex.java.core.internal.NodexInternal;

public abstract class ConnectionPool<T> {
    private final Queue<T> available = new LinkedList<T>();
    private int maxPoolSize = 1;
    private int connectionCount;
    private final Queue<Waiter> waiters = new LinkedList<Waiter>();

    public void setMaxPoolSize(int maxConnections) {
        this.maxPoolSize = maxConnections;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void getConnection(Handler<T> handler, long contextID) {
        block7: {
            connect = false;
            var5_4 = this;
            synchronized (var5_4) {
                block6: {
                    conn = this.available.poll();
                    if (conn == null) break block6;
                    handler.handle(conn);
                    break block7;
                }
                if (this.connectionCount >= this.maxPoolSize) ** GOTO lbl15
                if (++this.connectionCount <= this.maxPoolSize) {
                    connect = true;
                } else {
                    --this.connectionCount;
lbl15:
                    // 2 sources

                    this.waiters.add(new Waiter(handler, contextID));
                }
            }
        }
        if (connect) {
            this.connect(handler, contextID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed() {
        Waiter waiter;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (--this.connectionCount < this.maxPoolSize) {
                waiter = this.waiters.poll();
                if (waiter != null) {
                    ++this.connectionCount;
                }
            } else {
                waiter = null;
            }
        }
        if (waiter != null) {
            this.connect(waiter.handler, waiter.contextID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(final T conn) {
        Waiter waiter;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            waiter = this.waiters.poll();
            if (waiter == null) {
                this.available.add(conn);
            }
        }
        if (waiter != null) {
            final Waiter w = waiter;
            NodexInternal.instance.executeOnContext(w.contextID, new Runnable(){

                @Override
                public void run() {
                    NodexInternal.instance.setContextID(w.contextID);
                    w.handler.handle(conn);
                }
            });
        }
    }

    public void close() {
        this.available.clear();
        this.waiters.clear();
    }

    protected abstract void connect(Handler<T> var1, long var2);

    private class Waiter {
        final Handler<T> handler;
        final long contextID;

        private Waiter(Handler<T> handler, long contextID) {
            this.handler = handler;
            this.contextID = contextID;
        }
    }
}

