/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import org.nodex.java.addons.redis.RedisReply;
import org.nodex.java.core.Handler;
import org.nodex.java.core.buffer.Buffer;
import org.nodex.java.core.parsetools.RecordParser;

public class ReplyParser
implements Handler<Buffer> {
    static final byte[] CRLF = new byte[]{13, 10};
    static final byte STAR = 42;
    static final byte DOLLAR = 36;
    static final byte COLON = 58;
    static final byte PLUS = 43;
    static final byte MINUS = 45;
    private final RecordParser recordParser;
    private final Handler<RedisReply> replyHandler;
    private ReplyParseState respState = ReplyParseState.TYPE;
    private Buffer[] multiBulkResponses;
    private int multiBulkIndex;

    public ReplyParser(Handler<RedisReply> replyHandler) {
        this.recordParser = RecordParser.newFixed(1, new Handler<Buffer>(){

            @Override
            public void handle(Buffer data) {
                ReplyParser.this.doHandle(data);
            }
        });
        this.replyHandler = replyHandler;
    }

    @Override
    public void handle(Buffer data) {
        this.recordParser.handle(data);
    }

    private void doHandle(Buffer data) {
        block0 : switch (this.respState) {
            case TYPE: {
                byte type = data.getByte(0);
                switch (type) {
                    case 43: {
                        this.respState = ReplyParseState.ONE_LINE;
                        this.recordParser.delimitedMode(CRLF);
                        break block0;
                    }
                    case 45: {
                        this.respState = ReplyParseState.ERROR;
                        this.recordParser.delimitedMode(CRLF);
                        break block0;
                    }
                    case 58: {
                        this.respState = ReplyParseState.INTEGER;
                        this.recordParser.delimitedMode(CRLF);
                        break block0;
                    }
                    case 36: {
                        this.respState = ReplyParseState.BULK_NUM_BYTES;
                        this.recordParser.delimitedMode(CRLF);
                        break block0;
                    }
                    case 42: {
                        this.respState = ReplyParseState.MULTI_BULK_COUNT;
                        this.recordParser.delimitedMode(CRLF);
                        break block0;
                    }
                }
                System.err.println("Invalid response type: " + type);
                break;
            }
            case ONE_LINE: {
                this.sendOneLineReply(data.toString());
                break;
            }
            case ERROR: {
                this.sendErrorReply(data.toString());
                break;
            }
            case INTEGER: {
                this.sendIntegerReply(Integer.valueOf(data.toString()));
                break;
            }
            case BULK_NUM_BYTES: {
                String sbytes = data.toString();
                int numBytes = Integer.valueOf(sbytes);
                if (numBytes != -1) {
                    this.respState = ReplyParseState.BULK_DATA;
                    this.recordParser.fixedSizeMode(numBytes + 2);
                    break;
                }
                if (this.multiBulkResponses != null) {
                    ++this.multiBulkIndex;
                    if (this.multiBulkIndex != this.multiBulkResponses.length) break;
                    this.sendMultiBulkReply(this.multiBulkResponses);
                    break;
                }
                this.sendBulkReply(null);
                break;
            }
            case BULK_DATA: {
                Buffer bytes = data.copy(0, data.length() - 2);
                if (this.multiBulkResponses == null) {
                    this.sendBulkReply(bytes);
                    break;
                }
                this.multiBulkResponses[this.multiBulkIndex++] = bytes;
                if (this.multiBulkIndex == this.multiBulkResponses.length) {
                    this.sendMultiBulkReply(this.multiBulkResponses);
                    break;
                }
                this.recordParser.fixedSizeMode(1);
                this.respState = ReplyParseState.TYPE;
                break;
            }
            case MULTI_BULK_COUNT: {
                String sbytes = data.toString();
                int numResponses = Integer.valueOf(sbytes);
                if (numResponses != 0) {
                    this.multiBulkResponses = new Buffer[numResponses];
                    this.recordParser.fixedSizeMode(1);
                    this.respState = ReplyParseState.TYPE;
                    break;
                }
                this.sendMultiBulkReply(new Buffer[0]);
                break;
            }
            default: {
                System.err.println("Unknown state");
            }
        }
    }

    private void reset() {
        this.recordParser.fixedSizeMode(1);
        this.respState = ReplyParseState.TYPE;
        this.multiBulkResponses = null;
        this.multiBulkIndex = 0;
    }

    private void sendOneLineReply(String reply) {
        this.replyHandler.handle(new RedisReply(reply));
        this.reset();
    }

    private void sendIntegerReply(int reply) {
        this.replyHandler.handle(new RedisReply(reply));
        this.reset();
    }

    private void sendBulkReply(Buffer reply) {
        this.replyHandler.handle(new RedisReply(reply));
        this.reset();
    }

    private void sendMultiBulkReply(Buffer[] reply) {
        this.replyHandler.handle(new RedisReply(reply));
        this.reset();
    }

    private void sendErrorReply(String error) {
        this.replyHandler.handle(new RedisReply(RedisReply.Type.ERROR, error));
        this.reset();
    }

    private static enum ReplyParseState {
        TYPE,
        ONE_LINE,
        ERROR,
        INTEGER,
        BULK_NUM_BYTES,
        BULK_DATA,
        MULTI_BULK_COUNT;

    }
}

