/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import org.nodex.java.core.buffer.Buffer;

public class RedisReply {
    public final Type type;
    public String line;
    public String error;
    public int intResult;
    public Buffer bulkResult;
    public Buffer[] multiBulkResult;

    public RedisReply(String line) {
        this.type = Type.ONE_LINE;
        this.line = line;
    }

    public RedisReply(Type type, String line) {
        this.type = type;
        if (this.type == Type.ERROR) {
            this.error = line;
        } else {
            this.line = line;
        }
    }

    public RedisReply(int i) {
        this.type = Type.INTEGER;
        this.intResult = i;
    }

    public RedisReply(Buffer bulk) {
        this.type = Type.BULK;
        this.bulkResult = bulk;
    }

    public RedisReply(Buffer[] multiBulk) {
        this.type = Type.MULTI_BULK;
        this.multiBulkResult = multiBulk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.toString()).append(":");
        switch (this.type) {
            case ERROR: {
                sb.append(this.error);
                break;
            }
            case ONE_LINE: {
                sb.append(this.line);
                break;
            }
            case INTEGER: {
                sb.append(this.intResult);
                break;
            }
            case BULK: {
                sb.append(this.bulkResult == null ? "null" : this.bulkResult.toString());
                break;
            }
            case MULTI_BULK: {
                sb.append(this.multiBulkResult.length).append(":");
                for (Buffer buff : this.multiBulkResult) {
                    sb.append(buff == null ? "null" : buff.toString());
                    sb.append("\n");
                }
                break;
            }
        }
        return sb.toString();
    }

    public static enum Type {
        ERROR,
        ONE_LINE,
        INTEGER,
        BULK,
        MULTI_BULK;

    }
}

