/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import org.nodex.java.addons.redis.InternalConnection;
import org.nodex.java.addons.redis.RedisConnection;
import org.nodex.java.core.ConnectionPool;
import org.nodex.java.core.Handler;
import org.nodex.java.core.net.NetClient;
import org.nodex.java.core.net.NetSocket;

public class RedisPool {
    private final NetClient client = new NetClient();
    private final ConnectionPool<InternalConnection> pool = new ConnectionPool<InternalConnection>(){

        @Override
        protected void connect(Handler<InternalConnection> connectHandler, long contextID) {
            RedisPool.this.internalConnect(connectHandler, contextID);
        }
    };
    private String host = "localhost";
    private int port = 6379;
    private String password;

    public RedisPool setPort(int port) {
        this.port = port;
        return this;
    }

    public RedisPool setHost(String host) {
        this.host = host;
        return this;
    }

    public RedisPool setMaxPoolSize(int maxConnections) {
        this.pool.setMaxPoolSize(maxConnections);
        return this;
    }

    public int getMaxPoolSize() {
        return this.pool.getMaxPoolSize();
    }

    public RedisPool setPassword(String password) {
        this.password = password;
        return this;
    }

    public RedisConnection connection() {
        return new RedisConnection(this.pool, this.password);
    }

    public void close() {
        this.pool.close();
        this.client.close();
    }

    private void internalConnect(final Handler<InternalConnection> connectHandler, long contextID) {
        this.client.connect(this.port, this.host, new Handler<NetSocket>(){

            @Override
            public void handle(NetSocket socket) {
                connectHandler.handle(new InternalConnection(RedisPool.this.pool, socket));
            }
        });
    }
}

