/*
 * Decompiled with CFR 0.152.
 */
package org.nodex.java.addons.redis;

import org.nodex.java.addons.redis.RedisConnection;
import org.nodex.java.addons.redis.RedisException;
import org.nodex.java.addons.redis.RedisReply;
import org.nodex.java.addons.redis.ReplyHandler;
import org.nodex.java.core.Deferred;
import org.nodex.java.core.DeferredAction;
import org.nodex.java.core.Nodex;
import org.nodex.java.core.internal.NodexInternal;

abstract class RedisDeferred<T>
extends DeferredAction<T>
implements ReplyHandler {
    final DeferredType type;
    final long contextID;
    final RedisConnection rc;
    TxCommandType commandType = TxCommandType.OTHER;
    RedisReply reply;

    RedisDeferred(DeferredType type, RedisConnection rc) {
        this.type = type;
        this.contextID = Nodex.instance.getContextID();
        this.rc = rc;
    }

    @Override
    public Deferred<T> execute() {
        if (this.rc.conn == null) {
            this.rc.addToPending(this);
        } else if (!this.executed) {
            this.run();
            this.executed = true;
        }
        return this;
    }

    void doHandleReply() {
        if (this.reply.type == RedisReply.Type.ERROR) {
            this.setException(new RedisException(this.reply.error));
        } else {
            switch (this.type) {
                case VOID: {
                    this.setResult(null);
                    break;
                }
                case BOOLEAN: {
                    this.setResult(this.reply.intResult == 1);
                    break;
                }
                case STRING: {
                    this.setResult(this.reply.line);
                    break;
                }
                case INTEGER: {
                    this.setResult(this.reply.intResult);
                    break;
                }
                case DOUBLE: {
                    if (this.reply.bulkResult != null) {
                        this.setResult(Double.valueOf(this.reply.bulkResult.toString()));
                        break;
                    }
                    this.setResult(null);
                    break;
                }
                case BULK: {
                    this.setResult(this.reply.bulkResult);
                    break;
                }
                case MULTI_BULK: {
                    this.setResult(this.reply.multiBulkResult);
                }
            }
        }
    }

    @Override
    public void handleReply(RedisReply reply) {
        this.reply = reply;
        NodexInternal.instance.executeOnContext(this.contextID, new Runnable(){

            @Override
            public void run() {
                try {
                    RedisDeferred.this.doHandleReply();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    public void handleReplyDirect(RedisReply reply) {
        this.reply = reply;
        this.doHandleReply();
    }

    static enum TxCommandType {
        MULTI,
        EXEC,
        DISCARD,
        OTHER;

    }

    static enum DeferredType {
        VOID,
        BOOLEAN,
        INTEGER,
        BULK,
        MULTI_BULK,
        DOUBLE,
        STRING;

    }
}

